<?php

function theme_enqueue_styles() {
    wp_enqueue_style( 'child-style', get_stylesheet_directory_uri() . '/style.css', [] );
}
add_action( 'wp_enqueue_scripts', 'theme_enqueue_styles', 20 );

function avada_lang_setup() {
	$lang = get_stylesheet_directory() . '/languages';
	load_child_theme_textdomain( 'Avada', $lang );
}
add_action( 'after_setup_theme', 'avada_lang_setup' );

// TRADUÇÕES
add_filter( 'gettext', 'fs_translate_strings_1', 20, 3 );
function fs_translate_strings_1( $translation, $text, $domain ) {
    // Mapeamento de strings para tradução
    $translations = [
        'Read More' => 'LEIA MAIS',
        'About the Author' => 'Sobre o autor',
        'About' => 'Sobre',
        'Related Posts' => 'Posts sugeridos',
        'Related Projects' => 'Outras receitas',
        'Leave A Comment' => 'Deixe seu comentário',
        'Comment...' => 'Comentário...',
        'Post Comment' => 'Publicar',
        'View Posts' => 'Veja mais',
        'Previous' => 'Anterior',
        'Next' => 'Próximo',
        'Search' => 'Buscar',
        'All' => 'Todos',
        'Sort' => 'Classificar',
        'By' => 'por',
        'Default' => 'Padrão',
        'Order' => 'Ordem',
        'Name' => 'Nome',
        'Price' => 'Preço',
        'Date' => 'Data',
        'Popularity' => 'Popularidade',
        'Rating' => 'Classificação',
        'Show' => 'Mostre',
        'Products' => 'Produtos',
        'Details' => 'Saiba mais',
        'View Cart' => 'Ver Carrinho',
        'Checkout' => 'Finalizar',
        'Log out' => 'Sair',
        'Dashboard' => 'Painel do cliente',
        'Add an address for shipping options' => 'Adicione um endereço',
        'Hello' => 'Olá',
        'not' => 'não é',
        'Sign out' => 'Sair',
        'Remember Me' => 'Lembre-me de mim',
        'Log In' => 'Entrar',
        'Register' => 'Registre-se',
        'Username' => 'Usuário',
        'Password' => 'Senha',
        'Continuar para a finalização de compra' => 'Finalizar',
        'Update address' => 'Atualizar Endereço',
    ];

    // Verifica se o texto original está na lista de traduções e substitui
    if ( array_key_exists( $text, $translations ) ) {
        $translation = $translations[ $text ];
    }

    return $translation;
}


function custom_wp_mail_from_name( $name ) {
    return 'Luvisotto Advocacia'; // Substitua pelo nome desejado
}
add_filter( 'wp_mail_from_name', 'custom_wp_mail_from_name' );
