<?php

function theme_enqueue_styles() {
    wp_enqueue_style( 'child-style', get_stylesheet_directory_uri() . '/style.css', [] );
}
add_action( 'wp_enqueue_scripts', 'theme_enqueue_styles', 20 );

function avada_lang_setup() {
	$lang = get_stylesheet_directory() . '/languages';
	load_child_theme_textdomain( 'Avada', $lang );
}
add_action( 'after_setup_theme', 'avada_lang_setup' );

// TRADUÇÕES
add_filter( 'gettext', 'fs_translate_strings_1', 20, 3 );
function fs_translate_strings_1( $translation, $text, $domain ) {
    // Mapeamento de strings para tradução
    $translations = [
        'Read More' => 'LEIA MAIS',
        'About the Author' => 'Sobre o autor',
        'About' => 'Sobre',
        'Related Posts' => 'Posts Sugeridos',
        'Related Projects' => 'Projetos Sugeridos',
        'Leave A Comment' => 'Deixe seu comentário',
        'Comment...' => 'Comentário...',
        'Post Comment' => 'Publicar',
        'View Posts' => 'Veja mais',
        'Previous' => 'Anterior',
        'Next' => 'Próximo',
        'Search...' => 'Buscar',
        'All' => 'Todos',
        'Sort' => 'Classificar',
        'By' => 'por',
        'Default' => 'Padrão',
        'Order' => 'Ordem',
        'Name' => 'Nome',
        'Price' => 'Preço',
        'Date' => 'Data',
        'Popularity' => 'Popularidade',
        'Rating' => 'Classificação',
        'Show' => 'Mostre',
        'Products' => 'Produtos',
        'Details' => 'SAIBA MAIS',
        'View Cart' => 'Ver Carrinho',
        'Checkout' => 'Finalizar',
        'Log out' => 'Sair',
        'Dashboard' => 'Painel do cliente',
        'Add an address for shipping options' => 'Adicione um endereço',
        'Hello' => 'Olá',
        'not' => 'não é',
        'Sign out' => 'Sair',
        'Remember Me' => 'Lembre-me de mim',
        'Log In' => 'Entrar',
        'Register' => 'Registre-se',
        'Username' => 'Usuário',
        'Password' => 'Senha',
        'Continuar para a finalização de compra' => 'Finalizar',
        'Update address' => 'Atualizar Endereço',
    ];

    // Verifica se o texto original está na lista de traduções e substitui
    if ( array_key_exists( $text, $translations ) ) {
        $translation = $translations[ $text ];
    }

    return $translation;
}


add_filter('wp_nav_menu_objects', 'incluir_categoria_no_menu_portfolio', 10, 2);

function incluir_categoria_no_menu_portfolio($items, $args) {
    foreach ($items as &$item) {
        if ($item->object === 'avada_portfolio') {
            $post_id = $item->object_id;

            $terms = get_the_terms($post_id, 'portfolio_category');
            if (!empty($terms) && !is_wp_error($terms)) {
                $categoria_nome = $terms[0]->name;
                $categoria_slug = sanitize_title($categoria_nome); // transforma em slug válido

                // Cria a tag span com classe baseada na categoria
                $item->title .= ' <span class="menu-portfolio-status categoria-' . esc_attr($categoria_slug) . '">' . esc_html($categoria_nome) . '</span>';
            }
        }
    }
    return $items;
}
