﻿<!-- template="documentation-tab" -->
<h2>Plugin and Shortcode Documentation. In this tab, jump to:</h2>
<div class="mla-display-settings-page" id="mla-display-settings-documentation-tab" style="width:710px">
<p class="submit mla-settings-submit" [+example_style+]>
Browse and install: 
<a href="[+example_url+]" class="button button-primary">Example Plugins</a><br />
&nbsp;<br />
For more information about the example plugins, jump to <a href="#mla_example_plugins">The Example Plugins</a><br />
&nbsp;
</p>
<div id="mla-doc-gallery-shortcode"><a href="#mla_gallery"><strong>MLA Gallery Shortcode</strong></a>
<ul class="mla-doc-toc-list">
<li><a href="#documentation_sources">Option/Parameter Documentation Sources</a></li>
<li><a href="#gallery_substitution">Substitution Parameters</a></li>
<li><a href="#complex_shortcodes">Entering Long/Complex Shortcodes</a></li>
<li><a href="#gallery_display_style">Gallery Display Style</a></li>
<li><a href="#gallery_display_content">Gallery Display Content</a></li>
<li><a href="#thumbnail_substitution">Thumbnail Substitution,<br />Featured Images and mla_viewer</a></li>
<li><a href="#order_orderby">Order, Orderby</a></li>
<li><a href="#size">Size</a></li>
<li><a href="#link">Link</a></li>
<li><a href="#named_transfer">Transfer by Item Name</a></li>
<li><a href="#mla_minimum">Minimum Gallery Size</a></li>
<li><a href="#include_exclude">Include, Exclude</a></li>
<li><a href="#post_id_ids_post_parent">Post ID, "ids", Post Parent</a></li>
<li><a href="#author_author_name">Author, Author Name</a></li>
<li><a href="#category_parameters">Category Parameters</a></li>
<li><a href="#tag_parameters">Tag Parameters</a></li>
<li><a href="#simple_taxonomy_parameters">Simple Taxonomy Parameters</a></li>
<li><a href="#taxonomy_parameters_tax_input">Compound Taxonomy Parameters, "tax_input"</a></li>
<li><a href="#taxonomy_queries">Taxonomy Queries, the "tax_query"</a></li>
<li><a href="#taxonomy_keyword_search">Taxonomy term keyword(s) search</a></li>
<li><a href="#post_mime_type_parameter">Post MIME Type</a></li>
<li><a href="#post_type_post_status">Post Type, Post Status</a></li>
<li><a href="#pagination_parameters">Pagination Parameters</a></li>
<li><a href="#date_parameters">Simple Date Parameters</a></li>
<li><a href="#date_queries">Date and Time Queries, the "date query"</a></li>
<li><a href="#custom_field_parameters">Simple Custom Field Parameters</a></li>
<li><a href="#custom_field_queries">Custom Field Queries, the "meta_query"</a></li>
<li><a href="#search_keywords">Keyword(s) Search</a></li>
<li><a href="#cache_parameters">Caching Parameters</a></li>
<li><a href="#fields_parameter">Fields Parameter</a></li>
<li><a href="#debugging_output">Debugging Output</a></li>
<li><a href="#mla_gallery_hooks">MLA Gallery Filters (Hooks)</a></li>
</ul></div>
<div  id="mla-doc-cloud-shortcode"><a href="#mla_tag_cloud"><strong>MLA Tag Cloud Shortcode</strong></a>
<ul class="mla-doc-toc-list">
<li><a href="#tag_cloud_output">Tag Cloud Output Formats</a></li>
<li><a href="#tag_cloud_items">Tag Cloud Item Parameters</a></li>
<li><a href="#tag_cloud_link">Tag Cloud Item Link</a></li>
<li><a href="#tag_cloud_display_style">Tag Cloud Display Style (list and grid)</a></li>
<li><a href="#tag_cloud_display_content">Tag Cloud Display Content</a></li>
<li><a href="#tag_cloud_data_selection">Tag Cloud Data Selection Parameters</a></li>
<li><a href="#tag_cloud_debugging_output">Tag Cloud Debugging Output</a></li>
<li><a href="#tag_cloud_substitution">Tag Cloud Substitution Parameters</a></li>
<li><a href="#tag_cloud_pagination_parameters">Tag Cloud Pagination Parameters</a></li>
<li><a href="#tag_cloud_pagination_example">A Tag Cloud Pagination Example</a></li>
<li><a href="#mla_tag_cloud_hooks">MLA Tag Cloud Filters (Hooks)</a></li>
</ul></div>
<div  id="mla-doc-list-shortcode"><a href="#mla_term_list"><strong>MLA Term List Shortcode</strong></a>
<ul class="mla-doc-toc-list">
<li><a href="#term_list_output_formats">Term List Output Formats</a></li>
<li><a href="#term_list_output_structure">Term List Output Structure</a></li>
<li><a href="#term_list_items">Term List Item Parameters</a></li>
<li><a href="#term_list_items_afl">Term List Item Parameters (Array, Flat and List)</a></li>
<li><a href="#term_list_link">Term List Item Link Values (Array, Flat and List)</a></li>
<li><a href="#term_list_display_style_ldc">Term List Display Style (List, Dropdown and Checklist)</a></li>
<li><a href="#term_list_display_style">Term List Display Style (List and Checklist)</a></li>
<li><a href="#term_list_display_style_d">Term List Display Style (Dropdown)</a></li>
<li><a href="#term_list_display_content_all">Term List Display Content (all Output Formats)</a></li>
<li><a href="#term_list_display_content_afl">Term List Display Content (Array, Flat and List)</a></li>
<li><a href="#term_list_display_content">Term List Display Content (Dropdown and Checklist)</a></li>
<li><a href="#term_list_other">Term List Other Parameters</a></li>
<li><a href="#term_list_data_selection">Term List Data Selection Parameters</a></li>
<li><a href="#term_list_data_selection_h">Term List Data Selection Parameters (Hierarchical Output)</a></li>
<li><a href="#term_list_substitution">Term List Substitution Parameters</a></li>
<li><a href="#mla_term_list_examples">MLA Term List Examples</a></li>
<li><a href="#mla_term_list_hooks">MLA Term List Filters (Hooks)</a></li>
</ul></div>
<div  id="mla-doc-cf-list-shortcode" style="display:inline-block"><a href="#mla_cf_list"><strong>MLA Custom Field List Shortcode</strong></a>
<ul class="mla-doc-toc-list">
<li><a href="#cf_list_output">Custom Field List Output Formats</a></li>
<li><a href="#cf_list_items">Custom Field List Item Parameters</a></li>
<li><a href="#cf_list_items_flat">Custom Field List Item Parameters ("cloud" formats: flat, list and grid)</a></li>
<li><a href="#cf_list_items_flga">Custom Field List Item Parameters (except dropdown and checklist formats)</a></li>
<li><a href="#cf_list_link">Custom Field List Item Link</a></li>
<li><a href="#cf_list_display_templates">Custom Field List Display Style and Markup (all output formats except "flat")</a></li>
<li><a href="#cf_list_display_grid">Custom Field List Display Style (grid)</a></li>
<li><a href="#cf_list_display_style">Custom Field List Display Style (list, grid and checklist)</a></li>
<li><a href="#cf_list_display_content">Custom Field List Display Content</a></li>
<li><a href="#cf_list_display_content_html">Custom Field List Display Content (dropdown and checklist)</a></li>
<li><a href="#cf_list_data_selection">Custom Field List Data Selection Parameters</a></li>
<li><a href="#cf_list_debugging_output">Custom Field List Debugging Output</a></li>
<li><a href="#cf_list_substitution">Custom Field List Substitution Parameters</a></li>
<li><a href="#cf_list_pagination_parameters">Custom Field List Pagination Parameters</a></li>
<li><a href="#cf_list_pagination_example">A Custom Field List Pagination Example</a></li>
<li><a href="#mla_cf_list_hooks">MLA Custom Field List Filters (Hooks)</a></li>
</ul></div>
<ul style="list-style-position:inside; list-style:disc; line-height: 18px; clear:both">
<li>
<a href="#shortcode_api"><strong>Calling shortcode functions from PHP code; the MLA shortcode API</strong></a>
</li>
<li>
<a href="#gallery_examples"><strong>MLA Gallery Examples</strong></a>
</li>
<li style="list-style-type:none"><ul class="mla-doc-toc-list">
<li><a href="#simple_examples">Simple Examples</a></li>
<li><a href="#paginated_gallery">A Paginated Gallery</a></li>
<li><a href="#cloud_and_gallery">Tag Cloud and Gallery</a></li>
<li><a href="#search_form_and_gallery">Search Form and Gallery</a></li>
</ul></li>
<li>
<a href="#mla_output_parameter"><strong>Support for Alternative Gallery Output, e.g., Pagination</strong></a>
</li>
<li>
<a href="#alt_shortcode"><strong>Support for Other Gallery-generating Shortcodes</strong></a>
</li>
<li>
<a href="#photonic_gallery"><strong>Support for the &#8220;Photonic Gallery&#8221; Plugin</strong></a>
</li>
<li>
<a href="#justified_image_grid"><strong>Support for the &#8220;Justified Image Grid&#8221; Plugin</strong></a>
</li>
<li>
<a href="#real_media_library"><strong>Support for the &#8220;Real Media Library&#8221; Plugin</strong></a>
</li>
<li>
<a href="#catfolders"><strong>Support for the &#8220;CatFolders – WP Media Folders&#8221; Plugin</strong></a>
</li>
<li>
<a href="#mla_gallery_templates"><strong>Style and Markup Templates</strong></a>
</li>
<li style="list-style-type:none"><ul class="mla-doc-toc-list">
<li><a href="#argument_parameters">Argument substitution parameters</a></li>
<li><a href="#gallery_specific">Gallery-specific substitution parameters</a></li>
<li><a href="#mla_style_parameters">Substitution parameters for style templates</a></li>
<li><a href="#mla_markup_parameters">Substitution parameters for markup templates</a></li>
<li><a href="#mla_attachment_parameters">Attachment-specific substitution parameters for the markup template Item part</a></li>
</ul></li>
<li>
<a href="#mla_table_example"><strong>A table-based Style and Markup template example</strong></a>
</li>
<li>
<a href="#mla_variable_parameters"><strong>Field-level substitution parameters</strong></a>
</li>
<li style="list-style-type:none"><ul class="mla-doc-toc-list">
<li><a href="#field_level_prefixes">Field-level prefix values</a></li>
<li><a href="#field_level_formats">Field-level option/format values</a></li>
<li><a href="#field_level_data_sources">Field-level data sources</a></li>
<li><a href="#mla_iptc_identifiers">Field-level IPTC identifiers and friendly names</a></li>
<li><a href="#mla_camera_values">Field-level Enhanced EXIF CAMERA values</a></li>
<li><a href="#mla_gps_values">Field-level Enhanced EXIF GPS values</a></li>
<li><a href="#pdf_metadata">Field-level metadata in PDF documents</a></li>
<li><a href="#substitution_parameter_filters">Field-level substitution parameter filters (Hooks)</a></li>
</ul></li>
<li>
<a href="#mla_template_parameters"><strong>Content Templates</strong></a>
</li>
<li>
<a href="#mla_regular_expressions"><strong>Regular Expression Features</strong></a>
</li>
<li style="list-style-type:none"><ul class="mla-doc-toc-list">
<li><a href="#mla_regular_expressions_patterns">Patterns and Subpatterns</a></li>
<li><a href="#mla_regular_expressions_match">The <code>,match(p)</code> option/format value</a></li>
<li><a href="#mla_regular_expressions_extract">The <code>,extract(p,v)</code> option/format value</a></li>
<li><a href="#mla_regular_expressions_replace">The <code>,replace(p,r,v)</code> option/format value</a></li>
<li><a href="#mla_regular_expressions_matches">The <code>matches:</code> field-level prefix</a></li>
<li><a href="#mla_regular_expressions_examples">Application Examples</a></li>
</ul></li>
<li>
<a href="#mla_text_widget"><strong>The MLA Text Widget</strong></a>
</li>
<li>
<a href="#where_used_reporting"><strong>Where-used Reporting</strong></a>
</li>
<li>
<a href="#terms_search"><strong>Terms Search - filtering on taxonomy term names</strong></a>
</li>
<li>
<a href="#select_parent"><strong>Select Parent Popup Window</strong></a>
</li>
<li>
<a href="#admin_columns"><strong>Support for the &#8220;Admin Columns&#8221; Plugin</strong></a>
</li>
<li>
<a href="#mla_taxonomy_hooks"><strong>Custom Taxonomy Actions and Filters (Hooks)</strong></a>
</li>
<li>
<a href="#mla_list_table_hooks"><strong>Media/Assistant Submenu Actions and Filters (Hooks)</strong></a>
</li>
<li>
<a href="#mla_media_modal_filters"><strong>Media Manager Enhancement filters (Hooks)</strong></a>
</li>
<li>
<a href="#mla_edit_meta_boxes"><strong>Edit Media additional meta boxes (and Hooks)</strong></a>
</li>
<li>
<a href="#mla_views"><strong>Library Views/Post MIME Type Processing</strong></a>
</li>
<li>
<a href="#mla_uploads"><strong>File Extension and MIME Type Processing</strong></a>
</li>
<li>
<a href="#mla_optional_uploads"><strong>Searching for Upload MIME Types</strong></a>
</li>
<li>
<a href="#mla_custom_field_mapping"><strong>Custom Field and Attachment Metadata Processing Options</strong></a>
</li>
<li style="list-style-type:none"><ul class="mla-doc-toc-list">
<li><a href="#custom_field_mapping_example">Custom field mapping example</a></li>
<li><a href="#custom_field_rule_elements">The custom field rule elements</a></li>
<li><a href="#attachment_metadata_mapping">Adding or Changing Attachment Metadata</a></li>
<li><a href="#custom_field_mapping_with_templates">Custom field mapping with Content Templates</a></li>
</ul></li>
<li>
<a href="#mla_iptc_exif_mapping"><strong>IPTC &amp; EXIF Processing Options</strong></a>
</li>
<li style="list-style-type:none"><ul class="mla-doc-toc-list">
<li><a href="#iptc_exif_mapping_example">IPTC/EXIF/WP mapping examples</a></li>
<li><a href="#iptc_exif_mapping_tables">The IPTC/EXIF/WP rule elements</a></li>
<li><a href="#iptc_exif_mapping_with_templates">EXIF/Template mapping with Content Templates</a></li>
<li><a href="#date_iptc_exif_mapping">IPTC/EXIF/WP Mapping and Bulk Editing for the "Uploaded on" Standard Field</a></li>
<li><a href="#pdf_iptc_exif_mapping">IPTC/EXIF/WP Mapping for PDF Documents</a></li>
<li><a href="#wordpress_default_mapping">WordPress default title, slug and description mapping</a></li>
</ul></li>
<li><a href="#mla_mapping_hooks"><strong>MLA Custom Field and IPTC/EXIF/WP Mapping Actions and Filters (Hooks)</strong></a></li>
<li><a href="#mla_debug_tab"><strong>MLA Debug Tab</strong></a></li>
<li><a href="#mla_language_tab"><strong>WPML &amp; Polylang Multilingual Support; the MLA Language Tab</strong></a></li>
<li><a href="#mla_example_plugins"><strong>The Example Plugins</strong></a></li>
</ul>
<h3>Translating/Localizing the plugin</h3>
<p>
If you would like to localize MLA to see the admin screens in your own language,
have a look at the <a title="MLA Internationalization Guide.pdf" href="[+translate_url+]" target="_blank" class="mla-doc-bold-link">MLA Internationalization Guide</a>. You are encouraged to share your translation with other MLA users; the Guide tells you how!
</p>
<h3>Plugin Code Documentation</h3>
<p>
If you are a developer interested in how this plugin is put together, you should
have a look at the <a title="Consult the phpDocs documentation" href="[+phpDocs_url+]" target="_blank" class="mla-doc-bold-link">phpDocs documentation</a>.
<a name="mla_gallery"></a>
</p>
<p>
<a href="#backtotop">Go to Top</a>
</p>
<h3>MLA Gallery Shortcode</h3>
<p>
The <code>[mla_gallery]</code> shortcode is used in a post, page or custom post type to add a gallery of images and/or other Media Library items (such as PDF documents). MLA Gallery is a superset of the <code>[gallery]</code> shortcode in the WordPress core; it is compatible with <code>[gallery]</code> and provides many enhancements. These include:
</p>
<ul class="mla_settings">
<li>Full support for WordPress categories, tags and custom taxonomies. You can select items with any of the taxonomy parameters documented in the WP_Query class.</li>
<li>Support for all post_mime_type values, not just images.</li>
<li>Media Library items need not be "attached" to the post. You can build a gallery with any combination of items in the Library using taxonomy terms, custom fields and more.</li>
<li>Control over the styles, markup and content of each gallery using the Style and Markup Templates documented below.</li>
<li>Access to a wide range of content using the Attachment-specific and Field-level Substitution parameters documented below. A powerful Content Template facility lets you assemble content from multiple sources and vary the results depending on which data elements contain non-empty values for a given gallery item.</li>
<li>You can combine <code>[mla_gallery]</code> data selection with other popular gallery-generating plugins to get the best of both.
</li>
</ul>
<p>
&nbsp;
<a name="documentation_sources"></a>
</p>
<h4>Option/Parameter Documentation Sources</h4>
<p>
If you're new to Media Library Assistant and the <code>[mla_gallery]</code> shortcode you should read through the material in the <a href="#gallery_examples">MLA Gallery Examples</a> section.
</p>
<p>
All of the options/parameters documented for the <code>[gallery]</code> shortcode are supported by the <code>[mla_gallery]</code> shortcode; you can find them in the <a href="http://codex.wordpress.org/Gallery_Shortcode" title="WordPress Codex link" target="_blank">WordPress Codex</a>. Most of the parameters documented for the WP_Query class are also supported; see the <a href="https://developer.wordpress.org/reference/classes/wp_query/" title="WordPress Codex link" target="_blank">Codex WP_Query class reference</a>. Because the <code>[mla_gallery]</code> shortcode is designed to work with Media Library items, there are some parameter differences and extensions; these are documented below.
<a name="gallery_substitution"></a>
</p>
<h4>Substitution Parameters</h4>
<p>
Substitution parameters are a powerful way to add general and attachment-specific values to the gallery display. For example, if you code "<code>mla_rollover_text='{+date+} : {+description+}'</code>, the rollover text will contain the upload date, a colon, and the full description of each gallery item. There are dozens of parameter names like `date` and `description` divided in several categories:
</p>
<table>
<tr>
<td class="mla-doc-table-label"><a href="#gallery_specific">Gallery-specific</a></td>
<td>values that are known at the beginning of shortcode processing and remain the same for the entire shortcode, such as the ID and URL of the post/page in which the shortcode appears</td>
</tr>
<tr>
<td class="mla-doc-table-label"><a href="#mla_style_parameters">Style</a></td>
<td>values that are known when the gallery-specific CSS inline styles are composed just before gallery output begins</td>
</tr>
<tr>
<td class="mla-doc-table-label"><a href="#mla_markup_parameters">Markup</a></td>
<td>values that are known at the beginning of gallery output processing and remain the same for the entire gallery</td>
</tr>
<tr>
<td class="mla-doc-table-label"><a href="#mla_attachment_parameters">Attachment-specific</a></td>
<td  style="vertical-align: top">values that change for each item in the gallery, such as Title and Caption</td>
</tr>
<tr>
<td class="mla-doc-table-label"><a href="#mla_variable_parameters">Field-level</a></td>
<td>values from sources like shortcode parameters, query arguments, custom fields, taxonomy terms and attachment metadata. There are many, many values to choose from as well as options to reformat values and select array elements. You are encouraged to explore them.</td>
</tr>
<tr>
<td class="mla-doc-table-label"><a href="#mla_template_parameters">Content Template</a></td>
<td>lets you compose a value from multiple substitution parameters and test for empty values, choose among two or more alternatives or suppress output entirely</td>
</tr>
</table>
<p>
Click on any of the category names in the above table to go to the Documentation section describing the names available in that category and how to use them.
</p>
<p>
To use a substitution parameter in your shortcode, simply add "{+" before the substitution parameter name and add "+}" after the name. Note that the enclosing delimiters are different than those used in Style and Markup templates, since the WordPress shortcode parser reserves square brackets ("[" and "]") for its own use. Also, because square brackets are reserved, <strong>you must substitute curly braces for square brackets</strong> if your parameter values require them. For example, if your shortcode parameter is <code>mla_link_attributes='rel="shadowbox{sbalbum-{+instance+}};player=img"'</code>, the actual attribute added to the link will be <code>rel="shadowbox[sbalbum-1];player=img"</code>. If you must code a curly brace in a parameter value, preface it with <strong>two backslash characters</strong>, e.g., "\\{" or "\\}".
<a name="complex_shortcodes"></a>
</p>
<h4>Entering Long/Complex Shortcodes</h4>
<p>
The <code>[mla_gallery]</code> shortcode has many parameters and some of them have a complex syntax; it can be a challenge to build a correct shortcode. The <a href="https://codex.wordpress.org/Shortcode_API" title="Shortcode API Documentation" target="_blank">WordPress Shortcode API</a> has a number of limitations that make techniques such as entering HTML or splitting shortcode parameters across multiple lines difficult. If you have trouble with your shortcode, such as an "Invalid mla_gallery tax_query" message, try these rules to correct the problem:
</p>
<ul class="mla_settings">
<li>Use the Text tab of the post/page editor, not the Visual tab.</li>
<li>Enter the entire shortcode on one line; do not break it up - that confuses the WordPress shortcode parser.</li>
<li>Put "&lt;code&gt;&lt;/code&gt;" tags around the entire shortcode. Recent versions of WordPress mangle special characters like "=>" in the query if you don't add the tags.</li>
<li>Use the alternative "enclosing shortcode" syntax detailed below.</li>
</ul>
<p>
When embedding the shortcode in the body of a post, be very careful when coding parameters such as <code>tax_query</code>, <code>meta_query</code> or <code>date_query;</code> they must be a valid PHP array specification. Splitting your query over multiple lines or using the "Visual" editor will introduce HTML markup and escape sequences that can render your query invalid. MLA can clean up some of the damage, but if your query fails use the "mla_debug=true" parameter to see if your query has been corrupted. Look for the "mla_debug attribute_errors" entry in the debug output; it will often list the parts of the shortcode parameters that couldn&rsquo;t be parsed.
</p>
<p>
<strong>IMPORTANT:</strong> Beginning with version 4.0, WordPress changed the way it handles shortcode parameters. Using angle brackets, e.g., the <code>=></code> characters in a shortcode will often return "Invalid mla_gallery tax_query" errors. To prevent this: 1) add "&lt;code&gt;&lt;/code&gt;" tags around your shortcode, 2) use an escape sequence like "=&amp;gt;" in your query or 3) use the enclosing shortcode syntax.
</p>
<p>
MLA also supports an alternative syntax that can help you avoid parsing problems with long shortcodes; the <strong>"enclosing shortcode"</strong> syntax. You can read all about it in the <a href="https://codex.wordpress.org/Shortcode_API" title="Shortcode API Documentation" target="_blank">WordPress Shortcode API</a> documentation, but the basic idea is simple. Instead of coding your parameters inside the shortcode square brackets:
</p>
<p>
<code>[mla_gallery post_parent=all post_mime_type=image/png link=file]</code>
</p>
You code the parameters between opening and closing shortcode delimiters:
<p>
<code>[mla_gallery]post_parent=all post_mime_type=image/png link=file[/mla_gallery]</code>
</p>
<p>
WordPress parses the second, "enclosing" syntax in a different way that can eliminate some problems and make your shortcode easier to understand. For example, you can split your shortcode over multiple lines:
</p>
<p>
<code>[mla_gallery]</code><br />
<code>tax_query="</code><br />
&nbsp;&nbsp;&nbsp;&nbsp;<code>array(</code><br />
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<code>array(</code><br />
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<code>'taxonomy' => 'attachment_category',</code><br />
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<code>'field' => 'id',</code><br />
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<code>'terms' => array(11, 12)</code><br />
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<code>)</code><br />
&nbsp;&nbsp;&nbsp;&nbsp;<code>)"</code><br />
<code>post_mime_type=image/png link=file</code><br />
<code>[/mla_gallery]</code>
</p>
<p>
For simple <code>[mla_gallery]</code> shortcodes, code your parameters within the shortcode square brackets and follow the rules above. For more complex shortcodes, the enclosing syntax can avoid many of the limitations WordPress imposes on shortcode parsing.
<a name="gallery_display_style"></a>
</p>
<h4>Gallery Display Style</h4>
<p>
Two <code>[mla_gallery]</code> parameters provide a way to apply custom style and markup templates to your <code>[mla_gallery]</code> display. These parameters replace the default style and/or markup templates with templates you define on the "Shortcodes" tab of the Settings page. On the "Shortcodes" tab you can also select one of your custom templates to replace the built-in default template for all <code>[mla_gallery]</code> shortcodes the do not contain one of these parameters.
</p>
<table>
<tr>
<td class="mla-doc-table-label">mla_style</td>
<td>replaces the default style template for an <code>[mla_gallery]</code> shortcode. You can code "none" to suppress the addition of CSS inline styles entirely, or code "theme" to let your theme use the <code>use_default_gallery_style</code> filter to make the decision.</td>
</tr>
<tr>
<td class="mla-doc-table-label">mla_markup</td>
<td>replaces the default markup template for an <code>[mla_gallery]</code> shortcode</td>
</tr>
</table>
<p>
Four <code>[mla_gallery]</code> parameters provide control over the placement, size and spacing of gallery items without requiring the use of custom Style templates.
</p>
<table>
<tr>
<td class="mla-doc-table-label">columns</td>
<td>specifies the number of columns. The gallery will include a break tag at the end of each row and calculate the column width as appropriate. The default value is 3. If columns is set to 0, no row breaks will be included.</td>
</tr>
<tr>
<td class="mla-doc-table-label">mla_float</td>
<td>specifies the CSS float attribute of the ".gallery-item" style. Acceptable values are "left", "none", "right"; the default value is "right" if current locale is RTL, "left" on LTR (left-to-right inline flow, e.g., English).</td>
</tr>
<tr>
<td class="mla-doc-table-label">mla_margin</td>
<td>specifies the CSS margin property of the ".gallery-item" style. The default value is "1.5%", a percent of the total gallery width. You can also specify any dimension value, e.g., "10px" or "2em", as well as the "auto" or "inherit" values. Finally, you can specify "none", which will remove the margin property from the styles template altogether.</td>
</tr>
<tr>
<td class="mla-doc-table-label">mla_itemwidth</td>
<td>specifies the CSS width attribute of the ".gallery-item" style. You can specify a percent of the total gallery width, e.g., "33.3%". You can also specify any dimension value, e.g., "10px" or "2em", as well as the "auto" or "inherit" values. You can specify "none", which will remove the width property from the styles template altogether.
<br />&nbsp;<br />
Two additional values, "calculate" (the default) and "exact",  calculate the width automatically, based on the "columns" and "mla_margin" values. For "calculate", the width is calculated by dividing 100% by the number of columns, then subtracting twice the margin. For example, the default value is (floor(1000/3)/10) - ( 2.0 * 1.5 ) = 30.3%. Adding in the left and right margins makes each column 33.3% and the total width will be 99.9%
<br />&nbsp;<br />
For the "exact" value, the calculation is the same but the margin is ignored, so the width value would be 33.3%.</td>
</tr>
</table>
<p>
These parameters are only important if the gallery thumbnails are too large to fit within the width of the page on which they appear. For example, if you code <code>[mla_gallery size=full]</code>, the browser will automatically scale down large images to fit within the width attribute (in percent) of the ".gallery-item" style. The default 1.5% margin will ensure that the images do not overlap; you can increase it to add more space between the gallery items. You can also reduce the itemwidth parameter to increase the left and right space between the items.
</p>
<p>
The default margin and width calculations try to make the total width of each row as close to 100% as possible, but never exceed 100% due to rounding errors. If you have more advanced style and format needs, you can define custom style and/or markup templates. You can code <code>mla_style=none</code> to suppress inline styles entirely and use a separate stylesheet to control the format of the gallery. You can also code <code>mla_style=theme</code>, if your theme supports it, to use the theme's stylesheet to control the format of the gallery.
</p>
<p>
Three parameters provide control over the XHTML tags used to enclose each part of the gallery items.
</p>
<table>
<tr>
<td class="mla-doc-table-label">itemtag</td>
<td>the name of the XHTML tag used to enclose each item in the gallery. The default is "dl"; if your theme supports HTML5, the default is "figure".</td>
</tr>
<tr>
<td class="mla-doc-table-label">icontag</td>
<td>the name of the XHTML tag used to enclose each thumbnail icon in the gallery. The default is "dt"; if your theme supports HTML5, the default is "div".</td>
</tr>
<tr>
<td class="mla-doc-table-label">captiontag</td>
<td>the name of the XHTML tag used to enclose each caption. The default is "dd"; if your theme supports HTML5, the default is "figcaption".</td>
</tr>
</table>
<p>
These parameters work together to change the gallery markup. For example, to change the gallery markup to use div, span and p tags: 
</p>
<p>
<code>[gallery itemtag="div" icontag="span" captiontag="p"]</code>
<a name="gallery_display_content"></a>
</p>
<h4>Gallery Display Content</h4>
<p>
Twelve <code>[mla_gallery]</code> parameters provide an easy way to control the contents of gallery items without requiring the use of custom Markup templates.  
</p>
<table>
<tr>
<td class="mla-doc-table-label">mla_output</td>
<td>completely replaces gallery output with links to the "previous" or "next" item/page or pagination links. Complete documentation is in the <a href="#mla_output_parameter"><strong>Support for Alternative Gallery Output, e.g., Pagination</strong></a> section below.</td>
</tr>
<tr>
<td class="mla-doc-table-label">mla_rollover_text</td>
<td>adds the HTML "title" attribute in the hyperlink for each gallery item. This is the attachment title text displayed when the mouse rolls or hovers over the gallery thumbnail. Note that as of WordPress 3.7 there is no default "title" attribute; for older WordPress versions this parameter will replace the default "title".</td>
</tr>
<tr>
<td class="mla-doc-table-label">mla_target</td>
<td>adds an HTML "target" attribute to the hyperlink for each gallery item; see below.</td>
</tr>
<tr>
<td class="mla-doc-table-label">mla_link_attributes</td>
<td>adds one or more HTML attributes to the hyperlink for each gallery item; see below. For security reasons, HTML event Attributes are not allowed; any attribute name that begins with "on" will invalidate the parameter.</td>
</tr>
<tr>
<td class="mla-doc-table-label">mla_link_class</td>
<td>adds an HTML "class" attribute to the hyperlink for each gallery item.</td>
</tr>
<tr>
<td class="mla-doc-table-label">mla_link_href</td>
<td>replaces the HTML "href" attribute in the hyperlink for each gallery item; see below.</td>
</tr>
<tr>
<td class="mla-doc-table-label">mla_link_text</td>
<td>replaces the thumbnail image or attachment title text displayed for each gallery item.</td>
</tr>
<tr>
<td class="mla-doc-table-label">mla_image_attributes</td>
<td>adds one or more HTML attributes to the "img" tag of the thumbnail image or icon displayed for each gallery item. Note that if you include an "alt" or "class" attribute in this parameter it will override and replace the corresponding attribute already present in the tag, including any "mla_image_class" or "mla_image_alt" value. For security reasons, HTML event Attributes are not allowed; any attribute name that begins with "on" will invalidate the parameter.</td>
</tr>
<tr>
<td class="mla-doc-table-label">mla_image_class</td>
<td><strong>adds</strong> one or more values to the HTML "class" attribute in the "img" tag of the thumbnail image or icon displayed for each gallery item. Existing class values are retained, not replaced.</td>
</tr>
<tr>
<td class="mla-doc-table-label">mla_image_alt</td>
<td>replaces the HTML "alt" attribute in the "img" tag of the thumbnail image or icon displayed for each gallery item.</td>
</tr>
<tr>
<td class="mla-doc-table-label">mla_caption</td>
<td>replaces the attachment caption text displayed beneath the thumbnail of each gallery item.</td>
</tr>
<tr>
<td class="mla-doc-table-label">mla_nolink_text</td>
<td>replaces the empty string displayed when there are no gallery items or no pagination link.</td>
</tr>
</table>
<p>
The "mla_target" parameter accepts any value and adds an HTML "target" attribute to the hyperlink with that value. For example, if you code <code>mla_target="_blank"</code> the item will open in a new window or tab. You can also use "_self", "_parent", "_top" or the "<em>framename</em>" of a named frame.
</p>
<p>
All but the "mla_target" parameter support the <a href="#mla_markup_parameters">Markup</a>, <a href="#mla_attachment_parameters">Attachment-specific</a>, <a href="#mla_variable_parameters">Field-level</a> and <a href="#mla_template_parameters">Content Template</a> substitution parameters defined for Markup Templates. For example, if you code <code>mla_rollover_text='{+date+} : {+description+}'</code>, the rollover text will contain the upload date, a colon, and the full description of each gallery item. Simply add "{+" before the substitution parameter name and add "+}" after the name. Note that the enclosing delimiters are different than those used in the templates, since the WordPress shortcode parser reserves square brackets ("[" and "]") for its own use.
</p>
<p>
The "mla_link_href" parameter is a great way to change the destination your gallery item links to or add arguments to the link for later processing. For example, to make a gallery item link back to the page/post it is attached to, you can code: <code>mla_link_href='{+site_url+}/?page_id={+parent+}'</code>. You can also add arguments to the link, e.g., <code>mla_link_href='{+link_url+}?myarg1=myvalue1&amp;amp;myarg2=myvalue2'</code>. Note the use of the HTML entity name "&amp;amp;" to put an ampersand in the value; the WordPress "visual" post editor will replace "&amp;", "&lt;" and ">" with "&amp;amp;", "&amp;lt;" and "&amp;gt;" whether you like it not. The <strong>only</strong> markup parameter modified by this parameter is "link". Other markup parameters such as "pagelink", "filelink" and "link_url" are not modified.
</p>
<p>
The "mla_link_attributes" and "mla_image_attributes" parameters accept any value and adds it to the "&lt;a&gt;" or "&lt;img&gt;" tags for the gallery item. For example, you can create a Shadowbox JS (plugin) album by adding <code>mla_link_attributes='rel="shadowbox{sbalbum-{+instance+}};player=img"'</code> to your shortcode query (note the use of single quotes around the parameter value and the double quotes within the parameter). <strong>IMPORTANT:</strong> since the shortcode parser reserves square brackets ("[" and "]") for its own use, <strong>you must substitute curly braces for square brackets</strong> if your attributes require brackets (as this example does). In this case, the actual attribute added to the link will be <code>rel="shadowbox[sbalbum-1];player=img"</code>. If you must code a curly brace in your attribute value, preface it with <strong>two backslash characters</strong>, e.g., "\\{" or "\\}". If you code an attribute already present in the tag, your value will override the existing value.
</p>
<p>
The "mla_caption" parameter can be used, for example, to replace the default caption to a hyperlink containing the item's Title You can code something like this:<br />
&nbsp;<br /> 
<code>[mla_gallery size=icon post_mime_type=application/pdf post_parent=all link=file]<br />
mla_caption='&lt;a href="{+file_url+}" target="_blank"&gt;{+title+}&lt;/a&gt;'<br />
[/mla_gallery]</code><br />
&nbsp;<br />
Note the use of the alternative "enclosing shortcode" syntax in this example, which avoids the WordPress issues with including HTML markup in shortcode parameters.
<a name="thumbnail_substitution"></a>
</p>
<h4>Thumbnail Substitution, Featured Images and mla_viewer</h4>
<p>
There are two ways you can provide a thumbnail image for gallery display: 1) you can add a Featured Image to any Media Library item or 2) you can use the <code>mla_viewer</code>	parameter to have one generated when the gallery is displayed.
</p>
<p>
You can assign a "Featured Image" to any Media Library item. Simply go to the Media/Edit Media screen, scroll down to the "Featured Image" meta box and select an image as you would for a post or page. For non-image items such as Microsoft Office documents the Featured Image will replace the MIME-type icon or document title in a gallery display. For items which have a native thumbnail (generated by WordPress) you can add a shortcode parameter to the <code>[mla_gallery]</code> shortcode to have the Featured Image override the native thimbnail:
</p>
<table>
<tr>
<td class="mla-doc-table-label">mla_use_featured</td>
<td>set to "true" to substitute Featured Images for items which have a native thumbnail. The default value is "false"; native thumbnails will always be used when present.</td>
</tr>
</table>
<p>
WordPress 4.7 added thumbnail generation for PDF documents, and these "native thumbnail images" will automatically be used when available. You can also use MLA's thumbnail generation support (in the Media/Assistant Bulk Actions) to create native thumbnails for older documents.
</p>
<p>
The <code>mla_viewer</code> solution supports dynamic thumbnail image generation for PDF and Postscript documents on your site's server. The dynamic thumbnail image generation uses the PHP <code>Imagick</code> class, which <strong>requires ImageMagick and Ghostscript</strong> to be installed on your server.  If you need help installing them, look at this <a href="https://wordpress.org/support/topic/nothing-but-error-messages" title="Help with installation" target="_blank">PDF Thumbnails support topic</a>. If you don't have them on your server you can still use the Featured Image support to supply thumbnails for your non-image items.
</p>
<p>
Ten <code>[mla_gallery]</code> parameters provide an easy way to simulate thumbnail images for the non-image file types.
</p>
<table>
<tr>
<td class="mla-doc-table-label">mla_viewer</td>
<td>must be "true" or "single" to enable thumbnail substitution. Use "true" unless you experience generation failures due to memory limitations on your server. Use "single" to generate one thumbnail at a time, which may be slower but requires less memory. You can add ",required" to bypass the WordPress-generated native PDF thumbnails; MLA's Featured Image or a dynamically-generated thumbnail will always be used when ",required" is present.</td>
</tr>
<tr>
<td class="mla-doc-table-label">mla_viewer_extensions</td>
<td>a comma-delimited list of the file extensions to be processed; the default is "ai,eps,pdf,ps" (do not include the dot (".") preceding the file extension). You may add or remove extensions (when support for additional types becomes available).</td>
</tr>
<tr>
<td class="mla-doc-table-label">mla_viewer_limit</td>
<td>the upper limit in megabytes (default none) on the size of the file to be processed. You can set this to avoid processing large documents if performance becomes an issue.</td>
</tr>
<tr>
<td class="mla-doc-table-label">mla_viewer_width</td>
<td>the maximum width in pixels (default "150") of the thumbnail image. The height (unless also specified) will be adjusted to maintain the page proportions.</td>
</tr>
<tr>
<td class="mla-doc-table-label">mla_viewer_height</td>
<td>the maximum height in pixels (default "0") of the thumbnail image. The width (unless also specified) will be adjusted to maintain the page proportions.</td>
</tr>
<tr>
<td class="mla-doc-table-label">mla_viewer_best_fit</td>
<td>retain page proportions (default "false") when both height and width are explicitly stated. If "false", the image will be stretched as required to exactly fit the height and width. If "true", the image will be reduced in size to fit within the bounds, but proportions will be preserved. For example, a typical page is 612 pixels wide and 792 pixels tall. If you set width and height to 300 and set best_fit to true, the thumbnail will be reduced to 231 pixels wide by 300 pixels tall.</td>
</tr>
<tr>
<td class="mla-doc-table-label">size</td>
<td>You can use <code>size</code> as an alternative to <code>mla_viewer_width</code> and/or <code>mla_viewer_height</code> to set the image dimensions from one of the intermediate sizes your site supports, e.g., "medium" or "large" (but not "full"). If <code>size</code> is present and <code>mla_viewer_best_fit</code> is not, <code>mla_viewer_best_fit</code> will be set to "true".</td>
</tr>
<tr>
<td class="mla-doc-table-label">mla_viewer_page</td>
<td>the page number (default "1") to be used for the thumbnail image. If the page does not exist for a particular document the first page will be used instead.</td>
</tr>
<tr>
<td class="mla-doc-table-label">mla_viewer_resolution</td>
<td>the pixels/inch resolution (default 72) of the page before reduction. If you set this to a higher number, such as 300, you will improve thumbnail quality at the expense of additional processing time.</td>
</tr>
<tr>
<td class="mla-doc-table-label">mla_viewer_quality</td>
<td>the compression quality (default 90) of the final page. You can set this to a value between 1 and 100 to get smaller files at the expense of image quality; 1 is smallest/worst and 100 is largest/best.</td>
</tr>
<tr>
<td class="mla-doc-table-label">mla_viewer_type</td>
<td>the MIME type, "image/jpeg" or "image/png", (default image/jpeg) of the final thumbnail. You can, for example, set this to "image/png" to retain a transparent background instead of the white jpeg background.</td>
</tr>
</table>
<p>
When this feature is active, gallery items for which WordPress can generate a thumbnail image are not altered. If WordPress generation fails, the "Featured Image" will be used, if one is specified for the item. If the item does not have a Featured Image, supported file/MIME types (see <code>mla_viewer_extensions</code>) will have a gallery thumbnail generated dynamically. If all else fails, the thumbnail is replaced by an "img" html tag whose "src" attribute contains a url reference to the appropriate icon for the file/MIME type.
</p>
<p>
Five options in the Settings/Media Library Assistant MLA Gallery tab allow control over mla_viewer operation:
</p>
<ul class="mla_settings">
<li><strong>Enable thumbnail substitution</strong><br />
Check this option to allow the "mla_viewer" to generate thumbnail images for PDF documents. Thumbnails are generated dynamically, each time the item appears in an <code>[mla_gallery]</code> display.<br />
<strong>NOTE</strong>: If Imagick and/or Ghostscript support is not present a warning message will be displayed below the option checkbox.</li>
<li><strong>Enable Featured Images</strong><br />
Check this option to extend Featured Image support to all Media Library items. The Featured Image can be used as a thumbnail image for the item in an <code>[mla_gallery]</code> display.</li>
<li><strong>Enable Featured Image Generation</strong><br />
Check this option to enable the "Thumbnail" generation action in the Media/Assistant submenu Bulk Actions dropdown.
The Thumbnail generation action lets you add Featured Image items by generating an image for non-image files such as PDF documents.</li>
<li><strong>Enable explicit Ghostscript check</strong><br />
Check this option to enable the explicit check for Ghostscript support required for thumbnail generation. If your Ghostscript software is in a non-standard location, unchecking this option bypasses the check. Bad things can happen if Ghostscript is missing but ImageMagick is present, so leave this option checked unless you know it is safe to turn it off.</li>
<li><strong>Ghostscript path</strong><br />
If your Ghostscript software is in a non-standard location, enter the full path and name of the executable here. The value you enter will be used as-is and the search for Ghostscript in the usual locations will be bypassed.</li>
</ul>
<a name="order_orderby"></a>&nbsp;
<h4>Order, Orderby</h4>
<p>
The Orderby parameter specifies which database field(s) are used to sort the gallery. You can sort the gallery by one or more of these values (there is additional information on some of these values in the <a href="https://developer.wordpress.org/reference/classes/wp_query/#order-orderby-parameters" title="WordPress Codex link" target="_blank">Codex WP_Query class reference</a>):
</p>
<table>
<tr>
<td class="mla-doc-table-label">none</td>
<td>No order.</td>
</tr>
<tr>
<td class="mla-doc-table-label">ID</td>
<td>Order by post id. Note capitalization.</td>
</tr>
<tr>
<td class="mla-doc-table-label">author</td>
<td>Order by author (id, not display name).</td>
</tr>
<tr>
<td class="mla-doc-table-label">date</td>
<td>Order by date uploaded.</td>
</tr>
<tr>
<td class="mla-doc-table-label">description, content</td>
<td>Order by attachment description.</td>
</tr>
<tr>
<td class="mla-doc-table-label">title</td>
<td>Order by attachment title.</td>
</tr>
<tr>
<td class="mla-doc-table-label">caption, excerpt</td>
<td>Order by attachment caption. </td>
</tr>
<tr>
<td class="mla-doc-table-label">slug, name</td>
<td>Order by attachment name.</td>
</tr>
<tr>
<td class="mla-doc-table-label">modified</td>
<td>Order by last modified date.</td>
</tr>
<tr>
<td class="mla-doc-table-label">parent</td>
<td>Order by post/page parent id.</td>
</tr>
<tr>
<td class="mla-doc-table-label">menu_order</td>
<td>Order by page order.</td>
</tr>
<tr>
<td class="mla-doc-table-label">mime_type</td>
<td>Order by attachment MIME type.</td>
</tr>
<tr>
<td class="mla-doc-table-label">comment_count</td>
<td>Order by number of comments.</td>
</tr>
<tr>
<td class="mla-doc-table-label">rand</td>
<td>Random order.</td>
</tr>
<tr>
<td class="mla-doc-table-label">&lt;keyname&gt;, meta_value,<br />meta_value_num</td>
<td style="vertical-align: top;">Order by custom field value. Note that a <em>'meta_key=keyname'</em> must also be present in the query. For example, to sort by a custom field called "Publication Date" and display the most recent items first, code <code>[mla_gallery meta_key="Publication Date" orderby=meta_value order=DESC]</code></td>
</tr>
<tr>
<td class="mla-doc-table-label">post__in</td>
<td>Preserve order given in the <em>ids, include</em> or <em>post__in</em> array.</td>
</tr>
</table>
<p>
You can sort on more than one value, e.g., <code>orderby="author, date DESC"</code> and you can specify ASC/DESC on a value by value basis. <strong>NOTE: multiple orderby values are separated by commas, not spaces.</strong> This is a change from WP_Query. </p>
<p>
The order parameter (default ASC) can give an ASC/DESC default for any value that doesn't have a specific choice. For example, <code>orderby="author, date DESC, mime_type" order=ASC</code> is the same as <code>orderby="author ASC, date DESC, mime_type ASC"</code>.
<a name="size"></a>
</p>
<h4>Size</h4>
<p>
The Size parameter specifies the image size to use for the thumbnail display; "thumbnail" is the default value. You can also substitute an appropriate icon for some or all items or replace the thumbnail image with the item title.
</p>
<table>
<tr>
<td class="mla-doc-table-label">thumbnail,&nbsp;medium,<br />large,&nbsp;full</td>
<td valign="top">For image types, the size of the image you want to display. If the specific size is not available for an image an existing size will be substituted. For non-image types the title of the item will be displayed.</td>
</tr>
<tr>
<td class="mla-doc-table-label" style="font-style:italic">(other registered size)</td>
<td>For image types, any additional image size that was registered with add_image_size(). If the specified size is not available or if the attachment is not an image the title of the item will be displayed.</td>
</tr>
<tr>
<td class="mla-doc-table-label">icon</td>
<td>Display an appropriate 60x60 (or 64x64) pixel thumbnail for image items and an appropriate icon for non-image items such as PDF or text files. If, however, a non-image item has a "Featured Image" it will replace the icon.</td>
</tr>
<tr>
<td class="mla-doc-table-label">icon_feature</td>
<td>Display an appropriate 60x60 (or 64x64) pixel icon for <strong>ALL</strong> items, image and non-image. If, however, an item has a "Featured Image" it will replace the icon.</td>
</tr>
<tr>
<td class="mla-doc-table-label">icon_only</td>
<td>Display an appropriate 60x60 (or 64x64) pixel icon for <strong>ALL</strong> items, image and non-image.</td>
</tr>
<tr>
<td class="mla-doc-table-label">none</td>
<td>Suppress thumbnail display and substitute the title of the item.</td>
</tr>
</table>
<p>
&nbsp;
<a name="link"></a>
</p>
<h4>Link</h4>
<p>
The Link parameter specifies the target and type of link from the gallery item to the attachment or other destination. You can also specify a non-hyperlink treatment for the item.
</p>
<table>
<tr>
<td class="mla-doc-table-label">permalink, post</td>
<td>Link to the attachment's "media page". This is the default value.</td>
</tr>
<tr>
<td class="mla-doc-table-label">original</td>
<td>Link directly to the original, full-size, image file for scaled images or to the attachment file for unscaled images.</td>
</tr>
<tr>
<td class="mla-doc-table-label">file, full</td>
<td>Link directly to the attachment file. See also the "Transfer by Item Name" section just below.</td>
</tr>
<tr>
<td class="mla-doc-table-label">download</td>
<td>Link to the MLA "Transfer by Item Name" feature for this attachment with <code>mla_disposition=attachment</code>. Forces a file download instead of opening the file in the browser.  See the "Transfer by Item Name" section just below.</td>
</tr>
<tr>
<td class="mla-doc-table-label">thumbnail,&nbsp;medium,<br />large</td>
<td>For image attachments, the size of the image file you want to link to.</td>
</tr>
<tr>
<td class="mla-doc-table-label" style="font-style:italic">(other registered size)</td>
<td>For image attachments, any additional image size that was registered with add_image_size(). If the specified size is not available or if the attachment is not an image, the link will go directly to the attachment file.</td>
</tr>
<tr>
<td class="mla-doc-table-label">span</td>
<td>Substitutes a <code>&lt;span&gt;&lt;/span&gt;</code> tag for the hyperlink tag. You can use the "mla_link_attributes" and "mla_link_class" parameters to add attributes to the <code>&lt;span&gt;</code> tag. You can use the "mla_link_text" parameter to customize the text within the span.</td>
</tr>
<tr>
<td class="mla-doc-table-label">none</td>
<td>Eliminates the hyperlink tag surrounding the thumbnail image or text. You can use the "mla_link_text" parameter to customize the contents.</td>
</tr>
</table>
<p>
Note that the handling of `link=file` and `link=download` values can be altered by specifying <code>mla_named_transfer=true</code> as described in the next section.
<a name="named_transfer"></a>
</p>
<h4>Transfer by Item Name</h4>
<p>
The "mla_named_transfer" parameter activates a different approach to handling the <code>link=file</code> and <code>link=download</code> values. If you code <code>mla_named_transfer=true</code> each item will be identified by its <code>post_name</code> value instead of its directory and file name. When the gallery item link is clicked the post_name will be used to locate the file and send it to the browser. When used with <code>link=download</code> a file download is performed, otherwise the file will be opened in the browser.
</p>
<p>
The links generated for mla_named_transfer items are of the form:<br />
&nbsp;<br /> 
<code>http://mysite.com/wp-admin/admin-ajax.php?action=mla_named_transfer&amp;mla_item=item-name&amp;mla_disposition=inline</code><br />
&nbsp;<br />
Where the query arguments are:
</p>
<table>
<tr>
<td class="mla-doc-table-label">action</td>
<td>must be "mla_named_transfer".</td>
</tr>
<tr>
<td class="mla-doc-table-label">mla_item</td>
<td>is the post_name/slug value for the item. This is the last, editable part of the item&rsquo;s permalink.</td>
</tr>
<tr>
<td class="mla-doc-table-label">mla_disposition</td>
<td>selects a "forced download" ( use "download" or "attachment" ) or "open in the bowser" ( use "file", "view" or "inline" ).</td>
</tr>
<tr>
<td class="mla-doc-table-label">mla_debug</td>
<td>add <code>mla_debug=log</code> to send diagnostic information to the error log. If you add <code>mla_debug=log</code> as a shortcode parameter it will be added to these links as well.</td>
</tr>
</table>
<p>
This alternate approach provides a small measure of security by obscuring the directory structure used to locate the file. It also makes it possible to generate SEO-friendly "pretty links" and use the <a href="https://codex.wordpress.org/Rewrite_API" title="Codex article: Rewrite API" target="_blank">WordPress Rewrite API</a> to translate the pretty links to the Transfer by Item Name syntax. The <a title="Find the Pretty Links Example" href="[+example_url+]&amp;mla-example-search=Search+Plugins&amp;s=%22MLA+Item+Transfer+Pretty+Links%22" class="mla-doc-bold-link">MLA Item Transfer Pretty Links</a> example plugin shows how this can be done.
<a name="mla_minimum"></a>
</p>
<h4>Minimum Gallery Size</h4>
<p>
You can add <code>mla_minimum=(count)</code> to display an empty gallery if the number of items available for display is less than the number specified. For example, to display an empty gallery when just one item is available, code <code>mla_minimum=2</code>.
<a name="include_exclude"></a>
</p>
<h4>Include, Exclude</h4>
<table>
<tr>
<td class="mla-doc-table-label">include</td>
<td>comma separated attachment IDs to show only the information from these attachments.</td>
</tr>
<tr>
<td class="mla-doc-table-label">exclude</td>
<td>comma separated attachment IDs excludes the information from these attachments. Please note that include and exclude cannot be used together.</td>
</tr>
</table>
<p>
You can add <code>post_parent=all</code> to include or exclude attachments regardless of which post or page they are attached to. You can add <code>post_mime_type=all</code> to include or exclude attachments of all MIME types, not just images.
<a name="post_id_ids_post_parent"></a>
</p>
<h4>Post ID, "ids", Post Parent</h4>
<p>
The "id" parameter lets you specify a post ID for your query. The gallery will display images which are attached to that post. If the "id" parameter is not specified, the <code>[mla_gallery]</code> behavior differs from the <code>[gallery]</code> behavior. If your query uses taxonomy or custom field parameters, "author", "author_name" or "s" (search term), then the query will NOT be restricted to items attached to the current post. This lets you build a gallery with any combination of Media Library items that match the parameters.
</p>
<p>
The "ids" parameter lets you specify a list of item/attachment IDs. The attachment(s) matching the "ids" values will be displayed in the order specified by the list.
</p>
<p>
You can use the "post_parent" to override the default behavior. If you set "post_parent" to a specific post ID, only the items attached to that post are displayed. You can also specify multiple values separated by commas, e.g., <code>post_parent=1,2,3</code>. There are four additional values available:
</p>
<table>
<tr>
<td class="mla-doc-table-label">none</td>
<td>all the <strong>unattached</strong> items are displayed, i.e., items with post_parent equal to zero (0)</td>
</tr>
<tr>
<td class="mla-doc-table-label">current</td>
<td>only the items attached to the current post/page are displayed, i.e., the post/page that contains the shortcode</td>
</tr>
<tr>
<td class="mla-doc-table-label">any</td>
<td>all the <strong>attached</strong> items are displayed, i.e., items with post_parent not equal to zero (0)</td>
</tr>
<tr>
<td class="mla-doc-table-label">all</td>
<td>all of the items are displayed, i.e., post_parent is ignored</td>
</tr>
</table>
<p>
For example, <code>[mla_gallery tag="artisan"]</code> will display all images having the specified tag value, regardless of which post (if any) they are attached to. If you use <code>[mla_gallery tag="artisan" post_parent="current"]</code> it will display images having the specified tag value only if they are attached to the current post.
<a name="author_author_name"></a>
</p>
<h4>Author, Author Name</h4>
<p>
You can query by author's id or &quot;Username&quot;, the value used to log in to the site. In the database this is the "user_nicename" column (not the "display_name" column). For example, if you log in as &quot;john&quot; and your id is 2 you can code:
</p>
<ul class="mla_settings">
<li><code>[mla_gallery author=2]</code></li>
<li><code>[mla_gallery author_name='john']</code></li>
</ul>
<p>Multiple author ID values are allowed, but only one author name value can be entered.
<a name="category_parameters"></a>
</p>
<h4>Category Parameters</h4>
<p>
The Category parameters search in the WordPress core &quot;Categories&quot; taxonomy. Remember to use <code>post_parent=current</code> if you want to restrict your query to items attached to the current post. Category parameters supported by WP_Query are:
</p>
<table>
<tr>
<td class="mla-doc-table-label">cat (int)</td>
<td>use category id.</td>
</tr>
<tr>
<td class="mla-doc-table-label">category,<br />category_name&nbsp;(string)</td>
<td>use category slug (NOT name). As a convenience, MLA allows "category" as a synonym for "category_name".</td>
</tr>
<tr>
<td class="mla-doc-table-label">category__and (array)</td>
<td>use category id.</td>
</tr>
<tr>
<td class="mla-doc-table-label" style="font-style:italic">category__in (array)</td>
<td>use category id.</td>
</tr>
<tr>
<td class="mla-doc-table-label">category__not_in (array)</td>
<td>use category id.</td>
</tr>
</table>
<p>
More information and examples can be found on the <a href="https://developer.wordpress.org/reference/classes/wp_query/#category-parameters" title="WordPress Codex page" target="_blank">WordPress Codex WP_Query Class Reference</a> page.
<a name="tag_parameters"></a>
</p>
<h4>Tag Parameters</h4>
<p>
The Tag parameters search in the WordPress core &quot;Tags&quot; taxonomy. Remember to use <code>post_parent=current</code> if you want to restrict your query to items attached to the current post.
</p>
<p>
More information and examples can be found on the <a href="https://developer.wordpress.org/reference/classes/wp_query/#tag-parameters" title="WordPress Codex page" target="_blank">WordPress Codex WP_Query Class Reference</a> page.
Note that the "tag_id" parameter requires exactly one tag ID; multiple IDs are not allowed. You can use the "tag__in" parameter to query for multiple values.
<a name="simple_taxonomy_parameters"></a>
</p>
<h4>Simple Taxonomy Parameters</h4>
<p>
The <code>[mla_gallery]</code> shortcode supports the simple "{taxonomy}=(term(s))" values (deprecated as of WordPress version 3.1) as well as the more powerful "<a href="https://developer.wordpress.org/reference/classes/wp_query/#taxonomy-parameters" title="WordPress Codex Documentation for tax_query" target="_blank">tax_query</a>" value. <strong>If your shortcode includes an explicit <code>tax_query</code> parameter any simple taxonomy parameters will be ignored.</strong> Use these queries for your custom taxonomies (and for the MLA attachment_category and attachment_tag taxonomies); use the above Category and Tag parameters for the WordPress-provided taxonomies. If you do use a simple taxonomy parameter for Categories and Tags, the slug values are "category" and "post_tag". 
</p>
<p>
For simple queries, enter the custom taxonomy name and the term(s) that must be matched, e.g.:
</p>
<ul class="mla_settings">
<li><code>[mla_gallery attachment_category='separate-category,another-category']</code></li>
</ul>
<p>
Note that you should use the name/slug strings for taxonomy and terms, not the "title" strings. You can often use the "title" strings if they can be "sanitized" to the slug, but this is not always reliable. If you are using the "Att. Tag" taxonomy built in to MLA then your shortcode should be something like:
</p>
<ul class="mla_settings">
<li><code>[mla_gallery attachment_tag=artisan]</code></li>
</ul>
<p>
In this example, "attachment_tag" is the WordPress taxonomy name/slug for the taxonomy. If you're using "Att. Category", the slug would be "attachment_category".
</p>
<p>
The default behavior of the simple taxonomy query will match any of the terms in the list. Three special values let you find all items, items that have no assigned terms in the taxonomy or any (one or more) assigned terms in the taxonomy. For example, to find items that have no Att. Tags or any Att. Tags you can code:
</p>
<ul class="mla_settings">
<li><code>[mla_gallery attachment_tag=ignore.terms.assigned]</code></li>
<li><code>[mla_gallery attachment_tag=no.terms.assigned]</code></li>
<li><code>[mla_gallery attachment_tag=any.terms.assigned]</code></li>
</ul>
<p>
For applications using term id values instead of slugs three numeric synonyms are supported. For example, to find all items, items that have no Att. Tags or any Att. Tags you can code:
</p>
<ul class="mla_settings">
<li><code>[mla_gallery attachment_tag=-3]</code></li>
<li><code>[mla_gallery attachment_tag=-1]</code></li>
<li><code>[mla_gallery attachment_tag=-2]</code></li>
</ul>
<p>
If you have two or more simple taxonomy queries, they will be joined by "AND". MLA enhances the simple taxonomy query form by providing three additional parameters:
</p>
<table>
<tr>
<td class="mla-doc-table-label">tax_relation</td>
<td>SQL operator to join multiple taxonomy queries; can be "AND" (the default) or "OR".</td>
</tr>
<tr>
<td class="mla-doc-table-label">tax_operator</td>
<td>SQL operator to join the terms within each taxonomy; can be "IN" (the default), "NOT IN" or "AND".</td>
</tr>
<tr>
<td class="mla-doc-table-label">tax_include_children</td>
<td>whether or not to include children for hierarchical taxonomies; can be "true" (the default) or "false". </td>
</tr>
</table>
<p>
If you specify any of these parameters, MLA will convert your query to the more powerful "tax_query" form, searching on the "slug" field and using the operator you specify. For example, a query for two terms in which <strong>both</strong> terms must match would be coded as:
</p>
<ul class="mla_settings">
<li><code>[mla_gallery attachment_category='separate-category,another-category' tax_operator=AND tax_include_children=false]</code></li>
</ul>
<p>
If you code two or more simple taxonomy queries, the items selected must contain the terms in <strong><em>all</em></strong> of the taxonomies; they are joined by "AND". If you want to include items that match the terms in <strong><em>any</em></strong> of the taxonomies you can add <code>tax_relation="OR"</code>. For example, a query to match either an <code>attachment_category</code> or an <code>attachment_tag</code> would be coded as:
</p>
<ul class="mla_settings">
<li><code>[mla_gallery attachment_category='some-category' attachment_tag="a-tag" tax_relation=OR]</code></li>
</ul>
<p>
Note that the default tax_include_children value is true, matching the default WordPress setting. If your tax_operator is "AND", you will almost certainly want to change this setting.
<a name="taxonomy_parameters_tax_input"></a>
</p>
<h4>Compound Taxonomy Queries, "tax_input"</h4>
<p>
You can combine taxonomies and terms into a single parameter; <code>tax_input</code>. This is most often used to process selections made in the <a href="#term_list_display_content"><strong>MLA Term List Display Content (Dropdown and Checklist)</strong></a> for controls that contain multiple taxonomies. The parameter value can be one or more items consisting of the taxonomy slug and a term_id or slug, separated by a period. For example, <code>tax_input="animal.34,vegetable.carrot,vegetable.radish"</code>. <strong>If your shortcode includes an explicit <code>tax_query</code> parameter the <code>tax_input</code> parameter will be ignored.</strong> 
</p>
<p>
This example has a simple form to pick a term from two taxonomies and display a gallery with the items assigned to the selected term:
</p>
<p>
<code>
&lt;form id="animal-vegetable-form" method="post" action="."&gt;<br />
[mla_term_list taxonomy="animal,vegetable" mla_output=dropdown]<br />
&lt;input id="animal-vegetable-form-submit" name="animal_vegetable_form_submit" type="submit" value="Search" /&gt;<br />
&lt;/form&gt;<br />
[mla_gallery tax_input={+template:({+request:tax_input.animal-vegetable+}|animal.invalid-slug}+}]
</code>
</p>
<p>
In the example, <code>animal.invalid-slug</code> is a taxonomy.term combination that does not exist. It causes the gallery display to be suppressed until a selection is made in the dropdown control.
<a name="taxonomy_queries"></a>
</p>
<h4>Taxonomy Queries, the "tax_query"</h4>
<p>
More complex queries can be specified by using <a href="https://developer.wordpress.org/reference/classes/wp_query/#taxonomy-parameters" title="WordPress Codex Documentation for tax_query" target="_blank">WP_Query's "tax_query"</a>. <strong>If you add an explicit <code>tax_query</code> parameter to your shortcode any simple taxonomy parameters and the <code>tax_input</code> parameter will be ignored.</strong> Here are two tax_query examples:
</p>
<p><code>[mla_gallery]<br />
tax_query="array(<br />
&nbsp;&nbsp;&nbsp;&nbsp;array(<br />
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'taxonomy' =&gt; 'attachment_tag',<br />
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'field' =&gt; 'slug',<br />
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'terms' =&gt; 'artisan'<br />
&nbsp;&nbsp;&nbsp;&nbsp;)<br />
)"<br />
[/mla_gallery]
</code></p>
<p><code>[mla_gallery]<br />
tax_query="array(<br />
&nbsp;&nbsp;&nbsp;&nbsp;array(<br />
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'taxonomy' =&gt; 'attachment_category',<br />
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'field' =&gt; 'id',<br />
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'terms' =&gt; array(11, 12)<br />
&nbsp;&nbsp;&nbsp;&nbsp;)<br />
)"<br />
post_parent=current<br />
post_mime_type=all<br />
[/mla_gallery]
</code></p>
<p>
The first example is equivalent to the simple query <code>attachment_tag=artisan</code>. The second example matches items of all MIME types, attached to the current post, having an attachment_category ID of 11 or 12. Both examples use the <strong>"enclosing shortcode"</strong> format to avoid problems WordPress has in parsing parameters with special characters such as <code>=&gt;</code>.
</p>
<p>
When embedding the shortcode in the body of a post, be very careful when coding the tax_query; it must be a valid PHP array specification. You can use the alternative "enclosing shortcode" syntax to avoid many problems and make your query easier to enter and understand.  Read and follow the rules and guidelines in the "<a href="#complex_shortcodes">Entering Long/Complex Shortcodes</a>" Documentation section to get the results you want.
</p>
<p>
Three special "terms" values, "ignore.terms.assigned", "no.terms.assigned" and "any.terms.assigned",  let you find all items, items that have no assigned terms in the taxonomy or any (one or more) assigned terms. For example, to find items that have no Att. Tags you can code:</p>
<p><code>[mla_gallery]<br />
tax_query="array(<br />
&nbsp;&nbsp;&nbsp;&nbsp;array(<br />
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'taxonomy' =&gt; 'attachment_tag',<br />
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'terms' =&gt; 'no.terms.assigned'<br />
&nbsp;&nbsp;&nbsp;&nbsp;)<br />
)"<br />
[/mla_gallery]
</code></p>
<p>
You can also use three numeric synonyms, '-3' for "ignore.terms.assigned", '-1' for "no.terms.assigned" and '-2' for "any.terms.assigned" in applications using numeric term id values in place of slugs.
</p>
<p>
When you code <code>'terms' =&gt; 'ignore.terms.assigned'</code> the tax_query element for that taxonomy will be ignored. When you code <code>'terms' =&gt; 'no.terms.assigned'</code> or <code>'terms' =&gt; 'any.terms.assigned'</code> the only other element you need is <code>taxonomy =&gt;</code>. There is no need for parameters like <code>'field' =&gt;</code> or <code>'operator' =&gt;</code> to get the proper results. The example uses use the <strong>"enclosing shortcode"</strong> format to avoid problems WordPress has in parsing parameters with special characters such as <code>=&gt;</code>.
</p>
<p>
Remember to use <code>post_parent=current</code> if you want to restrict your query to items attached to the current post.
<a name="taxonomy_keyword_search"></a>
</p>
<h4>Taxonomy term keyword(s) search</h4>
<p>
Searching for keywords within the names of taxonomy terms is a completely different way to find items based on taxonomy information. Instead of matching on a slug or term-id value you can match on all or part of the term Title. The shortcode parameters in this section give you all the power of the "Terms Search" feature on the Media/Assistant submenu table, as described in the "<a href="#terms_search">Terms Search - filtering on taxonomy term names</a>" Documentation section. Here are the shortcode parameters that correspond to the controls on the "Search Terms" popup window:
</p>
<table>
<tr>
<td class="mla-doc-table-label">mla_terms_taxonomies</td>
<td>A comma-separated list of the taxonomy or taxonomies in which to search. Enter the slug(s) for one or more of the taxonomies registered for Media Library items, e.g., attachment_category or attachment_tag. If this parameter is omitted or empty, <strong>default taxonomies</strong> are specified in the Taxonomy Support section of the General tab.</td>
</tr>
<tr>
<td class="mla-doc-table-label">mla_terms_phrases</td>
<td>The word(s) or phrase(s) you are searching for. Prepending a word or quoted phrase with a hyphen will exclude items matching that value, e.g., 'pillow -sofa' will return items containing 'pillow' but not 'sofa'.</td>
</tr>
<tr>
<td class="mla-doc-table-label">mla_phrase_delimiter</td>
<td>A single character that separates the phrases within a term in <code>mla_terms_phrases</code>. The <strong>default delimiter</strong> is a space (' ').</td>
</tr>
<tr>
<td class="mla-doc-table-label">mla_negative_delimiter</td>
<td>A single character that encloses the negative (excluded) phrases within a term in <code>mla_terms_phrases</code>. The <strong>default delimiter</strong> is a slash ('/').</td>
</tr>
<tr>
<td class="mla-doc-table-label">mla_phrase_connector</td>
<td>If you enter multiple phrases (separated by the <code>mla_phrase_delimiter</code>) in the <code>mla_terms_phrases</code> parameter, this parameter controls how they are connected. Choose from OR to require that any one of the phrases must match for the search to succeed, or <strong>AND (the default)</strong> to require that all of the phrases must match.</td>
</tr>
<tr>
<td class="mla-doc-table-label">mla_term_delimiter</td>
<td>A single character that separates the terms in <code>mla_terms_phrases</code>. The <strong>default delimiter</strong> is a comma (',') since term names can contain spaces.</td>
</tr>
<tr>
<td class="mla-doc-table-label">mla_term_connector</td>
<td>If you enter multiple terms (separated by the <code>mla_term_delimiter</code>) in the <code>mla_terms_phrases</code> parameter, this parameter controls how they are connected. Choose from <strong>OR (the default)</strong> to require that any one of the terms must match for the search to succeed, or AND to require that all of the terms must match.</td>
</tr>
<tr>
<td class="mla-doc-table-label">whole_word</td>
<td>Add <code>whole_word=true</code> to require that each of the words entered must match a whole word in taxonomy terms. This is equivalent to putting quotes around each of the words in your search.</td>
</tr>
<tr>
<td class="mla-doc-table-label">sentence</td>
<td>Add <code>sentence=true</code> to require that all of the words entered must match in sequence. This is equivalent to putting quotes around all of the words in your search.</td>
</tr>
<tr>
<td class="mla-doc-table-label">exact</td>
<td>Add <code>exact=true</code> to require that each phrase must match the entire text of a term name.</td>
</tr>
</table>
<p>
<a name="post_mime_type_parameter"></a>
</p>
<h4>Post MIME Type</h4>
<p>
For compatibility with the WordPress <code>[gallery]</code> shortcode, this parameter defaults to <code>post_mime_type=image</code>. You can override the default to, for example, display PDF documents (<code>post_mime_type=application/pdf</code>) or all MIME types (<code>post_mime_type=all</code>). You can select several MIME types with a comma-separated list, e.g., <code>post_mime_type='audio,video'</code>. Wildcard specifications are also supported. For example, <code>post_mime_type='*/mpeg'</code> to select audio and video mpeg formats or <code>post_mime_type='application/*ms*'</code> to select all Microsoft application formats (Word, Excel, etc.).
<a name="post_type_post_status"></a>
</p>
<h4>Post Type, Post Status</h4>
<p>
For compatibility with the WordPress <code>[gallery]</code> shortcode, these parameters default to <code>post_type=attachment</code>, <code>post_status=inherit</code>. You can override the defaults to, for example, display items in the trash (<code>post_status=trash</code>). You can specify more than one value in a comma-separated list, e.g., <code>post_type="post,page"</code>.
</p>
<p>
You can change the <code>post_type</code> parameter to compose a "gallery" of WordPress objects such as posts, pages and custom post types. For example, to display a gallery of the published posts in a particular category you can code something like:
</p>
<p>
<code>[mla_gallery category=some-term post_type=post post_status=publish post_mime_type=all post_parent=all]</code>
</p>
<p>
Note that you must also change the <code>post_status</code> <code>post_mime_type</code> and <code>post_parent</code> because the default values for those parameters are set for Media Library image items.
</p>
<p>
For posts, pages and custom post types some of the other data values are used in slightly different ways:
</p>
<table>
<tr>
<td class="mla-doc-table-label">Title</td>
<td>Taken from the Title of the item.</td>
</tr>
<tr>
<td class="mla-doc-table-label">Caption</td>
<td>Taken from the Excerpt of the item.</td>
</tr>
<tr>
<td class="mla-doc-table-label">ALT Text</td>
<td>Not used.</td>
</tr>
<tr>
<td class="mla-doc-table-label">Description</td>
<td>Taken from the Content of the item.</td>
</tr>
<tr>
<td class="mla-doc-table-label">Thumbnail</td>
<td>Taken from the Featured Image of the item, if set. You can use the <code>size</code> parameter to display any of the available image sizes. If no Featured Image is set, the Title will be used instead.</td>
</tr>
<tr>
<td class="mla-doc-table-label">Page Link (link=page)</td>
<td valign="top">Taken from the "guid", or "short form" of the link to the item.</td>
</tr>
<tr>
<td class="mla-doc-table-label">File Link (link=file)</td>
<td valign="top">Taken from the permalink to the item.</td>
</tr>
</table>
<p>
You can find all the parameter values and more examples in the WP_Query class reference <a href="https://codex.wordpress.org/Class_Reference/WP_Query#Type_Parameters" title="WordPress Codex link" target="_blank">Type Parameters</a> and <a href="https://codex.wordpress.org/Class_Reference/WP_Query#Status_Parameters" title="WordPress Codex link" target="_blank">Status Parameters</a> sections.
<a name="pagination_parameters"></a>
</p>
<h4>Pagination Parameters</h4>
<p>
Pagination parameters let you divide your <code>[mla_gallery]</code> display into two or more pages when the display includes a large number of items. These parameters work with MLA's <a href="#mla_output_parameter"><strong>Support for Alternative Gallery Output, e.g., Pagination</strong></a> to make it easy to construct multi-page galleries without resorting to PHP templates and code in your theme.
</p>
<table>
<tr>
<td class="mla-doc-table-label">nopaging</td>
<td>The <code>[mla_gallery]</code> shortcode supplies <code>nopaging=true</code> as a default parameter. If you are working with a template that supports pagination you can replace this with specific values for "numberposts", "posts_per_page", "posts_per_archive_page", "paged" and/or "offset" . You can also pass "paged=current" to suppress the "nopaging" default; "current" will be replaced by the appropriate value (<code>get_query_var('paged')</code> or <code>get_query_var('page')</code>).</td>
</tr>
<tr>
<td class="mla-doc-table-label">numberposts,<br />posts_per_page</td>
<td>the number of items to display on each gallery page.</td>
</tr>
<tr>
<td class="mla-doc-table-label">posts_per_archive_page</td>
<td>number of items to show per page - on archive pages only. Over-rides posts_per_page on posts/pages where <code>is_archive()</code> or <code>is_search()</code> is true for the post/page in which the shortcode occurs. Note that search results will not display gallery images.</td>
</tr>
<tr>
<td class="mla-doc-table-label">paged</td>
<td>number of page. Show the items that would normally show up just on page X. The "paged=current" parameter is useful for "paginated single posts" (i.e. posts that include the <code>&lt;!--nextpage--&gt;</code> Quicktag one or more times). Simply make two or more copies of your <code>[mla_gallery]</code> shortcode separated by the Quicktag and include the "paged=current' in each copy. For true pagination it is better to use the "mla_paginate_current" parameter.</td>
</tr>
<tr>
<td class="mla-doc-table-label">offset</td>
<td>the number of terms to skip over before starting the current gallery page. This parameter is usually derived automatically from the more useful "mla_paginate_current" parameter.</td>
</tr>
<tr>
<td class="mla-doc-table-label">mla_paginate_current</td>
<td>the "current" gallery page; defaults to one (1) if not specified. MLA will usually manage this for you, looking for this parameter in the HTML $_REQUEST array if it is not coded in the gallery shortcode.</td>
</tr>
<tr>
<td class="mla-doc-table-label">mla_page_parameter</td>
<td>the name of the parameter containing the current page number; default "mla_paginate_current". You can change the name if you need multiple paginated galleries on one post/page. If you use this parameter, make sure you add it to the gallery shortcode and all pagination shortcodes for that gallery, and use the same unique value in all shortcodes for the specific gallery.</td>
</tr>
<tr>
<td class="mla-doc-table-label">mla_paginate_total</td>
<td>the highest page number you want to display; defaults to (total items / posts_per_page) if not specified, which is usually what you want. </td>
</tr>
</table>
<p>
The task of dividing a large <code>[mla_gallery]</code> into two or more pages is supported by MLA's <a href="#mla_output_parameter"><strong>Support for Alternative Gallery Output, e.g., Pagination</strong></a>. For more information and examples, go to that section of the Documentation. 
<a name="date_parameters"></a>
</p>
<h4>Simple Date Parameters</h4>
<p>
The <code>[mla_gallery]</code> shortcode supports five parameters for filtering the gallery display by year, month, week and day. For more complex date and time filters, see the "date query" feature in the next section below.
</p>
<table>
<tr>
<td class="mla-doc-table-label">year</td>
<td>the 4-digit year by which to filter the gallery, e.g., <code>year=2021</code>.</td>
</tr>
<tr>
<td class="mla-doc-table-label">monthnum</td>
<td>the month number (from 1 to 12) by which to filter the gallery.</td>
</tr>
<tr>
<td class="mla-doc-table-label">w</td>
<td>the week of the year (from 0 to 53) by which to filter the gallery. Uses the MySQL WEEK command. The mode is dependent on the "start_of_week" option.</td>
</tr>
<tr>
<td class="mla-doc-table-label">day</td>
<td>the day of the month (from 1 to 31) by which to filter the gallery.</td>
</tr>
<tr>
<td class="mla-doc-table-label">m</td>
<td>the 6-digit year and month by which to filter the gallery, e.g., <code>m=202101</code>.</td>
</tr>
</table>
<p>
These five parameters always use the "Uploaded on" date, stored in the <code>post_date</code> column of the <code>wp_posts</code> database table. Remember to use <code>post_parent=current</code> if you want to restrict your query to items attached to the current post.
</p>
<p>
You can use the <code>current_timestamp</code>, <code>current_datetime</code> and <code>current_getdate</code> field-level data sources to, for example, return items uploaded in the current year. Code something like <code>year="{+current_timestamp,timestamp( Y )+}"</code>.
<a name="date_queries"></a>
</p>
<h4>Date and Time Queries, the "date query"</h4>
<p>
The <code>[mla_gallery]</code> shortcode supports the "<a href="https://developer.wordpress.org/reference/classes/wp_query/#date-parameters" title="WordPress Codex Documentation for date_query" target="_blank">date_query</a>" parameter introduced in WordPress Version 3.7. You can use a date_query to filter your gallery based on the 'post_date', 'post_date_gmt', 'post_modified', 'post_modified_gmt', 'comment_date', or 'comment_date_gmt' database columns (although the column names include "post", the same columns are used for attachments).
</p>
<p>
As the <a href="https://developer.wordpress.org/reference/classes/wp_query/#date-parameters" title="WordPress Codex Documentation for date_query" target="_blank">Codex date_query documentation</a> suggests, "before" and "after" values can use any of the <a href="http://php.net/strtotime" title="PHP Date and Time Formats">PHP strtotime()-compatible string values</a>, which are quite powerful. For example, you can use relative values such as <code>'after' => 'second tuesday of last month'</code>. Careful study of the PHP documentation can be most rewarding. You can use <code>mla_debug=true</code> to see how PHP and WordPress translate your query to specific date-time values.
</p>
<p>
When embedding the shortcode in the body of a post, be very careful when coding the date_query; it must be a valid PHP array specification. You can use the alternative "enclosing shortcode" syntax to avoid many problems and make your query easier to enter and understand.  Read and follow the rules and guidelines in the "<a href="#complex_shortcodes">Entering Long/Complex Shortcodes</a>" Documentation section to get the results you want.
</p>
<p>
You can use the <code>current_timestamp</code>, <code>current_datetime</code> and <code>current_getdate</code> field-level data sources to, for example, return items uploaded in the current month. Code something like:
</p>
<p>
<code>[mla_gallery]<br />
&nbsp;&nbsp;&nbsp;&nbsp;date_query="array(<br />
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;array(<br />
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'year'  => {+current_timestamp,timestamp( Y )+},<br />
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'month' => {+current_timestamp,timestamp( m )+},<br />
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;),<br />
&nbsp;&nbsp;&nbsp;&nbsp;)"<br />
[/mla_gallery]
</code>
</p>
<p>
Remember to use <code>post_parent=current</code> if you want to restrict your query to items attached to the current post.
<a name="custom_field_parameters"></a>
</p>
<h4>Simple Custom Field Parameters</h4>
<p>
The <code>[mla_gallery]</code> shortcode supports the simple custom field parameters:
</p>
<table>
<tr>
<td class="mla-doc-table-label">meta_key&nbsp;(string)</td>
<td>Custom field key.</td>
</tr>
<tr>
<td class="mla-doc-table-label">meta_value&nbsp;(string)</td>
<td>Custom field value; string-based comparison.</td>
</tr>
<tr>
<td class="mla-doc-table-label">meta_value_num&nbsp;(number)</td>
<td>Custom field value; numeric comparison.</td>
</tr>
<tr>
<td class="mla-doc-table-label">meta_value_delimiter&nbsp;(single&nbsp;character)</td>
<td>Delimiter between two or more Custom field values.</td>
</tr>
<tr>
<td class="mla-doc-table-label">meta_compare&nbsp;(string)</td>
<td>Operator to test the 'meta_value'. Possible values are '=', '!=', '>', '>=', '&lt;', '&lt;=', 'LIKE', 'NOT LIKE', 'IN', 'NOT IN', 'BETWEEN', 'NOT BETWEEN', 'EXISTS', 'NOT EXISTS', 'REGEXP', 'NOT REGEXP' or 'RLIKE'. Default value is '='. </td>
</tr>
</table>
<p>
<strong>IMPORTANT:</strong> Beginning with version 4.0, WordPress changed the way it handles shortcode parameters. Using angle brackets, e.g., the <code>>=</code> characters in a shortcode will often return "Invalid mla_gallery tax_query" errors. To prevent this: 1) add "&lt;code&gt;&lt;/code&gt;" tags around your shortcode, 2) use an escape sequence like "&amp;gt;" in your query or 3) use the enclosing shortcode syntax.
You can find more information in the "<a href="#complex_shortcodes">Entering Long/Complex Shortcodes</a>" Documentation section.
</p>
<p>
For simple queries, enter the custom field name and the value(s) that must be matched, e.g.:
</p>
<ul class="mla_settings">
<li><code>[mla_gallery meta_key=camera meta_value='SP510UZ,NIKON D300E' meta_compare=IN]</code></li>
</ul>
<p>
Note that, by default, multiple custom field values are separated by commas and can contain spaces. Multiple values are only allowed with the 'IN', 'NOT IN', 'BETWEEN' and 'NOT BETWEEN' compare operators. If your values contain a comma you can specify a different delimiter, e.g.:
</p>
<ul class="mla_settings">
<li><code>[mla_gallery meta_key=camera meta_value='SP510UZ^NIKON D300E' meta_value_delimiter='^' meta_compare=IN]</code></li>
</ul>
<p>
Three special values let you find all items, items that have no valuess in the custom field or any (one or more) values in the field. For example, to find all items, items that have no values or any values you can code:
</p>
<ul class="mla_settings">
<li><code>[mla_gallery meta_key=camera meta_value=ignore.values.assigned]</code></li>
<li><code>[mla_gallery meta_key=camera meta_value=no.values.assigned]</code></li>
<li><code>[mla_gallery meta_key=camera meta_value=any.values.assigned]</code></li>
</ul>
<p>
These special values are particularly useful when forms containing a cloud, list, dropdown or checklist copntrol are used to select values, e.g., when the "<a href="#mla_cf_list">MLA Custom Field List Shortcode</a>" is used to present values for selection.
</p>
<p>
Remember to use <code>post_parent=current</code> if you want to restrict your query to items attached to the current post.
<a name="custom_field_queries"></a>
</p>
<h4>Custom Field Queries, the "meta_query"</h4>
<p>
The <code>[mla_gallery]</code> shortcode supports the more powerful <a href="https://developer.wordpress.org/reference/classes/wp_query/#custom-field-post-meta-parameters" title="WordPress Codex documentation for meta_query" target="_blank">"WP_Query meta_query"</a> parameters made available as of WordPress 3.1.
</p>
<p>
When embedding the shortcode in the body of a post, be very careful when coding the meta_query; it must be a valid PHP array specification. You can use the alternative "enclosing shortcode" syntax to avoid many problems and make your query easier to enter and understand.  Read and follow the rules and guidelines in the "<a href="#complex_shortcodes">Entering Long/Complex Shortcodes</a>" Documentation section to get the results you want.
</p>
<p>
Remember to use <code>post_parent=current</code> if you want to restrict your query to items attached to the current post.
<a name="search_keywords"></a>
</p>
<h4>Keyword(s) Search</h4>
<p>
The search parameter ("s=keyword") will perform a keyword search. By default, the search includes the "post_title" and "post_content" (Description) fields but not the "post_excerpt" (Caption) field. All of the words you enter in the parameter must match for the search to succeed. An SQL "LIKE" clause for each word is composed and added to the search criteria.
</p>
<p>
You can match on multi-word phrases in a variety of ways. These are described in detail, with examples, in the "Entering Words and Phrases" portion of the "<a href="#terms_search">Terms Search - filtering on taxonomy term names</a>" Documentation section. You can also use the <code>whole_word=true</code>, <code>sentence=true</code> and <code>exact=true</code> parameters to change the matching logic used in the <code>[mla_gallery]</code> shortcode.
</p>
<p>
You can search for Media Library items and parent posts/pages by their ID value(s). If <strong>all of the values</strong> in the search field are numeric (and unquoted) they will be interpreted as ID values. To search for items attached to one or more parent posts/pages, enter the ID of the parent(s). If you want to search for a numeric value in the text fields, surround it with quotes.
</p>
<p>
You can use the <code>mla_search_connector</code> and <code>mla_search_fields</code> parameters to extend the search to other fields and to relax the requirement that all phrases must match. Here are all of the parameters that control keyword searching:
</p>
<table>
<tr>
<td class="mla-doc-table-label">s</td>
<td>The word(s) or phrase(s) you are searching for. Prepending a word or quoted phrase with a hyphen will exclude items matching that value, e.g., 'pillow -sofa' will return items containing 'pillow' but not 'sofa'.</td>
</tr>
<tr>
<td class="mla-doc-table-label">mla_search_fields</td>
<td>The fields in which to search. Choose from title, name, excerpt, content, alt-text, file, terms.</td>
</tr>
<tr>
<td class="mla-doc-table-label">mla_negative_delimiter</td>
<td>A single character that encloses the negative (excluded) phrases in the search string. The <strong>default delimiter</strong> is a slash ('/'), e.g., 'pillow /sofa/' will return items containing 'pillow' but not 'sofa'.</td>
</tr>
<tr>
<td class="mla-doc-table-label">mla_terms_taxonomies</td>
<td>If you include 'terms' in <code>mla_search_fields</code>, you can add a comma-separated list of the taxonomy or taxonomies in which to search. Enter the slug(s) for one or more of the taxonomies registered for Media Library items, e.g., attachment_category or attachment_tag. If this parameter is omitted or empty, <strong>default taxonomies</strong> are specified in the Taxonomy Support section of the General tab.</td>
</tr>
<tr>
<td class="mla-doc-table-label">mla_search_connector</td>
<td>Choose from OR to require that any one of the phrases must match for the search to succeed, or AND (the default) to require that all of the phrases must match.</td>
</tr>
<tr>
<td class="mla-doc-table-label">whole_word</td>
<td>Add <code>whole_word=true</code> to require that each of the words entered must match a whole word in taxonomy terms. This is equivalent to putting quotes around each of the words in your search. <strong>Note that this option only affects the "terms" portion of the search.</strong> WordPress does not support a whole word search in any of the other search fields.</td>
</tr>
<tr>
<td class="mla-doc-table-label">sentence</td>
<td>Add <code>sentence=true</code> to require that all of the words entered must match in sequence. This is equivalent to putting quotes around all of the words in your search.</td>
</tr>
<tr>
<td class="mla-doc-table-label">exact</td>
<td>Add <code>exact=true</code> to require that the entire field content must match the search text.</td>
</tr>
</table>
<p>
The <code>mla_search_fields=terms</code> feature is a simple way to extend the search to the terms assigned to Media Library items. If searching on taxonomy terms is your primary goal, consider the more powerful "<a href="#taxonomy_keyword_search">Taxonomy term keyword(s) search</a>" parameters discussed in an earlier Documentation section.
<a name="cache_parameters"></a>
</p>
<h4>Caching Parameters</h4>
<p>
For applications that have very large numbers of attachments and taxonomy terms, there are three caching parameters that may improve the performance of your <code>[mla_gallery]</code> shortcodes. All of them default to "true", but you can set them to "false" to avoid some database access.
</p>
<table>
<tr>
<td class="mla-doc-table-label">cache_results</td>
<td>Post information cache.</td>
</tr>
<tr>
<td class="mla-doc-table-label">update_post_meta_cache</td>
<td>Post meta information cache.</td>
</tr>
<tr>
<td class="mla-doc-table-label">update_post_term_cache</td>
<td>Post term information cache.</td>
</tr>
</table>
<p>
In general you won't need these, since adding to the cache is the right thing to do, but they may be useful in specific circumstances. An example of such circumstances might be when using an <code>[mla_gallery]</code> to retrieve a simple list of thumbnails and links, but in which no other information about the items will be used and the taxonomy and meta data won't be needed. By not loading this information, you can save some time from the extra unnecessary SQL queries. 
<a name="fields_parameter"></a>
</p>
<h4>Fields Parameter</h4>
<p>
If your application uses PHP code to access Media Library items you can use the <code>MLAShortcodes::mla_get_shortcode_attachments()</code> function to perform the data selection portion of the <code>[mla_gallery]</code> processing and return an array of Media Library items. In this case, you can add a <code>fields</code> parameter to simplify the query and return just the ID values for the selected items instead of complete objects. There are two possible values for this parameter:
</p>
<table>
<tr>
<td class="mla-doc-table-label">fields=ids</td>
<td>Return an array of ID values.</td>
</tr>
<tr>
<td class="mla-doc-table-label">fields='id=>parent'</td>
<td>Return an array of stdClass objects with ID and post_parent properties.</td>
</tr>
</table>
<p>
&nbsp;
<a name="debugging_output"></a>
</p>
<h4>Debugging Output</h4>
<p>
The "mla_debug" parameter controls the display of information about the query parameters and SQL statements used to retrieve gallery items. If you code <code>mla_debug=true</code> you will see a lot of information added to the post or page containing the gallery. Of course, this parameter should <strong><em>ONLY</em></strong> be used in a development/debugging environment; it's quite ugly.
</p>
<p>
If you code <code>mla_debug=log</code> all of the information will be written to the error log. You can use the <a href="#mla_debug_tab">MLA Debug Tab</a> to view and download the information in the error log.
</p>
 <p>
Look for the "mla_debug attribute_errors" entry in the debug output; it will often list the parts of the shortcode parameters that couldn&rsquo;t be parsed. If you see "[mla_gallery" in this entry you probably used the enclosing shortcode format in that shortcode but did not add the "[/mla_gallery]" delimiter to an earlier shortcode.
<a name="mla_gallery_hooks"></a>
</p>
<h4>MLA Gallery Filters and Actions (Hooks)</h4>
<p>
The <code>[mla_gallery]</code> shortcode supports a comprehensive set of filters and actions that give you complete control over gallery composition from PHP code in your theme or in another plugin. All of the hooks and their parameters are documented in a simple, stand-alone plugin that can be found in the Documentation/Example Plugins submenu. You can find the example plugin here: <a title="Find the Gallery Hooks Example" href="[+example_url+]&amp;mla-example-search=Search+Plugins&amp;s=%22MLA+Gallery+Hooks+Example%22" class="mla-doc-bold-link" target="_blank">MLA Gallery Hooks Example</a>. You can use the rollover actions to view the code or download a copy or, to run the example:
</p>
<ol>
<li>Click on the link above or go to top of the Documentation tab and click on the "Example Plugins" button.</li>
<li>Hover over "MLA Gallery Hooks Example" in the Name column, then click the "Install" rollover action.</li>
<li>Go to the Plugins/Installed Plugins screen and activate the "MLA Gallery Hooks Example" plugin.</li>
<li>Edit the code to, for example, uncomment the <code>error_log()</code> calls so you can see what is passed to the hooks you are interested in.</li>
<li>Create a new <code>[mla_gallery]</code> shortcode or modify an existing shortcode, adding the <code>my_filter="all custom"</code> parameter to activate the example output.</li>
<li>View the post or page on which the modified shortcode appears to see a list of each item's custom fields appended to the gallery captions.</li>
</ol>
<p>
The example code documents each hook with comments in the filter/action function that intercepts each hook. Generally, each part of the gallery supports three hooks: 1) a "<strong>values</strong>" hook, which lets you record or update the substitution values for that gallery part, 2) a "<strong>template</strong>" hook, which lets you record/update the template used to generate the HTML markup, and 3) a "<strong>parse</strong>" hook which lets you modify or replace the markup generated for a gallery part. The current hooks are:
</p>
<table>
<tr>
<td class="mla-doc-hook-label">mla_raw_gallery_attributes</td>
<td class="mla-doc-hook-definition">called at the beginning of the gallery, before the attributes pass through the logic that handles the 'mla_page_parameter' and "request:" prefix processing.</td>
</tr>
<tr>
<td class="mla-doc-hook-label">mla_gallery_attributes,<br />mla_gallery_arguments</td>
<td class="mla-doc-hook-definition">called at the beginning of the gallery. You can record/modify shortcode parameter values before (attributes) or after (arguments) they are combined with all the defaults.</td>
</tr>
<tr>
<td class="mla-doc-hook-label">mla_gallery_initial_content</td>
<td class="mla-doc-hook-definition">called just after the <code>mla_gallery_attributes</code> filter, so you can inspect/modify any content enclosed by the <code>[mla_gallery]content[\mla_gallery]</code> "enclosing" shortcode format.</td>
</tr>
<tr>
<td class="mla-doc-hook-label">mla_gallery_query_attributes,<br />mla_gallery_query_arguments</td>
<td class="mla-doc-hook-definition">called just before the <code>WP_Query->query()</code> call that selects gallery items, with query parameters before or after they are combined with defaults.</td>
</tr>
<tr>
<td class="mla-doc-hook-label">mla_gallery_wp_query_object</td>
<td class="mla-doc-hook-definition">called just after the <code>WP_Query->query()</code> call, so you can inspect/record the results.</td>
</tr>
<tr>
<td class="mla-doc-hook-label">mla_gallery_the_attachments</td>
<td class="mla-doc-hook-definition">called after the <code>WP_Query->query()</code> is performed, so you can inspect/record the results or return a modified array of items satisfying the query.</td>
</tr>
<tr>
<td class="mla-doc-hook-label">mla_gallery_alt_shortcode_blacklist</td>
<td class="mla-doc-hook-definition">called after the <code>mla_gallery_wp_query_object</code> filter, so you can inspect/modify the list of parameters to be removed from those passed to the alternative gallery shortcode.</td>
</tr>
<tr>
<td class="mla-doc-hook-label">mla_gallery_alt_shortcode_attributes</td>
<td class="mla-doc-hook-definition">called after the <code>mla_gallery_wp_query_object</code> filter, so you can inspect/modify the parameters passed to the alternative gallery shortcode.</td>
</tr>
<tr>
<td class="mla-doc-hook-label">mla_gallery_alt_shortcode_ids</td>
<td class="mla-doc-hook-definition">called after the <code>mla_gallery_wp_query_object</code> filter, so you can inspect/modify the ID values or the entire <code>mla_alt_shortcode_ids</code> parameter passed to the alternative gallery shortcode.</td>
</tr>
<tr>
<td class="mla-doc-hook-label">mla_gallery_final_content</td>
<td class="mla-doc-hook-definition">called after the <code>mla_gallery_wp_query_object</code> filter, so you can inspect/modify any content enclosed by the <code>[mla_gallery]content[\mla_gallery]</code> "enclosing" shortcode format before it is passed to the alternative gallery shortcode.</td>
</tr>
<tr>
<td class="mla-doc-hook-label">mla_gallery_end_alt_shortcode</td>
<td class="mla-doc-hook-definition">called after the alternative gallery shortcode has been processed, so you can perform cleanup or other final actions.</td>
</tr>
<tr>
<td class="mla-doc-hook-label">use_mla_gallery_style</td>
<td class="mla-doc-hook-definition">allow or suppress the inclusion of CSS styles in the gallery output.</td>
</tr>
<tr>
<td class="mla-doc-hook-label">mla_gallery_style</td>
<td class="mla-doc-hook-definition">an old filter retained for compatibility with earlier MLA versions.</td>
</tr>
<tr>
<td class="mla-doc-hook-label">mla_gallery_style_values,<br /> mla_gallery_style_template,<br />mla_gallery_style_parse</td>
<td class="mla-doc-hook-definition">for manipulating the Style template.</td>
</tr>
<tr>
<td class="mla-doc-hook-label">mla_gallery_pagination_values</td>
<td class="mla-doc-hook-definition">for manipulating the markup values used in pagination controls.</td>
</tr>
<tr>
<td class="mla-doc-hook-label">mla_gallery_open_values,<br />mla_gallery_open_template,<br />mla_gallery_open_parse</td>
<td class="mla-doc-hook-definition">for manipulating the "Open" part of the Markup template.</td>
</tr>
<tr>
<td class="mla-doc-hook-label">mla_gallery_row_open_values,<br />mla_gallery_row_open_template,<br />mla_gallery_row_open_parse</td>
<td class="mla-doc-hook-definition">for manipulating the "Row Open" part of the Markup template.</td>
</tr>
<tr>
<td class="mla-doc-hook-label">mla_gallery_initial_item_values,<br />mla_gallery_item_values,<br />mla_gallery_item_template,<br />mla_gallery_item_parse</td>
<td class="mla-doc-hook-definition">for manipulating the "Item" part of the Markup template.</td>
</tr>
<tr>
<td class="mla-doc-hook-label">mla_gallery_row_close_values,<br />mla_gallery_row_close_template,<br />mla_gallery_row_close_parse</td>
<td class="mla-doc-hook-definition">for manipulating the "Row Close" part of the Markup template.</td>
</tr>
<tr>
<td class="mla-doc-hook-label">mla_gallery_close_values,<br />mla_gallery_close_template,<br />mla_gallery_close_parse</td>
<td class="mla-doc-hook-definition">for manipulating the "Close" part of the Markup template.</td>
</tr>
</table>
<a name="mla_tag_cloud"></a>
&nbsp;
<p>
<a href="#backtotop">Go to Top</a>
</p>
<h3>MLA Tag Cloud Shortcode</h3>
<p>
The <code>[mla_tag_cloud]</code> shortcode function displays a list of taxonomy terms in what is called a 'tag cloud', where the size of each term is determined by how many times that particular term has been assigned to Media Library items (attachments). The cloud works with both flat (e.g., Att. Tags) and hierarchical taxonomies (e.g., Att. Categories) MLA Tag Cloud provides many enhancements to the basic "cloud" display. These include:
</p>
<ul class="mla_settings">
<li>Full support for WordPress categories, tags and custom taxonomies. You can select from any taxonomy or list of taxonomies defined in your site.</li>
<li>Several display formats, including "flat", "list" and "grid" (modeled after the <code>[mla_gallery]</code> display).</li>
<li>Complete support for paginated clouds; display hundreds or thousands of terms in manageable groups.</li>
<li>Control over the styles, markup and content of each cloud using Style and Markup Templates. You can customize the "list" and "grid" formats to suit any need.</li>
<li>Access to a wide range of content using the term-specific and Field-level Substitution parameters. A powerful Content Template facility lets you assemble content from multiple sources and vary the results depending on which data elements contain non-empty values for a given term.</li>
<li>Display Style and Display Content parameters for easy customization of the cloud display and the destination of the links behind each term.
</li>
<li>A comprehensive set of filters gives you access to each step of the cloud generation process from PHP code in your theme or other plugins.
</li>
</ul>
<p>
The <code>[mla_tag_cloud]</code> shortcode has many parameters and some of them have a complex syntax; it can be a challenge to build a correct shortcode. The WordPress Shortcode API has a number of limitations that make techniques such as entering HTML or splitting shortcode parameters across multiple lines difficult. You can use the alternative "enclosing shortcode" syntax to avoid many problems and make your shortcode easier to enter and understand. Read and follow the rules and guidelines in the "<a href="#complex_shortcodes">Entering Long/Complex Shortcodes</a>" Documentation section to get the results you want. 
</p>
<p>
Many of the <code>[mla_tag_cloud]</code> concepts and shortcode parameters are modeled after the <code>[mla_gallery]</code> shortcode, so the learning curve is short. Differences and parameters unique to the cloud are given in the sections below.
<a name="tag_cloud_output"></a>
</p>
<h4>Tag Cloud Output Formats</h4>
<p>
The traditional tag cloud output is a "heat map" of term names where larger names are associated with more attachments than smaller names. The terms' display format is determined by the <strong>"mla_output"</strong> parameter:
</p>
<table>
<tr>
<td class="mla-doc-table-label">flat</td>
<td>Returns a sequence of hyperlink tags without further HTML markup. The "separator" parameter content (default, one newline character) is inserted between each hyperlink. <strong>"flat" is the default output format value.</strong></td>
</tr>
<tr>
<td class="mla-doc-table-label">list</td>
<td>Returns hyperlinks enclosed by one of the HTML list tags; unordered (<strong>&lt;ul&gt;&lt;/ul&gt;, the default tag value</strong>) or definitions (&lt;dl&gt;&lt;/dl&gt;), which allow for each term to have a "caption". The "itemtag", "termtag" and "captiontag" parameters customize the list markup. If the "captiontag" parameter is present the list tag will be definitions (&lt;dl&gt;&lt;/dl&gt;).</td>
</tr>
<tr>
<td class="mla-doc-table-label">ulist</td>
<td>Returns hyperlinks enclosed by HTML unordered list tags (&lt;ul&gt;&lt;/ul&gt;). The "itemtag" and "termtag" parameters customize the list markup.</td>
</tr>
<tr>
<td class="mla-doc-table-label">olist</td>
<td>Returns hyperlinks enclosed by HTML ordered list tags (&lt;ol&gt;&lt;/ol&gt;). The "itemtag" and "termtag" parameters customize the list markup.</td>
</tr>
<tr>
<td class="mla-doc-table-label">dlist</td>
<td>Returns hyperlinks enclosed by HTML definition list tags (&lt;dl&gt;&lt;/dl&gt;), which allow for each term to have a "caption". The "itemtag", "termtag" and "captiontag" parameters customize the list markup.</td>
</tr>
<tr>
<td class="mla-doc-table-label">grid</td>
<td>Modeled on the galleries produced by <code>[mla_gallery]</code>; a rectangular display with rows and columns. The tag parameters listed above, the "columns" parameter and the Display Style parameters customize the display.</td>
</tr>
<tr>
<td class="mla-doc-table-label">array</td>
<td>Returns a PHP array of cloud hyperlinks. This output format is not available through the shortcode; it is allowed when the <code>MLAShortcodes::mla_tag_cloud()</code> function is called directly from your theme or plugin PHP code.</td>
</tr>
</table>
<p>
A separate parameter, <code>echo=true</code>, allows you to echo cloud output directly to the browser instead of returning it to post/page content. This output format is not available through the shortcode; it is allowed when the <code>MLAShortcodes::mla_tag_cloud()</code> function is called directly from your theme or plugin PHP code.
</p>
<p>
The list and grid formats can be extensively customized by using custom <a href="#mla_gallery_templates"><strong>Style and Markup Templates</strong></a>. The <code>[mla_tag_cloud]</code> shortcode also supports pagination with "previous_link", "current_link", "next_link", "previous_page", "next_page" and "paginate_links" formats. These are essentially the same as those for the <code>[mla_gallery]</code> shortcode.
<a name="tag_cloud_items"></a>
</p>
<h4>Tag Cloud Item Parameters</h4>
<p>
Each item in the tag cloud comprises a term name of varying size, a hyperlink surrounding the term name and a "title" attribute (Rollover Text) displayed when the cursor hovers over the term name hyperlink. The following parameters customize item content and markup:
</p>
<table>
<tr>
<td class="mla-doc-table-label">smallest</td>
<td>The text size (default 8) of the tag with the smallest count value (units given by unit parameter).</td>
</tr>
<tr>
<td class="mla-doc-table-label">largest</td>
<td>The text size (default 22) of the tag with the highest count value (units given by the unit parameter).</td>
</tr>
<tr>
<td class="mla-doc-table-label">default_size</td>
<td>The text size (default 12) of the special links (all tags, no tags, any tags) (units given by the unit parameter).</td>
</tr>
<tr>
<td class="mla-doc-table-label">unit</td>
<td>Unit of measure as pertains to the smallest and largest values. This can be any CSS length value, e.g. pt (the default), px, em, %.</td>
</tr>
<tr>
<td class="mla-doc-table-label">separator</td>
<td>The text/space between tags. Default '\n' (whitespace)</td>
</tr>
<tr>
<td class="mla-doc-table-label">single_text</td>
<td>The text for the "title" attribute (Rollover Text) when the count value is one. The default is "%d item". If you change the default, don't forget to include the "%d" placeholder.</td>
</tr>
<tr>
<td class="mla-doc-table-label">multiple_text</td>
<td>The text for the "title" attribute (Rollover Text) when the count value is zero or more than one. The default is "%d items". If you change the default, don't forget to include the "%d" placeholder.</td>
</tr>
<tr>
<td class="mla-doc-table-label">link</td>
<td>Chooses the destination of the item hyperlink; details in the next section below.</td>
</tr>
<tr>
<td class="mla-doc-table-label">current_item</td>
<td>Identifies the current/selected item in the cloud. An integer value will be interpreted as a term id and anything else as a term slug. It will be ignored if it does not match an item in the cloud.</td>
</tr>
<tr>
<td class="mla-doc-table-label">current_item_class</td>
<td>The class attribute for the current item in the cloud as determined by the "current_item" parameter (if specified); default "mla_current_item".</td>
</tr>
</table>
<p>
The Item parameters are an easy way to customize the content and markup for each cloud item. For the list and grid formats you can also use the <a href="#tag_cloud_display_content">Tag Cloud Display Content parameters</a> and/or Style and Markup Templates for even greater flexibility.
</p>
<p>
The <code>current_item</code> parameter is managed for you in most ways. It is automatically added to the links behind each cloud element, and copied back into the shortcode parameters if it is not explicitly coded as a parameter. For the cloud element that matches the current item the <code>current_item_class</code> value is automatically added to the hyperlink class attribute for that item.
<a name="tag_cloud_link"></a>
</p>
<h4>Tag Cloud Item Link</h4>
<p>
The Link parameter (<code>link=</code>) specifies the target and type of link from the tag cloud term/item to the item's archive page, edit page or other destination. You can also specify a non-hyperlink treatment for each item.
</p>
<table>
<tr>
<td class="mla-doc-table-label">current</td>
<td>Link back to the current post/page with a query argument, <code>current_item</code>, set to the term_id of the selected term.</td>
</tr>
<tr>
<td class="mla-doc-table-label">view</td>
<td>Link to the term's "archive page"; <strong>this is the default value</strong>. Support for archive pages, or "tag archives", is theme-dependent. There is an introduction to tag archives in the WordPress Codex at the bottom of the <a href="http://codex.wordpress.org/Function_Reference/wp_tag_cloud#Creating_a_Tag_Archive" title="Codex Tag Archive Discussion" target="_blank"><code>wp_tag_cloud</code> Function Reference</a>.</td>
</tr>
<tr>
<td class="mla-doc-table-label">edit</td>
<td>Link to the term's "edit tag/category" admin screen. This is only useful if the user is logged in and has the appropriate role or capabilities for accessing the edit screen.</td>
</tr>
<tr>
<td class="mla-doc-table-label" style="font-style:italic">(mla_link_href)</td>
<td>Link to a custom destination, typically another post/page. If the "mla_link_href" parameter is present the value of the "link" parameter is ignored. See the pagination example later in this section for more details.</td>
</tr>
<tr>
<td class="mla-doc-table-label">span</td>
<td>Substitutes a <code>&lt;span&gt;&lt;/span&gt;</code> tag for the hyperlink tag. You can use the "mla_link_attributes" and "mla_link_class" parameters to add attributes to the <code>&lt;span&gt;</code> tag. You can use the "mla_link_text" parameter to customize the text within the span.</td>
</tr>
<tr>
<td class="mla-doc-table-label">none</td>
<td>Eliminates the hyperlink tag surrounding the item text. You can use the "mla_link_text" parameter to customize the contents.</td>
</tr>
</table>
<p>
Using the "mla_link_href" parameter to completely replace the link destination URL is a common and useful choice. With this parameter you can use the tag cloud to select a term and then go to another post/page that uses that selection as part of an <code>[mla_gallery]</code> shortcode. The pagination example later in this section uses this technique. 
<a name="tag_cloud_display_style"></a>
</p>
<h4>Tag Cloud Display Style (list and grid)</h4>
<p>
Two parameters provide a way to apply custom style and markup templates to your <code>[mla_tag_cloud]</code> display. These parameters replace the default style and/or markup templates with templates you define on the "Shortcodes" tab of the Settings page. Templates are supported for the "list" and "grid" cloud formats.
</p>
<table>
<tr>
<td class="mla-doc-table-label">mla_style</td>
<td>replaces the default style template for an <code>[mla_tag_cloud]</code> shortcode. You can code "none" to suppress the addition of CSS inline styles entirely.</td>
</tr>
<tr>
<td class="mla-doc-table-label">mla_markup</td>
<td>replaces the default markup template for an <code>[mla_tag_cloud]</code> shortcode</td>
</tr>
</table>
<p>
Four parameters provide control over the placement, size and spacing of terms in the "grid" format without requiring the use of custom Style templates.
</p>
<table>
<tr>
<td class="mla-doc-table-label">columns</td>
<td>specifies the number of columns. The grid will include a break tag at the end of each row and calculate the column width as appropriate. The default value is 3. If columns is set to 0, no row breaks will be included.</td>
</tr>
<tr>
<td class="mla-doc-table-label">mla_float</td>
<td>specifies the CSS float attribute of the ".tag-cloud-item" style. Acceptable values are "left", "none", "right"; the default value is "right" if current locale is RTL, "left" on LTR (left-to-right inline flow, e.g., English).</td>
</tr>
<tr>
<td class="mla-doc-table-label">mla_margin</td>
<td>specifies the CSS margin property of the ".tag-cloud-item" style. The default value is "1.5%", a percent of the total grid width. You can also specify any dimension value, e.g., "10px" or "2em", as well as the "auto" or "inherit" values. Finally, you can specify "none", which will remove the margin property from the styles template altogether.</td>
</tr>
<tr>
<td class="mla-doc-table-label">mla_itemwidth</td>
<td>specifies the CSS width attribute of the ".tag-cloud-item" style. You can specify a percent of the total grid width, e.g., "33.3%". You can also specify any dimension value, e.g., "10px" or "2em", as well as the "auto" or "inherit" values. You can specify "none", which will remove the margin property from the styles template altogether.
<br />&nbsp;<br />
Two additional values, "calculate" (the default) and "exact",  calculate the width automatically, based on the "columns" and "mla_margin" values. For "calculate", the width is calculated by dividing 100% by the number of columns, then subtracting twice the margin. For example, the default value is (floor(1000/3)/10) - ( 2.0 * 1.5 ) = 30.3%. Adding in the left and right margins makes each column 33.3% and the total width will be 99.9%
<br />&nbsp;<br />
For the "exact" value, the calculation is the same but the margin is ignored, so the width value would be 33.3%.</td>
</tr>
</table>
<p>
The default margin and width calculations try to make the total width of each row as close to 100% as possible, but never exceed 100% due to rounding errors. If you have more advanced style and format needs, you can define custom style and/or markup templates. You can also code <code>mla_style=none</code> to suppress inline styles entirely and use a separate stylesheet to control the format of the grid.
</p>
<p>
Three parameters provide control over the XHTML tags used to enclose each part of the tag cloud items. These parameters are only used in the "list" and "grid" output formats.
</p>
<table>
<tr>
<td class="mla-doc-table-label">itemtag</td>
<td>for "list" format, the name of the XHTML tag used to begin the list; the default is "ul". When an explicit "captiontag" parameter is added to "list" format, the default is "dl". For "grid" format, the name of the XHTML tag used to enclose each item in the cloud; the default is "dl".</td>
</tr>
<tr>
<td class="mla-doc-table-label">termtag</td>
<td>the name of the XHTML tag used to enclose each term in the cloud. For "list" format, the default is "li"; for "grid" format or when an explicit "captiontag" parameter is added to "list" format, the default is "dt".</td>
</tr>
<tr>
<td class="mla-doc-table-label">captiontag</td>
<td>the name of the XHTML tag used to enclose each caption. For "grid" format, the default is "dd". To add a caption in "list" format you must enter an explicit "captiontag=dd" parameter to the shortcode.</td>
</tr>
</table>
<p>
These parameters give you some control over the markup used for the cloud and its elements. For more complex applications you can use style and markup templates to gain complete control over the cloud display.
<a name="tag_cloud_display_content"></a>
</p>
<h4>Tag Cloud Display Content</h4>
<p>
Nine parameters provide an easy way to control the contents of tag cloud items without requiring the use of custom Markup templates.  
</p>
<table>
<tr>
<td class="mla-doc-table-label">mla_link_attributes</td>
<td>adds one or more HTML attributes to the hyperlink for each item; see below. For security reasons, HTML event Attributes are not allowed; any attribute name that begins with "on" will invalidate the parameter.</td>
</tr>
<tr>
<td class="mla-doc-table-label">mla_link_class</td>
<td><strong>adds</strong> one or more classes to any already defined for the hyperlink</td>
</tr>
<tr>
<td class="mla-doc-table-label">mla_link_style</td>
<td>replaces the CSS styles for the hyperlink. The default style is <code>font-size: [+font_size+][+unit+]</code>.</td>
</tr>
<tr>
<td class="mla-doc-table-label">mla_link_href</td>
<td>replaces the HTML "href" attribute in the hyperlink for each item; see below</td>
</tr>
<tr>
<td class="mla-doc-table-label">mla_link_text</td>
<td>replaces the term name text displayed for each item</td>
</tr>
<tr>
<td class="mla-doc-table-label">mla_nolink_text</td>
<td>replaces the empty string displayed when there are no cloud items or no pagination link</td>
</tr>
<tr>
<td class="mla-doc-table-label">mla_rollover_text</td>
<td>replaces the HTML "title" attribute in the hyperlink for each item. This is the attachment title text displayed when the mouse rolls or hovers over the term name</td>
</tr>
<tr>
<td class="mla-doc-table-label">mla_caption</td>
<td>replaces the caption text displayed beneath each item. The caption appears for "grid" items and for "list" items when the "captiontag" parameter is present.</td>
</tr>
<tr>
<td class="mla-doc-table-label">mla_item_value</td>
<td>replaces the <strong>term_id (default)</strong> value of the <code>current_item</code> hyperlink query argument.</td>
</tr>
<tr>
<td class="mla-doc-table-label">mla_target</td>
<td>adds an HTML "target" attribute to the hyperlink for each gallery item; see below</td>
</tr>
<tr>
<td class="mla-doc-table-label">&nbsp;</td>
<td>&nbsp;</td>
</tr>
<tr>
<td class="mla-doc-table-label">option_all_text</td>
<td>Text to display for showing an 'all terms' link. Default will not show a link to select 'all terms'. When this option is selected all items, including items with no term assignments at all, are included in the results.</td>
</tr>
<tr>
<td class="mla-doc-table-label">option_all_value</td>
<td>Control value for 'all terms' option. <strong>Default '-3' or 'ignore.terms.assigned'</strong>. Numeric values are used for the term_id; text values for the slug. When this option is selected all items, including items with no term assignments at all, are included in the results.</td>
</tr>
<tr>
<td class="mla-doc-table-label">option_no_terms_text</td>
<td>Text to display for showing an 'no terms assigned' link. Default will not show a link to select 'no terms'. When this option is selected only those items with no term assignments at all are included in the results.</td>
</tr>
<tr>
<td class="mla-doc-table-label">option_no_terms_value</td>
<td>Control value for 'no terms' option. <strong>Default '-1' or 'no.terms.assigned'</strong>. Numeric values are used for the term_id; text values for the slug. When this option is selected only those items with no term assignments at all are included in the results.</td>
</tr>
<tr>
<td class="mla-doc-table-label">option_any_terms_text</td>
<td>Text to display for showing an 'any terms assigned' link. Default will not show a link to select 'any terms assigned'. When this option is selected only those items with one or more term assignments are included in the results.</td>
</tr>
<tr>
<td class="mla-doc-table-label">option_any_terms_value</td>
<td>Control value for 'any terms' option. <strong>Default '-2' or 'any.terms.assigned'</strong>. Numeric values are used for the term_id; text values for the slug. When this option is selected only those items with one or more term assignments are included in the results.</td>
</tr>
</table>
<p>
The "mla_item_value" parameter is the most commonly-used. For example, to set the <code>current_item</code> to the term slug instead of the term id you would code <code>mla_item_value="{+slug+}"</code>.
</p>
<p>
All but the "mla_target" parameter support the <a href="#tag_cloud_markup_parameters">Markup</a>, <a href="#tag_cloud_item_parameters">Item-specific</a>, <a href="#tag_cloud_variable_parameters">Field-level</a> and <a href="#mla_template_parameters">Content Template</a> substitution parameters defined for Markup Templates. For example, if you code "<code>mla_rollover_text='{+slug+} : {+rollover_text+}'</code>, the rollover text will contain the term slug, a colon, and the appropriate "single text" or "multiple text". Simply add "{+" before the substitution parameter name and add "+}" after the name. Note that the enclosing delimiters are different than those used in the templates, since the WordPress shortcode parser reserves square brackets ("[" and "]") for its own use.
</p>
<p>
The "mla_link_href" parameter is a great way to change the destination your cloud item links to and/or add arguments to the link for later processing. For example, to make a gallery item link back to the current page/post you can code: <code>mla_link_href='{+page_url+}'</code>. You can also add arguments to the link, e.g., <code>mla_link_href='{+page_url+}?firstarg=value1&amp;amp;myarg=myvalue'</code>. Note the use of the HTML entity name "&amp;amp;" to put an ampersand in the value; the WordPress "visual" post editor will replace "&amp;", "&lt;" and ">" with "&amp;amp;", "&amp;lt;" and "&amp;gt;" whether you like it not. The <strong>only</strong> markup parameters modified by this parameter are "link_url" and "thelink". The markup parameters "viewlink" and "editlink" are not modified.
</p>
<p>
The "mla_link_attributes" parameter accepts any value and adds it to the "&lt;a&gt;" or "&lt;span&gt;" tags for the item. For example, you can add a unique identifier to each item by adding <code>mla_link_attributes='id="{+selector}-{+index+}"'</code> to your shortcode (note the use of single quotes around the parameter value and the double quotes within the parameter). <strong>IMPORTANT:</strong> since the shortcode parser reserves square brackets ("[" and "]") for its own use, <strong>you must substitute curly braces for square brackets</strong> if your attributes require brackets. If you must code a curly brace in your attribute value, preface it with <strong>two backslash characters</strong>, e.g., "\\{" or "\\}". If you code an attribute already present in the tag, your value will override the existing value.
</p>
<p>
The "mla_target" parameter accepts any value and adds an HTML "target" attribute to the hyperlink with that value. For example, if you code <code>mla_target="_blank"</code> the item will open in a new window or tab. You can also use "_self", "_parent", "_top" or the "<em>framename</em>" of a named frame.
</p>
<p>
The six "option_..." parameters provide an easy way to add special links to the cloud generated by the shortcode. You can add links for selecting all items, items that have no term assignments at all and/or items that have one or more assignments to any term(s) in the taxonomy. The default values for these links are compatible with the simple taxonomy query and tax_query parameters of the <code>[mla_gallery]</code> shortcode.
<a name="tag_cloud_data_selection"></a>
</p>
<h4>Tag Cloud Data Selection Parameters</h4>
<p>
The data selection parameters specify which taxonomy (or taxonomies) the terms are taken from, which terms are returned for the cloud and the order in which the terms are returned:
</p>
<table>
<tr>
<td class="mla-doc-table-label">taxonomy</td>
<td>The taxonomy or taxonomies to retrieve terms from; default "post_tag". Use the name/slug of each taxonomy, not the display name, e.g., 'post_tag', 'category', 'attachment_tag', or 'attachment_category'. You can specify multiple taxonomies as a comma-separated string or (if you are calling <code>MLAShortcodes::mla_tag_cloud()</code> function directly from your theme or plugin PHP code) as an array.</td>
</tr>
<tr>
<td class="mla-doc-table-label">post_mime_type</td>
<td>The MIME type(s) of the items to include in the term-specific counts. The default is "all", which avoids the additional database effort required to filter by MIME type. You can override the default to, for example, display PDF documents (<code>post_mime_type=application/pdf</code>) or all image MIME types (<code>post_mime_type=image</code>). You can select several MIME types with a comma-separated list, e.g., <code>post_mime_type='audio,video'</code>. Wildcard specifications are also supported. For example, <code>post_mime_type='*/mpeg'</code> to select audio and video mpeg formats or <code>post_mime_type='application/*ms*'</code> to select all Microsoft application formats (Word, Excel, etc.).</td>
</tr>
<tr>
<td class="mla-doc-table-label">post_type</td>
<td>The <a href="http://codex.wordpress.org/Post_Types" title="WordPress Codex &quot;Post Types&quot; page" target="_blank">post type(s)</a> of the items to include in the term-specific counts. The default is "attachment". You can override the default if you want to count other types for which the taxonomy is registered, e.g., "post" to count Posts in the "category" and "post_tag" taxonomies. The <a href="http://codex.wordpress.org/Post_Types" title="WordPress Codex &quot;Post Types&quot; page" target="_blank">Codex Page</a> documents other post type values. Make sure your "post_status" and "post_type" values are consistent, e.g., use <code>post_type="attachment,post" post_status="inherit,publish"</code> together.</td>
</tr>
<tr>
<td class="mla-doc-table-label">post_status</td>
<td>The <a href="http://codex.wordpress.org/Post_Status" title="WordPress Codex &quot;Post Status&quot; page" target="_blank">post status value(s)</a> of the items to include in the term-specific counts. The default is "inherit", which counts attachments (Media Library Items). You can override the default if you want to count other values, e.g., "publish" to count published Posts in the "category" and "post_tag" taxonomies. If you code "private" and the user is not logged in, "private" will be removed. The <a href="http://codex.wordpress.org/Post_Status" title="WordPress Codex &quot;Post Status&quot; page" target="_blank">Codex page</a> documents other post status values.</td>
</tr>
<tr>
<td class="mla-doc-table-label">ids</td>
<td>A comma-separated list of <strong>attachment ID</strong> values for an item-specific cloud. Only those terms assigned to the attachment(s) in the list will be included. You can have one or more IDs and you can include assigned terms from one or more taxonomies. Do not use the "include" parameter if you use the "ids" parameter.</td>
</tr>
<tr>
<td class="mla-doc-table-label">no_count</td>
<td>The default, "false", computes a term-specific count of the number of attachments assigned to that term. If you have a large number of terms and/or attachments, this can take a long time.<br />
&nbsp;<br />
You can code "true" to omit the attachment-counting process. If you do that, the "post_mime_type", "post_type", "post_status", "minimum", "number" and "orderby=count" parameters are also ignored, since they require counting the attachments.<br />
&nbsp;<br />
You can code "internal" to skip the explicit attachment-counting process and use the WordPress-maintained "count" database values. If you code <code>no_count=internal</code>, the "post_mime_type", "post_type" and "post_status" paramerters are ignored, since they require a separate subquery to filter the cloud by post-specific values.<br />
&nbsp;</td>
</tr>
<tr>
<td class="mla-doc-table-label">include</td>
<td>A comma-separated list of term ids (<strong>not</strong> names or slugs) to include. Only the terms in this list that are used in the taxonomies you specified will be retrieved.</td>
</tr>
<tr>
<td class="mla-doc-table-label">exclude</td>
<td>A comma-separated list of term ids (<strong>not</strong> names or slugs) to exclude from the returned values.</td>
</tr>
<tr>
<td class="mla-doc-table-label">parent</td>
<td>Get direct children of this term id (only terms whose explicit parent is this value). If 0 is passed, only top-level terms are returned.</td>
</tr>
<tr>
<td class="mla-doc-table-label">minimum</td>
<td>The minimum number of attachments that must be associated with the term for the term to be included. For example, "minimum=1" will omit "empty" terms.</td>
</tr>
<tr>
<td class="mla-doc-table-label">number</td>
<td>The maximum number of "most popular" terms to return. The default, zero, returns them all. Terms are sorted by "count DESC, id ASC" to apply this constraint.</td>
</tr>
<tr>
<td class="mla-doc-table-label">orderby</td>
<td>The final sort order of the retrieved terms. Can be one or more of "count", "id" (term_id), "name" (the default), "none", "random", or "slug". Coding "none" is equivalent to "orderby=count order=DESC" (the initial sort to qualify the most popular terms for the cloud).<br />
&nbsp;<br />
If you install and activate the <a href="https://wordpress.org/plugins/simple-custom-post-order/" target="_blank" rel="noopener noreferrer nofollow">Simple Custom Post Order</a> plugin you can code "term_order" to sort the cloud into the "drag and drop" order supported by that plugin.<br />
&nbsp;<br />
Or, if you install and activate the <a href="https://wordpress.org/plugins/simple-taxonomy-ordering/" target="_blank" rel="noopener noreferrer nofollow">Simple Taxonomy Ordering</a> plugin you can code "tax_position" to sort the cloud into the "drag and drop" order supported by that plugin.<br />
&nbsp;</td>
</tr>
<tr>
<td class="mla-doc-table-label">order</td>
<td>Can be "ASC" (ascending, the default) or "DESC" (descending). Note that DESC is not supported for <code>orderby=tax_position</code>.</td>
</tr>
<tr>
<td class="mla-doc-table-label">no_orderby</td>
<td>The default, "false", applies the orderby and order parameters to the final term list. If you have a large number of terms and/or attachments, this can take a long time. You can code "true" to omit both the initial sort (most popular terms) and the final sorting process. If you do that, the sort order of the cloud will be indeterminite.</td>
</tr>
<tr>
<td class="mla-doc-table-label">preserve_case</td>
<td>Preserve upper- and lower-case distinctions when sorting by name. The default, "false", specifies a case-insensitive sort order.</td>
</tr>
<tr>
<td class="mla-doc-table-label">pad_counts</td>
<td>True to include the count of all children in their parents' count. The default, "false", does not include children in their parents' count.<br />
&nbsp;<br />
The "pad_counts" parameter is only applied to the first (or only) taxonomy you specify, and that taxonomy must be hierarchical to see any difference in the counts.<br />
&nbsp;</td>
</tr>
<tr>
<td class="mla-doc-table-label">limit</td>
<td>The number of terms to return. This parameter is used for pagination; it is applied <strong>after</strong> and separate from the "number" parameter above.</td>
</tr>
<tr>
<td class="mla-doc-table-label">offset</td>
<td>The number of terms to skip before returning the results. This parameter is used for pagination.</td>
</tr>
</table>
<p>
You can sort on more than one value, e.g., <code>orderby="count DESC, name"</code> and you can specify ASC/DESC on a value by value basis. <strong>NOTE: multiple orderby values are separated by commas, not spaces.</strong> This is a change from WP_Query.
</p>
<p>
The order parameter (default ASC) can give an ASC/DESC default for any value that doesn't have a specific choice. For example, <code>orderby="count DESC, name" order=ASC</code> is the same as <code>orderby="count DESC, name ASC"</code>.
<a name="tag_cloud_debugging_output"></a>
</p>
<h4>Debugging Output</h4>
<p>
The "mla_debug" parameter controls the display of information about the query parameters and SQL statements used to retrieve tag cloud items. If you code <code>mla_debug=true</code> you will see a lot of information added to the post or page containing the cloud. Of course, this parameter should <strong><em>ONLY</em></strong> be used in a development/debugging environment; it's quite ugly.
</p>
<p>
If you code <code>mla_debug=log</code> all of the information will be written to the error log. You can use the <a href="#mla_debug_tab">MLA Debug Tab</a> to view and download the information in the error log.
</p>
 <p>
Look for the "mla_debug attribute_errors" entry in the debug output; it will often list the parts of the shortcode parameters that couldn&rsquo;t be parsed. If you see "[mla_gallery" in this entry you probably used the enclosing shortcode format in that shortcode but did not add the "[/mla_gallery]" delimiter to an earlier shortcode.
<a name="tag_cloud_substitution"></a>
</p>
<h4>Tag Cloud Substitution Parameters</h4>
<p>
Substitution parameters are a powerful way to add general and attachment-specific values to the gallery display. For example, if you code "<code>mla_link_href="{+page_url+}?current_id={+term_id+}&amp;mla_cloud_current={+request:mla_cloud_current+}"</code>, the hyperlinks behind each cloud term will contain the page URL and the taxonomy term ID. There are many parameter names like `page_url` and `term_id` divided in several categories:
</p>
<table>
<tr>
<td class="mla-doc-table-label">Cloud-specific</td>
<td>values that are known at the beginning of shortcode processing and remain the same for the entire shortcode, such as the ID and URL of the post/page in which the shortcode appears</td>
</tr>
<tr>
<td class="mla-doc-table-label">Style</td>
<td>values that are known when the cloud-specific CSS inline styles are composed just before cloud output begins</td>
</tr>
<tr>
<td class="mla-doc-table-label">Markup</td>
<td>values that are known at the beginning of cloud output processing and remain the same for the entire cloud</td>
</tr>
<tr>
<td class="mla-doc-table-label"><a href="#tag_cloud_item_parameters">Item-specific</a></td>
<td  style="vertical-align: top">values that change for each term/item in the cloud, such as Name and Description</td>
</tr>
<tr>
<td class="mla-doc-table-label"><a href="#mla_variable_parameters">Field-level</a></td>
<td>additional values from sources like query arguments and shortcode parameters. The "request:" and "query:" field-level prefixes can be used in the cloud. The other prefixes are attachment-specific and have no meaning in a cloud</td>
</tr>
<tr>
<td class="mla-doc-table-label"><a href="#mla_template_parameters">Content&nbsp;Template</a></td>
<td>lets you compose a value from multiple substitution parameters and test for empty values, choose among two or more alternatives or suppress output entirely</td>
</tr>
</table>
<p>
The following paragraphs go into more detail about each category and the parameter names within them.
</p>
<p>
To use a substitution parameter in your shortcode, simply add "{+" before the substitution parameter name and add "+}" after the name. Note that the enclosing delimiters are different than those used in Style and Markup templates, since the WordPress shortcode parser reserves square brackets ("[" and "]") for its own use. Also, because square brackets are reserved, <strong>you must substitute curly braces for square brackets</strong> if your parameter values require them. For example, if your shortcode parameter is <code>mla_link_attributes='rel="shadowbox{sbalbum-{+instance+}};player=img"'</code>, the actual attribute added to the link will be <code>rel="shadowbox[sbalbum-1];player=img"</code>. If you must code a curly brace in a parameter value, preface it with <strong>two backslash characters</strong>, e.g., "\\{" or "\\}".
</p>
<p>
<strong>Cloud-specific substitution parameters</strong> are known at the beginning of shortcode processing and they do not change during processing. They can be used, for example, in any of the data selection parameters to change the items selected for the cloud based on information about the post/page on which the cloud appears. The cloud-specific substitution parameters are:
</p>
<table>
<tr>
<td class="mla-doc-table-label">site_url</td>
<td>absolute URL to the site directory, without trailing slash</td>
</tr>
<tr>
<td class="mla-doc-table-label">base_url</td>
<td>absolute URL to the upload directory, without trailing slash</td>
</tr>
<tr>
<td class="mla-doc-table-label">base_dir</td>
<td>absolute (full) path to the upload directory, without trailing slash</td>
</tr>
<tr>
<td class="mla-doc-table-label">instance</td>
<td>starts at '1', incremented for each additional shortcode in the post/page</td>
</tr>
<tr>
<td class="mla-doc-table-label">selector</td>
<td>"mla_tag_cloud-{$instance}", e.g., mla_tag_cloud-1</td>
</tr>
<tr>
<td class="mla-doc-table-label">page_ID,<br />id</td>
<td style="vertical-align: top">the <code>ID</code> value of the post/page in which the cloud appears</td>
</tr>
<tr>
<td class="mla-doc-table-label">page_author</td>
<td>the <code>post_author</code> value of the post/page in which the cloud appears</td>
</tr>
<tr>
<td class="mla-doc-table-label">page_date</td>
<td>the <code>post_date</code> value of the post/page in which the cloud appears</td>
</tr>
<tr>
<td class="mla-doc-table-label">page_content</td>
<td>the <code>post_content</code> value of the post/page in which the cloud appears</td>
</tr>
<tr>
<td class="mla-doc-table-label">page_title</td>
<td>the <code>post_title</code> value of the post/page in which the cloud appears</td>
</tr>
<tr>
<td class="mla-doc-table-label">page_excerpt</td>
<td>the <code>post_excerpt</code> value of the post/page in which the cloud appears</td>
</tr>
<tr>
<td class="mla-doc-table-label">page_status</td>
<td>the <code>post_status</code> value of the post/page in which the cloud appears</td>
</tr>
<tr>
<td class="mla-doc-table-label">page_name</td>
<td>the <code>post_name</code> value of the post/page in which the cloud appears</td>
</tr>
<tr>
<td class="mla-doc-table-label">page_modified</td>
<td>the <code>post_modified</code> value of the post/page in which the cloud appears</td>
</tr>
<tr>
<td class="mla-doc-table-label">page_guid</td>
<td>the <code>post_guid</code> value of the post/page in which the cloud appears</td>
</tr>
<tr>
<td class="mla-doc-table-label">page_type</td>
<td>the <code>post_type</code> value of the post/page in which the cloud appears</td>
</tr>
<tr>
<td class="mla-doc-table-label">page_url</td>
<td>absolute URL to the page or post on which the cloud appears, if any, with trailing slash</td>
</tr>
</table>
<p>
If the shortcode is executed when there is no current post, an artificial "empty post" is used to supply reasonable default values. One special case is the "Author Archive" page when the author has no posts. In this case, an atrificial "author post" supplies a few values based on the author's user information. The available values are documented in the <a href="#gallery_specific">Gallery-specific substitution parameters</a> subsection.</p>
</p>
<p>
Style and Markup templates give you great flexibility for the content and format of each [mla_tag_cloud] when you use the "list" and "grid" output formats. You can define as many templates as you need. 
</p>
<p>
Style templates provide cloud-specific CSS inline styles (you can code mla_style=none to suppress the addition of CSS inline styles entirely). Markup templates provide the HTML markup for 1) the beginning of the cloud, 2) the beginning of each row ("grid" format), 3) each cloud item, 4) the end of each row ("grid" format) and 5) the end of the cloud. The MLA Gallery tab on the Settings page lets you add, change and delete custom templates. The default templates are also displayed on this tab for easy reference. 
</p>
<p>
For the "grid" output format, all of the Markup template sections are used. For the "list" output format, only the "Open", "Item" and "Close" sections are used. There are two default templates for the "list" format; "tag-cloud-ul" and "tag-cloud-dl". As the names imply, the "tag-cloud-dl" default is used when the "captiontag" parameter is present in the shortcode. If you name a custom Markup template in your shortcode, it will be used whether the "captiontag" is present or not.
<a name="tag_cloud_variable_parameters"></a>
</p>
<p>
The following <strong>field-level substitution parameters</strong> are available in the Style template and any of the Markup template sections:</p>
<table>
<tr>
<td class="mla-doc-table-label">request</td>
<td>The parameters defined in the <code>$_REQUEST</code> array; the "query strings" sent from the browser. The PHP $_REQUEST variable is a superglobal Array that contains the contents of both $_GET, $_POST and $_COOKIE arrays.</td>
</tr>
<tr>
<td class="mla-doc-table-label">query</td>
<td>The parameters defined in the <code>[mla_tag_cloud]</code> shortcode. For example, if your shortcode is <code>[mla_tag_cloud taxonomy=attachment_tag div-class=some_class]</code> you can access the parameters as <code>[+query:taxonomy+]</code> and <code>[+query:div-class+]</code> respectively. You can define your own parameters, e.g., "div-class"; they will be accessible as field-level data but will otherwise be ignored.</td>
</tr>
<tr>
<td class="mla-doc-table-label">template</td>
<td>A Content Template, which lets you compose a value from multiple substitution parameters and test for empty values, choosing among two or more alternatives or suppressing output entirely. See the <a href="#mla_template_parameters">Content Templates</a> section for details. Note that the formatting option is not supported for content templates.</td>
</tr>
</table>
<p>
Tag cloud substitution parameters for the <strong>Style template</strong> are:
</p>
<table>
<tr>
<td class="mla-doc-table-label">mla_output</td>
<td>shortcode parameter, default = 'flat'</td>
</tr>
<tr>
<td class="mla-doc-table-label">mla_style</td>
<td>shortcode parameter, default = 'tag-cloud'</td>
</tr>
<tr>
<td class="mla-doc-table-label">mla_markup</td>
<td>shortcode parameter, default = 'tag-cloud-ul', or 'tag-cloud-dl' if the "captiontag" parameter is present.</td>
</tr>
<tr>
<td class="mla-doc-table-label">taxonomy</td>
<td>the slug of the taxonomy on which the cloud is based. Multiple taxonomy slugs are joined with a dash to form a single value.</td>
</tr>
<tr>
<td class="mla-doc-table-label">current_item</td>
<td>the current/selected item in the cloud, as entered in the shortcode parameters.</td>
</tr>
<tr>
<td class="mla-doc-table-label">itemtag</td>
<td>shortcode parameter, default = 'ul', or 'dl' if the "captiontag" parameter is present.</td>
</tr>
<tr>
<td class="mla-doc-table-label">termtag</td>
<td>shortcode parameter, default = 'li', or 'dd' if the "captiontag" parameter is present.</td>
</tr>
<tr>
<td class="mla-doc-table-label">captiontag</td>
<td>shortcode parameter, default = '', i.e., no caption tag value.</td>
</tr>
<tr>
<td class="mla-doc-table-label">columns</td>
<td>shortcode parameter, default = '3'; only meaningful for the "grid" output format.</td>
</tr>
<tr>
<td class="mla-doc-table-label">itemwidth</td>
<td>shortcode parameter, default is calculated by dividing 100% by the number of columns and subtracting twice the margin value, e.g., 30.3% for three columns and a margin value of 1.5%. Can also contain other dimensional values such as '10px' or CSS-specific values like 'auto' or 'inherit'.</td>
</tr>
<tr>
<td class="mla-doc-table-label">margin</td>
<td>shortcode parameter, default = '1.5%'. Can also contain other dimensional values such as '10px' or CSS-specific values like 'auto' or 'inherit'.</td>
</tr>
<tr>
<td class="mla-doc-table-label">float</td>
<td>'right' if current locale is RTL, 'left' if not</td>
</tr>
<tr>
<td class="mla-doc-table-label">found_rows</td>
<td>the number of terms retrieved for the cloud</td>
</tr>
<tr>
<td class="mla-doc-table-label">min_count</td>
<td>the smallest number of attachments associated with any term</td>
</tr>
<tr>
<td class="mla-doc-table-label">max_count</td>
<td>the largest number of attachments associated with any term</td>
</tr>
<tr>
<td class="mla-doc-table-label">min_scaled_count</td>
<td>the smallest scaled count associated with any term</td>
</tr>
<tr>
<td class="mla-doc-table-label">max_scaled_count</td>
<td>the largest scaled count associated with any term</td>
</tr>
<tr>
<td class="mla-doc-table-label">spread</td>
<td>max_scaled_count - min_scaled_count</td>
</tr>
<tr>
<td class="mla-doc-table-label">smallest</td>
<td>the text size of the tag with the smallest count value</td>
</tr>
<tr>
<td class="mla-doc-table-label">largest</td>
<td>the text size of the tag with the largest count value</td>
</tr>
<tr>
<td class="mla-doc-table-label">unit</td>
<td>Unit of measure as pertains to the smallest and largest values</td>
</tr>
<tr>
<td class="mla-doc-table-label">font_spread</td>
<td>largest - smallest</td>
</tr>
<tr>
<td class="mla-doc-table-label">font_step</td>
<td>font_spread / spread</td>
</tr>
<tr>
<td class="mla-doc-table-label">separator</td>
<td>The text/space between tags</td>
</tr>
<tr>
<td class="mla-doc-table-label">single_text</td>
<td>Rollover Text when the count value is one</td>
</tr>
<tr>
<td class="mla-doc-table-label">multiple_text</td>
<td> Rollover Text when the count value is zero or more than one</td>
</tr>
<tr>
<td class="mla-doc-table-label">echo</td>
<td>whether the output is echoed directly to the browser (true) or returned to the caller (false). For a shortcode, always false.</td>
</tr>
<tr>
<td class="mla-doc-table-label">link</td>
<td>the destination name of the item hyperlink, default 'view'</td>
</tr>
</table>
<p>
&nbsp;
<a name="tag_cloud_markup_parameters"></a>
</p>
<p>
Tag cloud substitution parameters for the <strong>Markup template</strong> are available in all of the template sections. All of the <strong>cloud-specific substitution parameters</strong> and the <strong>substitution parameters for Style templates</strong> are available for use in markup templates. There are no additional substitution parameters defined at the start of markup processing, but there are <a href="#mla_tag_cloud_hooks">MLA Tag Cloud Filters (Hooks)</a> that could add, modify or delete parameters available for markup processing, if your application uses them.
<a name="tag_cloud_item_parameters"></a>
</p>
<p>
Tag cloud <strong>item-specific substitution parameters</strong> for the Markup template are available in the "Item" section of the template. They include all of the parameters defined above (for the Style and Markup templates) Additional item-specific parameters are:
</p>
<table>
<tr>
<td class="mla-doc-table-label">index</td>
<td>starts at '1', incremented for each item in the cloud</td>
</tr>
<tr>
<td class="mla-doc-table-label">last_in_row</td>
<td>for the "grid" output format, set to "last_in_row" for the last item in each full cloud row, and to an empty string for all other items in the row. If the cloud ends with a partial row, the last_in_row parameter is not set.</td>
</tr>
<tr>
<td class="mla-doc-table-label">key</td>
<td>set to the "tags" array key/index value. Only useful if the <code>mla_get_terms_query_results()</code> filter has altered the array keys.</td>
</tr>
<tr>
<td class="mla-doc-table-label">term_id</td>
<td>the term id</td>
</tr>
<tr>
<td class="mla-doc-table-label">name</td>
<td>the term display name</td>
</tr>
<tr>
<td class="mla-doc-table-label">slug</td>
<td>the term slug</td>
</tr>
<tr>
<td class="mla-doc-table-label">term_group</td>
<td>the term group</td>
</tr>
<tr>
<td class="mla-doc-table-label">term_taxonomy_id</td>
<td>the term-taxonomy id</td>
</tr>
<tr>
<td class="mla-doc-table-label">taxonomy</td>
<td>the primary taxonomy for this term</td>
</tr>
<tr>
<td class="mla-doc-table-label">description</td>
<td>the term description, if any</td>
</tr>
<tr>
<td class="mla-doc-table-label">parent</td>
<td>the direct parent of the term</td>
</tr>
<tr>
<td class="mla-doc-table-label">count</td>
<td>the number of attachments associated with the term. This will include attachments assigned to child terms if the <code>pad_counts=true</code> parameter is present.</td>
</tr>
<tr>
<td class="mla-doc-table-label">term_count</td>
<td>the number of attachments explicitly associated with the term; not its children. This is only defined when the <code>pad_counts=true</code> parameter is present.</td>
</tr>
<tr>
<td class="mla-doc-table-label">scaled_count</td>
<td>scaled count value, for determining font size. The default formula for scaling the count is <code>round(log10($tag->count + 1) * 100)</code></td>
</tr>
<tr>
<td class="mla-doc-table-label">font_size</td>
<td>the numeric portion of the CSS "font-size" attribute</td>
</tr>
<tr>
<td class="mla-doc-table-label">link_url</td>
<td>the URL portion of "thelink" (below). Derived from editlink_url, termlink_url or mla_link_href.</td>
</tr>
<tr>
<td class="mla-doc-table-label">currentlink_url</td>
<td>URL of the current post/page plus a "current_item=term_id" query argument</td>
</tr>
<tr>
<td class="mla-doc-table-label">editlink_url</td>
<td>URL of the term's "edit category/tag" page</td></tr>
<tr>
<td class="mla-doc-table-label">termlink_url</td>
<td>URL of the term's archive page</td>
</tr>
<tr>
<td class="mla-doc-table-label">caption</td>
<td>if captiontag is not empty, contains term description or the mla_caption value</td>
</tr>
<tr>
<td class="mla-doc-table-label">link_attributes</td>
<td>link attributes, if any, drawn from the mla_target, mla_link_attributes and mla_link_class parameters</td>
</tr>
<tr>
<td class="mla-doc-table-label">current_item_class</td>
<td>set to "mla_current_item" for the current item in the cloud as determined by the "current_item" parameter, and to an empty string for all other items in the cloud.</td>
</tr>
<tr>
<td class="mla-doc-table-label">rollover_text</td>
<td>the "title" attribute value, drawn from single_text/multiple_text or the mla_rollover_text parameters</td>
</tr>
<tr>
<td class="mla-doc-table-label">link_style</td>
<td>the CSS "style" attribute, drawn from the font_size and unit parameters</td>
</tr>
<tr>
<td class="mla-doc-table-label">link_text</td>
<td>the text enclosed by the hyperlink, drawn from the term name or mla_link_text parameter</td>
</tr>
<tr>
<td class="mla-doc-table-label">thevalue</td>
<td>term id (default), slug or other value as determined by the "mla_item_value" parameter</td>
</tr>
<tr>
<td class="mla-doc-table-label">thelink</td>
<td>full hyperlink to the chosen destination as determined by the "link" and "mla_link_href" parameters</td>
</tr>
<tr>
<td class="mla-doc-table-label">currentlink</td>
<td>full hyperlink to the current page with a term-specific query argument, including all the Display Content parameters</td>
</tr>
<tr>
<td class="mla-doc-table-label">editlink</td>
<td>full hyperlink to the term's "edit category/tag" page, including all the Display Content parameters</td>
</tr>
<tr>
<td class="mla-doc-table-label">termlink</td>
<td>full hyperlink to the term's archive page, including all the Display Content parameters</td>
</tr>
</table>
<p>
&nbsp;
<a name="tag_cloud_pagination_parameters"></a>
</p>
<h4>Tag Cloud Pagination Parameters</h4>
<p>
If you have a large number of terms in your cloud taxonomy you may want to paginate the cloud display, i.e., divide the cloud into two or more pages of a reasonable size. Pagination support for <code>[mla_tag_cloud]</code> is modeled on similar functions for<code>[mla_gallery]</code>, and you can find more explanation of the ideas behind pagination in the <a href="#mla_output_parameter"><strong>Support for Alternative Gallery Output, e.g., Pagination</strong></a> section. Five parameters are supplied for this purpose:
</p>
<table>
<tr>
<td class="mla-doc-table-label">limit</td>
<td>the maximum number of terms to display in one cloud "page". Think of this as a "terms per page" value.</td>
</tr>
<tr>
<td class="mla-doc-table-label">offset</td>
<td>the number of terms to skip over before starting the current cloud page. This parameter is usually derived automatically from the more useful "mla_cloud_current" parameter.</td>
</tr>
<tr>
<td class="mla-doc-table-label">mla_page_parameter</td>
<td>the name of the parameter containing the current page number; default "mla_cloud_current". You can change the name if you need multiple paginated clouds on one post/page.</td>
</tr>
<tr>
<td class="mla-doc-table-label">mla_cloud_current</td>
<td>the current cloud page number. The name of this parameter can be changed to support multiple paginated clouds on one post/page. This parameter will automatically be added to the URLs generated by pagination output types and managed for you.</td>
</tr>
<tr>
<td class="mla-doc-table-label">term_id</td>
<td>the id of the current term within the cloud. This parameter is used with the "previous_link", "current_link" and "next_link" output types. You <strong>must</strong> supply a term_id value when using these output types.</td>
</tr>
</table>
<p>
The <code>[mla_tag_cloud]</code> shortcode can be used to provide "Previous" and "Next" links that support moving among the individual items in a cloud or among cloud "pages". For example, if you have many terms in your Att. Category or Att. Tag taxonomies you can build a term-specific <code>[mla_gallery]</code> page with links to the previous/next term in the taxonomy (a complete pagination example is included below). You can also build a page that shows a large taxonomy in groups, or "cloud pages", of ten terms with links to the previous/next ten terms or links to all of the cloud pages of terms in the taxonomy.
</p>
<p>
The <strong>"mla_output"</strong> parameter determines the type of output the shortcode will return. For pagination output, you can choose from six values: 
</p>
<table>
<tr>
<td class="mla-doc-table-label">next_link</td>
<td>returns a link to the next cloud item, based on the "term_id" parameter value. The optional "<strong>,wrap</strong>" qualifier determines what happens at the end of the cloud. If you omit the qualifier, an empty string is returned for the "next_link" from the last item. If you code the ",wrap" qualifier, the "next_link" from the last item will be to the first item.</td>
</tr>
<tr>
<td class="mla-doc-table-label">current_link</td>
<td>returns a link to the current cloud item, based on the "term_id" parameter value. This gives you an easy way to provide a visual indication of where you are within the taxonomy. The "span" and  "none" link formats are often used with this mla_output type.</td>
</tr>
<tr>
<td class="mla-doc-table-label">previous_link</td>
<td>returns a link to the previous cloud item, based on the "term_id" parameter value. The optional "<strong>,wrap</strong>" qualifier determines what happens at the beginning of the cloud. If you omit the qualifier, an empty string is returned for the "previous_link" from the first item. If you code the ",wrap" qualifier, "previous_link" from the gallery item will be to the last item.</td>
</tr>
<tr>
<td class="mla-doc-table-label">next_page</td>
<td>returns a link to the next "page" of cloud items, based on the "mla_cloud_current" parameter value. The optional "<strong>,wrap</strong>" or "<strong>,last</strong>" qualifiers determine what happens at the end of the taxonomy. If you omit the qualifier, an empty string is returned for the "next_page" if there are no more items in the taxonomy. If you code the ",wrap" qualifier, the "next_page" from the last page of items will be to the first page. If you code the ",last" qualifier, the "next_page" link will return to/remain on the last page.</td>
</tr>
<tr>
<td class="mla-doc-table-label">previous_page</td>
<td>returns a link to the previous "page" of cloud items, based on the "mla_cloud_current" parameter value. The optional "<strong>,wrap</strong>" or "<strong>,first</strong>" qualifiers determine what happens at the beginning of the taxonomy. If you omit the qualifier, an empty string is returned for the "previous_link" from the first page. If you code the ",wrap" qualifier, "previous_page" from the first page will be to the last page. If you code the ",first" qualifier, the "previous_link" link will return to/remain on the first page.</td>
</tr>
<tr>
<td class="mla-doc-table-label">paginate_links</td>
<td>returns a link to cloud items at the start and end of the list and to pages around the current "cloud page" ( e.g.: &laquo; Previous 1 ... 3 4 5 6 7 ... 9 Next &raquo; ), based on the "mla_cloud_current" parameter value. The optional "<strong>,show_all</strong>" qualifier will show all of the cloud pages instead of a short list around the current page. The optional "<strong>,prev_next</strong>" qualifier will include the "&laquo; Previous" and "Next &raquo;" portions of the link list.</td>
</tr>
</table>
<p>
The best way to understand cloud pagination is by example, as in the next section below.
<a name="tag_cloud_pagination_example"></a>
</p>
<h4>Tag Cloud Pagination Example</h4>
<p>
This section takes you through several of the <code>[mla_tag_cloud]</code> features, step by step. Let's start with a very simple cloud showing all of the terms in the "Att. Category" taxonomy:
</p>
<p>
<code>[mla_tag_cloud taxonomy=attachment_category number=0]</code>
</p>
<p>
The "number=0" parameter overrides the default maximum of 45 terms, showing all of the terms in the taxonomy. Let's paginate the cloud and limit the terms display to ten terms per "page":
</p>
<p>
<code>[mla_tag_cloud taxonomy=attachment_category number=0 limit=10]<br />
[mla_tag_cloud taxonomy=attachment_category number=0 limit=10  mla_output="paginate_links,prev_next"]</code>
</p>
<p>
The "limit=10" parameter (on <strong>both</strong> shortcodes) limits the term display to ten terms. The second <code>[mla_tag_cloud]</code> shortcode, adding the 'mla_output="paginate_links,prev_next"' parameter, displays a line of pagination links below the cloud page. Coordination between the two shortcodes is automatic, using the "mla_cloud_current" parameter added to the URLs by the shortcode.
</p>
<p>Now we'll make the cloud a convenient way to control a term-specific <code>[mla_gallery]</code>. The next step uses the "mla_link_href" parameter to change the link destination of each cloud term, returning to the current page with the term id of the selected term. We also add the "mla_cloud_current" parameter to each of these new links, so the tag cloud page is retained when a term is selected:
</p>
<p>
<code>[mla_tag_cloud taxonomy=attachment_category number=0 limit=10 mla_link_href="{+page_url+}?current_id={+term_id+}&amp;amp;mla_cloud_current={+template:({+request:mla_cloud_current+})|1+}"]<br />
[mla_tag_cloud taxonomy=attachment_category number=0 limit=10  mla_output="paginate_links,prev_next"]</code>
</p>
<p>
The "&amp;amp;" before the "mla_cloud_current" parameter is required to get by the WordPress Visual Editor. The "{+request:mla_cloud_current+}" value copies the current page number from the URL ($_REQUEST array) and adds it to each term's link. If the current page number is absent (e.g., on the initial page load) the default value is 1. Now, let's use the "current_id={+term_id+}" information in the link to compose a term-specific <code>[mla_gallery]</code>: 
</p>
<p>
<code>[mla_tag_cloud taxonomy=attachment_category number=0 limit=10 mla_link_href="{+page_url+}?current_id={+term_id+}&amp;amp;mla_cloud_current={+template:({+request:mla_cloud_current+})|1+}"]<br />
[mla_tag_cloud taxonomy=attachment_category number=0 limit=10  mla_output="paginate_links,prev_next"]
<br />&nbsp;<br />
[mla_gallery post_mime_type=all tax_query="array ( 0 => array ( 'taxonomy' => 'attachment_category', 'field' => 'id', 'terms' => array( {+request:current_id+} ), 'include_children' => false ) )" mla_caption="{+title+}" columns=5 size=icon link=file]</code>
</p>
<p>
The most complicated part of the new shortcode is the "tax_query" parameter, which we're using to ensure that the gallery items displayed match the count displayed for each term in the tag cloud. The tag cloud count does not contain items associated with any "child terms", or sub-categories, of the cloud item. To match this count we must use the "include_children=false" and "field=id" parameters of the "tax_query".
</p>
<p>
We can easily paginate the term-specific gallery by adding a second <code>[mla_gallery]</code> shortcode and a "posts_per_page" parameter to both shortcodes:
</p>
<p>
<code>[mla_tag_cloud taxonomy=attachment_category number=0 limit=10 mla_link_href="{+page_url+}?current_id={+term_id+}&amp;amp;mla_cloud_current={+template:({+request:mla_cloud_current+})|1+}"]<br />
[mla_tag_cloud taxonomy=attachment_category number=0 limit=10  mla_output="paginate_links,prev_next"]
<br />&nbsp;<br />
[mla_gallery post_mime_type=all tax_query="array ( 0 => array ( 'taxonomy' => 'attachment_category', 'field' => 'id', 'terms' => array( {+request:current_id+} ), 'include_children' => false ) )" mla_caption="{+title+}" columns=5 posts_per_page=5 size=icon link=file]
<br />&nbsp;<br />
[mla_gallery post_mime_type=all tax_query="array ( 0 => array ( 'taxonomy' => 'attachment_category', 'field' => 'id', 'terms' => array( {+request:current_id+} ), 'include_children' => false ) )" columns=5 posts_per_page=5 mla_output="paginate_links,prev_next"]</code>
</p>
<p>
The pagination controls for the tag cloud and the gallery operate independently because by default they use different names for their respective "_current" page parameters. Our page now has a lot of functionality without requiring any WordPress templates or PHP code.
</p>
<p>
For extra credit, let's add some more navigation options to the page. We'll build previous, current and next term links at the bottom of the page. These are enclosed in an HTML table so they all appear on one line of the page. Here is just the additional content; the table of three link navigation controls:
</p>
<p>
<code>
&lt;table width=99%&gt;&lt;tr&gt;<br />
&lt;td width=33% style="text-align: left"&gt;[mla_tag_cloud taxonomy=attachment_category number=0 term_id="{+request:current_id+}" mla_output="previous_link" smallest=12 largest=12 mla_link_href="{+page_url+}?current_id={+term_id+}" mla_link_text="Previous: {+name+}"]&lt;/td&gt;<br />&nbsp;<br />
&lt;td width=33% style="text-align: center; font-weight: bold:"&gt;[mla_tag_cloud taxonomy=attachment_category number=0 term_id="{+request:current_id+}" mla_output=current_link smallest=12 largest=12 mla_link_text="Current: {+name+}" link=span]&lt;/td&gt;<br />&nbsp;<br />
&lt;td width=33% style="text-align: right"&gt;[mla_tag_cloud taxonomy=attachment_category number=0 term_id="{+request:current_id+}" mla_output="next_link" smallest=12 largest=12 mla_link_href="{+page_url+}?current_id={+term_id+}" mla_link_text="Next: {+name+}"]&lt;/td&gt;<br />
&lt;/tr&gt;&lt;/table&gt;
</code>
</p>
<p>
The "smallest=12" and "largest=12" parameters make "font-size" the same for all of the term names regardless of how many items are associated with the term. The "mla_link_text" parameters add labels to each of the three navigation links. Finally, the "link=span" parameter in the middle ("mla_output=current_link") shortcode removes the hyperlink behind the term name, since it would just take you back to the page you're already on.
<a name="mla_tag_cloud_hooks"></a>
</p>
<h4>MLA Tag Cloud Filters (Hooks)</h4>
<p>
The <code>[mla_tag_cloud]</code> shortcode supports a comprehensive set of filters that give you complete control over cloud composition from PHP code in your theme or in another plugin. An example of using the hooks from a simple, stand-alone plugin can be found in the Documentation/Example Plugins submenu. You can find the example plugin here: <a title="Find the Tag Cloud Hooks Example" href="[+example_url+]&amp;mla-example-search=Search+Plugins&amp;s=%22MLA+Tag+Cloud+Hooks+Example%22" class="mla-doc-bold-link">MLA Tag Cloud Hooks Example</a>. To run the example:
</p>
<ol>
<li>Click on the link above or go to top of the Documentation tab and click on the "Example Plugins" button.</li>
<li>Hover over "MLA Tag Cloud Hooks Example" in the Name column, then click the "Install" rollover action.</li>
<li>Go to the Plugins/Installed Plugins screen and activate the "MLA Tag Cloud Hooks Example" plugin.</li>
<li>Create a new <code>[mla_tag_cloud]</code> shortcode or modify an existing shortcode, adding the <code>my_filter="color cloud"</code> parameter to activate the example output.</li>
<li>View the post or page on which the modified shortcode appears to see a tag cloud with a range of colors applied to the terms.</li>
</ol>
<p>
The example code documents each hook with comments in the filter/action function that intercepts the hook. Generally, each part of the cloud supports three hooks: 1) a "<strong>values</strong>" hook, which lets you record or update the substitution values for that cloud part, 2) a "<strong>template</strong>" hook, which lets you record/update the template used to generate the HTML markup, and 3) a "<strong>parse</strong>" hook which lets you modify or replace the markup generated for a cloud part. The current hooks are:
</p>
<table>
<tr>
<td class="mla-doc-hook-label">mla_tag_cloud_raw_attributes</td>
<td class="mla-doc-hook-definition">called at the beginning of the cloud, before the attributes pass through the logic that handles the 'mla_page_parameter' and "request:" prefix processing.</td>
</tr>
<tr>
<td class="mla-doc-table-label">mla_tag_cloud_attributes,<br />mla_tag_cloud_arguments</td>
<td class="mla-doc-hook-definition">called at the beginning of the cloud generation. You can record/modify shortcode parameter values before (attributes) or after (arguments) they are combined with all the defaults.</td>
</tr>
<tr>
<td class="mla-doc-table-label">mla_get_terms_query_attributes,<br />mla_get_terms_query_arguments</td>
<td class="mla-doc-hook-definition">called just before the <code>WP_Query->query()</code> call that selects gallery items, with query parameters before or after they are combined with defaults.</td>
</tr>
<tr>
<td class="mla-doc-table-label">mla_get_terms_clauses</td>
<td class="mla-doc-hook-definition">gives you a final opportunity to inspect or modify the SQL clauses for the data selection process.</td>
</tr>
<tr>
<td class="mla-doc-table-label">mla_get_terms_query_results</td>
<td class="mla-doc-hook-definition">called just after the <code>$wpdb->get_results</code> call, so you can inspect/record or modify the results.</td>
</tr>
<tr>
<td class="mla-doc-table-label">mla_tag_cloud_scale</td>
<td class="mla-doc-hook-definition">called as the scaled_count (size) of each term is calculated, so you can modify the results.</td>
</tr>
<tr>
<td class="mla-doc-table-label">use_mla_tag_cloud_style</td>
<td class="mla-doc-hook-definition">allow or suppress the inclusion of CSS styles in the tag cloud output.</td>
</tr>
<tr>
<td class="mla-doc-table-label">mla_tag_cloud_style_values,<br /> mla_tag_cloud_style_template,<br />mla_tag_cloud_style_parse</td>
<td class="mla-doc-hook-definition">for manipulating the Style template.</td>
</tr>
<tr>
<td class="mla-doc-table-label">mla_tag_cloud_open_values,<br />mla_tag_cloud_open_template,<br />mla_tag_cloud_open_parse</td>
<td class="mla-doc-hook-definition">for manipulating the "Open" part of the Markup template used in a "list" or "grid" cloud.</td>
</tr>
<tr>
<td class="mla-doc-table-label">mla_tag_cloud_row_open_values,<br />mla_tag_cloud_row_open_template,<br />mla_tag_cloud_row_open_parse</td>
<td class="mla-doc-hook-definition">for manipulating the "Row Open" part of the Markup template used in a "grid" cloud.</td>
</tr>
<tr>
<td class="mla-doc-table-label">mla_tag_cloud_item_values,<br />mla_tag_cloud_item_template,<br />mla_tag_cloud_item_parse</td>
<td class="mla-doc-hook-definition">for manipulating the "Item" part of the Markup template used in a "list" or "grid" cloud.</td>
</tr>
<tr>
<td class="mla-doc-table-label">mla_tag_cloud_row_close_values,<br />mla_tag_cloud_row_close_template,<br />mla_tag_cloud_row_close_parse</td>
<td class="mla-doc-hook-definition">for manipulating the "Row Close" part of the Markup template used in a "grid" cloud.</td>
</tr>
<tr>
<td class="mla-doc-table-label">mla_tag_cloud_close_values,<br />mla_tag_cloud_close_template,<br />mla_tag_cloud_close_parse</td>
<td class="mla-doc-hook-definition">for manipulating the "Close" part of the Markup template used in a "list" or "grid" cloud.</td>
</tr>
</table>
<a name="mla_term_list"></a>
&nbsp;
<p>
<a href="#backtotop">Go to Top</a>
</p>
<h3>MLA Term List Shortcode</h3>
<p>
The <code>[mla_term_list]</code> shortcode function displays hierarchical taxonomy terms in a variety of formats; link lists, dropdown controls and checkbox lists. The list works with both flat (e.g., Att. Tags) and hierarchical taxonomies (e.g., Att. Categories). MLA Term List enhancements for lists and controls include:
</p>
<ul class="mla_settings">
<li>Full support for WordPress categories, tags and custom taxonomies. You can select from any taxonomy or list of taxonomies defined in your site.</li>
<li>Several display formats, including "flat", "list", "dropdown" and "checklist".</li>
<li>Control over the styles, markup and content of each list using Style and Markup Templates. You can customize the "list" formats to suit any need.</li>
<li>Access to a wide range of content using the term-specific and Field-level Substitution parameters. A powerful Content Template facility lets you assemble content from multiple sources and vary the results depending on which data elements contain non-empty values for a given term.</li>
<li>Display Style and Display Content parameters for easy customization of the list display and the destination/value behind each term.
</li>
<li>A comprehensive set of filters gives you access to each step of the list generation process from PHP code in your theme or other plugins.
</li>
</ul>
<p>
The <code>[mla_term_list]</code> shortcode has many parameters and some of them have a complex syntax; it can be a challenge to build a correct shortcode. The WordPress Shortcode API has a number of limitations that make techniques such as entering HTML or splitting shortcode parameters across multiple lines difficult. You can use the alternative "enclosing shortcode" syntax to avoid many problems and make your shortcode easier to enter and understand. Read and follow the rules and guidelines in the "<a href="#complex_shortcodes">Entering Long/Complex Shortcodes</a>" Documentation section to get the results you want. 
</p>
<p>
Many of the <code>[mla_term_list]</code> concepts and shortcode parameters are modeled after the <code>[mla_gallery]</code> and <code>[mla_tag_cloud]</code> shortcodes, so the learning curve is shorter. Differences and parameters unique to the list are given in the sections below.
<a name="term_list_output_formats"></a>
</p>
<h4>Term List Output Formats</h4>
<p>
The default term list output is an unordered list of term names surrounded by hyperlinks. The terms' display format is determined by the <strong>"mla_output"</strong> parameter:
</p>
<table>
<tr>
<td class="mla-doc-table-label">flat</td>
<td>Returns a sequence of hyperlink tags without further HTML markup. The "separator" parameter content (default, one newline character) is inserted between each hyperlink.</td>
</tr>
<tr>
<td class="mla-doc-table-label">list</td>
<td>Returns hyperlinks enclosed by one of the HTML list tags; unordered (<strong>&lt;ul&gt;&lt;/ul&gt;, the default tag value</strong>) or definitions (&lt;dl&gt;&lt;/dl&gt;), which allow for each term to have a "caption". The "itemtag", "termtag" and "captiontag" parameters customize the list markup. If the "captiontag" parameter is present the list tag will be definitions (&lt;dl&gt;&lt;/dl&gt;).</td>
</tr>
<tr>
<td class="mla-doc-table-label">ulist</td>
<td>Returns hyperlinks enclosed by HTML unordered list tags (&lt;ul&gt;&lt;/ul&gt;). The "itemtag" and "termtag" parameters customize the list markup. <strong>"ulist" is the default output format value.</strong></td>
</tr>
<tr>
<td class="mla-doc-table-label">olist</td>
<td>Returns hyperlinks enclosed by HTML ordered list tags (&lt;ol&gt;&lt;/ol&gt;). The "itemtag" and "termtag" parameters customize the list markup.</td>
</tr>
<tr>
<td class="mla-doc-table-label">dlist</td>
<td>Returns hyperlinks enclosed by HTML definition list tags (&lt;dl&gt;&lt;/dl&gt;), which allow for each term to have a "caption". The "itemtag", "termtag" and "captiontag" parameters customize the list markup.</td>
</tr>
<tr>
<td class="mla-doc-table-label">dropdown</td>
<td>Returns an HTML "select" control with a sequence of HTML "option" tags.</td>
</tr>
<tr>
<td class="mla-doc-table-label">checklist</td>
<td>Returns HTML "input", "type=checkbox" elements enclosed by HTML unordered list tags (&lt;ul&gt;&lt;/ul&gt;). The "itemtag" and "termtag" parameters customize the list markup.</td>
</tr>
<tr>
<td class="mla-doc-table-label">array</td>
<td>Returns a PHP array of list hyperlinks. This output format is not available through the shortcode; it is allowed when the <code>MLAShortcodes::mla_term_list()</code> function is called directly from your theme or plugin PHP code.</td>
</tr>
</table>
<p>
A separate parameter, <code>echo=true</code>, allows you to echo cloud output directly to the browser instead of returning it to post/page content. This output format is not available through the shortcode; it is allowed when the <code>MLAShortcodes::mla_term_list()</code> function is called directly from your theme or plugin PHP code.
</p>
<p>
The list, dropdown and checklist formats can be extensively customized by using custom <a href="#mla_gallery_templates"><strong>Style and Markup Templates</strong></a>.
<a name="term_list_output_structure"></a>
</p>
<h4>Term List Output Structure</h4>
<p>
The <strong>"hierarchical"</strong> parameter determines the overall structure of the list:
</p>
<table>
<tr>
<td class="mla-doc-table-label">hierarchical=false</td>
<td>display terms without regard to parent/child relationships.</td>
</tr>
<tr>
<td class="mla-doc-table-label">hierarchical=true</td>
<td>display terms in a nested/indented structure where child terms are placed immediately after their parent. <strong>This is the default value.</strong> If you code multiple taxonomies in the same shortcode, each taxonomy will generate its own separate list or control.</td>
</tr>
<tr>
<td class="mla-doc-table-label">hierarchical=combine</td>
<td>display terms from multiple taxnomies in a single nested/indented structure.</td>
</tr>
</table>
<p>
The hierarchical display is enhanced by a number of data selection parameters that let you select and display portions of the hierarchy, e.g., a single root/parent term and all of its children.
<a name="term_list_items"></a>
</p>
<h4>Term List Item Parameters</h4>
<p>
Each item in the list comprises a term name, a hyperlink surrounding the term name and a "title" attribute (Rollover Text) displayed when the cursor hovers over the term name hyperlink. The following parameters customize item content and markup:
</p>
<table>
<tr>
<td class="mla-doc-table-label">show_count</td>
<td>Show how many items are assigned to the term. Values "true" or <strong>"false" (default)</strong>.</td>
</tr>
<tr>
<td class="mla-doc-table-label">current_item</td>
<td>Identifies the current/selected item(s) in the list. An integer value will be interpreted as a term id and anything else as a term slug. It will be ignored if it does not match an item in the list. Multiple values are allowed, separated by commas.</td>
</tr>
<tr>
<td class="mla-doc-table-label">mla_item_parameter</td>
<td>The name of the parameter containing the current item value; <strong>default "current_item"</strong>. You can change the name if you need multiple lists on one post/page.</td>
</tr>
<tr>
<td class="mla-doc-table-label">active_item_class</td>
<td>The class attribute for the "active" item(s) in the list as determined by the "current_item" parameter (if specified); <strong>default "mla_active_item"</strong>. An item is "active" if it or any of its child items are the current item.</td>
</tr>
<tr>
<td class="mla-doc-table-label">current_item_class</td>
<td>The class attribute for the current item in the list as determined by the "current_item" parameter (if specified); <strong>default "mla_current_item"</strong>.</td>
</tr>
</table>
<p>
The Item parameters are an easy way to customize the content and markup for each list item. For the array, flat and list formats you can also use the additional list item parameters in the next section.
<a name="term_list_items_afl"></a>
</p>
<h4>Term List Item Parameters (Array, Flat and List)</h4>
<p>
The following parameters customize item content and markup:
</p>
<table>
<tr>
<td class="mla-doc-table-label">separator</td>
<td>The text/space between terms. <strong>Default '\n'</strong> (whitespace)</td>
</tr>
<tr>
<td class="mla-doc-table-label">single_text</td>
<td>The text for the "title" attribute (Rollover Text) when the count value is one; <strong>default "%d item"</strong>. If you change the default, don't forget to include the "%d" placeholder.</td>
</tr>
<tr>
<td class="mla-doc-table-label">multiple_text</td>
<td>The text for the "title" attribute (Rollover Text) when the count value is zero or more than one; <strong>default "%d items"</strong>. If you change the default, don't forget to include the "%d" placeholder.</td>
</tr>
<tr>
<td class="mla-doc-table-label">link</td>
<td>Chooses the destination of the item hyperlink; details in the next section below.</td>
</tr>
</table>
<p>
The Item parameters are an easy way to customize the content and markup for each list item. For the list formats you can also use the <a href="#term_list_display_content_afl">Term List Display Content parameters</a> and/or Style and Markup Templates for even greater flexibility. The dropdown and checklist formats have corresponding Display Content parameters.
<a name="term_list_link"></a>
</p>
<h4>Term List Item Link Values (Array, Flat and List)</h4>
<p>
The Link parameter specifies the target and type of link from the list term/item to the item's archive page, edit page or other destination. You can also specify a non-hyperlink treatment for each item. These values only apply to the hyperlinks generated for the "array", "flat" and "list" output formats.
</p>
<table>
<tr>
<td class="mla-doc-table-label">current</td>
<td>Link back to the current post/page with a query argument, <code>current_item</code>, set to the term_id of the selected term. <strong>"current" is the default item link value.</strong></td>
</tr>
<tr>
<td class="mla-doc-table-label">view</td>
<td>Link to the term's "archive page". Support for archive pages, or "tag archives", is theme-dependent. There is an introduction to tag archives in the WordPress Codex at the bottom of the <a href="http://codex.wordpress.org/Function_Reference/wp_tag_cloud#Creating_a_Tag_Archive" title="Codex Tag Archive Discussion" target="_blank"><code>wp_tag_cloud</code> Function Reference</a>.</td>
</tr>
<tr>
<td class="mla-doc-table-label">edit</td>
<td>Link to the term's "edit tag/category" admin screen. This is only useful if the user is logged in and has the appropriate role or capabilities for accessing the edit screen.</td>
</tr>
<tr>
<td class="mla-doc-table-label" style="font-style:italic">(mla_link_href)</td>
<td>Link to a custom destination, typically another post/page. If the "mla_link_href" parameter is present the value of the "link" parameter is ignored. See the example later in this section for more details.</td>
</tr>
<tr>
<td class="mla-doc-table-label">span</td>
<td>Substitutes a <code>&lt;span&gt;&lt;/span&gt;</code> tag for the hyperlink tag. You can use the "mla_link_attributes" and "mla_link_class" parameters to add attributes to the <code>&lt;span&gt;</code> tag. You can use the "mla_link_text" parameter to customize the text within the span.</td>
</tr>
<tr>
<td class="mla-doc-table-label">none</td>
<td>Eliminates the hyperlink tag surrounding the item text. You can use the "mla_link_text" parameter to customize the contents.</td>
</tr>
</table>
<p>
Using the "mla_link_href" parameter to completely replace the link destination URL is a common and useful choice. With this parameter you can use the term list to select a term and then go to another post/page that uses that selection as part of an <code>[mla_gallery]</code> shortcode. The example later in this section uses this technique. 
<a name="term_list_display_style_ldc"></a>
</p>
<h4>Term List Display Style (List, Dropdown and Checklist)</h4>
<p>
Two parameters provide a way to apply custom style and markup templates to your <code>[mla_term_list]</code> display. These parameters replace the default style and/or markup templates with templates you define on the "Shortcodes" tab of the Settings page. Templates are supported for the "list", "dropdown" and "checklist" list formats.
</p>
<table>
<tr>
<td class="mla-doc-table-label">mla_style</td>
<td>replaces the default style template for an <code>[mla_term_list]</code> shortcode. You can code "none" to suppress the addition of CSS inline styles entirely.</td>
</tr>
<tr>
<td class="mla-doc-table-label">mla_markup</td>
<td>replaces the default markup template for an <code>[mla_term_list]</code> shortcode</td>
</tr>
</table>
<a name="term_list_display_style"></a>
&nbsp;
<h4>Term List Display Style (List and Checklist)</h4>
<p>
Three parameters provide control over the XHTML tags used to enclose each part of the list items. These parameters are used in the "list" output formats as follows:
</p>
<table>
<tr>
<td class="mla-doc-table-label">itemtag</td>
<td>the name of the XHTML tag used to begin the list; the default depends on the output format (list/ulist, olist, dlist). When an explicit "captiontag" parameter is added to "list" format, the default is "dl".</td>
</tr>
<tr>
<td class="mla-doc-table-label">termtag</td>
<td>the name of the XHTML tag used to enclose each term in the list; the default is "li". When an explicit "captiontag" parameter is added, the default is "dt".</td>
</tr>
<tr>
<td class="mla-doc-table-label">captiontag</td>
<td>the name of the XHTML tag used to enclose each caption. For "dlist" format, the default is "dd". To add a caption in "list" format you must enter an explicit "captiontag=dd" parameter to the shortcode.</td>
</tr>
</table>
<a name="term_list_display_style_d"></a>
&nbsp;
<h4>Term List Display Style (Dropdown)</h4>
<p>
Three parameters provide control over the XHTML tags used to enclose each part of the dropdown control items. 
</p>
<table>
<tr>
<td class="mla-doc-table-label">itemtag</td>
<td>the name of the XHTML tag used to name the control; the default is "select".</td>
</tr>
<tr>
<td class="mla-doc-table-label">termtag</td>
<td>the name of the XHTML tag used to name each term in the control; the default is "item".</td>
</tr>
<tr>
<td class="mla-doc-table-label">mla_multi_select</td>
<td>The default, "false", specifies that only one value can be selected. If set to "true", it specifies that multiple options can be selected at once.</td>
</tr>
</table>
<p>
These parameters give you some control over the markup used for the list and its elements. For more complex applications you can use style and markup templates to gain complete control over the list display.
<a name="term_list_display_content_all"></a>
</p>
<h4>Term List Display Content (all Output Formats)</h4>
<p>
Six parameters provide an easy way to add special entries to the links or input controls generated by the shortcode.  You can add entries for selecting all items, items that have no term assignments at all and/or items that have one or more assignments to any term(s) in the taxonomy. The default values for these entries are compatible with the simple taxonomy query and tax_query parameters of the <code>[mla_gallery]</code> shortcode.
</p>
<table>
<tr>
<td class="mla-doc-table-label">option_all_text</td>
<td>Text to display for showing an 'all terms' option. Default will not show an option to select 'all terms'. When this option is selected all items, including items with no term assignments at all, are included in the results.</td>
</tr>
<tr>
<td class="mla-doc-table-label">option_all_value</td>
<td>Control value for 'all terms' option. <strong>Default '-3' or 'ignore.terms.assigned'</strong>. Numeric values are used for the term_id; text values for the slug. When this option is selected all items, including items with no term assignments at all, are included in the results.</td>
</tr>
<tr>
<td class="mla-doc-table-label">option_no_terms_text</td>
<td>Text to display for showing an 'no terms assigned' option. Default will not show an option to select 'no terms'. When this option is selected only those items with no term assignments at all are included in the results.</td>
</tr>
<tr>
<td class="mla-doc-table-label">option_no_terms_value</td>
<td>Control value for 'no terms' option. <strong>Default '-1' or 'no.terms.assigned'</strong>. Numeric values are used for the term_id; text values for the slug. When this option is selected only those items with no term assignments at all are included in the results.</td>
</tr>
<tr>
<td class="mla-doc-table-label">option_any_terms_text</td>
<td>Text to display for showing an 'any terms assigned' option. Default will not show an option to select 'any terms assigned'. When this option is selected only those items with one or more term assignments are included in the results.</td>
</tr>
<tr>
<td class="mla-doc-table-label">option_any_terms_value</td>
<td>Control value for 'any terms' option. <strong>Default '-2' or 'any.terms.assigned'</strong>. Numeric values are used for the term_id; text values for the slug. When this option is selected only those items with one or more term assignments are included in the results.</td>
</tr>
</table>
<p>
The "mla_debug" parameter controls the display of information about the query parameters and SQL statements used to retrieve list items. If you code <code>mla_debug=true</code> you will see a lot of information added to the post or page containing the list. Of course, this parameter should <strong><em>ONLY</em></strong> be used in a development/debugging environment; it's quite ugly.
</p>
<p>
If you code <code>mla_debug=log</code> all of the information will be written to the error log. You can use the <a href="#mla_debug_tab">MLA Debug Tab</a> to view and download the information in the error log.
</p>
<p>
Look for the "mla_debug attribute_errors" entry in the debug output; it will often list the parts of the shortcode parameters that couldn&rsquo;t be parsed. If you see "[mla_gallery" in this entry you probably used the enclosing shortcode format in that shortcode but did not add the "[/mla_gallery]" delimiter to an earlier shortcode.
<a name="term_list_display_content_afl"></a>
</p>
<h4>Term List Display Content (Array, Flat and List)</h4>
<p>
Nine parameters provide an easy way to control the contents of list items without requiring the use of custom Markup templates.  
</p>
<table>
<tr>
<td class="mla-doc-table-label">mla_link_attributes</td>
<td>adds one or more HTML attributes to the hyperlink for each item; see below. For security reasons, HTML event Attributes are not allowed; any attribute name that begins with "on" will invalidate the parameter.</td>
</tr>
<tr>
<td class="mla-doc-table-label">mla_link_class</td>
<td><strong>adds</strong> one or more classes to any already defined for the hyperlink</td>
</tr>
<tr>
<td class="mla-doc-table-label">mla_link_href</td>
<td>replaces the HTML "href" attribute in the hyperlink for each item; see below</td>
</tr>
<tr>
<td class="mla-doc-table-label">mla_link_text</td>
<td>replaces the term name text displayed for each item</td>
</tr>
<tr>
<td class="mla-doc-table-label">mla_nolink_text</td>
<td>replaces the empty string displayed when there are no list items</td>
</tr>
<tr>
<td class="mla-doc-table-label">mla_rollover_text</td>
<td>replaces the HTML "title" attribute in the hyperlink for each item. This is the attachment title text displayed when the mouse rolls or hovers over the term name</td>
</tr>
<tr>
<td class="mla-doc-table-label">mla_caption</td>
<td>replaces the caption text displayed beneath each item. The caption appears for "dlist" items and for "list" items when the "captiontag" parameter is present.</td>
</tr>
<tr>
<td class="mla-doc-table-label">mla_item_value</td>
<td>replaces the <strong>term_id (default)</strong> value of the <code>current_item</code> hyperlink query argument.</td>
</tr>
<tr>
<td class="mla-doc-table-label">mla_target</td>
<td>adds an HTML "target" attribute to the hyperlink for each gallery item; see below</td>
</tr>
</table>
<p>
The "mla_item_value" parameter is the most commonly-used. For example, to set the <code>current_item</code> to the term slug instead of the term id you would code <code>mla_item_value="{+slug+}"</code>.
</p>
<p>
All but the "mla_target" parameter support the <a href="#term_list_markup_parameters">Markup</a>, <a href="#term_list_item_parameters">Item-specific</a>, <a href="#term_list_variable_parameters">Field-level</a> and <a href="#mla_template_parameters">Content Template</a> substitution parameters defined for Markup Templates. For example, if you code "<code>mla_rollover_text='{+slug+} : {+rollover_text+}'</code>, the rollover text will contain the term slug, a colon, and the appropriate "single text" or "multiple text". Simply add "{+" before the substitution parameter name and add "+}" after the name. Note that the enclosing delimiters are different than those used in the templates, since the WordPress shortcode parser reserves square brackets ("[" and "]") for its own use.
</p>
<p>
The "mla_link_href" parameter is a great way to change the destination your list item links to and/or add arguments to the link for later processing. For example, to make a gallery item link back to the current page/post you can code: <code>mla_link_href='{+page_url+}'</code>. You can also add arguments to the link, e.g., <code>mla_link_href='{+page_url+}?firstarg=value1&amp;amp;myarg=myvalue'</code>. Note the use of the HTML entity name "&amp;amp;" to put an ampersand in the value; the WordPress "visual" post editor will replace "&amp;", "&lt;" and ">" with "&amp;amp;", "&amp;lt;" and "&amp;gt;" whether you like it not. The <strong>only</strong> markup parameters modified by this parameter are "link_url" and "thelink". The markup parameters "currentlink", "viewlink" and "editlink" are not modified.
</p>
<p>
The "mla_link_attributes" parameter accepts any value and adds it to the "&lt;a&gt;" or "&lt;span&gt;" tags for the item. For example, you can add a unique identifier to each item by adding <code>mla_link_attributes='id="{+selector}-{+index+}"'</code> to your shortcode (note the use of single quotes around the parameter value and the double quotes within the parameter). <strong>IMPORTANT:</strong> since the shortcode parser reserves square brackets ("[" and "]") for its own use, <strong>you must substitute curly braces for square brackets</strong> if your attributes require brackets. If you must code a curly brace in your attribute value, preface it with <strong>two backslash characters</strong>, e.g., "\\{" or "\\}". If you code an attribute already present in the tag, your value will override the existing value.
</p>
<p>
The "mla_target" parameter accepts any value and adds an HTML "target" attribute to the hyperlink with that value. For example, if you code <code>mla_target="_blank"</code> the item will open in a new window or tab. You can also use "_self", "_parent", "_top" or the "<em>framename</em>" of a named frame.
<a name="term_list_display_content"></a>
</p>
<h4>Term List Display Content (Dropdown and Checklist)</h4>
<p>
Dropdown and Checklist formats do not generate hyperlinks; they generate HTML input controls that return the content of <code>value</code> attributes. Eight parameters provide an easy way to control the contents of items without requiring the use of custom Markup templates. 
</p>
<table>
<tr>
<td class="mla-doc-table-label">mla_control_name</td>
<td>replaces the <strong><code>tax_input[[+taxonomy+]][]</code> (default)</strong> name attribute in the input tag for the control(s). Useful for adding multiple dropdown controls for the same taxonomy to a post/page and for dropdown controls containing terms from multiple taxonomies.</td>
</tr>
<tr>
<td class="mla-doc-table-label">mla_option_text</td>
<td>replaces the <strong>term name (default)</strong> text displayed for each option</td>
</tr>
<tr>
<td class="mla-doc-table-label">mla_option_value</td>
<td>replaces the <strong>term_id (default)</strong> value returned for each option. For <strong>dropdown</strong> controls containing terms from multiple taxonomies, the default is <strong><code>[+taxonomy+].[+term_id+]</code></strong>.</td>
</tr>
<tr>
<td class="mla-doc-table-label">hide_if_empty</td>
<td>If <strong>false (default)</strong>, display a control with "option_none" text &amp; value. If true, display mla_nolink_text or nothing.</td>
</tr>
<tr>
<td class="mla-doc-table-label">mla_nolink_text</td>
<td>replaces the entire control with text/markup; <strong>default empty</strong></td>
</tr>
<tr>
<td class="mla-doc-table-label">option_none_text</td>
<td>Text to display for showing a 'no terms' option, displayed when there are no terms defined in the taxonomy. Default will not show an option to select 'no terms'.</td>
</tr>
<tr>
<td class="mla-doc-table-label">option_none_value</td>
<td>Control value for 'no terms' option, displayed when there are no terms defined in the taxonomy. <strong>Default -1</strong>. Numeric values are used for the term_id; text values for the slug.</td>
</tr>
</table>
<p>
The <code>mla_option_value</code> parameter is the most commonly-used. For example, to return the term slug instead of the term id you would code <code>mla_option_value="{+slug+}"</code>.
</p>
<p>
Dropdown controls containing terms from multiple taxonomies (flat or hierarchical) require special handling because the <code>name=</code> attribute appears once for the entire control, not once for each term within the control. To associate each term with its taxonomy both values are encoded in the <code>value=</code> attribute in the term's option tag. Here is an example for two "flat" taxonomies:</p>
<p>
<code>
[mla_term_list taxonomy="animal,vegetable" mla_output=dropdown]
</code>
</p>
<p>
The above shortcode generates the HTML below (some class attributes removed for clarity).
</p>
<p>
<code>
&lt;select name="tax_input[animal-vegetable][]" class="term-list-taxonomy-animal-vegetable" id="mla_term_list-1"&gt;<br />
&nbsp;&nbsp;&lt;option class="term-list-dropdown-term level-0" value="animal.12"&gt;Dog&lt;/option&gt;<br />
&nbsp;&nbsp;&lt;option class="term-list-dropdown-term level-0" value="animal.13"&gt;Cat&lt;/option&gt;<br />
&nbsp;&nbsp;&lt;option class="term-list-dropdown-term level-0" value="vegetable.33"&gt;Carrot&lt;/option&gt;<br />
&nbsp;&nbsp;&lt;option class="term-list-dropdown-term level-0" value="vegetable.35"&gt;Apple&lt;/option&gt;<br />
&lt;/select&gt;
</code>
</p>
<p>
In the above example, to return the term slug instead of the term id you would add <code>mla_option_value="{+taxonomy+}.{+slug+}"</code> to the shortcode.
</p>
<p>
If you use the default control name, the <code>[mla_gallery]</code> shortcode&rsquo;s <code>tax_input</code> parameter can convert the compound value(s) returned in the <code>tax_input</code> array to the appropriate taxonomy-specific entries. For example, the <code>animal.12</code> value can be handled as if it was <code>animal=12</code>. For the above example, the corresponding <code>[mla_gallery]</code> shortcode parameter would be <code>tax_input="{+request:tax_input.animal-vegetable+}"</code>. See the <a href="#taxonomy_parameters_tax_input"><strong>Compound Taxonomy Queries, "tax_input"</strong></a> section for more information.
</p>
<p>
You could use the <code>mla_control_name</code> shortcode parameter to move the selected term out of the default <code>tax_input</code> array to a separate query argument and then process the returned value in your own PHP code.
<a name="term_list_other"></a>
</p>
<h4>Term List Other Parameters</h4>
<table>
<tr>
<td class="mla-doc-table-label">mla_debug</td>
<td>controls debug log output; <strong>default false</strong>. See below for details.</td>
</tr>
<tr>
<td class="mla-doc-table-label">echo</td>
<td>This does not apply to the shortcode; it is allowed when the <code>MLAShortcodes::mla_term_list()</code> function is called directly from your theme or plugin PHP code. If <code>echo=false</code> content generated by the function is returned to the caller; <strong>false is the default value</strong>. If <code>echo=true</code> content is echoed to the browser and nothing is returned.</td>
</tr>
</table>
<p>
The "mla_debug" parameter controls the display of information about the query parameters and SQL statements used to retrieve list items. If you code <code>mla_debug=true</code> you will see a lot of information added to the post or page containing the list. Of course, this parameter should <strong><em>ONLY</em></strong> be used in a development/debugging environment; it's quite ugly.
</p>
<p>
If you code <code>mla_debug=log</code> all of the information will be written to the error log. You can use the <a href="#mla_debug_tab">MLA Debug Tab</a> to view and download the information in the error log.
</p>
<p>
Look for the "mla_debug attribute_errors" entry in the debug output; it will often list the parts of the shortcode parameters that couldn&rsquo;t be parsed. If you see "[mla_gallery" in this entry you probably used the enclosing shortcode format in that shortcode but did not add the "[/mla_gallery]" delimiter to an earlier shortcode.
<a name="term_list_data_selection"></a>
</p>
<h4>Term List Data Selection Parameters</h4>
<p>
The data selection parameters specify which taxonomy (or taxonomies) the terms are taken from, which terms are returned for the list and the order in which the terms are returned:
</p>
<table>
<tr>
<td class="mla-doc-table-label">taxonomy</td>
<td>The taxonomy or taxonomies to retrieve terms from; <strong>default 'post_tag'</strong>. Use the name/slug of each taxonomy, not the display name, e.g., 'post_tag', 'category', 'attachment_tag', or 'attachment_category'. You can specify multiple taxonomies as a comma-separated string or (if you are calling <code>MLAShortcodes::mla_term_list()</code> function directly from your theme or plugin PHP code) as an array.</td>
</tr>
<tr>
<td class="mla-doc-table-label">post_mime_type</td>
<td>The MIME type(s) of the items to include in the term-specific counts. The default is "all", which avoids the additional database effort required to filter by MIME type. You can override the default to, for example, display PDF documents (<code>post_mime_type=application/pdf</code>) or all image MIME types (<code>post_mime_type=image</code>). You can select several MIME types with a comma-separated list, e.g., <code>post_mime_type='audio,video'</code>. Wildcard specifications are also supported. For example, <code>post_mime_type='*/mpeg'</code> to select audio and video mpeg formats or <code>post_mime_type='application/*ms*'</code> to select all Microsoft application formats (Word, Excel, etc.).</td>
</tr>
<tr>
<td class="mla-doc-table-label">post_type</td>
<td>The <a href="http://codex.wordpress.org/Post_Types" title="WordPress Codex &quot;Post Types&quot; page" target="_blank">post type(s)</a> of the items to include in the term-specific counts. The default is "attachment". You can override the default if you want to count other types for which the taxonomy is registered, e.g., "post" to count Posts in the "category" and "post_tag" taxonomies. The <a href="http://codex.wordpress.org/Post_Types" title="WordPress Codex &quot;Post Types&quot; page" target="_blank">Codex Page</a> documents other post type values. Make sure your "post_status" and "post_type" values are consistent, e.g., use <code>post_type="attachment,post" post_status="inherit,publish"</code> together.</td>
</tr>
<tr>
<td class="mla-doc-table-label">post_status</td>
<td>The <a href="http://codex.wordpress.org/Post_Status" title="WordPress Codex &quot;Post Status&quot; page" target="_blank">post status value(s)</a> of the items to include in the term-specific counts. The default is "inherit", which counts attachments (Media Library Items). You can override the default if you want to count other values, e.g., "publish" to count published Posts in the "category" and "post_tag" taxonomies. If you code "private" and the user is not logged in, "private" will be removed. The <a href="http://codex.wordpress.org/Post_Status" title="WordPress Codex &quot;Post Status&quot; page" target="_blank">Codex page</a> documents other post status values.</td>
</tr>
<tr>
<td class="mla-doc-table-label">ids</td>
<td>A comma-separated list of <strong>attachment ID</strong> values for an item-specific list. Only those terms assigned to the attachment(s) in the list will be included. You can have one or more IDs and you can include assigned terms from one or more taxonomies. Do not use the "include" parameter if you use the "ids" parameter.</td>
</tr>
<tr>
<td class="mla-doc-table-label">no_count</td>
<td>The default, "false", computes a term-specific count of the number of attachments assigned to that term. If you have a large number of terms and/or attachments, this can take a long time.<br />
&nbsp;<br />
You can code "true" to omit the attachment-counting process. If you do that, the "post_mime_type", "post_type", "post_status", "minimum", "number" and "orderby=count" parameters are also ignored, since they require counting the attachments.<br />
&nbsp;<br />
You can code "internal" to skip the explicit attachment-counting process and use the WordPress-maintained "count" database values. If you code <code>no_count=internal</code>, the "post_mime_type", "post_type" and "post_status" paramerters are ignored, since they require a separate subquery to filter the list by post-specific values.<br />
&nbsp;</td>
</tr>
<tr>
<td class="mla-doc-table-label">include</td>
<td>A comma-separated list of term ids (<strong>not</strong> names or slugs) to include. Only the terms in this list that are used in the taxonomies you specified will be retrieved.</td>
</tr>
<tr>
<td class="mla-doc-table-label">exclude</td>
<td>A comma-separated list of term ids (<strong>not</strong> names or slugs) to exclude from the returned values.</td>
</tr>
<tr>
<td class="mla-doc-table-label">parent</td>
<td>Get direct children of this term id (only terms whose explicit parent is this value). If 0 is passed, only top-level terms are returned.</td>
</tr>
<tr>
<td class="mla-doc-table-label">minimum</td>
<td>The minimum number of attachments that must be associated with the term for the term to be included. For example, "minimum=1" will omit "empty" terms.</td>
</tr>
<tr>
<td class="mla-doc-table-label">number</td>
<td>The maximum number of "most popular" terms to return. The default, zero, returns them all. Terms are sorted by "count DESC, id ASC" to apply this constraint.</td>
</tr>
<tr>
<td class="mla-doc-table-label">orderby</td>
<td>The sort order of the retrieved terms. Can be one or more of "count", "id" (term_id), "name" (the default), "none", "random", or "slug".<br />
&nbsp;<br />
If you install and activate the <a href="https://wordpress.org/plugins/simple-custom-post-order/" target="_blank" rel="noopener noreferrer nofollow">Simple Custom Post Order</a> plugin you can code "term_order" to sort the cloud into the "drag and drop" order supported by that plugin.<br />
&nbsp;<br />
Or, if you install and activate the <a href="https://wordpress.org/plugins/simple-taxonomy-ordering/" target="_blank" rel="noopener noreferrer nofollow">Simple Taxonomy Ordering</a> plugin you can code "tax_position" to sort the cloud into the "drag and drop" order supported by that plugin.<br />
&nbsp;</td>
</tr>
<tr>
<td class="mla-doc-table-label">order</td>
<td>Can be "ASC" (ascending, the default) or "DESC" (descending). Note that DESC is not supported for <code>orderby=tax_position</code>.</td>
</tr>
<tr>
<td class="mla-doc-table-label">preserve_case</td>
<td>Preserve upper- and lower-case distinctions when sorting by name. The default, "false", specifies a case-insensitive sort order.</td>
</tr>
<tr>
<td class="mla-doc-table-label">pad_counts</td>
<td>True to include the count of all children in their parents' count. The default, "false", does not include children in their parents' count.<br />
&nbsp;<br />
The "pad_counts" parameter is only applied to the first (or only) taxonomy you specify, and that taxonomy must be hierarchical to see any difference in the counts.<br />
&nbsp;</td>
</tr>
</table>
<p>
You can sort on more than one value, e.g., <code>orderby="count DESC, name"</code> and you can specify ASC/DESC on a value by value basis. <strong>NOTE: multiple orderby values are separated by commas, not spaces.</strong> This is a change from WP_Query.
</p>
<p>
The order parameter (default ASC) can give an ASC/DESC default for any value that doesn't have a specific choice. For example, <code>orderby="count DESC, name" order=ASC</code> is the same as <code>orderby="count DESC, name ASC"</code>.
<a name="term_list_data_selection_h"></a>
</p>
<h4>Term List Data Selection Parameters (Hierarchical Output)</h4>
<p>
When the list is organized by the term hierarchy (hierarchical=true) four parameters can be used to trim the tree and display a subset of the terms:
</p>
<table>
<tr>
<td class="mla-doc-table-label">child_of</td>
<td>Display all terms that are descendants (i.e. children &amp; grandchildren) of the term identified by its term_id; <strong>default empty</strong></td>
</tr>
<tr>
<td class="mla-doc-table-label">exclude_tree</td>
<td>Comma/space-separated string of term_id values to exclude along with all of their descendant terms. If <code>include</code> is non-empty, <code>exclude_tree</code> is ignored. <strong>Default empty.</strong></td>
</tr>
<tr>
<td class="mla-doc-table-label">include_tree</td>
<td>Comma/space-separated string of term_id values to include along with all of their descendant terms. <strong>Default empty.</strong></td>
</tr>
<tr>
<td class="mla-doc-table-label">depth</td>
<td>The maximum depth of parent/child relationships; <strong>default 0/False</strong> to display all levels</td>
</tr>
</table>
<p>
You can use these parameters with multiple <code>[mla_term_list]</code> shortcodes to navigate large hierarchical taxonomies. For example, define a control that shows only root terms ( <code>parent=0</code> ) with a control that shows the children of a specific root term ( <code>child_of={+current_item+}</code> ).
<a name="term_list_substitution"></a>
</p>
<h4>Term List Substitution Parameters</h4>
<p>
Substitution parameters are a powerful way to add general and attachment-specific values to the list display. For example, if you code "<code>mla_link_href="{+page_url+}?current_slug={+slug+}&amp;current_name={+name,url+}"</code>, the hyperlinks behind each list term will contain the page URL, the current term slug and the term name encoded in url format. There are many parameter names like `page_url` and `slug` divided in several categories:
</p>
<table>
<tr>
<td class="mla-doc-table-label">List-specific</td>
<td>values that are known at the beginning of shortcode processing and remain the same for the entire shortcode, such as the ID and URL of the post/page in which the shortcode appears</td>
</tr>
<tr>
<td class="mla-doc-table-label">Style</td>
<td>values that are known when the list-specific CSS inline styles are composed just before list output begins</td>
</tr>
<tr>
<td class="mla-doc-table-label">Markup</td>
<td>values that are known at the beginning of list output processing and remain the same for the entire list</td>
</tr>
<tr>
<td class="mla-doc-table-label"><a href="#term_list_item_parameters">Item-specific</a></td>
<td  style="vertical-align: top">values that change for each term/item in the list, such as Name and Description</td>
</tr>
<tr>
<td class="mla-doc-table-label"><a href="#mla_variable_parameters">Field-level</a></td>
<td>additional values from sources like query arguments and shortcode parameters. The "request:" and "query:" field-level prefixes can be used in the list. The other prefixes are attachment-specific and have no meaning in a list</td>
</tr>
<tr>
<td class="mla-doc-table-label"><a href="#mla_template_parameters">Content&nbsp;Template</a></td>
<td>lets you compose a value from multiple substitution parameters and test for empty values, choose among two or more alternatives or suppress output entirely</td>
</tr>
</table>
<p>
The following paragraphs go into more detail about each category and the parameter names within them.
</p>
<p>
To use a substitution parameter in your shortcode, simply add "{+" before the substitution parameter name and add "+}" after the name. Note that the enclosing delimiters are different than those used in Style and Markup templates, since the WordPress shortcode parser reserves square brackets ("[" and "]") for its own use. Also, because square brackets are reserved, <strong>you must substitute curly braces for square brackets</strong> if your parameter values require them. For example, if your shortcode parameter is <code>mla_link_attributes='rel="shadowbox{sbalbum-{+instance+}};player=img"'</code>, the actual attribute added to the link will be <code>rel="shadowbox[sbalbum-1];player=img"</code>. If you must code a curly brace in a parameter value, preface it with <strong>two backslash characters</strong>, e.g., "\\{" or "\\}".
</p>
<p>
<strong>list-specific substitution parameters</strong> are known at the beginning of shortcode processing and they do not change during processing. They can be used, for example, in any of the data selection parameters to change the items selected for the list based on information about the post/page on which the list appears. The list-specific substitution parameters are:
</p>
<table>
<tr>
<td class="mla-doc-table-label">site_url</td>
<td>absolute URL to the site directory, without trailing slash</td>
</tr>
<tr>
<td class="mla-doc-table-label">base_url</td>
<td>absolute URL to the upload directory, without trailing slash</td>
</tr>
<tr>
<td class="mla-doc-table-label">base_dir</td>
<td>absolute (full) path to the upload directory, without trailing slash</td>
</tr>
<tr>
<td class="mla-doc-table-label">instance</td>
<td>starts at '1', incremented for each additional shortcode in the post/page</td>
</tr>
<tr>
<td class="mla-doc-table-label">selector</td>
<td>"mla_term_list-{$instance}", e.g., mla_term_list-1</td>
</tr>
<tr>
<td class="mla-doc-table-label">page_ID,<br />id</td>
<td style="vertical-align: top">the <code>ID</code> value of the post/page in which the list appears</td>
</tr>
<tr>
<td class="mla-doc-table-label">page_author</td>
<td>the <code>post_author</code> value of the post/page in which the list appears</td>
</tr>
<tr>
<td class="mla-doc-table-label">page_date</td>
<td>the <code>post_date</code> value of the post/page in which the list appears</td>
</tr>
<tr>
<td class="mla-doc-table-label">page_content</td>
<td>the <code>post_content</code> value of the post/page in which the list appears</td>
</tr>
<tr>
<td class="mla-doc-table-label">page_title</td>
<td>the <code>post_title</code> value of the post/page in which the list appears</td>
</tr>
<tr>
<td class="mla-doc-table-label">page_excerpt</td>
<td>the <code>post_excerpt</code> value of the post/page in which the list appears</td>
</tr>
<tr>
<td class="mla-doc-table-label">page_status</td>
<td>the <code>post_status</code> value of the post/page in which the list appears</td>
</tr>
<tr>
<td class="mla-doc-table-label">page_name</td>
<td>the <code>post_name</code> value of the post/page in which the list appears</td>
</tr>
<tr>
<td class="mla-doc-table-label">page_modified</td>
<td>the <code>post_modified</code> value of the post/page in which the list appears</td>
</tr>
<tr>
<td class="mla-doc-table-label">page_guid</td>
<td>the <code>post_guid</code> value of the post/page in which the list appears</td>
</tr>
<tr>
<td class="mla-doc-table-label">page_type</td>
<td>the <code>post_type</code> value of the post/page in which the list appears</td>
</tr>
<tr>
<td class="mla-doc-table-label">page_url</td>
<td>absolute URL to the page or post on which the list appears, if any, with trailing slash</td>
</tr>
</table>
<p>
If the shortcode is executed when there is no current post, an artificial "empty post" is used to supply reasonable default values. One special case is the "Author Archive" page when the author has no posts. In this case, an atrificial "author post" supplies a few values based on the author's user information. The available values are documented in the <a href="#gallery_specific">Gallery-specific substitution parameters</a> subsection.</p>
</p>
<p>
Style and Markup templates give you great flexibility for the content and format of each <code>[mla_term_list]</code> when you use the "list", "dropdown" and "checklist" output formats. You can define as many templates as you need. 
</p>
<p>
Style templates provide list-specific CSS inline styles (you can code mla_style=none to suppress the addition of CSS inline styles entirely). Markup templates provide the HTML markup for the beginning of the list, each list item and the end of the list. Additional "Child" template parts provide optional markup for the opening, each item and the close of sublists for child terms.
</p>
<p>
The Shortcodes tab on the Settings page lets you add, change and delete custom templates. The default templates are also displayed on this tab for easy reference. 
</p>
<p>
There are two default templates for the "list" format; "term-list-ul" and "term-list-dl". As the names imply, the "term-list-dl" default is used for the "dlist" output format or when the "captiontag" parameter is present in the shortcode. If you name a custom Markup template in your shortcode, it will be used whether the "captiontag" is present or not.
<a name="term_list_variable_parameters"></a>
</p>
<p>
The following <strong>field-level substitution parameters</strong> are available in the Style template and any of the Markup template sections:</p>
<table>
<tr>
<td class="mla-doc-table-label">request</td>
<td>The parameters defined in the <code>$_REQUEST</code> array; the "query strings" sent from the browser. The PHP $_REQUEST variable is a superglobal Array that contains the contents of both $_GET, $_POST and $_COOKIE arrays.</td>
</tr>
<tr>
<td class="mla-doc-table-label">query</td>
<td>The parameters defined in the <code>[mla_term_list]</code> shortcode. For example, if your shortcode is <code>[mla_term_list taxonomy=attachment_tag div-class=some_class]</code> you can access the parameters as <code>[+query:taxonomy+]</code> and <code>[+query:div-class+]</code> respectively. You can define your own parameters, e.g., "div-class"; they will be accessible as field-level data but will otherwise be ignored.</td>
</tr>
<tr>
<td class="mla-doc-table-label">template</td>
<td>A Content Template, which lets you compose a value from multiple substitution parameters and test for empty values, choosing among two or more alternatives or suppressing output entirely. See the <a href="#mla_template_parameters">Content Templates</a> section for details. Note that the formatting option is not supported for content templates.</td>
</tr>
</table>
<p>
Term list substitution parameters for the <strong>Style template</strong> are:
</p>
<table>
<tr>
<td class="mla-doc-table-label">mla_output</td>
<td>shortcode parameter, default = 'ulist'</td>
</tr>
<tr>
<td class="mla-doc-table-label">mla_style</td>
<td>shortcode parameter, default = 'term-list'</td>
</tr>
<tr>
<td class="mla-doc-table-label">mla_markup</td>
<td>shortcode parameter, default = 'term-list-ul', '-dl', '-dropdown' or '-checklist' depending on the list output format</td>
</tr>
<tr>
<td class="mla-doc-table-label">taxonomy</td>
<td>the slug of the taxonomy on which the list is based. Multiple taxonomy slugs are joined with a dash to form a single value.</td>
</tr>
<tr>
<td class="mla-doc-table-label">current_item</td>
<td>the current/selected item in the list, as entered in the shortcode parameters.</td>
</tr>
<tr>
<td class="mla-doc-table-label">itemtag</td>
<td>shortcode parameter, default = 'ul', 'ol', or 'dl' if the "captiontag" parameter is present.</td>
</tr>
<td class="mla-doc-table-label">itemtag_attributes</td>
<td>HTML attribute value(s) added to the item tag</td>
</tr>
<tr>
<td class="mla-doc-table-label">itemtag_class</td>
<td>HTML class names(s) added to the item tag</td>
</tr>
<tr>
<td class="mla-doc-table-label">itemtag_id</td>
<td>HTML "id" attribute value for the item tag</td>
</tr>
<tr>
<td class="mla-doc-table-label">termtag</td>
<td>shortcode parameter, default = 'li', or 'dd' if the "captiontag" parameter is present.</td>
</tr>
<tr>
<td class="mla-doc-table-label">captiontag</td>
<td>shortcode parameter, default = '', i.e., no caption tag value.</td>
</tr>
<tr>
<td class="mla-doc-table-label">multiple</td>
<td>'multiple' if the <code>mla_multi_select</code> parameter is true, empty if not.</td>
</tr>
<tr>
<tr>
<td class="mla-doc-table-label">all_found_rows</td>
<td>the number of terms retrieved for the list before "pruning" by the Hierarchical Output Data Selection parameters</td>
</tr>
<tr>
<td class="mla-doc-table-label">found_rows</td>
<td>the number of terms retrieved for the list, after any "pruning"</td>
</tr>
<tr>
<td class="mla-doc-table-label">separator</td>
<td>The text/space between tags</td>
</tr>
<tr>
<td class="mla-doc-table-label">single_text</td>
<td>Rollover Text when the count value is one</td>
</tr>
<tr>
<td class="mla-doc-table-label">multiple_text</td>
<td> Rollover Text when the count value is zero or more than one</td>
</tr>
<tr>
<td class="mla-doc-table-label">echo</td>
<td>whether the output is echoed directly to the browser (true) or returned to the caller (false). For a shortcode, always false.</td>
</tr>
<tr>
<td class="mla-doc-table-label">link</td>
<td>the destination name of the item hyperlink, default 'view'</td>
</tr>
</table>
<p>
&nbsp;
<a name="term_list_markup_parameters"></a>
</p>
<p>
Term list substitution parameters for the <strong>Markup template</strong> are available in all of the template sections. All of the <strong>list-specific substitution parameters</strong> and the <strong>substitution parameters for Style templates</strong> are available for use in markup templates. Three substitution parameters are added or modified for the markup template:
</p>
<table>
<tr>
<td class="mla-doc-table-label">current_level</td>
<td>the parent/child relationship "depth", starting at zero for root terms</td>
</tr>
<tr>
<td class="mla-doc-table-label">itemtag_class</td>
<td>the 'children' class is added for all but the root level</td>
</tr>
<tr>
<td class="mla-doc-table-label">itemtag_id</td>
<td>the term's parent id is added for all but the root level</td>
</tr>
</table>
<p>
There are also <a href="#mla_term_list_hooks">MLA Term List Filters (Hooks)</a> that could add, modify or delete parameters available for markup processing, if your application uses them.
<a name="term_list_item_parameters"></a>
</p>
<p>
Term list <strong>item-specific substitution parameters</strong> for the Markup template are available in the "Item" and "Child Item" sections of the template. They include all of the parameters defined above (for the Style and Markup templates) Additional item-specific parameters are:
</p>
<table>
<tr>
<td class="mla-doc-table-label">key</td>
<td>set to the "tags" array key/index value. Only useful if the <code>mla_get_terms_query_results()</code> filter has altered the array keys.</td>
</tr>
<tr>
<td class="mla-doc-table-label">term_id</td>
<td>the term id</td>
</tr>
<tr>
<td class="mla-doc-table-label">name</td>
<td>the term display name</td>
</tr>
<tr>
<td class="mla-doc-table-label">slug</td>
<td>the term slug</td>
</tr>
<tr>
<td class="mla-doc-table-label">term_group</td>
<td>the term group</td>
</tr>
<tr>
<td class="mla-doc-table-label">term_taxonomy_id</td>
<td>the term-taxonomy id</td>
</tr>
<tr>
<td class="mla-doc-table-label">taxonomy</td>
<td>the primary taxonomy for this term</td>
</tr>
<tr>
<td class="mla-doc-table-label">description</td>
<td>the term description, if any</td>
</tr>
<tr>
<td class="mla-doc-table-label">parent</td>
<td>the direct parent of the term</td>
</tr>
<tr>
<td class="mla-doc-table-label">count</td>
<td>the number of attachments associated with the term. This will include attachments assigned to child terms if the <code>pad_counts=true</code> parameter is present.</td>
</tr>
<tr>
<td class="mla-doc-table-label">term_count</td>
<td>the number of attachments explicitly associated with the term; not its children. This is only defined when the <code>pad_counts=true</code> parameter is present.</td>
</tr>
<tr>
<td class="mla-doc-table-label">link_url</td>
<td>the URL portion of "thelink" (below). Derived from editlink_url, termlink_url or mla_link_href.</td>
</tr>
<tr>
<td class="mla-doc-table-label">currentlink_url</td>
<td>URL of the current post/page plus a "current_item=term_id" query argument</td>
</tr>
<tr>
<td class="mla-doc-table-label">editlink_url</td>
<td>URL of the term's "edit category/tag" page</td></tr>
<tr>
<td class="mla-doc-table-label">termlink_url</td>
<td>URL of the term's archive page</td>
</tr>
<tr>
<td class="mla-doc-table-label">children</td>
<td>HTML markup for the current term's children, if any</td>
</tr>
<tr>
<td class="mla-doc-table-label">caption</td>
<td>if captiontag is not empty, contains term description or the mla_caption value</td>
</tr>
<tr>
<td class="mla-doc-table-label">link_attributes</td>
<td>link attributes, if any, drawn from the mla_target, mla_link_attributes and mla_link_class parameters</td>
</tr>
<tr>
<td class="mla-doc-table-label">active_item_class</td>
<td>set to the value of the <code>active_item_class</code> parameter (default "mla_active_item") for the active item(s) in the list as determined by the "current_item" parameter, and to an empty string for all other items in the list. An item is "active" if it or any of its child items are the current item.</td>
</tr>
<tr>
<td class="mla-doc-table-label">current_item_class</td>
<td>set to the value of the <code>current_item_class</code> parameter (default "mla_current_item") for the current item in the list as determined by the "current_item" parameter, and to an empty string for all other items in the list.</td>
</tr>
<tr>
<td class="mla-doc-table-label">rollover_text</td>
<td>the "title" attribute value, drawn from single_text/multiple_text or the mla_rollover_text parameters</td>
</tr>
<tr>
<td class="mla-doc-table-label">link_style</td>
<td>the CSS "style" attribute, drawn from the font_size and unit parameters</td>
</tr>
<tr>
<td class="mla-doc-table-label">link_text</td>
<td>the text enclosed by the hyperlink, drawn from the term name or mla_link_text parameter</td>
</tr>
<tr>
<td class="mla-doc-table-label">thevalue</td>
<td>term id (default), slug or other value as determined by the "mla_item_value" parameter</td>
</tr>
<tr>
<td class="mla-doc-table-label">thelink</td>
<td>full hyperlink to the chosen destination as determined by the "link" and "mla_link_href" parameters</td>
</tr>
<tr>
<td class="mla-doc-table-label">currentlink</td>
<td>full hyperlink to the current page with a term-specific query argument, including all the Display Content parameters</td>
</tr>
<tr>
<td class="mla-doc-table-label">editlink</td>
<td>full hyperlink to the term's "edit category/tag" page, including all the Display Content parameters</td>
</tr>
<tr>
<td class="mla-doc-table-label">termlink</td>
<td>full hyperlink to the term's archive page, including all the Display Content parameters</td>
</tr>
</table>
<p>
&nbsp;
<a name="mla_term_list_examples"></a>
</p>
<h4>MLA Term List Examples</h4>
<p>
Here is a simple example of a dropdown control for the Att. Categories taxonomy:
</p>
<p>
<code>
&lt;form id="mla-text-form" action="." method="post" class="row"&gt;<br />
&lt;strong&gt;Att. Categories&lt;/strong&gt;<br />
[mla_term_list post_mime_type=image taxonomy=attachment_category mla_output=dropdown mla_option_value="{+slug+}" show_count=true pad_counts=false ]<br />
&nbsp;<br />
&lt;input id="text-form-submit" name="text_form_submit" type="submit" value="Search" /&gt;<br />
&lt;/form&gt;<br />
&nbsp;<br />
&lt;h3&gt;Gallery&lt;/h3&gt;<br />
[mla_gallery]<br />
attachment_category="{+template:({+request:tax_input.attachment_category+}|no-term-selected)+}"<br />
posts_per_page=3 mla_output="paginate_links,prev_next"<br />
mla_link_href='{+new_url+}?mla_paginate_current={+new_page+}&amp;tax_input[attachment_category]={+query:attachment_category,url+}'<br />
[/mla_gallery]<br />
&nbsp;<br />
[mla_gallery attachment_category="{+template:({+request:tax_input.attachment_category+}|no-term-selected)+}" posts_per_page=3 mla_caption="{+title+} : {+description+}" mla_nolink_text="&lt;br&gt;Select a term to display the gallery.&lt;br&gt;"]
</code>
</p>
<p>
As you can see, the key is passing the selected term from the form to the gallery shortcodes. By default, the <code>[mla_term_list]</code> shortcode collects all of its results in the <code>tax_input</code> array, keyed by taxonomy slug. The example combines this with an invalid term slug so the gallery will be empty until a term is selected in the dropdown. Note that the pagination shortcode uses the &ldquo;enclosing shortcode&rdquo; format so HTML characters in the mla_link_href parameter are not corrupted by the WordPress shortcode parsing process.
</p>
<p>
You can experiment with a category checklist format by simply changing <code>mla_output=dropdown</code> to <code>mla_output=checklist</code> in the <code>[mla_term_list]</code> shortcode.
You will also see that the term you select doesn&rsquo;t &ldquo;stick&rdquo; in the dropdown control when the page is refreshed with the gallery display. That is one motivation for the <a title="Find the UI Elements Example" href="[+example_url+]&amp;mla-example-search=Search+Plugins&amp;s=%22MLA+UI+Elements+Example%22" class="mla-doc-bold-link">MLA UI Elements Example</a> plugin. You can use that example plugin to improve the user experience after you have got the basic application going.
</p>
<p>
&nbsp;
<a name="mla_term_list_hooks"></a>
</p>
<h4>MLA Term List Filters (Hooks)</h4>
<p>
The <code>[mla_term_list]</code> shortcode supports a comprehensive set of filters that give you complete control over list composition from PHP code in your theme or in another plugin. An example of using the hooks from a simple, stand-alone plugin can be found in the Documentation/Example Plugins submenu. You can find the example plugin here: <a title="Find the Term List Hooks Example" href="[+example_url+]&amp;mla-example-search=Search+Plugins&amp;s=%22MLA+Term+List+Hooks+Example%22" class="mla-doc-bold-link">MLA Term List Hooks Example</a>. To run the example:
</p>
<ol>
<li>Click on the link above or go to top of the Documentation tab and click on the "Example Plugins" button.</li>
<li>Hover over "MLA Term List Hooks Example" in the Name column, then click the "Install" rollover action.</li>
<li>Go to the Plugins/Installed Plugins screen and activate the "MLA Term List Hooks Example" plugin.</li>
<li>Create a new <code>[mla_term_list]</code> shortcode or modify an existing shortcode, adding the <code>my_filter="color list"</code> parameter to activate the example output.</li>
<li>View the post or page on which the modified shortcode appears to see a term list with a range of colors applied to the terms.</li>
</ol>
<p>
The example code documents each hook with comments in the filter/action function that intercepts the hook. Generally, each part of the list supports three hooks: 1) a "<strong>values</strong>" hook, which lets you record or update the substitution values for that list part, 2) a "<strong>template</strong>" hook, which lets you record/update the template used to generate the HTML markup, and 3) a "<strong>parse</strong>" hook which lets you modify or replace the markup generated for a list part. The current hooks are:
</p>
<table>
<tr>
<td class="mla-doc-hook-label">mla_term_list_raw_attributes</td>
<td class="mla-doc-hook-definition">called at the beginning of the cloud, before the attributes pass through the logic that handles the 'mla_page_parameter' and "request:" prefix processing.</td>
</tr>
<tr>
<td class="mla-doc-table-label">mla_term_list_attributes,<br />mla_term_list_arguments</td>
<td class="mla-doc-hook-definition">called at the beginning of the cloud generation. You can record/modify shortcode parameter values before (attributes) or after (arguments) they are combined with all the defaults.</td>
</tr>
<tr>
<td class="mla-doc-table-label">mla_get_terms_query_attributes,<br />mla_get_terms_query_arguments</td>
<td class="mla-doc-hook-definition">called just before the <code>WP_Query->query()</code> call that selects gallery items, with query parameters before or after they are combined with defaults.</td>
</tr>
<tr>
<td class="mla-doc-table-label">mla_get_terms_clauses</td>
<td class="mla-doc-hook-definition">gives you a final opportunity to inspect or modify the SQL clauses for the data selection process.</td>
</tr>
<tr>
<td class="mla-doc-table-label">mla_get_terms_query_results</td>
<td class="mla-doc-hook-definition">called just after the <code>$wpdb->get_results</code> call, so you can inspect/record or modify the results.</td>
</tr>
<tr>
<td class="mla-doc-table-label">use_mla_term_list_style</td>
<td class="mla-doc-hook-definition">allow or suppress the inclusion of CSS styles in the tag cloud output.</td>
</tr>
<tr>
<td class="mla-doc-table-label">mla_term_list_style_values,<br /> mla_term_list_style_template,<br />mla_term_list_style_parse</td>
<td class="mla-doc-hook-definition">for manipulating the Style template.</td>
</tr>
<tr>
<td class="mla-doc-table-label">mla_term_list_open_values,<br />mla_term_list_open_template,<br />mla_term_list_open_parse</td>
<td class="mla-doc-hook-definition">for manipulating the "Open" part of the Markup template used in a "list", "dropdown" or "checklist" term list.</td>
</tr>
<tr>
<td class="mla-doc-table-label">mla_term_list_item_values,<br />mla_term_list_item_template,<br />mla_term_list_item_parse</td>
<td class="mla-doc-hook-definition">for manipulating the "Item" part of the Markup template used in a "list", "dropdown" or "checklist" term list.</td>
</tr>
<tr>
<td class="mla-doc-table-label">mla_term_list_close_values,<br />mla_term_list_close_template,<br />mla_term_list_close_parse</td>
<td class="mla-doc-hook-definition">for manipulating the "Close" part of the Markup template used in a "list", "dropdown" or "checklist" term list.</td>
</tr>
</table>
<div id="mla-doc-cf-list-div" style="display:inline"><a name="mla_cf_list"></a>
<p>
<a name="mla_cf_list"></a>
</p>
<p>
<a href="#backtotop">Go to Top</a>
</p>
<h3>MLA Custom Field List Shortcode</h3>
<p>
The <code>[mla_custom_list]</code> shortcode function displays a list of WordPress custom field values in a variety of formats, including a "cloud", where the size of each value is determined by how many times that particular value has been added to Media Library items (attachments). MLA Custom Field List provides many enhancements to the basic "cloud" display. These include:
</p>
<ul class="mla_settings">
<li>Several display formats, including "flat" (cloud), list, "grid" (modeled after the <code>[mla_gallery]</code> display), "dropdown" and "checklist". The list formats are "ulist", "olist" and "dlist".</li>
<li>Complete support for paginated lists; display hundreds or thousands of values in manageable groups.</li>
<li>Control over the styles, markup and content of each list using Style and Markup Templates. You can customize the "list", "grid" and "checklist" formats to suit any need.</li>
<li>Access to a wide range of content using the value-specific and Field-level Substitution parameters. A powerful Content Template facility lets you assemble content from multiple sources and vary the results depending on which data elements contain non-empty values for a given term.</li>
<li>Display Style and Display Content parameters for easy customization of the list display and the destination of the links behind each value.</li>
<li>A comprehensive set of filters gives you access to each step of the list generation process from PHP code in your theme or other plugins.</li>
</ul>
<p>
The <code>[mla_custom_list]</code> shortcode has many parameters and some of them have a complex syntax; it can be a challenge to build a correct shortcode. The WordPress Shortcode API has a number of limitations that make techniques such as entering HTML or splitting shortcode parameters across multiple lines difficult. You can use the alternative "enclosing shortcode" syntax to avoid many problems and make your shortcode easier to enter and understand. Read and follow the rules and guidelines in the "<a href="#complex_shortcodes">Entering Long/Complex Shortcodes</a>" Documentation section to get the results you want. 
</p>
<p>
Many of the <code>[mla_custom_list]</code> concepts and shortcode parameters are modeled after the <code>[mla_gallery]</code> shortcode, so the learning curve is short. Differences and parameters unique to the list are given in the sections below.
</p>
<p>
<a name="cf_list_output"></a>
</p>
<h4>Custom Field List Output Formats</h4>
<p>
The values' display format is determined by the <strong>"mla_output"</strong> parameter:
</p>
<table>
<tr>
<td class="mla-doc-table-label">flat</td>
<td>Returns a sequence of hyperlink tags without enclosing HTML markup. The tags are of varying size depending on how many items share the value. The "separator" parameter content (default, one newline character) is inserted between each hyperlink. <strong>"flat" is the default output format value.</strong></td>
</tr>
<tr>
<td class="mla-doc-table-label">flat,div</td>
<td>Adding the ",div" qualifier to the flat output format will wrap the hyperlink tags in an HTML "div" tag so, for example, you can add CSS styles to highlight the current list item. This output adds style and markup template processing to the output. Default templates are provided, and you can specify custom templates of your own. For this format, only the "Description", "Arguments", "Open" and "Close" markup template sections are used.</td>
</tr>
<tr>
<td class="mla-doc-table-label">ulist</td>
<td>Returns hyperlinks enclosed by HTML unordered list tags (&lt;ul&gt;&lt;/ul&gt;). The "itemtag" and "valuetag" parameters customize the list markup.</td>
</tr>
<tr>
<td class="mla-doc-table-label">olist</td>
<td>Returns hyperlinks enclosed by HTML ordered list tags (&lt;ol&gt;&lt;/ol&gt;). The "itemtag" and "valuetag" parameters customize the list markup.</td>
</tr>
<tr>
<td class="mla-doc-table-label">dlist</td>
<td>Returns hyperlinks enclosed by HTML definition list tags (&lt;dl&gt;&lt;/dl&gt;), which allow for each value to have a "caption". The "itemtag", "valuetag" and "captiontag" parameters customize the list markup.</td>
</tr>
<tr>
<td class="mla-doc-table-label">grid</td>
<td>Modeled on the galleries produced by <code>[mla_gallery]</code>; a rectangular display with rows and columns. The tag parameters listed above, the "columns" parameter and the Display Style parameters customize the display.</td>
</tr>
<tr>
<td class="mla-doc-table-label">dropdown</td>
<td>Returns an HTML "select" control with a sequence of HTML "option" tags.</td>
</tr>
<tr>
<td class="mla-doc-table-label">checklist</td>
<td>Returns HTML "input", "type=checkbox" elements enclosed by HTML unordered list tags (&lt;ul&gt;&lt;/ul&gt;). The "itemtag" and "valuetag" parameters customize the list markup.</td>
</tr>
<tr>
<td class="mla-doc-table-label">checklist,div</td>
<td>Adding the ",div" qualifier to the checklist output format will wrap the list in an HTML "div" tag so, for example, you can add CSS styles to highlight the current list item or limit the size of the display area and add scroll bars to a long list. This output adds style and markup template processing to the output. Default templates are provided, and you can specify custom templates of your own. For this format, only the "Description", "Arguments", "Open" and "Close" markup template sections are used.</td>
</tr>
<tr>
<td class="mla-doc-table-label">array</td>
<td>Returns a PHP array of hyperlinks. This output format is not available through the shortcode; it is allowed when the <code>MLAShortcodes::mla_custom_list()</code> function is called directly from your theme or plugin PHP code.</td>
</tr>
</table>
<p>
A separate parameter, <code>echo=true</code>, allows you to echo cloud output directly to the browser instead of returning it to post/page content. This output format is not available through the shortcode; it is allowed when the <code>MLAShortcodes::mla_custom_list()</code> function is called directly from your theme or plugin PHP code.
</p>
<p>
The list, grid, dropdown and checklist formats can be extensively customized by using custom <a href="#mla_gallery_templates"><strong>Style and Markup Templates</strong></a>.
</p>
<p>
The <code>[mla_custom_list]</code> shortcode also supports <a href="#cf_list_pagination_parameters">mla_output pagination formats</a>: "previous_link", "current_link", "next_link", "previous_page", "next_page" and "paginate_links". These are essentially the same as those for the <code>[mla_gallery]</code> shortcode.
</p>
<p>
<a name="cf_list_items"></a>
</p>
<h4>Custom Field List Item Parameters</h4>
<p>
The following parameters customize item content and markup for all of the output fomats:
</p>
<table>
<tr>
<td class="mla-doc-table-label">show_count</td>
<td>Show how many items are assigned to the value. Values "true" or <strong>"false" (default)</strong>.</td>
</tr>
<tr>
<td class="mla-doc-table-label">current_item</td>
<td>Identifies the current/selected item in the list. It contains a text value. It will be ignored if it does not match an item in the list.</td>
</tr>
<tr>
<td class="mla-doc-table-label">mla_item_parameter</td>
<td>The name of the parameter containing the current item value; <strong>default "current_item"</strong>. You can change the name if you need multiple lists on one post/page.</td>
</tr>
</table>
<p>
The <code>current_item</code> parameter is managed for you in most ways. It is automatically added to the links behind each cloud element, and copied back into the shortcode parameters if it is not explicitly coded as a parameter. For the cloud element that matches the current item the <code>current_item_class</code> value is automatically added to the hyperlink class attribute for that item.
</p>
<p>
<a name="cf_list_items_flat"></a>
</p>
<h4>Custom Field List Item Parameters ("cloud" formats: flat, list and grid)</h4>
<p>
Each item in "cloud" formats comprises a field value of varying size, a hyperlink surrounding the value and a "title" attribute (Rollover Text) displayed when the cursor hovers over the value hyperlink. The following parameters customize "cloud" item content and markup:
</p>
<table>
<tr>
<td class="mla-doc-table-label">smallest</td>
<td>The text size <strong>(default 8 for flat format otherwise defaults to default_size)</strong> of the item with the smallest count value (units given by unit parameter).</td>
</tr>
<tr>
<td class="mla-doc-table-label">largest</td>
<td>The text size <strong>(default 22 for flat format otherwise defaults to default_size)</strong> of the item with the highest count value (units given by the unit parameter).</td>
</tr>
<tr>
<td class="mla-doc-table-label">default_size</td>
<td>The text size <strong>(default 12)</strong> of the special links (all items, no items, any items) (units given by the unit parameter).</td>
</tr>
<tr>
<td class="mla-doc-table-label">unit</td>
<td>Unit of measure as pertains to the smallest and largest values. This can be any CSS length value, e.g. <strong>pt (the default)</strong>, px, em, %.</td>
</tr>
<tr>
<td class="mla-doc-table-label">separator</td>
<td>The text/space between items. <strong>Default '\n'</strong> (whitespace). Only used in the flat format</td>
</tr>
</table>
<p>
For the flat format you can set the three size parameters to the same value to display links of uniform size. For the list and grid formats all links are displayed in the "default_size", which you can change by adding it as a shortcode parameter.  You can recreate the "cloud" display for the list and grid formats by adding explicit size parameters to the shortcode, e.g., <code>smallest=8 largest=22</code>.</p>
<p>
<a name="cf_list_items_flga"></a>
</p>
<h4>Custom Field List Item Parameters (except dropdown and checklist formats)</h4>
<p>
The dropdown and checklist formats do not generate hyperlinks, so the parameters here do not apply to them. The following parameters customize item hyperlink content and markup:
</p>
<table>
<tr>
<td class="mla-doc-table-label">single_text</td>
<td>The text for the "title" attribute (Rollover Text) when the count value is one. The default is "%d item". If you change the default, don't forget to include the "%d" placeholder.</td>
</tr>
<tr>
<td class="mla-doc-table-label">multiple_text</td>
<td>The text for the "title" attribute (Rollover Text) when the count value is zero or more than one. The default is "%d items". If you change the default, don't forget to include the "%d" placeholder.</td>
</tr>
<tr>
<td class="mla-doc-table-label">link</td>
<td>Chooses the destination of the item hyperlink; details in the next section below.</td>
</tr>
<tr>
<td class="mla-doc-table-label">current_item_class</td>
<td>The class attribute for the current item in the cloud as determined by the "current_item" parameter (if specified); default "mla_current_item".</td>
</tr>
</table>
<p>
The above parameters are an easy way to customize the content and markup for each list item. For the list and grid formats you can also use the <a href="#cf_list_display_content">Custom Field List Display Content parameters</a> and/or Style and Markup Templates for even greater flexibility.
</p>
<p>
<a name="cf_list_link"></a>
</p>
<h4>Custom Field List Item Link</h4>
<p>
The Link parameter specifies the target and type of link from the cloud value/item to the item's destination. You can also specify a non-hyperlink treatment for each item.
</p>
<table>
<tr>
<td class="mla-doc-table-label">current</td>
<td>Link back to the current post/page with a query argument, <code>current_item</code>, set to the value of the selected item. <strong>"current" is the default link value</strong>.</td>
</tr>
<tr>
<td class="mla-doc-table-label" style="font-style:italic">(mla_link_href)</td>
<td>Link to a custom destination, typically another post/page. If the "mla_link_href" parameter is present the value of the "link" parameter is ignored. See the pagination example later in this section for more details.</td>
</tr>
<tr>
<td class="mla-doc-table-label">span</td>
<td>Substitutes a <code>&lt;span&gt;&lt;/span&gt;</code> tag for the hyperlink tag. You can use the "mla_link_attributes" and "mla_link_class" parameters to add attributes to the <code>&lt;span&gt;</code> tag. You can use the "mla_link_text" parameter to customize the text within the span.</td>
</tr>
<tr>
<td class="mla-doc-table-label">none</td>
<td>Eliminates the hyperlink tag surrounding the item text. You can use the "mla_link_text" parameter to customize the contents.</td>
</tr>
</table>
<p>
Using the "mla_link_href" parameter to completely replace the link destination URL is a common and useful choice. With this parameter you can use the list to select a value and then go to another post/page that uses that selection as part of an <code>[mla_gallery]</code> shortcode. The pagination example later in this section uses this technique. 
</p>
<p><a name="cf_list_display_templates"></a>
</p>
<h4>Custom Field List Display Style and Markup (all output formats except "flat")</h4>
<p>
Two parameters provide a way to apply custom style and markup templates to your <code>[mla_custom_list]</code> display. These parameters replace the default style and/or markup templates with templates you define on the "Shortcodes" tab of the Settings page. Templates are supported for the "flat,div", list, "grid", "dropdown", "checklist" and "checklist,div" formats.
</p>
<table>
<tr>
<td class="mla-doc-table-label">mla_style</td>
<td>replaces the default style template for an <code>[mla_custom_list]</code> shortcode. You can code "none" to suppress the addition of CSS inline styles entirely.</td>
</tr>
<tr>
<td class="mla-doc-table-label">mla_markup</td>
<td>replaces the default markup template for an <code>[mla_custom_list]</code> shortcode</td>
</tr>
</table>
<p><a name="cf_list_display_grid"></a></p>
<h4>Custom Field List Display Style (grid)</h4>
<p>
Four parameters provide control over the placement, size and spacing of values in the "grid" format without requiring the use of custom Style templates.
</p>
<table>
<tr>
<td class="mla-doc-table-label">columns</td>
<td>specifies the number of columns. The grid will include a break tag at the end of each row and calculate the column width as appropriate. The default value is 3. If columns is set to 0, no row breaks will be included.</td>
</tr>
<tr>
<td class="mla-doc-table-label">mla_float</td>
<td>specifies the CSS float attribute of the ".cf-cloud-item" style. Acceptable values are "left", "none", "right"; the default value is "right" if current locale is RTL, "left" on LTR (left-to-right inline flow, e.g., English).</td>
</tr>
<tr>
<td class="mla-doc-table-label">mla_margin</td>
<td>specifies the CSS margin property of the ".cf-cloud-item" style. The default value is "1.5%", a percent of the total grid width. You can also specify any dimension value, e.g., "10px" or "2em", as well as the "auto" or "inherit" values. Finally, you can specify "none", which will remove the margin property from the styles template altogether.</td>
</tr>
<tr>
<td class="mla-doc-table-label">mla_itemwidth</td>
<td>specifies the CSS width attribute of the ".cf-cloud-item" style. You can specify a percent of the total grid width, e.g., "33.3%". You can also specify any dimension value, e.g., "10px" or "2em", as well as the "auto" or "inherit" values. You can specify "none", which will remove the margin property from the styles template altogether.
<br />&nbsp;<br />
Two additional values, "calculate" (the default) and "exact",  calculate the width automatically, based on the "columns" and "mla_margin" values. For "calculate", the width is calculated by dividing 100% by the number of columns, then subtracting twice the margin. For example, the default value is (floor(1000/3)/10) - ( 2.0 * 1.5 ) = 30.3%. Adding in the left and right margins makes each column 33.3% and the total width will be 99.9%
<br />&nbsp;<br />
For the "exact" value, the calculation is the same but the margin is ignored, so the width value would be 33.3%.</td>
</tr>
</table>
<p>
The default margin and width calculations try to make the total width of each row as close to 100% as possible, but never exceed 100% due to rounding errors. If you have more advanced style and format needs, you can define custom style and/or markup templates. You can also code <code>mla_style=none</code> to suppress inline styles entirely and use a separate stylesheet to control the format of the grid.
</p>
<p><a name="cf_list_display_style"></a></p>
<h4>Custom Field List Display Style (list, grid and checklist)</h4>
<p>
Three parameters provide control over the XHTML tags used to enclose each part of the list items.
</p>
<table>
<tr>
<td class="mla-doc-table-label">itemtag</td>
<td>for list formats, the name of the XHTML tag used to begin the list; the <strong>defaults are "ul" for "ulist", "ol" for "olist" and "dl" fot "dlist"</strong>. For "grid" format, the name of the XHTML tag used to enclose each item in the cloud; the <strong>default is "dl"</strong>.</td>
</tr>
<tr>
<td class="mla-doc-table-label">valuetag</td>
<td>the name of the XHTML tag used to enclose each value in the cloud. For list formats, the <strong>default is "li"</strong>; for "grid" format  the <strong>default is "dt"</strong>.</td>
</tr>
<tr>
<td class="mla-doc-table-label">captiontag</td>
<td>the name of the XHTML tag used to enclose each caption. For "grid" and "dlist" formats, the <strong>default is "dd"</strong>.</td>
</tr>
</table>
<p>
These parameters give you some control over the markup used for the list and its elements. For more complex applications you can use style and markup templates to gain complete control over the cloud display.
</p>
<p><a name="cf_list_display_content"></a></p>
<h4>Custom Field List Display Content</h4>
<p>
Ten parameters provide an easy way to control the contents of tag cloud items without requiring the use of custom Markup templates.  
</p>
<table>
<tr>
<td class="mla-doc-table-label">mla_link_attributes</td>
<td>adds one or more HTML attributes to the hyperlink for each item; see below. For security reasons, HTML event Attributes are not allowed; any attribute name that begins with "on" will invalidate the parameter.</td>
</tr>
<tr>
<td class="mla-doc-table-label">mla_link_class</td>
<td><strong>adds</strong> one or more classes to any already defined for the hyperlink</td>
</tr>
<tr>
<td class="mla-doc-table-label">mla_link_style</td>
<td>replaces the CSS styles for the hyperlink. The default style is <code>font-size: [+font_size+][+unit+]</code>.</td>
</tr>
<tr>
<td class="mla-doc-table-label">mla_link_href</td>
<td>replaces the HTML "href" attribute in the hyperlink for each item; see below</td>
</tr>
<tr>
<td class="mla-doc-table-label">mla_link_text</td>
<td>replaces the value text displayed for each item</td>
</tr>
<tr>
<td class="mla-doc-table-label">mla_nolink_text</td>
<td>replaces the empty string displayed when there are no cloud items or no pagination link</td>
</tr>
<tr>
<td class="mla-doc-table-label">mla_rollover_text</td>
<td>replaces the HTML "title" attribute in the hyperlink for each item. This is the attachment title text displayed when the mouse rolls or hovers over the value</td>
</tr>
<tr>
<td class="mla-doc-table-label">mla_caption</td>
<td>replaces the caption text displayed beneath each item. The caption appears for "grid" items and for "list" items when the "captiontag" parameter is present.</td>
</tr>
<tr>
<td class="mla-doc-table-label">mla_item_value</td>
<td>replaces the custom field value of the <code>current_item</code> hyperlink query argument.</td>
</tr>
<tr>
<td class="mla-doc-table-label">mla_target</td>
<td>adds an HTML "target" attribute to the hyperlink for each gallery item; see below</td>
</tr>
</table>
<p>
Six parameters provide an easy way to add and control the contents of special list items for selecting special groups of values. You can add links for selecting all items, items that have no values for the custom field and/or items that have one or more values for the custom field. The default values for these links are compatible with the simple custom field parameters and meta_query parameters of the <code>[mla_gallery]</code> shortcode.
</p>
<table>
<tr>
<td class="mla-doc-table-label">option_all_text</td>
<td>Text to display for showing an 'all values' link. <strong>Default will not show a link to select 'all values'</strong>. When this option is selected all items, including items with no values at all, are included in the results.</td>
</tr>
<tr>
<td class="mla-doc-table-label">option_all_value</td>
<td>Control value for 'all values' option. <strong>Default 'ignore.values.assigned'</strong>. When this option is selected all items, including items with no values at all, are included in the results.</td>
</tr>
<tr>
<td class="mla-doc-table-label">option_no_values_text</td>
<td>Text to display for showing an 'no values' link. <strong>Default will not show a link to select 'no values'</strong>. When this option is selected only those items with no values at all are included in the results.</td>
</tr>
<tr>
<td class="mla-doc-table-label">option_no_values_value</td>
<td>Control value for 'no values' option. <strong>Default 'no.values.assigned'</strong>. When this option is selected only those items with no values at all are included in the results.</td>
</tr>
<tr>
<td class="mla-doc-table-label">option_any_values_text</td>
<td>Text to display for showing an 'any values' link. <strong>Default will not show a link to select 'any values'</strong>. When this option is selected only those items with one or more values are included in the results.</td>
</tr>
<tr>
<td class="mla-doc-table-label">option_any_values_value</td>
<td>Control value for 'any values' option. <strong>Default 'any.values.assigned'</strong>. When this option is selected only those items with one or more values are included in the results.</td>
</tr>
</table>
<p>
All but the "mla_target" parameter support the <a href="#cf_list_markup_parameters">Markup</a>, <a href="#cf_list_item_parameters">Item-specific</a>, <a href="#cf_list_variable_parameters">Field-level</a> and <a href="#mla_template_parameters">Content Template</a> substitution parameters defined for Markup Templates. For example, if you code "<code>mla_rollover_text='{+meta_key+} : {+rollover_text+}'</code>, the rollover text will contain the custom field name, a colon, and the appropriate "single text" or "multiple text". Simply add "{+" before the substitution parameter name and add "+}" after the name. Note that the enclosing delimiters are different than those used in the templates, since the WordPress shortcode parser reserves square brackets ("[" and "]") for its own use.
</p>
<p>
The "mla_link_href" parameter is a great way to change the destination your cloud item links to and/or add arguments to the link for later processing. For example, to make a gallery item link back to the current page/post you can code: <code>mla_link_href='{+page_url+}'</code>. You can also add arguments to the link, e.g., <code>mla_link_href='{+page_url+}?firstarg=value1&amp;amp;myarg=myvalue'</code>. Note the use of the HTML entity name "&amp;amp;" to put an ampersand in the value; the WordPress "visual" post editor will replace "&amp;", "&lt;" and ">" with "&amp;amp;", "&amp;lt;" and "&amp;gt;" whether you like it not. The <strong>only</strong> markup parameters modified by this parameter are "link_url" and "thelink". The markup parameters "viewlink" and "editlink" are not modified.
</p>
<p>
The "mla_link_attributes" parameter accepts any value and adds it to the "&lt;a&gt;" or "&lt;span&gt;" tags for the item. For example, you can add a unique identifier to each item by adding <code>mla_link_attributes='id="{+selector}-{+index+}"'</code> to your shortcode (note the use of single quotes around the parameter value and the double quotes within the parameter). <strong>IMPORTANT:</strong> since the shortcode parser reserves square brackets ("[" and "]") for its own use, <strong>you must substitute curly braces for square brackets</strong> if your attributes require brackets. If you must code a curly brace in your attribute value, preface it with <strong>two backslash characters</strong>, e.g., "\\{" or "\\}". If you code an attribute already present in the tag, your value will override the existing value.
</p>
<p>
The "mla_target" parameter accepts any value and adds an HTML "target" attribute to the hyperlink with that value. For example, if you code <code>mla_target="_blank"</code> the item will open in a new window or tab. You can also use "_self", "_parent", "_top" or the "<em>framename</em>" of a named frame.
</p>
<p><a name="cf_list_display_content_html"></a></p>
<h4>Custom Field List Display Content (dropdown and checklist)</h4>
<p>
Dropdown and Checklist formats do not generate hyperlinks; they generate HTML input controls that return the content of <code>value</code> attributes. Eight parameters provide an easy way to control the contents of items without requiring the use of custom Markup templates. 
</p>
<table>
<tr>
<td class="mla-doc-table-label">mla_control_name</td>
<td>replaces the <strong><code>current_item</code> or <code>current_items[]</code> (default)</strong> name attribute in the input tag for the control(s). The <code>current_items[]</code> default is used for checklists and for dropdowns when <code>mla_multi_select=true</code>. Useful for adding multiple controls to a post/page.</td>
</tr>
<tr>
<td class="mla-doc-table-label">mla_multi_select</td>
<td>The <strong>default, "false"</strong>, specifies that only one dropdown control option can be selected. If set to "true", it specifies that multiple dropdown control options can be selected at once. Not used for checklist controls.</td>
</tr>
<tr>
<td class="mla-doc-table-label">mla_option_text</td>
<td>replaces the <strong>custom field value (default)</strong> <strong>displayed</strong> for each option, i.e., the text enclosed by the option/input tag.</td>
</tr>
<tr>
<td class="mla-doc-table-label">mla_option_value</td>
<td>replaces the <strong>custom field value (default)</strong> <strong>returned</strong> for each option, i.e., the <code>value</code> attribute of the option/input tag.</td>
</tr>
<tr>
<td class="mla-doc-table-label">hide_if_empty</td>
<td>If <strong>false (default)</strong>, display a control with "option_none_" text &amp; value. If true, display mla_nolink_text or nothing.</td>
</tr>
<tr>
<td class="mla-doc-table-label">mla_nolink_text</td>
<td>replaces the entire control with text/markup; <strong>default empty</strong></td>
</tr>
<tr>
<td class="mla-doc-table-label">option_none_text</td>
<td>Text to display for showing a 'no values' option, displayed when there are no values defined for the custom field. Default will not show an option to select 'no values'.</td>
</tr>
<tr>
<td class="mla-doc-table-label">option_none_value</td>
<td>Control value for a 'no values' option, returned when there are no values defined for the custom field. <strong>Defaults to the option_none_text</strong>.</td>
</tr>
</table>
<p><a name="cf_list_data_selection"></a></p>
<h4>Custom Field List Data Selection Parameters</h4>
<p>
The data selection parameters specify which custom field(s) the values are taken from, which values are returned for the cloud and the order in which the values are returned:
</p>
<table>
<tr>
<td class="mla-doc-table-label">meta_key</td>
<td>The custom field to retrieve values from. The field name is required.</td>
</tr>
<tr>
<td class="mla-doc-table-label">post_mime_type</td>
<td>The MIME type(s) of the items to include in value selection and value-specific counts. <strong>The default is "all"</strong>, which avoids the additional database effort required to filter by MIME type. You can override the default to, for example, include only PDF documents (<code>post_mime_type=application/pdf</code>) or all image MIME types (<code>post_mime_type=image</code>). You can select several MIME types with a comma-separated list, e.g., <code>post_mime_type='audio,video'</code>. Wildcard specifications are also supported. For example, <code>post_mime_type='*/mpeg'</code> to select audio and video mpeg formats or <code>post_mime_type='application/*ms*'</code> to select all Microsoft application formats (Word, Excel, etc.).</td>
</tr>
<tr>
<td class="mla-doc-table-label">post_type</td>
<td>The <a href="http://codex.wordpress.org/Post_Types" title="WordPress Codex &quot;Post Types&quot; page" target="_blank">post type(s)</a> of the items to include in value selection and value-specific counts. <strong>The default is "attachment"</strong>. You can override the default if you want to select other types for which the custom field is used, e.g., "post" to select Posts. The <a href="http://codex.wordpress.org/Post_Types" title="WordPress Codex &quot;Post Types&quot; page" target="_blank">Codex Page</a> documents other post type values. Make sure your "post_status" and "post_type" values are consistent, e.g., use <code>post_type="attachment,post" post_status="inherit,publish"</code> together.</td>
</tr>
<tr>
<td class="mla-doc-table-label">post_status</td>
<td>The <a href="http://codex.wordpress.org/Post_Status" title="WordPress Codex &quot;Post Status&quot; page" target="_blank">post status value(s)</a> of the items to include in value selection and value-specific counts. <strong>The default is "inherit"</strong>, which counts attachments (Media Library Items). You can override the default if you want to count other values, e.g., "publish" to count published Posts. If you code "private" and the user is not logged in, "private" will be removed. The <a href="http://codex.wordpress.org/Post_Status" title="WordPress Codex &quot;Post Status&quot; page" target="_blank">Codex page</a> documents other post status values.</td>
</tr>
<tr>
<td class="mla-doc-table-label">ids</td>
<td>A comma-separated list of <strong>attachment ID</strong> values for an item-specific cloud. Only those custom field values used in the attachment(s) in the list will be included. You can have one or more IDs and you can include values from one or more custom fields. Do not use the "include" parameter if you use the "ids" parameter.</td>
</tr>
<tr>
<td class="mla-doc-table-label">no_count</td>
<td><strong>The default, "false"</strong>, computes a value-specific count of the number of attachments using that value. If you have a large number of values and/or attachments, this can take a long time.<br />
&nbsp;<br />
You can code "true" to omit the attachment-counting process. If you do that, the "post_mime_type", "post_type", "post_status", "minimum", "number" and "orderby=count" parameters are also ignored, since they require counting the attachments.<br />
&nbsp;</td>
</tr>
<tr>
<td class="mla-doc-table-label">include</td>
<td>A comma-separated list of field values to include. Only the values in this list that are used in the field(s) you specified will be retrieved.</td>
</tr>
<tr>
<td class="mla-doc-table-label">exclude</td>
<td>A comma-separated list of field values to exclude from the returned values.</td>
</tr>
<tr>
<td class="mla-doc-table-label">minimum</td>
<td>The minimum number of attachments that must be associated with a value for that value to be included. <strong>The "default" is one (1)</strong>, because a custom field value must occur in at least one item to exist at all.</td>
</tr>
<tr>
<td class="mla-doc-table-label">number</td>
<td>The maximum number of "most popular" values to return. <strong>The default, zero (0)</strong>, returns them all. values are sorted by "count DESC, meta_value ASC" to apply this constraint.</td>
</tr>
<tr>
<td class="mla-doc-table-label">orderby</td>
<td>The final sort order of the retrieved values. Can be one or more of "count", "meta_value" (the default), "none", or "random". Coding "none" is equivalent to "orderby=count order=DESC" (the initial sort to qualify the most popular values for the list).
</tr>
<tr>
<td class="mla-doc-table-label">order</td>
<td>Can be <strong>"ASC" (ascending, the default)</strong> or "DESC" (descending).</td>
</tr>
<tr>
<td class="mla-doc-table-label">no_orderby</td>
<td><strong>The default, "false"</strong>, applies the orderby and order parameters to the final value list. If you have a large number of valuess and/or attachments, this can take a long time. You can code "true" to omit both the initial sort (most popular values) and the final sorting process. If you do that, the sort order of the list will be indeterminite.</td>
</tr>
<tr>
<td class="mla-doc-table-label">preserve_case</td>
<td>Preserve upper- and lower-case distinctions when sorting by name. The default, "false", specifies a case-insensitive sort order.</td>
</tr>
<tr>
<td class="mla-doc-table-label">limit</td>
<td>The number of values to return. This parameter is used for <a href="#cf_list_pagination_parameters">pagination</a>; it is applied <strong>after</strong> and separate from the "number" parameter above.</td>
</tr>
<tr>
<td class="mla-doc-table-label">offset</td>
<td>The number of values to skip before returning the results. This parameter is used for <a href="#cf_list_pagination_parameters">pagination</a>.</td>
</tr>
</table>
<p>
You can sort on more than one value, e.g., <code>orderby="count DESC, name"</code> and you can specify ASC/DESC on a value by value basis. <strong>NOTE: multiple orderby values are separated by commas, not spaces.</strong> This is a change from WP_Query.
</p>
<p>
The order parameter (default ASC) can give an ASC/DESC default for any value that doesn't have a specific choice. For example, <code>orderby="count DESC, name" order=ASC</code> is the same as <code>orderby="count DESC, name ASC"</code>.
<a name="cf_list_debugging_output"></a>
</p>
<h4>Debugging Output</h4>
<p>
The "mla_debug" parameter controls the display of information about the query parameters and SQL statements used to retrieve list items. If you code <code>mla_debug=true</code> you will see a lot of information added to the post or page containing the list. Of course, this parameter should <strong><em>ONLY</em></strong> be used in a development/debugging environment; it's quite ugly.
</p>
<p>
If you code <code>mla_debug=log</code> all of the information will be written to the error log. You can use the <a href="#mla_debug_tab">MLA Debug Tab</a> to view and download the information in the error log. Use this only for development/debugging to avoid filling the log file with unneeded data.
</p>
 <p>
Look for the "mla_debug attribute_errors" entry in the debug output; it will often list the parts of the shortcode parameters that couldn&rsquo;t be parsed. If you see "[mla_custom_list]" in this entry you probably used the enclosing shortcode format in that shortcode but did not add the "[/mla_custom_list]" delimiter to an earlier shortcode.
<a name="cf_list_substitution"></a>
</p>
<h4>Custom Field List Substitution Parameters</h4>
<p>
Substitution parameters are a powerful way to add general and attachment-specific values to the list or pass them on to an <code>[mla_gallery]</code> display. For example, if you code "<code>mla_link_href="{+page_url+}?field_name={+meta_key+}&amp;current_item={+request:current_item+}"</code>, the hyperlinks behind each cloud term will contain the page URL, the custom field name and the custom field value in <code>current_item</code>. There are many substitution parameter names like <code>page_url</code> and <code>meta_key</code> divided in several categories:
</p>
<table>
<tr>
<td class="mla-doc-table-label">List-specific</td>
<td>values that are known at the beginning of shortcode processing and remain the same for the entire shortcode, such as the ID and URL of the post/page in which the shortcode appears</td>
</tr>
<tr>
<td class="mla-doc-table-label">Style</td>
<td>values that are known when the list-specific CSS inline styles are composed just before list output begins</td>
</tr>
<tr>
<td class="mla-doc-table-label">Markup</td>
<td>values that are known at the beginning of list output processing and remain the same for the entire list</td>
</tr>
<tr>
<td class="mla-doc-table-label"><a href="#cf_list_item_parameters">Item-specific</a></td>
<td  style="vertical-align: top">values that change for each value/item in the list, such as Name and Count</td>
</tr>
<tr>
<td class="mla-doc-table-label"><a href="#mla_variable_parameters">Field-level</a></td>
<td>additional values from sources like query arguments and shortcode parameters. The "request:" and "query:" field-level prefixes can be used in the list. The other prefixes are attachment-specific and have no meaning in a custom field list</td>
</tr>
<tr>
<td class="mla-doc-table-label"><a href="#mla_template_parameters">Content&nbsp;Template</a></td>
<td>lets you compose a value from multiple substitution parameters and test for empty values, choose among two or more alternatives or suppress output entirely</td>
</tr>
</table>
<p>
To use a substitution parameter in your shortcode, simply add "{+" before the substitution parameter name and add "+}" after the name. Note that the enclosing delimiters are different than those used in Style and Markup templates, since the WordPress shortcode parser reserves square brackets ("[" and "]") for its own use. Also, because square brackets are reserved, <strong>you must substitute curly braces for square brackets</strong> if your parameter values require them. For example, if your shortcode parameter is <code>mla_link_attributes='rel="shadowbox{sbalbum-{+instance+}};player=img"'</code>, the actual attribute added to the link will be <code>rel="shadowbox[sbalbum-1];player=img"</code>. If you must code a curly brace in a parameter value, preface it with <strong>two backslash characters</strong>, e.g., "\\{" or "\\}".
</p>
<p>
<strong>List-specific substitution parameters</strong> are known at the beginning of shortcode processing and they do not change during processing. They can be used, for example, in any of the data selection parameters to change the items selected for the cloud based on information about the post/page on which the cloud appears. The cloud-specific substitution parameters are:
</p>
<table>
<tr>
<td class="mla-doc-table-label">site_url</td>
<td>absolute URL to the site directory, without trailing slash</td>
</tr>
<tr>
<td class="mla-doc-table-label">base_url</td>
<td>absolute URL to the upload directory, without trailing slash</td>
</tr>
<tr>
<td class="mla-doc-table-label">base_dir</td>
<td>absolute (full) path to the upload directory, without trailing slash</td>
</tr>
<tr>
<td class="mla-doc-table-label">instance</td>
<td>starts at '1', incremented for each additional shortcode in the post/page</td>
</tr>
<tr>
<td class="mla-doc-table-label">selector</td>
<td>"mla_custom_list-{$instance}", e.g., mla_custom_list-1</td>
</tr>
<tr>
<td class="mla-doc-table-label">page_ID,<br />id</td>
<td style="vertical-align: top">the <code>ID</code> value of the post/page in which the list appears</td>
</tr>
<tr>
<td class="mla-doc-table-label">page_author</td>
<td>the <code>post_author</code> value of the post/page in which the list appears</td>
</tr>
<tr>
<td class="mla-doc-table-label">page_date</td>
<td>the <code>post_date</code> value of the post/page in which the list appears</td>
</tr>
<tr>
<td class="mla-doc-table-label">page_content</td>
<td>the <code>post_content</code> value of the post/page in which the list appears</td>
</tr>
<tr>
<td class="mla-doc-table-label">page_title</td>
<td>the <code>post_title</code> value of the post/page in which the list appears</td>
</tr>
<tr>
<td class="mla-doc-table-label">page_excerpt</td>
<td>the <code>post_excerpt</code> value of the post/page in which the list appears</td>
</tr>
<tr>
<td class="mla-doc-table-label">page_status</td>
<td>the <code>post_status</code> value of the post/page in which the list appears</td>
</tr>
<tr>
<td class="mla-doc-table-label">page_name</td>
<td>the <code>post_name</code> value of the post/page in which the list appears</td>
</tr>
<tr>
<td class="mla-doc-table-label">page_modified</td>
<td>the <code>post_modified</code> value of the post/page in which the list appears</td>
</tr>
<tr>
<td class="mla-doc-table-label">page_guid</td>
<td>the <code>post_guid</code> value of the post/page in which the list appears</td>
</tr>
<tr>
<td class="mla-doc-table-label">page_type</td>
<td>the <code>post_type</code> value of the post/page in which the list appears</td>
</tr>
<tr>
<td class="mla-doc-table-label">page_url</td>
<td>absolute URL to the page or post on which the list appears, if any, with trailing slash</td>
</tr>
</table>
<p>
If the shortcode is executed when there is no current post, an artificial "empty post" is used to supply reasonable default values. One special case is the "Author Archive" page when the author has no posts. In this case, an atrificial "author post" supplies a few values based on the author's user information. The available values are documented in the <a href="#gallery_specific">Gallery-specific substitution parameters</a> subsection.</p>
</p>
<p>
Style and Markup templates give you great flexibility for the content and format of each [mla_custom_list] when you use the "list" and "grid" output formats. You can define as many templates as you need. 
</p>
<p>
Style templates provide list-specific CSS inline styles (you can code mla_style=none to suppress the addition of CSS inline styles entirely). Markup templates provide the HTML markup for 1) the beginning of the list, 2) the beginning of each row ("grid" format), 3) each list item, 4) the end of each row ("grid" format) and 5) the end of the list. The MLA Gallery tab on the Settings page lets you add, change and delete custom templates. The default templates are also displayed on this tab for easy reference. 
</p>
<p>
For the "grid" output format, all of the Markup template sections are used. For the list output formats, only the "Open", "Item" and "Close" sections are used. There are two default templates for the list formats; "custom-list-ul" (for "ulist", "olist" and "checklist") and "custom-list-dl" (for "dlist").
<a name="cf_list_variable_parameters"></a>
</p>
<p>
The following <strong>field-level substitution parameters</strong> are available in the Style template and any of the Markup template sections:</p>
<table>
<tr>
<td class="mla-doc-table-label">request</td>
<td>The parameters defined in the <code>$_REQUEST</code> array; the "query strings" sent from the browser. The PHP $_REQUEST variable is a superglobal Array that contains the contents of both $_GET, $_POST and $_COOKIE arrays.</td>
</tr>
<tr>
<td class="mla-doc-table-label">query</td>
<td>The parameters defined in the <code>[mla_custom_list]</code> shortcode. For example, if your shortcode is <code>[mla_tag_cloud meta_key="My Custom Field" div-class=some_class]</code> you can access the parameters as <code>[+query:meta_key+]</code> and <code>[+query:div-class+]</code> respectively. You can define your own parameters, e.g., "div-class"; they will be accessible as field-level data but will otherwise be ignored.</td>
</tr>
<tr>
<td class="mla-doc-table-label">template</td>
<td>A Content Template, which lets you compose a value from multiple substitution parameters and test for empty values, choosing among two or more alternatives or suppressing output entirely. See the <a href="#mla_template_parameters">Content Templates</a> section for details. Note that the formatting option is not supported for content templates.</td>
</tr>
</table>
<p>
Custom List substitution parameters for the <strong>Style template</strong> are:
</p>
<table>
<tr>
<td class="mla-doc-table-label">mla_output</td>
<td>the primary value of the shortcode parameter; default = 'flat'.</td>
</tr>
<tr>
<td class="mla-doc-table-label">mla_output_qualifier</td>
<td>the qualifier value, if any, of the shortcode parameter; default empty. Qualifiers include 'wrap', 'last', 'first', 'show_all' and 'prev_next'.</td>
</tr>
<tr>
<td class="mla-doc-table-label">mla_style</td>
<td>shortcode parameter. For flat and pagination formats, default = 'none'. For other formats, default = 'custom-list'.</td>
</tr>
<tr>
<td class="mla-doc-table-label">mla_markup</td>
<td>shortcode parameter. Defaults depend on the output format: 'custom-list-ul', 'custom-list-dl', 'custom-list-grid''custom-list-dropdown' or 'custom-list-checklist'.</td>
</tr>
<tr>
<td class="mla-doc-table-label">meta_key</td>
<td>the name of the custom field on which the list is based.</td>
</tr>
<tr>
<td class="mla-doc-table-label">current_item</td>
<td>the value of current/selected item in the list, as entered in the shortcode parameters.</td>
</tr>
<tr>
<td class="mla-doc-table-label">itemtag</td>
<td>shortcode parameter, default = 'ul', or 'dl' if the "captiontag" parameter is present.</td>
</tr>
<tr>
<td class="mla-doc-table-label">itemtag_attributes</td>
<td>HTML attribute value(s) added to the item tag</td>
</tr>
<tr>
<td class="mla-doc-table-label">itemtag_class</td>
<td>HTML class names(s) added to the item tag</td>
</tr>
<tr>
<td class="mla-doc-table-label">itemtag_id</td>
<td>HTML "id" attribute value for the item tag</td>
</tr>
<tr>
<td class="mla-doc-table-label">valuetag</td>
<td>shortcode parameter, default = 'li', or 'dd' if the "captiontag" parameter is present.</td>
</tr>
<tr>
<td class="mla-doc-table-label">captiontag</td>
<td>shortcode parameter, default = '', i.e., no caption tag value.</td>
</tr>
<tr>
<td class="mla-doc-table-label">multiple</td>
<td>'multiple' if the <code>mla_multi_select</code> parameter is true, empty if not.</td>
</tr>
<tr>
<td class="mla-doc-table-label">columns</td>
<td>shortcode parameter, default = '3'; only meaningful for the "grid" output format.</td>
</tr>
<tr>
<td class="mla-doc-table-label">itemwidth</td>
<td>shortcode parameter, default is calculated by dividing 100% by the number of columns and subtracting twice the margin value, e.g., 30.3% for three columns and a margin value of 1.5%. Can also contain other dimensional values such as '10px' or CSS-specific values like 'auto' or 'inherit'.</td>
</tr>
<tr>
<td class="mla-doc-table-label">margin</td>
<td>shortcode parameter, default = '1.5%'. Can also contain other dimensional values such as '10px' or CSS-specific values like 'auto' or 'inherit'.</td>
</tr>
<tr>
<td class="mla-doc-table-label">float</td>
<td>'right' if current locale is RTL, 'left' if not</td>
</tr>
<tr>
<td class="mla-doc-table-label">database_rows</td>
<td>the number of actual values retrieved for the list, not including the "all", "no values" and/or "any values" elements</td>
</tr>
<tr>
<td class="mla-doc-table-label">found_rows</td>
<td>the number of values prepared for the list, including the "all", "no values" and/or "any values" elements</td>
</tr>
<tr>
<td class="mla-doc-table-label">min_count</td>
<td>the smallest number of attachments associated with any value</td>
</tr>
<tr>
<td class="mla-doc-table-label">max_count</td>
<td>the largest number of attachments associated with any value</td>
</tr>
<tr>
<td class="mla-doc-table-label">min_scaled_count</td>
<td>the smallest scaled count associated with any value</td>
</tr>
<tr>
<td class="mla-doc-table-label">max_scaled_count</td>
<td>the largest scaled count associated with any value</td>
</tr>
<tr>
<td class="mla-doc-table-label">spread</td>
<td>max_scaled_count - min_scaled_count</td>
</tr>
<tr>
<td class="mla-doc-table-label">smallest</td>
<td>the text size of the tag with the smallest count value</td>
</tr>
<tr>
<td class="mla-doc-table-label">largest</td>
<td>the text size of the tag with the largest count value</td>
</tr>
<tr>
<td class="mla-doc-table-label">unit</td>
<td>Unit of measure as pertains to the smallest and largest values</td>
</tr>
<tr>
<td class="mla-doc-table-label">font_spread</td>
<td>largest - smallest</td>
</tr>
<tr>
<td class="mla-doc-table-label">font_step</td>
<td>font_spread / spread</td>
</tr>
<tr>
<td class="mla-doc-table-label">separator</td>
<td>The text/space between values</td>
</tr>
<tr>
<td class="mla-doc-table-label">single_text</td>
<td>Rollover Text when the count value is one</td>
</tr>
<tr>
<td class="mla-doc-table-label">multiple_text</td>
<td> Rollover Text when the count value is zero or more than one</td>
</tr>
<tr>
<td class="mla-doc-table-label">echo</td>
<td>whether the output is echoed directly to the browser (true) or returned to the caller (false). For a shortcode, always false.</td>
</tr>
<tr>
<td class="mla-doc-table-label">link</td>
<td>the destination name of the item hyperlink, default 'current'</td>
</tr>
</table>
<p>
&nbsp;
<a name="cf_list_markup_parameters"></a>
</p>
<p>
Custom list substitution parameters for the <strong>Markup template</strong> are available in all of the template sections. All of the <strong>list-specific substitution parameters</strong> and the <strong>substitution parameters for Style templates</strong> are available for use in markup templates.
</p>
<p>
There is just one additional substitution parameter defined at the start of markup processing:
</p>
<table>
<tr>
<td class="mla-doc-table-label">thename</td>
<td>the name of the substitution parameter that contains the current item in the list; default 'current_item'.</td>
</tr>
</table>
<p>
There are <a href="#mla_cf_list_hooks">MLA Custom Field List Filters (Hooks)</a> that could add, modify or delete parameters available for markup processing, if your application uses them.
<a name="cf_list_item_parameters"></a>
</p>
<p>
Custom list <strong>item-specific substitution parameters</strong> for the Markup template are available in the "Item" section of the template. They include all of the parameters defined above (for the Style and Markup templates) Additional item-specific parameters are:
</p>
<table>
<tr>
<td class="mla-doc-table-label">index</td>
<td>starts at '1', incremented for each item in the list</td>
</tr>
<tr>
<td class="mla-doc-table-label">key</td>
<td>set to the "tags" array key/index value. Only useful if the <code>mla_get_custom_values_query_results()</code> filter has altered the array keys.</td>
</tr>
<tr>
<td class="mla-doc-table-label">last_in_row</td>
<td>for the "grid" output format, set to "last_in_row" for the last item in each full grid row, and to an empty string for all other items in the row. If the list ends with a partial row, the last_in_row parameter is not set.</td>
</tr>
<tr>
<td class="mla-doc-table-label">meta_value</td>
<td>the value of the  item, escaped to be a valid HTML attribute value</td>
</tr>
<tr>
<td class="mla-doc-table-label">meta_text</td>
<td>the item display name</td>
</tr>
<tr>
<td class="mla-doc-table-label">count</td>
<td>the number of attachments associated with the item.</td>
</tr>
<tr>
<td class="mla-doc-table-label">scaled_count</td>
<td>scaled count value, for determining font size. The default formula for scaling the count is <code>round(log10($tag->count + 1) * 100)</code></td>
</tr>
<tr>
<td class="mla-doc-table-label">font_size</td>
<td>the numeric portion of the CSS "font-size" attribute</td>
</tr>
<tr>
<td class="mla-doc-table-label">link_url</td>
<td>the URL portion of "thelink" (below). Derived from currentlink_url or mla_link_href.</td>
</tr>
<tr>
<td class="mla-doc-table-label">currentlink_url</td>
<td>URL of the current post/page plus current item and optional current page query arguments</td>
</tr>
<tr>
<td class="mla-doc-table-label">caption</td>
<td>if captiontag is not empty, contains the mla_caption value</td>
</tr>
<tr>
<td class="mla-doc-table-label">link_attributes</td>
<td>link attributes, if any, drawn from the mla_target, mla_link_attributes and mla_link_class parameters</td>
</tr>
<tr>
<td class="mla-doc-table-label">current_item_class</td>
<td>set to "mla_current_item" for the current item in the list as determined by the "current_item" parameter, and to an empty string for all other items in the list.</td>
</tr>
<tr>
<td class="mla-doc-table-label">rollover_text</td>
<td>the "title" attribute value, drawn from single_text/multiple_text or the mla_rollover_text parameters</td>
</tr>
<tr>
<td class="mla-doc-table-label">link_style</td>
<td>the CSS "style" attribute, drawn from the font_size and unit parameters or the mla_link_style parameter</td>
</tr>
<tr>
<td class="mla-doc-table-label">link_text</td>
<td>the text enclosed by the hyperlink, drawn from the item taxt or mla_link_text parameter</td>
</tr>
<tr>
<td class="mla-doc-table-label">thevalue</td>
<td>item value (default) or other value as determined by the "mla_item_value" parameter</td>
</tr>
<tr>
<td class="mla-doc-table-label">thelink</td>
<td>full hyperlink to the chosen destination as determined by the "link" and "mla_link_href" parameters</td>
</tr>
<tr>
<td class="mla-doc-table-label">currentlink</td>
<td>full hyperlink to the current page with a term-specific query argument, including all the Display Content parameters</td>
</tr>
</table>
<p>
&nbsp;
<a name="cf_list_pagination_parameters"></a>
</p>
<h4>Custom Field List Pagination Parameters</h4>
<p>
If you have a large number of values for your custom field you may want to paginate the list display, i.e., divide the list into two or more pages of a reasonable size. Pagination support for <code>[mla_custom_list]</code> is modeled on similar functions for<code>[mla_gallery]</code>, and you can find more explanation of the ideas behind pagination in the <a href="#mla_output_parameter"><strong>Support for Alternative Gallery Output, e.g., Pagination</strong></a> section.
</p>
<p>
The <strong>"mla_output"</strong> parameter determines the type of output the shortcode will return. For pagination output, you can choose from six values: 
</p>
<table>
<tr>
<td class="mla-doc-table-label">next_link</td>
<td>returns a link to the next list item, based on the "term_id" parameter value. The optional "<strong>,wrap</strong>" qualifier determines what happens at the end of the list. If you omit the qualifier, an empty string is returned for the "next_link" from the last item. If you code the ",wrap" qualifier, the "next_link" from the last item will be to the first item.</td>
</tr>
<tr>
<td class="mla-doc-table-label">current_link</td>
<td>returns a link to the current list item, based on the "term_id" parameter value. This gives you an easy way to provide a visual indication of where you are within the taxonomy. The "span" and  "none" link formats are often used with this mla_output type.</td>
</tr>
<tr>
<td class="mla-doc-table-label">previous_link</td>
<td>returns a link to the previous list item, based on the "term_id" parameter value. The optional "<strong>,wrap</strong>" qualifier determines what happens at the beginning of the list. If you omit the qualifier, an empty string is returned for the "previous_link" from the first item. If you code the ",wrap" qualifier, "previous_link" from the gallery item will be to the last item.</td>
</tr>
<tr>
<td class="mla-doc-table-label">next_page</td>
<td>returns a link to the next "page" of list items, based on the "mla_custom_list_current" parameter value. The optional "<strong>,wrap</strong>" or "<strong>,last</strong>" qualifiers determine what happens at the end of the taxonomy. If you omit the qualifier, an empty string is returned for the "next_page" if there are no more items in the taxonomy. If you code the ",wrap" qualifier, the "next_page" from the last page of items will be to the first page. If you code the ",last" qualifier, the "next_page" link will return to/remain on the last page.</td>
</tr>
<tr>
<td class="mla-doc-table-label">previous_page</td>
<td>returns a link to the previous "page" of list items, based on the "mla_custom_list_current" parameter value. The optional "<strong>,wrap</strong>" or "<strong>,first</strong>" qualifiers determine what happens at the beginning of the taxonomy. If you omit the qualifier, an empty string is returned for the "previous_link" from the first page. If you code the ",wrap" qualifier, "previous_page" from the first page will be to the last page. If you code the ",first" qualifier, the "previous_link" link will return to/remain on the first page.</td>
</tr>
<tr>
<td class="mla-doc-table-label">paginate_links</td>
<td>returns a link to list items at the start and end of the list and to pages around the current "list page" ( e.g.: &laquo; Previous 1 ... 3 4 5 6 7 ... 9 Next &raquo; ), based on the "mla_custom_list_current" parameter value. The optional "<strong>,show_all</strong>" qualifier will show all of the list pages instead of a short list around the current page. The optional "<strong>,prev_next</strong>" qualifier will include the "&laquo; Previous" and "Next &raquo;" portions of the link list.</td>
</tr>
</table>
<p>
Eight parameters are supplied for pagination control:
</p>
<table>
<tr>
<td class="mla-doc-table-label">limit</td>
<td>the maximum number of terms to display in one list "page". Think of this as a "values per page" value.</td>
</tr>
<tr>
<td class="mla-doc-table-label">offset</td>
<td>the number of terms to skip over before starting the current list page. This parameter is usually derived automatically from the more useful "mla_custom_list_current" parameter.</td>
</tr>
<tr>
<td class="mla-doc-table-label">mla_custom_list_current</td>
<td>the current list page number. The name of this parameter can be changed to support multiple paginated lists on one post/page. This parameter will automatically be added to the URLs generated by pagination output types and managed for you.</td>
</tr>
<tr>
<td class="mla-doc-table-label">mla_page_parameter</td>
<td>the name of the parameter containing the current page number; default "mla_custom_list_current". You can change the name if you need multiple paginated lists on one post/page.</td>
</tr>
<tr>
<td class="mla-doc-table-label">mla_paginate_total</td>
<td>the highest page number you want to display; defaults to (total items / limit) if not specified, which is usually what you want. </td>
</tr>
<tr>
<td class="mla-doc-table-label">mla_paginate_rows</td>
<td>If you have some other way of computing the total number of values you want to paginate you can use <code>mla_paginate_rows</code> to simplify your shortcode parameters and avoid redundant database access. If, for example, you want pagination controls for a list that you know has fifty values you can code <code>[mla_custom_list mla_output=paginate_links mla_paginate_rows=50]</code> and then add any other page selection or list display content parameters you need.</td>
</tr>
<tr>
<td class="mla-doc-table-label">current_item</td>
<td>Identifies the current/selected item in the list. It contains a text value. It will be ignored if it does not match an item in the list.</td>
</tr>
<tr>
<td class="mla-doc-table-label">mla_item_parameter</td>
<td>The name of the parameter containing the current item value; <strong>default "current_item"</strong>. You can change the name if you need multiple lists on one post/page.</td>
</tr>
<tr>
<td class="mla-doc-table-label">offset, paged</td>
<td><strong>DO NOT USE THESE PARAMETERS; THEY WILL BREAK MLA PAGINATION</strong></td>
</tr>
</table>
<p>
The <code>[mla_custom_list]</code> shortcode can be used to provide "Previous" and "Next" links that support moving among the individual items in a list or among list "pages". For example, if you have many values in your custom field you can build a value-specific <code>[mla_gallery]</code> page with links to the previous/next value in the custom field (a complete pagination example is included below). You can also build a page that shows a large number of custom field values in groups, or "list pages", of ten values with links to the previous/next ten values or links to all of the list pages of values for the custom field.
</p>
<h4>Next and previous list items; the <code>next_link</code> and <code>previous_link</code> output types</h4>
<p>
If you use an <code>[mla_gallery]</code> shortcode to build a gallery of items with a specific custom field value you can use the <code>next_link</code> and <code>previous_link</code> output types to move through single-value "pages" for the gallery.
</p>
<p>
The next or previous link returned is drawn from the item-specific "link" substitution parameter for the next or previous list item. This means you can use all of the <a href="#cf_list_display_content">Custom Field List Display Content</a> parameters to control each element of the link. For example, you can code <code>mla_rollover_text='&amp;larr; Previous'</code> to customize the text link to the "previous_link" item. You can also add HTML arguments to the link to pass values along from one page to the next.
</p>
<h4>Next and previous list pages; the <code>next_page</code> and <code>previous_page</code> output types</h4> 
<p>
If your custom field has a large number of distinct values you might want to divide your <code>[mla_custom_list]</code> into "list pages" with a manageable number of values on each page. For these applications you can use the <code>next_page</code> and <code>previous_page</code> output types to move through the list in groups of, say, ten values per "list page".
</p>
<p>
MLA has its own "mla_custom_list_current" parameter to indicate the current set of values within the list (the current list page). MLA will automatically manage this parameter for you, but you can also use it explicitly to handle special cases.
</p>
<p>For most applications, "limit" is the only pagination parameter you need to specify. Make sure this parameter is the same for your main list shortcode and for the pagination shortcodes that go with it. Also, make sure you use exactly the same item selection and sorting parameters in all shortcodes.
</p>
<h4>Gallery Display Content parameters for <code>next_page</code> and <code>previous_page</code> output types</h4>
<p>
The next or previous link returned can use the following Gallery Display Content parameters to control each element of the link:
</p>
<table>
<tr>
<td class="mla-doc-table-label">mla_link_attributes</td>
<td>adds one or more HTML attributes to the hyperlink </td>
</tr>
<tr>
<td class="mla-doc-table-label">mla_link_class</td>
<td><strong>adds</strong> one or more classes to those already defined for the hyperlink </td>
</tr>
<tr>
<td class="mla-doc-table-label">mla_link_href</td>
<td>replaces the HTML &quot;href&quot; attribute in the hyperlink </td>
</tr>
<tr>
<td class="mla-doc-table-label">mla_link_text</td>
<td>replaces the link text </td>
</tr>
<tr>
<td class="mla-doc-table-label">mla_prev_text</td>
<td>the "previous page" text (default "&laquo; Previous"); an alternative to "mla_link_text" for <code>mla_output=previous_page</code></td>
</tr>
<tr>
<td class="mla-doc-table-label">mla_next_text</td>
<td>the "next page" text (default "Next &raquo;") an alternative to "mla_link_text" for <code>mla_output=next_page</code></td>
</tr>
<tr>
<td class="mla-doc-table-label">mla_nolink_text</td>
<td>replaces the empty string displayed when there is no link and link text, e.g., no previous or next page link </td>
</tr>
<tr>
<td class="mla-doc-table-label">mla_rollover_text</td>
<td>replaces the HTML &quot;title&quot; attribute in the hyperlink. This is the text displayed when the mouse rolls or hovers over the link text </td>
</tr>
<tr>
<td class="mla-doc-table-label">mla_target</td>
<td>adds an HTML &quot;target&quot; attribute to the hyperlink </td>
</tr>
</table>
<h4>Generalized paginated link list; the <code>paginate_links</code> output type</h4>
<p>
WordPress provides a function that "<em>can be used to create paginated link list for any area</em>." The "paginate_links" output type is modeled on this function and lets you generate a list of links for moving among "gallery pages".
</p>
<p>
The <strong>Page Selection Parameters</strong> and <strong>Gallery Display Content Parameters</strong> defined above also apply to the "paginate_links" output type. There are five additional parameters unique to this output type.
</p>
<h4>Specific parameters for the <code>paginate_links</code> output type</h4>
<table>
<tr>
<td class="mla-doc-table-label">mla_end_size</td>
<td>How many numbers (default 1) appear on either the start and the end list edges</td>
</tr>
<tr>
<td class="mla-doc-table-label">mla_mid_size</td>
<td>How many numbers (default 2) appear to either side of current page, but not including current page</td>
</tr>
<tr>
<td class="mla-doc-table-label">mla_prev_text</td>
<td>the "previous page" text (default "&laquo; Previous") , which appears when the ",prev_next" qualifier is added to the output_type</td>
</tr>
<tr>
<td class="mla-doc-table-label">mla_next_text</td>
<td>the "next page" text (default "Next &raquo;") , which appears when the ",prev_next" qualifier is added to the output_type</td>
</tr>
<tr>
<td class="mla-doc-table-label">mla_paginate_type</td>
<td>the format of the return value. "<strong>plain</strong>" (the default) returns a string with links separated by the newline character. "<strong>list</strong>" returns an unordered (ul) HTML list.</td>
</tr>
</table>
<p>If you code the "<strong>,show_all</strong>" qualifier, most of the above parameters have no effect; the "mla_paginate_type" parameter is the exception.
</p>
<h4>Markup Substitution Parameters for <code>next_page</code>, <code>previous_page</code> and <code>paginate_links</code> output types</h4>
<p>You can use any of the <a href="#mla_markup_parameters"><strong>Substitution parameters for markup templates</strong></a> in your next/previous page links (since the links are at the "gallery page" level, <strong>the attachment-specific substitution parameters are not available</strong>). The following additional substitution parameters are available for the <code>next_page</code> and <code>previous_page</code> output types:
</p>
<table>
<tr>
<td class="mla-doc-table-label">current_page</td>
<td>the number of the current page</td>
</tr>
<tr>
<td class="mla-doc-table-label">new_page</td>
<td>the number of the new (previous or next) page; zero for paginate_links</td>
</tr>
<tr>
<td class="mla-doc-table-label">last_page</td>
<td>the number of the last/highest/maximum page</td>
</tr>
<tr>
<td class="mla-doc-table-label">posts_per_page</td>
<td>the number of items on each gallery page</td>
</tr>
<tr>
<td class="mla-doc-table-label">found_rows</td>
<td>the number of items in the gallery</td>
</tr>
<tr>
<td class="mla-doc-table-label">current_offset</td>
<td>the number of items skipped before the current page</td>
</tr>
<tr>
<td class="mla-doc-table-label">new_offset</td>
<td>the number of items skipped before the new page</td>
</tr>
<tr>
<td class="mla-doc-table-label">current_page_text</td>
<td>'mla_custom_list_current="[+current_page+]"'</td>
</tr>
<tr>
<td class="mla-doc-table-label">new_page_text</td>
<td>'mla_custom_list_current="[+new_page+]"'</td>
</tr>
<tr>
<td class="mla-doc-table-label">last_page_text</td>
<td>'mla_paginate_total="[+last_page+]"'</td>
</tr>
<tr>
<td class="mla-doc-table-label">posts_per_page_text</td>
<td>'posts_per_page="[+posts_per_page+]"'</td>
</tr>
<tr>
<td class="mla-doc-table-label">scheme</td>
<td>the HTTP protocol used to access the page; usually "http://" but might be "https://"</td>
</tr>
<tr>
<td class="mla-doc-table-label">http_host</td>
<td>contents of the <em>Host:</em> header of the current request; usually a domain name such as "mysite.com" or an IP address</td>
</tr>
<tr>
<td class="mla-doc-table-label">query_string</td>
<td>the query arguments portion of the new URL, including the questions mark that precedes them.</td>
</tr>
<tr>
<td class="mla-doc-table-label">request_uri</td>
<td>the URI given to access the page, e.g., "wordpress/2013/06/sample-post" or "wordpress/tag-gallery-page?attachment_tag=sample". MLA manages pagination by adding the "mla_custom_list_current" query parameter to the URI value</td>
</tr>
<tr>
<td class="mla-doc-table-label">new_url</td>
<td>concatenation of scheme + http_host + request_uri</td>
</tr>
</table>
<p>
<a name="cf_list_pagination_example"></a>
</p>
<h4>Custom Field List Pagination Example</h4>
<p>
This section takes you through several of the <code>[mla_custom_list]</code> features, step by step. For these examples, a custom field named "camera" was created from the <code>meta:image_meta.camera</code> values WordPress generates. Let's start with a very simple list showing all of the values for the "camera" custom field in the default flat output format (a cloud):
</p>
<p>
<code>[mla_custom_list meta_key=camera]</code>
</p>
<p>
The "meta_key=camera" parameter names the custom field on which the list is based. Let's paginate the list and limit the terms display to ten terms per "page":
</p>
<p>
<code>[mla_custom_list meta_key=camera limit=10]<br />
[mla_custom_list meta_key=camera limit=10  mla_output="paginate_links,prev_next"]</code>
</p>
<p>
The "limit=10" parameter (on <strong>both</strong> shortcodes) limits the list display to ten values. The second <code>[mla_custom_list]</code> shortcode, adding the 'mla_output="paginate_links,prev_next"' parameter, displays a line of pagination links below the list page. Coordination between the two shortcodes is automatic, using the "mla_custom_list_current" parameter added to the URLs by the shortcode.
</p>
<p>Now we'll make the list a convenient way to control a value-specific <code>[mla_gallery]</code>. We use the current item value managed by the list shortcode to filter the gallery display:_
</p>
<p>
<code>[mla_custom_list meta_key=camera limit=10]<br />
[mla_custom_list meta_key=camera limit=10  mla_output="paginate_links,prev_next"]
<br />&nbsp;<br />
[mla_gallery meta_key=camera meta_value="{+template:{+request:current_item+}|a-bad-value+}" mla_caption="{+title+}" link=file]</code>
</p>
<p>
The "meta_value" parameter value is a Content Template that returns the "current_item" value, if present, or the string "a-bad-value" to display an empty gallery if no list value has been selected.
</p>
<p>
We can easily paginate the term-specific gallery by adding a second <code>[mla_gallery]</code> shortcode and a "posts_per_page" parameter to both shortcodes:
</p>
<p>
<code>[mla_custom_list meta_key=camera limit=10]<br />
[mla_custom_list meta_key=camera limit=10  mla_output="paginate_links,prev_next"]
<br />&nbsp;<br />
[mla_gallery meta_key=camera meta_value="{+template:{+request:current_item+}|a-bad-value+}" posts_per_page=5 mla_caption="{+title+}" link=file]
<br />&nbsp;<br />
[mla_gallery meta_key=camera meta_value="{+template:{+request:current_item+}|a-bad-value+}" posts_per_page=5 mla_output="paginate_links,prev_next"]</code>
</p>
<p>
The pagination controls for the custom field list and the gallery operate independently because by default they use different names for their respective "_current" page parameters. Our page now has a lot of functionality without requiring any WordPress templates or PHP code.
</p>
<p>
For extra credit, let's add some more navigation options to the page. We'll build previous, current and next term links at the bottom of the page. These are enclosed in an HTML table so they all appear on one line of the page. Here is just the additional content; the table of three link navigation controls:
</p>
<p>
<code>
&lt;table width=99%&gt;&lt;tr&gt;<br />
&lt;td width=33% style="text-align: left"&gt;[mla_custom_list meta_key=camera mla_output="previous_link" mla_link_text="Previous: {+meta_text+}"]&lt;/td&gt;<br />&nbsp;<br />
&lt;td width=33% style="text-align: center; font-weight: bold:"&gt;[mla_custom_list meta_key=camera mla_output=current_link mla_link_text="Current: {+meta_text+}" link=span]&lt;/td&gt;<br />&nbsp;<br />
&lt;td width=33% style="text-align: right"&gt;[mla_custom_list meta_key=camera mla_output="next_link" mla_link_text="Next: {+meta_text+}"]&lt;/td&gt;<br />
&lt;/tr&gt;&lt;/table&gt;
</code>
</p>
<p>
The "mla_link_text" parameters add labels to each of the three navigation links. Finally, the "link=span" parameter in the middle ("mla_output=current_link") shortcode removes the hyperlink behind the term name, since it would just take you back to the page you're already on.
<a name="mla_cf_list_hooks"></a>
</p>
<h4>MLA Custom Field List Filters (Hooks)</h4>
<p>
The <code>[mla_custom_list]</code> shortcode supports a comprehensive set of filters that give you complete control over list composition from PHP code in your theme or in another plugin. An example of using the hooks from a simple, stand-alone plugin can be found in the Documentation/Example Plugins submenu. You can find the example plugin here: <a title="Find the Custom Field List Hooks Example" href="[+example_url+]&amp;mla-example-search=Search+Plugins&amp;s=%22MLA+Custom+List+Hooks+Example%22" class="mla-doc-bold-link">MLA Custom Field List Hooks Example</a>. To run the example:
</p>
<ol>
<li>Click on the link above or go to top of the Documentation tab and click on the "Example Plugins" button.</li>
<li>Hover over "MLA Custom Field List Hooks Example" in the Name column, then click the "Install" rollover action.</li>
<li>Go to the Plugins/Installed Plugins screen and activate the "MLA Custom Field List Hooks Example" plugin.</li>
<li>Create a new <code>[mla_custom_list]</code> shortcode or modify an existing shortcode, adding the <code>my_filter="color list"</code> parameter to activate the example output. Make sure the shortcode uses the "flat" output format.</li>
<li>View the post or page on which the modified shortcode appears to see a list with a range of colors applied to the values.</li>
</ol>
<p>
The example code documents each hook with comments in the filter/action function that intercepts the hook. Generally, each part of the list supports three hooks: 1) a "<strong>values</strong>" hook, which lets you record or update the substitution values for that list part, 2) a "<strong>template</strong>" hook, which lets you record/update the template used to generate the HTML markup, and 3) a "<strong>parse</strong>" hook which lets you modify or replace the markup generated for a list part. The current hooks are:
</p>
<table>
<tr>
<td class="mla-doc-hook-label">mla_custom_list_raw_attributes</td>
<td class="mla-doc-hook-definition">called at the beginning of the list, before the attributes pass through the logic that handles the 'mla_page_parameter' and "request:" prefix processing.</td>
</tr>
<tr>
<td class="mla-doc-hook-label">mla_custom_list_attributes,<br />mla_custom_list_arguments</td>
<td class="mla-doc-hook-definition">called at the beginning of the list generation. You can record/modify shortcode parameter values before (attributes) or after (arguments) they are combined with all the defaults.</td>
</tr>
<tr>
<td class="mla-doc-hook-label">mla_get_custom_values_query_attributes,<br />mla_get_custom_values_query_arguments</td>
<td class="mla-doc-hook-definition">called just before building the SQL query for the <code>$wpdb->get_results()</code> call that selects list values, with query parameters before or after they are combined with defaults.</td>
</tr>
<tr>
<td class="mla-doc-hook-label">mla_get_custom_values_clauses</td>
<td class="mla-doc-hook-definition">gives you a final opportunity to inspect or modify the SQL clauses for the data selection process.</td>
</tr>
<tr>
<td class="mla-doc-hook-label">mla_get_custom_values_query_results</td>
<td class="mla-doc-hook-definition">called just after the <code>$wpdb->get_results()</code> call, so you can inspect/record or modify the results.</td>
</tr>
<tr>
<td class="mla-doc-hook-label">mla_custom_list_scale</td>
<td class="mla-doc-hook-definition">called as the scaled_count (size) of each term is calculated, so you can modify the results.</td>
</tr>
<tr>
<td class="mla-doc-hook-label">use_mla_custom_list_style</td>
<td class="mla-doc-hook-definition">allow or suppress the inclusion of CSS styles in the list output.</td>
</tr>
<tr>
<td class="mla-doc-hook-label">mla_custom_list_style_values,<br /> mla_custom_list_style_template,<br />mla_custom_list_style_parse</td>
<td class="mla-doc-hook-definition">for manipulating the Style template.</td>
</tr>
<tr>
<td class="mla-doc-hook-label">mla_custom_list_open_values,<br />mla_custom_list_open_template,<br />mla_custom_list_open_parse</td>
<td class="mla-doc-hook-definition">for manipulating the "Open" part of the Markup template used in a "list", "grid", "dropdown" or "checklist" list.</td>
</tr>
<tr>
<td class="mla-doc-hook-label">mla_custom_list_row_open_values,<br />mla_custom_list_row_open_template,<br />mla_custom_list_row_open_parse</td>
<td class="mla-doc-hook-definition">for manipulating the "Row Open" part of the Markup template used in a "grid" list.</td>
</tr>
<tr>
<td class="mla-doc-hook-label">mla_custom_list_item_values,<br />mla_custom_list_item_template,<br />mla_custom_list_item_parse</td>
<td class="mla-doc-hook-definition">for manipulating the "Item" part of the Markup template used in a "list", "grid", "dropdown" or "checklist" list.</td>
</tr>
<tr>
<td class="mla-doc-hook-label">mla_custom_list_row_close_values,<br />mla_custom_list_row_close_template,<br />mla_custom_list_row_close_parse</td>
<td class="mla-doc-hook-definition">for manipulating the "Row Close" part of the Markup template used in a "grid" list.</td>
</tr>
<tr>
<td class="mla-doc-hook-label">mla_custom_list_close_values,<br />mla_custom_list_close_template,<br />mla_custom_list_close_parse</td>
<td class="mla-doc-hook-definition">for manipulating the "Close" part of the Markup template used in a "list", "grid", "dropdown" or "checklist" list.</td>
</tr>
</table>
</div>
<a name="shortcode_api"></a>
<p>
<a href="#backtotop">Go to Top</a>
</p>
<h3>Calling shortcode functions from PHP code; the MLA shortcode API</h3>
<p>
You can always use the WordPress <code>do_shortcode()</code> function to execute MLA shortcodes, but you can also call several of the MLA shortcode support functions directly from your PHP code. You can find the available API functions and parameter documentation in the <code>/media-library-assistant/includes/class-mla-shortcode.php</code> file.
<a name="gallery_examples"></a>
</p>
<p>
<a href="#backtotop">Go to Top</a>
</p>
<h3>MLA Gallery Examples</h3>
<p>
As you can tell from the number of parameters available, the <code>[mla_gallery]</code> shortcode is powerful, but it can be complex. The examples in this section show several of the more popular applications, taken from topics in the MLA Support Forum.
<a name="simple_examples"></a>
</p>
<h4>Simple Examples</h4>
<ul class="mla_settings">
<li><code>[mla_gallery]</code> - will display all the images "attached" to the current post/page.</li>
<li><code>[mla_gallery ids="1,3,2,4"]</code> - will display specific images on any post/page. The numbers are the ID values of the images. You can use the "Add Media..." popup window and "Create Gallery" to get the list, then change the shortcode name to "mla_gallery" if you want to add other <code>[mla_gallery]</code> specific parameters.</li>
<li><code>[mla_gallery post_parent=all]</code> - will display all the images in your Media Library.</li>
<li><code>[mla_gallery post_parent=all post_mime_type=application/pdf]</code> - will display all the PDF documents in your Media Library. Since PDF documents are not images, the title of the document will display in place of the thumbnail image.</li>
<li><code>[mla_gallery post_parent=all post_mime_type="audio,video"]</code> - will display all the audio and video documents in your Media Library.</li>
<li><code>[mla_gallery post_parent=all post_mime_type=application/pdf size=icon link=file]</code> - will display all the PDF documents in your Media Library. The "PDF icon" will display in place of the thumbnail. When the icon is clicked, the document itself will be displayed in the browser.</li>
</ul>
<p>
Perhaps the most popular Media Library Assistant feature is the ability to assign category and tag values to Media Library Items and use the values to filter a gallery display. "Categories" and "Tags" are built-in WordPress "taxonomies" and have been used for a long time to organize posts and pages. WordPress does not have built-in support for using them with attachments and that was one of the original motivations for MLA.
</p>
<p>
With MLA you can extend Categories and Tags support to attachments. MLA also provides two additional taxonomies for your convenience, Att. Categories and Att. Tags. Because of the way WordPress works, using Categories and Tags for attachments as well as posts and pages can be complicated, so many people find that using the separate Att. Categories and Att. Tags is more convenient.
</p>
<p>
To use a taxonomy you must create one or more "terms" within it. For example, you could create terms in the Category taxonomy like "Big Dog" and "Little Dog". For each term, WordPress automatically creates a "slug", e.g., "big-dog" and "little-dog" for the previous examples. Removing capital letters, spaces and punctuation makes it easier to organize and search the database. It's the slug you can use in [mla_gallery] shortcodes. To "<em>display the attachments that have been assigned to a single category/tag</em>", use the term's slug; for the four taxonomies we've discussed:
</p>
<ul class="mla_settings">
<li>Categories: <code>[mla_gallery category_name=big-dog]</code></li>
<li>Tags: <code>[mla_gallery tag=big-dog]</code></li>
<li>Att. Categories: <code>[mla_gallery attachment_category=big-dog]</code></li>
<li>Att. Tags: <code>[mla_gallery attachment_tag=big-dog]</code></li>
</ul>
<p>
The category_name example does not follow the general rule of "taxonomy-slug = term-slug" because it was created long ago, when Categories and Tags were the only taxonomies allowed. The tag example does not follow the rule, either, since the actual taxonomy-slug is "post_tag", not "tag".
<a name="paginated_gallery"></a>
</p>
<h4>A Paginated Gallery</h4>
<p>
If your gallery display includes a large number of items it may be useful to divide the display into "pages" with a fixed upper limit of items per page. The <a href="#mla_output_parameter"><strong>Support for Alternative Gallery Output, e.g., Pagination</strong></a> section explains several ways to do that; here is one example. Put <strong>both of these shortcodes</strong> on a post or page to display a paginated gallery:
</p>
<blockquote>
<code>[mla_gallery attachment_category=big-dog posts_per_page=12]</code><br />
&nbsp;<br />
<code>[mla_gallery attachment_category=big-dog posts_per_page=12 mla_output="paginate_links,prev_next"]</code>
</blockquote>
<p>
Note that <strong>two shortcodes are required</strong>; one for the gallery display and a second one for the pagination controls. The first <code>[mla_gallery]</code> displays the images assigned to <code>attachment_category=big-dog</code> and displays a maximum of 12 images at once. The second <code>[mla_gallery]</code> has <strong>exactly the same</strong> data selection parameter and posts per page parameter; that's essential to match up with the first shortcode. It adds one more parameter, <code>mla_output</code>. This parameter changes the display from a set of images to a set of pagination controls.
</p>
<p>
MLA will add and manage a "current page" parameter of its own so the two shortcodes stay in synch as you navigate from page to page. That's all there is to it.
<a name="cloud_and_gallery"></a>
</p>
<h4>Tag Cloud and Gallery</h4>
<p>
Adding the "taxonomy=term" parameter to your shortcode is all well and good, but letting the viewer choose a term when they view the post/page is often better. One easy way to do this is to add the <code>[mla_tag_cloud]</code> shortcode. Here is a simple combination of a cloud and a gallery display:
</p>
<blockquote>
<code>[mla_tag_cloud taxonomy=attachment_category number=0 mla_link_href="{+page_url+}?term_slug={+slug+}"]</code><br />
&nbsp;<br />
<code>[mla_gallery attachment_category="{+template:({+request:term_slug+}|a-bad-term)+}" mla_nolink_text="Click a term to display the gallery."]</code>
</blockquote>
<p>
The <code>[mla_tag_cloud]</code> displays Att. Categories terms in the familiar cloud format. The <code>number=0</code> parameter ensures that all of the terms are displayed. The <code>mla_link_href</code> parameter links each term back to the current page (<code>{+page_url}</code>) and passes a variable back with the term selection (<code>?term_slug={+slug+}</code>). If you put the <code>[mla_tag_cloud]</code> shortcode on another page or in a widget you will have to hard-code the URL portion of the link.
</p>
<p>
The <code>[mla_gallery]</code> displays the images assigned to the selected attachment_category term. The <code>mla_nolink_text</code> parameter gives the text to display when the gallery is empty, e.g., before you click on a term. In this shortcode:
</p>
<ul class="mla_settings">
<li>The <code>template:</code> prefix says that this is a Content Template</li>
<li>The parentheses "()" around the two elements are used to group them into a list of alternatives</li>
<li>The vertical bar "|" between the two elements means "stop when you get a non-empty alternative"</li>
<li><code>{+request:term_slug+}</code> will be empty unless there is a term_slug in the URL</li>
<li><code>a-bad-term</code> is a literal value (and thus never empty) which does not match any term in the attachment_category taxonomy, so the gallery will be empty if this alternative is used</li>
</ul>
<p>
You can read more about templates in the <a href="#mla_template_parameters">Content Templates</a> section. You can paginate your gallery by adding a third shortcode to the post/page. Put the new shortcode between the cloud and gallery so the pagination controls will appear above the gallery display:
</p>
<blockquote>
<code>[mla_tag_cloud taxonomy=attachment_category number=0 mla_link_href="{+page_url+}?term_slug={+slug+}"]</code><br />
&nbsp;<br />
<code>[mla_gallery attachment_category="{+template:({+request:term_slug+}|a-bad-term)+}" posts_per_page=12" mla_output="paginate_links,prev_next" mla_link_href="{+page_url+}?term_slug={+request:term_slug+}"]</code><br />
&nbsp;<br />
<code>[mla_gallery attachment_category="{+template:({+request:term_slug+}|a-bad-term)+}" posts_per_page=12 mla_nolink_text="Click a term to display the gallery."]</code>
</blockquote>
<p>
The <code>posts_per_page=12</code> parameter has been added to the gallery display shortcode (the third shortcode). A new <code>[mla_gallery]</code> is added to display the pagination controls. The data selection parameter and <code>posts_per_page=12</code> parameter match the gallery display shortcode below it. The <code>mla_output</code> parameter displays the pagination controls. Finally, the <code>mla_link_href="{+page_url+}?term_slug={+request:term_slug+}"</code> parameter is added so the pagination controls pass the <code>term_slug</code> from page to page.
<a name="search_form_and_gallery"></a>
</p>
<h4>Search Form and Gallery</h4>
<p>
A common alternative to the taxonomy filtering in the previous examples is a keyword-based search. This example shows a simple HTML form with a text box and a button to run the search. The user can enter one or more words to search for in the Title or Description of Media Library items, then click "Search" to display a gallery of matching images:
</p>
<blockquote>
<code>&lt;form id="mla-search-form" action="." method="post"><br />
&lt;input id="mla-search-box" name="search-string" type="text" value="" />&amp;nbsp;&lt;input id="submit" name="submit" type="submit" value="Search" /><br />
&lt;/form></code><br />
&nbsp;<br />
<code>[mla_gallery s="{+template:({+request:search-string+}|a-bad-term)+}" mla_nolink_text="Enter a search value above to display gallery."]</code>
</blockquote>
<p>
In this example the <code>name="search-string"</code> parameter is passed from the form to the <code>s="{+request:search-string+}</code>... parameter in the shortcode. As in the Cloud and Gallery example a Content Template is used to supply <code>a-bad-term</code> before the form is completed, which displays an empty gallery because it doesn't match anything. You can find more information on the <code>s=</code> parameter and other search parameters in the <a href="#search_keywords">Keyword(s) Search</a> section.
</p>
<p>
As in the Cloud and Gallery example, paginating your gallery display requires a slight modification of the <code>[mla_gallery]</code> shortcode (at the bottom of the next example) and adding a second <code>[mla_gallery]</code> shortcode (in the middle of the next example) to display the pagination controls:
</p>
<blockquote>
<code>&lt;form id="mla-search-form" action="." method="post"><br />
&lt;input id="mla-search-box" name="search-string" type="text" value="" />&amp;nbsp;&lt;input id="submit" name="submit" type="submit" value="Search" /><br />
&lt;/form></code><br />
&nbsp;<br />
<code>[mla_gallery s="{+template:({+request:search-string+}|a-bad-term)+}" posts_per_page=12 mla_output="paginate_links,prev_next" mla_link_href="{+page_url+}?search-string={+request:search-string+}"]</code><br />
&nbsp;<br />
<code>[mla_gallery s="{+template:({+request:search-string+}|a-bad-term)+}" mla_nolink_text="Enter a search value above to display gallery." posts_per_page=12]</code>
</blockquote>
<p>
The <code>posts_per_page=12</code> parameter has been added to the gallery display shortcode (the third shortcode). A new <code>[mla_gallery]</code> is added to display the pagination controls. The data selection parameter (<code>s="{+request:search-string+}</code>...) and <code>posts_per_page=12</code> parameter match the gallery display shortcode below it. The <code>mla_output</code> parameter displays the pagination controls. Finally, the <code>mla_link_href="{+page_url+}?search-string={+request:search-string+}"</code> parameter is added so the pagination controls pass the <code>search-string</code> from page to page.
<a name="mla_output_parameter"></a>
</p>
<p>
<a href="#backtotop">Go to Top</a>
</p>
<h3>Support for Alternative Gallery Output, e.g., Pagination</h3>
<p>
The <code>[mla_gallery]</code> shortcode can be used to provide "Previous" and "Next" links that support moving among the individual items in a gallery or among gallery "pages". For example, if you have many items with a specific Att. Category or Att. Tag value you can build a single-image page with links to the previous/next item having that value. You can also build a page that shows a large gallery in groups, or "gallery pages", of ten items with links to the previous/next ten items or links to all of the gallery pages of items having that value. Finally, you can get a set of links to all pages in the gallery or links around the current page ( e.g.: &laquo; Previous 1 ... 3 4 5 6 7 ... 9 Next &raquo; ).
</p>
<p>
<strong>IMPORTANT:</strong> Pagination controls are an alternative output, not an additional output. One shortcode can generate either a gallery display or pagination controls. <strong>You will need two or more shortcodes to get both the gallery and the controls</strong>.
</p>
<h4>The <code>mla_output</code> parameter</h4>
<p>
The <strong>"mla_output"</strong> parameter determines the type of output the shortcode will return. Explanation and examples of each output type are given later in this section. You can choose from seven values:
</p>
<table>
<tr>
<td class="mla-doc-table-label">gallery</td>
<td>The default value; returns the traditional gallery of image thumbnails, captions, etc.</td>
</tr>
<tr>
<td class="mla-doc-table-label">next_link</td>
<td>returns a link to the next gallery item. The optional "<strong>,wrap</strong>" qualifier determines what happens at the end of the gallery. If you omit the qualifier, an empty string is returned for the "next_link" from the last item in the gallery. If you code the ",wrap" qualifier, the "next_link" from the last item will be to the first gallery item.</td>
</tr>
<tr>
<td class="mla-doc-table-label">current_link</td>
<td>returns a link to the current gallery item. This gives you an easy way to provide a visual indication of where you are within the overall gallery. The "span" and  "none" link formats are often used with this mla_output type.</td>
</tr>
<tr>
<td class="mla-doc-table-label">previous_link</td>
<td>returns a link to the previous gallery item. The optional "<strong>,wrap</strong>" qualifier determines what happens at the beginning of the gallery. If you omit the qualifier, an empty string is returned for the "previous_link" from the first gallery item. If you code the ",wrap" qualifier, "previous_link" from the first gallery item will be to the last gallery item.</td>
</tr>
<tr>
<td class="mla-doc-table-label">next_page</td>
<td>returns a link to the next "page" of gallery items. The optional "<strong>,wrap</strong>" or "<strong>,last</strong>" qualifiers determine what happens at the end of the gallery. If you omit the qualifier, an empty string is returned for the "next_page" if there are no more items in the gallery. If you code the ",wrap" qualifier, the "next_page" from the last page of items will be to the first page of gallery items. If you code the ",last" qualifier, the "next_page" link will return to/remain on the last page of gallery items.</td>
</tr>
<tr>
<td class="mla-doc-table-label">previous_page</td>
<td>returns a link to the previous "page" of gallery items. The optional "<strong>,wrap</strong>" or "<strong>,first</strong>" qualifiers determine what happens at the beginning of the gallery. If you omit the qualifier, an empty string is returned for the "previous_link" from the first page of gallery items. If you code the ",wrap" qualifier, "previous_page" from the first page of gallery items will be to the last page of gallery items. If you code the ",first" qualifier, the "previous_link" link will return to/remain on the first page of gallery items.</td>
</tr>
<tr>
<td class="mla-doc-table-label">paginate_links</td>
<td>returns a link to gallery items at the start and end of the list and to pages around the current "gallery page" ( e.g.: &laquo; Previous 1 ... 3 4 5 6 7 ... 9 Next &raquo; ). The optional "<strong>,show_all</strong>" qualifier will show all of the gallery pages instead of a short list around the current page. The optional "<strong>,prev_next</strong>" qualifier will include the "&laquo; Previous" and "Next &raquo;" portions of the link list.</td>
</tr>
</table>
<h4>Next and previous gallery items; the <code>next_link</code> and <code>previous_link</code> output types</h4>
<p>
WordPress provides functions that generate links to the "<em>next/previous image attached to the current post</em>." These are not useful when your Media Library items are not images or are not attached to a specific post or page.  If, for example, you use an <code>[mla_gallery]</code> shortcode to build a gallery of items with a specific Att. Tag value you can use the <code>next_link</code> and <code>previous_link</code> output types to move through single-item pages for the gallery. You will need one more parameter to specify the "current item" in the gallery:
</p>
<table>
<tr>
<td class="mla-doc-table-label">id</td>
<td>(optional) the ID of the "current" gallery item. If you omit this parameter, the default value is the ID of the current "post". The default value is only useful if you are enhancing the PHP code of the "image.php" template for the "Attachment Page" associated with a Media Library item.</td>
</tr>
</table>
<p>
The next or previous link returned is drawn from the attachment-specific "link" substitution parameter for the next or previous gallery item. This means you can use all of the <a href="#gallery_display_content">Gallery Display Content</a> parameters to control each element of the link. For example, you can code <code>mla_rollover_text='&amp;larr; Previous'</code> to replace the thumbnail image with a generic text link to the "previous_link" item. You can also add HTML arguments to the link to pass values along from one page to the next.
</p>
<p>
Here is a more complete example of two standard WordPress pages, "Sample Gallery" and "Single Sample", that work together. The "Sample Gallery" page displays a gallery of all items assigned to the Att.Tags "sample" term. The "Single Sample" page displays the full-size image for a "sample" item and has links to move back and forth through all the items assigned to the term. The Sample Gallery page contains:
</p>
<code>
[mla_gallery attachment_tag="sample" mla_caption="{+title+}" mla_link_href="/single-sample/?current_id={+attachment_ID+}&amp;attachment_tag={+query:attachment_tag+}"]
</code>
<p>
In this example <code>/single-sample/</code>, the URL portion of the link, is the "Permalink" WordPress generates from the page title. If your Permalink structure is different you will have to adjust this element. Note the use of <code>attachment_tag={+query:attachment_tag+}</code> in the href to pass the tag value from the gallery page to the Single Sample page. <strong>The Single Sample page has three <code>[mla_gallery]</code> shortcodes; one to display the image and two for the "Previous Sample" and "Next Sample" links</strong>:
</p>
<code>
[mla_gallery columns=1 ids="{+request:current_id+}" size=medium]
<br />&nbsp;<br />
&lt;div style="clear: both; float: left"&gt;<br />
[mla_gallery mla_output="previous_link,wrap" mla_link_text='&amp;larr; Previous Sample' attachment_tag="{+request:attachment_tag+}" id="{+request:current_id+}" mla_rollover_text="{+title+}" mla_link_href="{+page_url+}?current_id={+attachment_ID+}&amp;attachment_tag={+query:attachment_tag+}"]<br />
&lt;/div&gt;<br />
&lt;div style="float: right"&gt;<br />
[mla_gallery mla_output="next_link,wrap" mla_link_text='Next Sample &amp;rarr;' attachment_tag="{+request:attachment_tag+}" id="{+request:current_id+}" mla_rollover_text="{+title+}" mla_link_href="{+page_url+}?current_id={+attachment_ID+}&amp;attachment_tag={+query:attachment_tag+}"]<br />
&lt;/div&gt;
</code>
<p>
Consider the following points:
</p>
<ol>
<li>The "ids" parameter in the first <code>[mla_gallery]</code> takes the "current_id" value (for the single image to be displayed) from the link's query arguments (in the PHP $_REQUEST array). This is passed from the Sample Gallery page and updated in the previous/next link.
</li>
<li>The "id" parameters in the second and third <code>[mla_gallery]</code> take the "current_id" value from the $_REQUEST array. In these "galleries" the "current_id" is the item from which "previous" and "next" are calculated.
</li>
<li>The "attachment_tag" parameters in the second and third <code>[mla_gallery]</code> take the their value from the $_REQUEST array as well. The Att. Tag value is used to reconstruct the original gallery for the previous/next calculation, keeping the navigation within the bounds of the selected term.
</li>
</ol>
<p>
This example shows the power of the substitution parameters and in particular the "query" and "request" prefixes that can be used to pass information into an <code>[mla_gallery]</code> and from one page to the next. All of this without modifying PHP templates or requiring other code modifications!
</p>
<h4>Next and previous gallery pages; the <code>next_page</code> and <code>previous_page</code> output types</h4>
<p>
WordPress provides functions that generate links to the "<em>next/previous set of posts within the current query</em>." These are not useful because the "current query" is for posts/pages, <strong>not</strong> Media Library items. What's needed is a way to paginate an <code>[mla_gallery]</code> shortcode on a single post or page. If, for example, you use an <code>[mla_gallery]</code> shortcode to build a gallery of items with a specific Att. Tag value you can use the <code>next_page</code> and <code>previous_page</code> output types to move through the gallery in groups of, say, ten items per "gallery page".
</p>
<p>
WordPress uses the "paged" parameter to indicate the current "<em>set of posts within the current query</em>." To avoid built-in WordPress logic that uses this parameter, MLA has its own "mla_paginate_current" parameter to indicate the current set of items within the gallery (the current gallery page). MLA will automatically manage this parameter for you, but you can also use it explicitly to handle special cases.
</p>
<h4>An example of the <code>next_page</code> and <code>previous_page</code> output types</h4>
<p>
Expanding the "attachment tag gallery" example, you can select images using the MLA Att. Tag taxonomy and divide the  gallery into fixed-size pages. Following the main gallery shortcode are <strong>two additional shortcodes</strong> for the previous/next page links:
</p>
<code>
[mla_gallery attachment_tag="sample" posts_per_page=10 mla_caption="{+title+}"]
<br />&nbsp;<br />
&lt;div style="clear: both; float: left"&gt;<br />
[mla_gallery attachment_tag="sample" posts_per_page=10 mla_output="previous_page,first" mla_link_text='&amp;larr; Previous Gallery Page' mla_rollover_text="Previous or first page for this tag"]<br />
&lt;/div&gt;<br />
&lt;div style="float: right"&gt;<br />
[mla_gallery attachment_tag="sample" posts_per_page=10 mla_output="next_page,last" mla_link_text='&amp;larr; Next Gallery Page' mla_rollover_text="Next or last page for this tag"]<br />
&lt;/div&gt;
</code>
<p>
This example is simpler that the earlier single-item paging example because the "current page" handling is done by MLA, and the "sample" tag value is hard-coded. You could also develop a generic "Att. Tag" gallery page and pass the tag value in the URI for that page (as in the single-item pagination example earlier in this section).
</p>
<h4>Page selection parameters for <code>next_page</code> and <code>previous_page</code> output types</h4>
<p>
Use the following parameters to specify the size of each gallery page and the current gallery page:
</p>
<table>
<tr>
<td class="mla-doc-table-label">posts_per_page</td>
<td>sets the number of gallery items on each gallery "page" </td>
</tr>
<tr>
<td class="mla-doc-table-label">numberposts</td>
<td>synonym for "posts_per_page" </td>
</tr>
<tr>
<td class="mla-doc-table-label">mla_paginate_current</td>
<td>the "current" gallery page; defaults to one (1) if not specified. MLA will usually manage this for you, adding it to the hyperlinks for the previous and next gallery pages. MLA will look for this parameter in the HTML $_REQUEST array if it is not coded in the gallery shortcode.</td>
</tr>
<tr>
<td class="mla-doc-table-label">mla_page_parameter</td>
<td>the name of the parameter containing the current page number; default "mla_paginate_current". You can change the name if you need multiple paginated galleries on one post/page. If you use this parameter, make sure you add it to the gallery shortcode and all pagination shortcodes for that gallery, and use the same unique value in all shortcodes for the specific gallery.</td>
</tr>
<tr>
<td class="mla-doc-table-label">mla_paginate_total</td>
<td>the highest page number you want to display; defaults to (total items / posts_per_page) if not specified, which is usually what you want. </td>
</tr>
<tr>
<td class="mla-doc-table-label">mla_paginate_rows</td>
<td>If you have some other way of computing the total number of items you want to paginate you can use <code>mla_paginate_rows</code> to simplify your shortcode parameters and avoid redundant database access. If, for example, you want pagination controls for a gallery that you know has fifty items you can code <code>[mla_gallery mla_output=paginate_links mla_paginate_rows=50]</code> and then add any other page selection or gallery display content parameters you need.</td>
</tr>
<tr>
<td class="mla-doc-table-label">offset, paged</td>
<td><strong>DO NOT USE THESE PARAMETERS; THEY WILL BREAK MLA PAGINATION</strong></td>
</tr>
</table>
<p>For most applications, "posts_per_page" is the only pagination parameter you need to specify. Make sure this parameter is the same for your main gallery shortcode and for the pagination shortcodes that go with it. Also, make sure you use exactly the same item selection and sorting parameters in both shortcodes.
</p>
<h4>Gallery Display Content parameters for <code>next_page</code> and <code>previous_page</code> output types</h4>
<p>
The next or previous link returned can use the following Gallery Display Content parameters to control each element of the link:
</p>
<table>
<tr>
<td class="mla-doc-table-label">mla_link_attributes</td>
<td>adds one or more HTML attributes to the hyperlink </td>
</tr>
<tr>
<td class="mla-doc-table-label">mla_link_class</td>
<td><strong>adds</strong> one or more classes to those already defined for the hyperlink </td>
</tr>
<tr>
<td class="mla-doc-table-label">mla_link_href</td>
<td>replaces the HTML &quot;href&quot; attribute in the hyperlink </td>
</tr>
<tr>
<td class="mla-doc-table-label">mla_link_text</td>
<td>replaces the link text </td>
</tr>
<tr>
<td class="mla-doc-table-label">mla_prev_text</td>
<td>the "previous page" text (default "&laquo; Previous"); an alternative to "mla_link_text" for <code>mla_output=previous_page</code></td>
</tr>
<tr>
<td class="mla-doc-table-label">mla_next_text</td>
<td>the "next page" text (default "Next &raquo;") an alternative to "mla_link_text" for <code>mla_output=next_page</code></td>
</tr>
<tr>
<td class="mla-doc-table-label">mla_nolink_text</td>
<td>replaces the empty string displayed when there is no link and link text, e.g., no previous or next page link </td>
</tr>
<tr>
<td class="mla-doc-table-label">mla_rollover_text</td>
<td>replaces the HTML &quot;title&quot; attribute in the hyperlink. This is the text displayed when the mouse rolls or hovers over the link text </td>
</tr>
<tr>
<td class="mla-doc-table-label">mla_target</td>
<td>adds an HTML &quot;target&quot; attribute to the hyperlink </td>
</tr>
</table>
<h4>Markup Substitution Parameters for <code>next_page</code> and <code>previous_page</code> output types</h4>
<p>You can use any of the <a href="#mla_markup_parameters"><strong>Substitution parameters for markup templates</strong></a> in your next/previous page links (since the links are at the "gallery page" level, the attachment-specific substitution parameters are not available). The following additional substitution parameters are available for the <code>next_page</code> and <code>previous_page</code> output types:
</p>
<table>
<tr>
<td class="mla-doc-table-label">current_page</td>
<td>the number of the current page</td>
</tr>
<tr>
<td class="mla-doc-table-label">new_page</td>
<td>the number of the new (previous or next) page; zero for paginate_links</td>
</tr>
<tr>
<td class="mla-doc-table-label">last_page</td>
<td>the number of the last/highest/maximum page</td>
</tr>
<tr>
<td class="mla-doc-table-label">posts_per_page</td>
<td>the number of items on each gallery page</td>
</tr>
<tr>
<td class="mla-doc-table-label">found_rows</td>
<td>the number of items in the gallery</td>
</tr>
<tr>
<td class="mla-doc-table-label">current_offset</td>
<td>the number of items skipped before the current page</td>
</tr>
<tr>
<td class="mla-doc-table-label">new_offset</td>
<td>the number of items skipped before the new page</td>
</tr>
<tr>
<td class="mla-doc-table-label">current_page_text</td>
<td>'mla_paginate_current="[+current_page+]"'</td>
</tr>
<tr>
<td class="mla-doc-table-label">new_page_text</td>
<td>'mla_paginate_current="[+new_page+]"'</td>
</tr>
<tr>
<td class="mla-doc-table-label">last_page_text</td>
<td>'mla_paginate_total="[+last_page+]"'</td>
</tr>
<tr>
<td class="mla-doc-table-label">posts_per_page_text</td>
<td>'posts_per_page="[+posts_per_page+]"'</td>
</tr>
<tr>
<td class="mla-doc-table-label">scheme</td>
<td>the HTTP protocol used to access the page; usually "http://" but might be "https://"</td>
</tr>
<tr>
<td class="mla-doc-table-label">http_host</td>
<td>contents of the <em>Host:</em> header of the current request; usually a domain name such as "mysite.com" or an IP address</td>
</tr>
<tr>
<td class="mla-doc-table-label">request_uri</td>
<td>the URI given to access the page, e.g., "wordpress/2013/06/sample-post" or "wordpress/tag-gallery-page?attachment_tag=sample". MLA manages pagination by adding the "mla_paginate_current" query parameter to the URI value</td>
</tr>
<tr>
<td class="mla-doc-table-label">new_url</td>
<td>concatenation of scheme + http_host + request_uri</td>
</tr>
</table>
<h4>Generalized paginated link list; the <code>paginate_links</code> output type</h4>
<p>
WordPress provides a function that "<em>can be used to create paginated link list for any area</em>." The "paginate_links" output type is modeled on this function and lets you generate a list of links for moving among "gallery pages".
</p>
<p>
The <strong>Page Selection Parameters</strong>, <strong>Gallery Display Content Parameters</strong> and <strong>Markup Substitution Parameters</strong> defined above also apply to the "paginate_links" output type. There are five additional parameters unique to this output type.
</p>
<h4>Specific parameters for the <code>paginate_links</code> output type</h4>
<table>
<tr>
<td class="mla-doc-table-label">mla_end_size</td>
<td>How many numbers (default 1) appear on either the start and the end list edges</td>
</tr>
<tr>
<td class="mla-doc-table-label">mla_mid_size</td>
<td>How many numbers (default 2) appear to either side of current page, but not including current page</td>
</tr>
<tr>
<td class="mla-doc-table-label">mla_prev_text</td>
<td>the "previous page" text (default "&laquo; Previous") , which appears when the ",prev_next" qualifier is added to the output_type</td>
</tr>
<tr>
<td class="mla-doc-table-label">mla_next_text</td>
<td>the "next page" text (default "Next &raquo;") , which appears when the ",prev_next" qualifier is added to the output_type</td>
</tr>
<tr>
<td class="mla-doc-table-label">mla_paginate_type</td>
<td>the format of the return value. "<strong>plain</strong>" (the default) returns a string with links separated by the newline character. "<strong>list</strong>" returns an unordered (ul) HTML list.</td>
</tr>
</table>
<p>If you code the "<strong>,show_all</strong>" qualifier, most of the above parameters have no effect; the "mla_paginate_type" parameter is the exception.
</p>
<h4>An example of the <code>paginate_links</code> output type</h4>
<p>
Expanding the "attachment tag gallery" example, you can select images using the MLA Att. Tag taxonomy and divide the  gallery into fixed-size pages. Following the main gallery shortcode is <strong>the second shortcode for the list of page links</strong>:
</p>
<code>
[mla_gallery attachment_tag="sample" posts_per_page=10 mla_caption="{+title+}"]
<br />&nbsp;<br />
[mla_gallery attachment_tag="sample" posts_per_page=10 mla_output="paginate_links,prev_next" mla_nolink_text='No Gallery Pages']<br />
</code>
<p>
This example is even simpler that the two earlier examples because there's just one additional <code>[mla_gallery]</code> shortcode for pagination links.
<a name="alt_shortcode"></a>
</p>
<p>
<a href="#backtotop">Go to Top</a>
</p>
<h3>Support for Other Gallery-generating Shortcodes</h3>
<p>
The <code>[mla_gallery]</code> shortcode can be used in combination with other gallery-generating shortcodes to give you the data selection power of <code>[mla_gallery]</code> and the formatting/display power of popular alternatives such as the WordPress.com Jetpack Carousel and Tiled Galleries modules. Any shortcode that accepts "ids=" or a similar parameter listing the attachment ID values for the gallery can be used. The <code>[mla_gallery]</code> code will compile the list of attachments for your gallery, then hand control over to the alternate shortcode to format the results. Note that MLA does not play any role in formatting the gallery display, so MLA-specific parameters such as <code>mla_caption</code> and <code>mla_link_href</code> are not processed. Five parameters implement this feature:
</p>
<table>
<tr>
<td class="mla-doc-table-label">mla_alt_shortcode</td>
<td>the name of the shortcode to be called for gallery format and display. You can code "no" (recommended) or "mla_gallery" (used by the Justified Image Grid plugin) to disable the alternate shortcode processing. To use <code>[mla_gallery]</code> as the alternate shortcode code "yes".</td>
</tr>
<tr>
<td class="mla-doc-table-label">mla_alt_parameters</td>
<td>(optional, default empty) parameters that would normally be processed by <code>[mla_gallery]</code> and not passed through to the alternate shortcode. For example, if the alternate shortcode is "mla_tag_cloud", "mla_term_list" or "mla_gallery" you might use this parameter to, for example, pass <code>post_mime_type=</code> or <code>mla_debug=</code> on to the alternate shortcode.</td>
</tr>
<tr>
<td class="mla-doc-table-label">mla_alt_ids_name</td>
<td>(optional, default "ids") the name of the parameter used to pass a list of attachment ID values to the alternate shortcode</td>
</tr>
<tr>
<td class="mla-doc-table-label">mla_alt_ids_template</td>
<td>(optional) a Content Template for the entire parameter value passed to the alternate shortcode. When processing the template, the list of ID values is available as the <code>{+alt_ids+}</code> substitution parameter. See the example below.</td>
</tr>
<tr>
<td class="mla-doc-table-label">mla_alt_ids_value</td>
<td>(optional) an item-specific substitution parameter, Content Template or other alternative for the attachment ID value(s) passed to the alternate shortcode. It is applied once for each item selected for the gallery, and all the item-specific substitution parameters are available to be used.</td>
</tr>
</table>
<p>
For example, if you want to select images using the MLA Att. Category taxonomy but want to display a "Tiled Mosaic" gallery, you can code:
</p>
<code>
[mla_gallery attachment_category=vegetable tax_operator="NOT IN" mla_alt_shortcode=gallery type="rectangular" mla_alt_ids_name=include]
</code>
<p>
This example selects all the images that are "NOT IN" the Att. Category "vegetable". The selected images are passed to the <code>[gallery]</code> shortcode in an "include" parameter, along with the "type=rectangular" parameter. The result is as if you had coded:
</p>
<code>
[gallery include="1,2,3" type="rectangular"]
</code>
<p>
In the above example, the <code>mla_alt_ids_name=include</code> parameter isn't really necessary, since the <code>[gallery]</code> shortcode accepts the "ids" parameter. It was included in the example just to show how the "mla_alt_ids_name" might be used for some other shortcode that requires a different name for the parameter.
</p>
<p>
You can pass any parameters you need through the <code>[mla_gallery]</code> shortcode and on to the alternate shortcode you're using. Here's another example, using the Photonic Gallery plugin:
</p>
<code>
[mla_gallery attachment_tag=fauna orderby=rand mla_alt_shortcode=gallery type=default style=strip-below slideshow_height=320 slide_size=medium]
</code>
<p>
Here, <code>[mla_gallery]</code> selects the images with an Att. Tag of "fauna" and sorts them in a random order. It then calls on the <code>[gallery]</code> shortcode (which Photonic also uses), as if you had coded:
</p>
<code>
[gallery ids="3,1,4,2,7" type=default style=strip-below slideshow_height=320 slide_size=medium]
</code>
<p>
Photonic recognizes the <code>type=default</code> parameter and takes over, using the other three parameters to format its results. This example is a less convenient but more flexible alternative to the native Photonic support built-in to <code>[mla_gallery]</code> (see next section).
</p>
<p>
The next example selects one PDF document at random and uses the <a href="https://wordpress.org/plugins/pdf-embedder/" title="PDF Embedder plugin" target="_blank">PDF Embedder</a> plugin to display the document content. The <code>mla_alt_ids_name</code> and <code>mla_alt_ids_value</code> parameters change the "ids" and attachment ID defaults to the "url" and file URL values expected by the <code>[pdf-embedder]</code> shortcode.
</p>
<code>
[mla_gallery post_mime_type="application/pdf" orderby=rand numberposts=1 mla_alt_shortcode=pdf-embedder mla_alt_ids_name=url mla_alt_ids_value="{+filelink_url+}"]
</code>
<p>
The next example selects items assigned to a taxonomy term and uses the <a href="https://wordpress.org/plugins/shortcodes-ultimate/" title="Shortcodes Ultimate plugin" target="_blank">Shortcodes Ultimate</a> plugin's <a href="https://getshortcodes.com/shortcodes/custom_gallery/" title="Custom Gallery shortcode" target="_blank">Custom gallery</a> shortcode to display the gallery with a lightbox enhancement. The <code>mla_alt_ids_name</code> and <code>mla_alt_ids_template</code> parameters change the "ids" and attachment ID defaults to the "source" and "media:" values expected by the <code>[su_custom_gallery]</code> shortcode.
</p>
<code>
[mla_gallery attachment_category=accipitridae link="lightbox" mla_alt_shortcode="su_custom_gallery" mla_alt_ids_name="source" mla_alt_ids_template="media: {+alt_ids+}"]
</code>
<p>
You can also use the "enclosing shortcode" form if the alternate shortcode, such as Fullscreen Galleria's "fsg_link", requires it. You would code this form as:
</p>
<code>
[mla_gallery ids="1,2,3" mla_alt_shortcode=fsg_link mla_alt_ids_name=include class=button]View the gallery[/mla_gallery]
</code>
<p>If you mix the self-closing and enclosing versions of <code>[mla_gallery]</code> on one post/page you must use the "xhtml-style closing shortcodes like [mla_gallery /]" for the self-closing shortcodes.
</p>
<p>
<strong>NOTE:</strong> When you use "mla_alt_shortcode" to pass format/display responsibility off to another shortcode you will lose the <code>[mla_gallery]</code> Gallery Display Style (e.g. "mla_float") and Gallery Display Content (e.g. "mla_caption") parameters. There is no reliable way for <code>[mla_gallery]</code> to pass this information on to the other shortcode you've specified.
<a name="photonic_gallery"></a>
</p>
<p>
<a href="#backtotop">Go to Top</a>
</p>
<h3>Support for the &#8220;Photonic Gallery for Flickr, Picasa, SmugMug, 500px and Instagram&#8221; Plugin</h3>
<p>
The <a href="http://wordpress.org/extend/plugins/photonic/" title="Photonic Gallery plugin directory page" target="_blank">Photonic Gallery for Flickr, Picasa, SmugMug, 500px and Instagram</a> plugin adds several new parameters to the <code>[mla_gallery]</code> shortcode to enhance your galleries. All you have to do is install the plugin, then add a "style=" parameter to your <code>[mla_gallery]</code> shortcode to use the Photonic styling and markup in place of the native <code>[mla_gallery]</code> style and markup templates.
</p>
<p>
You can use the "Photonic" screen of the Insert Media dialog to build the display portion of your shortcode parameters. After you click "Insert into post", change the shortcode name from "gallery" to "mla_gallery" and add the query parameters you need to select the attachments for the gallery. The <code>[mla_gallery]</code> code will compile the list of attachments for your gallery, then hand control over to Photonic to format the results. Note that MLA does not play any role in formatting the gallery display, so MLA-specific parameters such as <code>mla_caption</code> and <code>mla_link_href</code> are not processed.
<a name="justified_image_grid"></a>
</p>
<p>
<a href="#backtotop">Go to Top</a>
</p>
<h3>Support for the &#8220;Justified Image Grid&#8221; Plugin</h3>
<p>
<a href="https://justifiedgrid.com/" title="Justified Image Grid site" target="_blank">Justified Image Grid</a> (JIG) is an inexpensive premium plugin that renders a spectacular horizontal masonry grid for a simple to browse and easy to use gallery. It includes several lightboxes for highlighting individual images. 
</p>
<p>
This section should really be titled "JIG's support for MLA" because JIG includes explicit support for filtering a gallery by selecting terms from MLA's Att. Categories and Att. Tags taxonomies. Look for the <code>image_categories</code>, <code>image_tags</code> and <code>filterby</code> parameters of the <code>[justified_image_grid]</code> shortcode.
</p>
<p>
You can also set a JIG option to "Use JIG as MLA display (automatically take over)". Activate that option if you wish to automatically use Justified Image Grid in place of your current Media Library Assistant galleries (<code>[mla_gallery]</code>). Useful for already established galleries. You can use or disable JIG display individually by adding just <code>mla_alt_shortcode=justified_image_grid</code> or <code>mla_alt_shortcode=no</code> to any MLA shortcode, respectively. 
</p>
<p>
Of course, you can always use MLA's <code>[mla_tag_cloud}</code>, <code>[mla_term_list}</code> and <code>[mla_gallery}</code>, shortcodes for more complex item selection applications such as custom field or date queries, or multi-taxonomy queries. Adding <code>mla_alt_shortcode=justified_image_grid</code> to the <code>[mla_gallery}</code> shortcode will pass a list of the selected items to JIG for formatting and displaying the resulting gallery. You can add any JIG-specific parameters to the shortcode and they will be passed along as well.
</p>
<p>
<a name="real_media_library"></a>
</p>
<p>
<a href="#backtotop">Go to Top</a>
</p>
<h3>Support for the &#8220;Real Media Library&#8221; Plugin</h3>
<p>
The <a href="https://wordpress.org/plugins/real-media-library-lite/" title="Real Media Library plugin directory page" target="_blank">WordPress Real Media Library: Media Library Folder & File Manager</a> plugin helps you with media management. Organize thousands of uploaded files into folders, collections and galleries. You can add parameters to the <code>[mla_gallery]</code> shortcode to filter the gallery display by a specific RML folder, collection or gallery ID. There are three <code>[mla_gallery]</code> shortcode parameters for this purpose:
</p>
<table>
<tr>
<td class="mla-doc-table-label">mla_rml_folder</td>
<td>the ID of the RML folder, collection or gallery from which to source items for the gallery display. You can find the ID of a folder easily in your media library. Simply select a folder, afterwards click the three-dots icon in the folder toolbar. A dialog opens and in the bottom right corner you can find a number which represents the folder ID.</td>
</tr>
<tr>
<td class="mla-doc-table-label">mla_rml_include_children</td>
<td>"false" (the default) to restrict the potential items to the specific folder or gallery named in the <code>mla_rml_folder</code> parameter. Set it to "true" to include items in folders contained in the specific folder or collection named in the shortcode.</td>
</tr>
<tr>
<td class="mla-doc-table-label">mla_allow_rml</td>
<td>(optional) "false" (the default) to remove the RML parameters from <code>[mla_gallery]</code> database queries. "true" to preserve the parameters. This parameter is only useful for performance testing purposes. It is automatically set to "true" if the <code>mla_rml_folder</code> parameter is present. You can safely ignore it.</td>
</tr>
</table>
<p>
You can use the other <code>[mla_gallery]</code> data selection parameters to further refine your query. For example, you can use <code>post_mime_type=application/pdf</code> to display only the PDF documents in a folder, or use <code>application_category=abc</code> to display only the images assigned to Att. Category "abc" in an RML gallery.
<a name="catfolders"></a>
</p>
<p>
<a href="#backtotop">Go to Top</a>
</p>
<h3>Support for the &#8220;CatFolders – WP Media Folders&#8221; Plugin</h3>
<p>
The <a href="https://wordpress.org/plugins/catfolders/" title="CatFolders – WP Media Folders plugin directory page" target="_blank">CatFolders – WP Media Folders</a> free/lite and pro plugins help you categorize media files better and faster. You can add a parameter to the <code>[mla_gallery]</code> shortcode to filter the gallery display by a specific folder ID. There is one <code>[mla_gallery]</code> shortcode parameter for this purpose:
</p>
<table>
<tr>
<td class="mla-doc-table-label">mla_catf_folder</td>
<td>the name of the folder from which to source items for the gallery display. To find the ID of a folder, right-click on the folder name to display the context menu, then click "Properties". In the Image Folder display you will see the folder ID. For the <code>mla_catf_folder</code> value do not include the pound sign ('#'), just the folder number.</td>
</tr>
</table>
<p>
You can use the other <code>[mla_gallery]</code> data selection parameters to further refine your query. For example, you can use <code>post_mime_type=application/pdf</code> to display only the PDF documents in a folder, or use <code>application_category=abc</code> to display only the images assigned to Att. Category "abc" in the folder.
<a name="mla_gallery_templates"></a>
</p>
<p>
<a href="#backtotop">Go to Top</a>
</p>
<h3>Style and Markup Templates</h3>
<p>
The Style and Markup templates give you great flexibility for the content and format of each <code>[mla_gallery]</code> or <code>[mla_tag_cloud]</code> (list and grid formats). You can define as many templates as you need.
</p>
<p>
Style templates provide gallery-specific (or cloud-specific) CSS inline styles (you can code <code>mla_style=none</code> to suppress the addition of CSS inline styles entirely). Markup templates provide the HTML markup for 1) the beginning of the gallery, 2) the beginning of each row, 3) each gallery item, 4) the end of each row and 5) the end of the gallery. The attachment-specific markup parameters let you choose among most of the attachment fields, not just the caption.
</p>
<p>
The MLA Gallery tab on the Settings page lets you add, change and delete custom templates. The default templates are also displayed on this tab for easy reference. You can find a custom template example with step-by-step instructions in <a href="#mla_table_example"><strong>A Table-based Style and Markup Template Example</strong></a> below.
</p>
<p>
In a template, substitution parameters are surrounded by opening ('[+') and closing ('+]') delimiters to separate them from the template text; see the default templates for many examples.
<a name="argument_parameters"></a>
</p>
<h4>Argument Substitution Parameters</h4>
<p>
A markup template can include default values for any of the shortcode parameters and values you define for your own use, e.g., you can add <code>columns=1</code> to the arguments section to change the MLA default value whenever the template is used. The argument substitution parameter(s) you define in the markup template are treated as if you had added them to the shortcode that uses the template, but parameters you actually use in the shortcode will overide the default values you code in the arguments section. For example, if the arguments section of your "blue-table" markup template looks like:
</p>
<code>columns=1 div-class=blue div-id=id3</code>
<p>
and your shortcode is
</p>
<p>
<code>[mla_gallery mla_markup=blue-table div-id=ID5]</code>
</p>
<p>
the end result will be as if you had coded
</p>
<p>
<code>[mla_gallery mla_markup=blue-table div-id=ID5 columns=1 div-class=blue]</code>
</p>
<p>
The custom parameters you code in the arguments section become part of the shortcode parameters. To access them in your template or in other shortcode parameters you must use the 'query:' prefix, e.g., <code>[+query:div-class+]</code> in the template or <code>{+query:div-id+}</code> in another shortcode parameter.
</p>
<p>
In the arguments section you can separate the parameters with one or more spaces or you can code them on separate lines. If your parameter value includes spaces you must enclose it in single or double quotes.
<a name="gallery_specific"></a>
</p>
<h4>Gallery-specific Substitution Parameters</h4>
<p>
Gallery-specific substitution parameters are known at the beginning of shortcode processing and they do not change during processing. They can be used, for example, in any of the data selection parameters to change the items selected for the gallery based on information about the post/page on which the gallery appears. The gallery-specific substitution parameters are:
</p>
<table>
<tr>
<td class="mla-doc-table-label">site_url</td>
<td>absolute URL to the site directory, without trailing slash</td>
</tr>
<tr>
<td class="mla-doc-table-label">base_url</td>
<td>absolute URL to the upload directory, without trailing slash</td>
</tr>
<tr>
<td class="mla-doc-table-label">base_dir</td>
<td>absolute (full) path to the upload directory, without trailing slash</td>
</tr>
<tr>
<td class="mla-doc-table-label">instance</td>
<td>starts at '1', incremented for each additional shortcode in the post/page</td>
</tr>
<tr>
<td class="mla-doc-table-label">selector</td>
<td>"mla_gallery-{$instance}", e.g., mla_gallery-1</td>
</tr>
<tr>
<td class="mla-doc-table-label">page_ID,<br />id</td>
<td style="vertical-align: top">the <code>ID</code> value of the post/page in which the gallery appears</td>
</tr>
<tr>
<td class="mla-doc-table-label">page_author</td>
<td>the <code>post_author</code> value of the post/page in which the gallery appears</td>
</tr>
<tr>
<td class="mla-doc-table-label">page_date</td>
<td>the <code>post_date</code> value of the post/page in which the gallery appears</td>
</tr>
<tr>
<td class="mla-doc-table-label">page_content</td>
<td>the <code>post_content</code> value of the post/page in which the gallery appears</td>
</tr>
<tr>
<td class="mla-doc-table-label">page_title</td>
<td>the <code>post_title</code> value of the post/page in which the gallery appears</td>
</tr>
<tr>
<td class="mla-doc-table-label">page_excerpt</td>
<td>the <code>post_excerpt</code> value of the post/page in which the gallery appears</td>
</tr>
<tr>
<td class="mla-doc-table-label">page_status</td>
<td>the <code>post_status</code> value of the post/page in which the gallery appears</td>
</tr>
<tr>
<td class="mla-doc-table-label">page_name</td>
<td>the <code>post_name</code> value of the post/page in which the gallery appears</td>
</tr>
<tr>
<td class="mla-doc-table-label">page_modified</td>
<td>the <code>post_modified</code> value of the post/page in which the gallery appears</td>
</tr>
<tr>
<td class="mla-doc-table-label">page_parent</td>
<td>the <code>post_parent</code> value of the post/page in which the gallery appears</td>
</tr>
<tr>
<td class="mla-doc-table-label">page_guid</td>
<td>the <code>post_guid</code> value of the post/page in which the gallery appears</td>
</tr>
<tr>
<td class="mla-doc-table-label">page_type</td>
<td>the <code>post_type</code> value of the post/page in which the gallery appears</td>
</tr>
<tr>
<td class="mla-doc-table-label">page_mime_type</td>
<td>the <code>post_mime_type</code> value of the post/page in which the gallery appears</td>
</tr>
<tr>
<td class="mla-doc-table-label">page_url</td>
<td>absolute URL to the page or post on which the gallery appears, if any, with trailing slash</td>
</tr>
</table>
<p>
If the shortcode is executed when there is no current post, an artificial "empty post" is used to supply reasonable default values. One special case is the "Author Archive" page when the author has no posts. In this case, an atrificial "author post" supplies a few values based on the author's user information. The available values are:</p>
<table>
<tr>
<td class="mla-doc-table-label">page_ID,<br />id</td>
<td style="vertical-align: top">the author's user <code>ID</code> value</td>
</tr>
<tr>
<td class="mla-doc-table-label">page_author</td>
<td>the author's user <code>ID</code> value</td>
</tr>
<tr>
<td class="mla-doc-table-label">page_content</td>
<td>the author's <code>description</code> value</td>
</tr>
<tr>
<td class="mla-doc-table-label">page_title</td>
<td>the author's <code>display_name</code> value</td>
</tr>
<tr>
<td class="mla-doc-table-label">page_excerpt</td>
<td>the author's <code>nickname</code> value</td>
</tr>
<tr>
<tr>
<td class="mla-doc-table-label">page_name</td>
<td>the author's <code>user_nicename</code> value</td>
</tr>
<tr>
<tr>
<td class="mla-doc-table-label">page_type</td>
<td>"author"</td>
</tr>
</table>
<a name="mla_style_parameters"></a>&nbsp;
<p>
<a href="#backtotop">Go to Top</a>
</p>
<h4>Substitution parameters for style templates</h4>
All of the <a href="#gallery_specific">gallery-specific substitution parameters</a> are available for use in style templates. These additional substitution parameters are also available:
<table>
<tr>
<td class="mla-doc-table-label">mla_style</td>
<td>shortcode parameter, default = 'default'</td>
</tr>
<tr>
<td class="mla-doc-table-label">mla_markup</td>
<td>shortcode parameter, default = 'default'</td>
</tr>
<tr>
<td class="mla-doc-table-label">itemtag</td>
<td>shortcode parameter, default = 'dl', or 'figure' for HTML5 themes</td>
</tr>
<tr>
<td class="mla-doc-table-label">icontag</td>
<td>shortcode parameter, default = 'dt', or 'div' for HTML5 themes</td>
</tr>
<tr>
<td class="mla-doc-table-label">captiontag</td>
<td>shortcode parameter, default = 'dd', or 'figcaption' for HTML5 themes</td>
</tr>
<tr>
<td class="mla-doc-table-label">columns</td>
<td>shortcode parameter, default = '3'</td>
</tr>
<tr>
<td class="mla-doc-table-label">itemwidth</td>
<td>shortcode parameter, default is calculated by dividing 100% by the number of columns and subtracting twice the margin value, e.g., 30.3% for three columns and a margin value of 1.5%. Can also contain other dimensional values such as '10px' or CSS-specific values like 'auto' or 'inherit'.</td>
</tr>
<tr>
<td class="mla-doc-table-label">margin</td>
<td>shortcode parameter, default = '1.5%'. Can also contain other dimensional values such as '10px' or CSS-specific values like 'auto' or 'inherit'.</td>
</tr>
<tr>
<td class="mla-doc-table-label">float</td>
<td>'right' if current locale is RTL, 'left' if not</td>
</tr>
<tr>
<td class="mla-doc-table-label">size_class</td>
<td>shortcode 'size' parameter, default = 'thumbnail'</td>
</tr>
<tr>
<td class="mla-doc-table-label">found_rows</td>
<td>the total number of items in the gallery before considering pagination parameters</td>
</tr>
<tr>
<td class="mla-doc-table-label">current_rows</td>
<td>the number of items in the current page of the gallery, considering any pagination parameters</td>
</tr>
<tr>
<td class="mla-doc-table-label">max_num_pages</td>
<td>the number of pages in the gallery</td>
</tr>
</table>
<a name="mla_markup_parameters"></a>
&nbsp;
<p>
<a href="#backtotop">Go to Top</a>
</p>
<h4>Substitution parameters for markup templates</h4>
<p>
All of the <a href="#gallery_specific">gallery-specific substitution parameters</a> and the  <a href="#mla_style_parameters">Substitution parameters for style templates</a> are available for use in markup templates. There are no additional substitution parameters defined at the start of markup processing, but there are <a href="#mla_gallery_hooks">MLA Gallery Filters (Hooks)</a> that could add, modify or delete parameters available for markup processing, if your application uses them.
<a name="mla_attachment_parameters"></a>
</p>
<p>
<a href="#backtotop">Go to Top</a>
</p>
<h4>Attachment-specific substitution parameters for the markup template Item part</h4>
<p>
These substitution parameters are only available in the "Item" part of the markup template, since they require an attachment for their data source. In addition to the parameters in the list below, you can use any of the <a href="#field_level_data_sources">Data sources for custom field mapping</a> (except "None", "Metadata" and "Template").
</p>
<p>
You may need to append one of the <a href="#field_level_formats">format options</a> to the name depending on the context in which the substitution parameter is used. If you need both the native format and the altered format, simply wrap the altered format in a content template, e.g., <code>[+template:([+width,commas+])+]</code>. The template will prevent the native value from being over-written with the formatted value.
</p>
<p>
The item-level substitution parameter names are:
</p>
<table>
<tr>
<td class="mla-doc-table-label">index</td>
<td>starts at '1', incremented for each attachment in the gallery</td>
</tr>
<tr>
<td class="mla-doc-table-label">last_in_row</td>
<td>set to "last_in_row" for the last item in each full gallery row, and to an empty string for all other items in the row. If the gallery ends with a partial row, the last_in_row parameter is not set.</td>
</tr>
<tr>
<td class="mla-doc-table-label">caption</td>
<td>if captiontag is not empty, contains caption/post_excerpt</td>
</tr>
<tr>
<td class="mla-doc-table-label">captiontag_content</td>
<td>if both captiontag and caption are not empty, contains the complete HTML markup for the caption. This can be used to omit empty tags (as it is in the default template).</td>
</tr>
<tr>
<td class="mla-doc-table-label">excerpt</td>
<td>always contains post_excerpt</td>
</tr>
<tr>
<td class="mla-doc-table-label">attachment_ID</td>
<td>attachment post ID</td>
</tr>
<tr>
<td class="mla-doc-table-label">mime_type</td>
<td>attachment post_mime_type</td>
</tr>
<tr>
<td class="mla-doc-table-label">menu_order</td>
<td>attachment menu_order</td>
</tr>
<tr>
<td class="mla-doc-table-label">date</td>
<td>attachment post_date</td>
</tr>
<tr>
<td class="mla-doc-table-label">modified</td>
<td>attachment post_modified</td>
</tr>
<tr>
<td class="mla-doc-table-label">parent</td>
<td>attachment post_parent (ID)</td>
</tr>
<tr>
<td class="mla-doc-table-label">parent_name</td>
<td>post_name of the parent, or an empty string</td>
</tr>
<tr>
<td class="mla-doc-table-label">parent_title</td>
<td>post_title of the parent, or '(unattached)'</td>
</tr>
<tr>
<td class="mla-doc-table-label">parent_type</td>
<td>'post', 'page' or custom post type of the parent</td>
</tr>
<tr>
<td class="mla-doc-table-label">parent_date</td>
<td>upload date of the parent</td>
</tr>
<tr>
<td class="mla-doc-table-label">parent_permalink</td>
<td>permalink to the parent</td>
</tr>
<tr>
<td class="mla-doc-table-label">title</td>
<td>attachment post_title</td>
</tr>
<tr>
<td class="mla-doc-table-label">slug</td>
<td>attachment post_name</td>
</tr>
<tr>
<td class="mla-doc-table-label">width</td>
<td>width in pixels, for image types</td>
</tr>
<tr>
<td class="mla-doc-table-label">height</td>
<td>height in pixels, for image types</td>
</tr>
<tr>
<td class="mla-doc-table-label">orientation</td>
<td>"portrait" (height > width) or "landscape", for image types; empty for non-image types</td>
</tr>
<tr>
<td class="mla-doc-table-label">image_meta</td>
<td>image metadata, for image types</td>
</tr>
<tr>
<td class="mla-doc-table-label">image_alt</td>
<td>ALT text, for image types. If there are multiple values (unlikely) only the first value is available. If you need to process multiple values, use the field-level data source "alt_text".</td>
</tr>
<tr>
<td class="mla-doc-table-label">base_file</td>
<td>path and file name relative to uploads directory</td>
</tr>
<tr>
<td class="mla-doc-table-label">path</td>
<td>path portion of base_file</td>
</tr>
<tr>
<td class="mla-doc-table-label">file</td>
<td>file name portion of base_file</td>
</tr>
<tr>
<td class="mla-doc-table-label">description</td>
<td>attachment post_content</td>
</tr>
<tr>
<td class="mla-doc-table-label">file_url</td>
<td>attachment guid; full path and file name in URL format</td>
</tr>
<tr>
<td class="mla-doc-table-label">author_id</td>
<td>attachment post_author</td>
</tr>
<tr>
<td class="mla-doc-table-label">author</td>
<td>author display_name, or 'unknown'</td>
</tr>
<tr>
<td class="mla-doc-table-label">link</td>
<td>hyperlink to the attachment page (default) or file (shortcode 'link' parameter = "file")</td>
</tr>
<tr>
<td class="mla-doc-table-label">pagelink</td>
<td>always contains a hyperlink to the attachment page</td>
</tr>
<tr>
<td class="mla-doc-table-label">filelink</td>
<td>always contains a hyperlink to the attachment file</td>
</tr>
<tr>
<td class="mla-doc-table-label">downloadlink</td>
<td>always contains a hyperlink to the MLA file downloader for this attachment</td>
</tr>
<tr>
<td class="mla-doc-table-label">transferlink</td>
<td>always contains a hyperlink to the <a href="#named_transfer">Transfer by Item Name</a> handler for this attachment</td>
</tr>
<tr>
<td class="mla-doc-table-label">link_url</td>
<td>the URL portion of <em>link</em></td>
</tr>
<tr>
<td class="mla-doc-table-label">pagelink_url</td>
<td>the URL portion of <em>pagelink</em></td>
</tr>
<tr>
<td class="mla-doc-table-label">filelink_url</td>
<td>the URL portion of <em>filelink</em></td>
</tr>
<tr>
<td class="mla-doc-table-label">downloadlink_url</td>
<td>the URL portion of <em>downloadlink</em></td>
</tr>
<tr>
<td class="mla-doc-table-label">transferlink_url</td>
<td>the URL portion of <em>transferlink</em></td>
</tr>
<tr>
<td class="mla-doc-table-label">thumbnail_content</td>
<td>complete content of the gallery item link. This will either be an "&lt;img ... &gt;" tag<br />or a text string for non-image items</td>
</tr>
<tr>
<td class="mla-doc-table-label">thumbnail_width</td>
<td>for image/icon items, width of the gallery image/icon</td>
</tr>
<tr>
<td class="mla-doc-table-label">thumbnail_height</td>
<td>for image/icon items, height of the gallery image/icon</td>
</tr>
<tr>
<td class="mla-doc-table-label">thumbnail_url</td>
<td>for image/icon items, URL of the gallery image/icon</td>
</tr>
<tr>
<td class="mla-doc-table-label">icon_pagelink</td>
<td>contains a hyperlink to the attachment page with the item's MIME type icon in place of the thumbnail image</td>
</tr>
<tr>
<td class="mla-doc-table-label">icon_filelink</td>
<td>contains a hyperlink to the attachment file with the item's MIME type icon in place of the thumbnail image</td>
</tr>
<tr>
<td class="mla-doc-table-label">icon_img</td>
<td>contains an IMG tag with the item's MIME type icon</td>
</tr>
<tr>
<td class="mla-doc-table-label">icon_src</td>
<td>contains the SRC portion of <em>icon_img</em></td>
</tr>
</table>
<h4>Field-level substitution parameters for the markup template Item part</h4>
<p>
You can use the <a href="#mla_variable_parameters"><strong>field-level substitution parameters</strong></a> in the item part to draw data from a wide variety of sources and format it as required. See that section of the Documentation for more information.
<a name="mla_table_example"></a>
</p>
<p>
<a href="#backtotop">Go to Top</a>
</p>
<h3>A Table-based Style and Markup Template Example</h3>
<p>
Here's a small example that shows a gallery using <code>&lt;table&gt;</code> markup.
The Item markup section shows how to use the "terms", "custom", "iptc" and "exif" substitution parameters.
</p>
<h4>Style Template</h4>
<code>
&lt;style type='text/css'&gt;<br />
&nbsp;&nbsp;#[+selector+] {<br />
&nbsp;&nbsp;&nbsp;&nbsp;margin: auto;<br />
&nbsp;&nbsp;}<br />
&nbsp;&nbsp;#[+selector+] .gallery-row {<br />
&nbsp;&nbsp;&nbsp;&nbsp;float: [+float+];<br />
&nbsp;&nbsp;&nbsp;&nbsp;margin-top: 10px;<br />
&nbsp;&nbsp;&nbsp;&nbsp;border-top: 1px solid #ddd;<br />
&nbsp;&nbsp;&nbsp;&nbsp;text-align: center;<br />
&nbsp;&nbsp;&nbsp;&nbsp;width: [+itemwidth+]%;<br />
&nbsp;&nbsp;}<br />
&nbsp;&nbsp;#[+selector+] .gallery-row td.gallery-icon {<br />
&nbsp;&nbsp;&nbsp;&nbsp;width: 60;<br />
&nbsp;&nbsp;&nbsp;&nbsp;height: 60;<br />
&nbsp;&nbsp;&nbsp;&nbsp;vertical-align: top;<br />
&nbsp;&nbsp;}<br />
&nbsp;&nbsp;#[+selector+] .gallery-row .gallery-icon img {<br />
&nbsp;&nbsp;&nbsp;&nbsp;border: 2px solid #cfcfcf;<br />
&nbsp;&nbsp;}<br />
&nbsp;&nbsp;#[+selector+] .gallery-caption {<br />
&nbsp;&nbsp;&nbsp;&nbsp;margin-left: 0;<br />
&nbsp;&nbsp;&nbsp;&nbsp;vertical-align: top;<br />
&nbsp;&nbsp;}<br />
&lt;/style&gt;
</code>
<h4>Markup Template</h4>
<table width="700" border="0" cellpadding="5">
	<tr>
		<td style="vertical-align: top; font-weight:bold">Open</td>
		<td><code>&lt;table id='[+selector+]' class='gallery galleryid-[+id+]<br />gallery-columns-[+columns+] gallery-size-[+size_class+]'&gt;</code></td>
	</tr>
	<tr>
		<td style="vertical-align: top; font-weight:bold">Row Open</td>
		<td><code>&lt;tr class='gallery-row'&gt;</code></td>
	</tr>
	<tr>
		<td style="vertical-align: top; font-weight:bold">Item</td>
		<td><code>&lt;td class='gallery-icon'&gt;<br />
		&nbsp;&nbsp;&nbsp;&nbsp;[+link+]<br />
	&lt;/td&gt;<br />
	&lt;td class='wp-caption-text gallery-caption'&gt;<br />
		&nbsp;&nbsp;&nbsp;&nbsp;&lt;strong&gt;[+title+]&lt;/strong&gt;&lt;br /&gt;<br />
		&nbsp;&nbsp;&nbsp;&nbsp;[+description+]&lt;br /&gt;<br />
		&nbsp;&nbsp;&nbsp;&nbsp;[+date+]<br />
		&nbsp;&nbsp;&nbsp;&nbsp;[+custom:client,single+]<br />
		&nbsp;&nbsp;&nbsp;&nbsp;[+terms:category+]<br />
		&nbsp;&nbsp;&nbsp;&nbsp;[+iptc:caption-or-abstract+]<br />
		&nbsp;&nbsp;&nbsp;&nbsp;[+iptc:2#025,single+]<br />
		&nbsp;&nbsp;&nbsp;&nbsp;[+exif:Artist+]
	&lt;/td&gt;</code>
</td>
	</tr>
	<tr>
		<td style="vertical-align: top; font-weight:bold">Row Close</td>
		<td><code>&lt;/tr&gt;</code></td>
	</tr>
	<tr>
		<td style="vertical-align: top; font-weight:bold">Close</td>
		<td><code>&lt;/table&gt;</code></td>
	</tr>
</table>
<p>
To create the custom templates, follow the steps below. To define the custom style template:
</p>
<ol>
<li>Navigate to the Settings/Media Library Assistant Shortcodes tab.</li>
<li>Click on the "Style" view just above the templates table.</li>
<li>Hover over the "default (default)" Style entry (for the Gallery shortcode) and click the "Copy" action link.</li>
<li>When the page refreshes, the "Edit Template" screen will appear.</li>
<li>Change the template Name to (for example) "cat-styles".</li>
<li>Copy the template above and paste it into the "Styles" text box.</li>
<li>Review the content to make sure all the HTML and CSS markup is valid and not corrupted by the copy process.</li>
<li>Scroll to the bottom and click "Update" to save your template.</li>
</ol>
<p>
Markup templates are a bit more complicated because they have five parts, but the process is similar. 
To define the custom markup template:
</p>
<ol>
<li>Navigate to the Settings/Media Library Assistant Shortcodes tab.</li>
<li>Click the "Add New Template" button to the left of the table views.</li>
<li>Change the "select template type" dropdown control to "Markup".</li>
<li>Change the "select template shortcode" dropdown control to "Gallery".</li>
<li>Copy the template parts from the above example and paste them into the corresponding part text boxes.</li>
<li>Review the content to make sure all the HTML and CSS markup is valid and not corrupted by the copy process.</li>
<li>Scroll to the bottom and click "Add Template".</li>
</ol>
<p>
Once you have defined and saved your custom templates you can change your shortcode to use the templates:<br />
&nbsp;<br />
<code>[mla_gallery ... mla_style=table-style mla_markup=table-markup]</code><br />
&nbsp;<br />
It's a bit of work, but you only have to do it once.
<a name="mla_variable_parameters"></a>
</p>
<p>
<a href="#backtotop">Go to Top</a>
</p>
<h3>Field-level Substitution Parameters</h3>
<p>
Field-level substitution parameters let you access query arguments, custom fields, taxonomy terms and attachment metadata for display in an MLA gallery or in an MLA tag cloud. You can also use them in IPTC/EXIF/WP or Custom Field mapping rules. For field-level parameters, the value you code within the surrounding the ('[+' and '+]' or '{+' and '+}') delimiters has three parts; the prefix, the field name (or template content) and, if desired, an option/format value.
</p>
<table>
	<tr>
		<td class="mla-doc-table-label">prefix</td>
		<td>defines which type of field-level data you are accessing. It must immediately follow the opening ('[+' or '{+') delimiter and end with a colon (':'). There can be no spaces in this part of the parameter.</td>
	</tr>
	<tr>
		<td class="mla-doc-table-label">field name</td>
		<td>defines which field-level data element you are accessing. It must immediately follow the colon (':'). There can be no spaces between the colon and the field name. Spaces are allowed within the field name to accommodate custom field names that contain them.<br />
		&nbsp;<br />
		 <strong>Compound names</strong> are used to access elements within arrays, e.g., <code>sizes.thumbnail.file</code> is used to specify the file name for the thumbnail version of an image. You can also use a "*" placeholder to denote "all elements at this level" and return an array of lower-level elements. For example, you can code <code>sizes.*.file</code> to return an array of file names for all of the image's intermediate sizes.<br />
		&nbsp;<br />
		 For the "<strong>template</strong>" prefix, the field name is replaced by the template content; see the <a href="#mla_template_parameters">Content Templates</a> section for details.<br />
		&nbsp;</td>
	</tr>
	<tr>
		<td class="mla-doc-table-label">option/format value</td>
		<td>if present, immediately follows the field name using a comma (,) separator and ends with the closing delimiter ('+]' or '+}'). There can be no spaces in this part of the parameter.</td>
	</tr>
</table>
<p>
The next sections define each of the prefix and option/format values. 
<a name="field_level_prefixes"></a>
</p>
<h4>Prefix values</h4>
<p>
There are twenty prefix values for field-level parameters. Prefix values must be coded as shown; all lowercase letters.
</p>
<table>
	<tr>
		<td class="mla-doc-table-label">template</td>
		<td>A Content Template, which lets you compose a value from multiple substitution parameters and test for empty values, choosing among two or more alternatives or suppressing output entirely. See the <a href="#mla_template_parameters">Content Templates</a> section for details. Note that the formatting option is not supported for templates.</td>
	</tr>
	<tr>
		<td class="mla-doc-table-label">request</td>
		<td>The parameters defined in the <code>$_REQUEST</code> array; the "query strings" sent from the browser. The PHP $_REQUEST variable is a superglobal Array that contains the contents of both $_GET, $_POST and $_COOKIE arrays. It can be used to collect data sent with both the GET and POST methods. For example, if the URL is <code>http://www.mysite.com/mypage?myarg=myvalue</code> you can access the query string as <code>[+request:myarg+]</code>, which has the value "myvalue".</td>
	</tr>
	<tr>
		<td class="mla-doc-table-label">query</td>
		<td>The parameters defined in the <code>[mla_gallery]</code> shortcode. For example, if your shortcode is <code>[mla_gallery attachment_tag=my-tag div-class=some_class]</code> you can access the parameters as <code>[+query:attachment_tag+]</code> and <code>[+query:div-class+]</code> respectively. Only the parameters actually present in the shortcode are accessible; default values for parameters not actually present are not available. You can define your own parameters, e.g., "div-class"; they will be accessible as field-level data but will otherwise be ignored.</td>
	</tr>
	<tr>
		<td class="mla-doc-table-label">meta</td>
		<td>WordPress attachment metadata, if any, embedded in the image/audio/video file. For this category, you can code any of the field names embedded in the _wp_attachment_metadata array. The "Attachment Metadata" display in the Media/Edit Media screen will show you the names and values of these fields. Note that the fields available differ among image, audio and video attachments.<br />
		&nbsp;<br />
		The "image_meta" portion of the attachment metadata is of particular interest. This array contains some "extended image metadata" drawn from IPTC and EXIF fields by WordPress and improved a bit. You can find more information in the Codex <a href="http://codex.wordpress.org/Function_Reference/wp_read_image_metadata" title="Codex information for image_meta" target="_blank">Function Reference/wp read image metadata</a>. For example, to get the ISO speed rating for an image, code <code>[+meta:image_meta.iso+]</code>.</td>
	</tr>
	<tr>
		<td class="mla-doc-table-label">custom,<br />page_custom,<br />parent_custom</td>
		<td>WordPress Custom Fields, which you can define and populate on the Edit Media screen or map from various sources on the Settings/Media Library Assistant Custom and IPTC/EXIF/WP tabs. The "custom" prefix acts on the attachment itself, "page_custom" acts on the post/page in which the shortcode occurs, and "parent_custom" acts on the attachment's parent, if any. Note that "page_custom" is useful only for shortcodes; it has no values in mapping rules.
		<br />&nbsp;<br />
		The field name, or key, can contain spaces and some punctuation characters. You <strong><em>cannot use the plus sign ('+')</em></strong> in a field name you want to use with <code>[mla_gallery]</code>. Custom field names are case-sensitive; "client" and "Client" are not the same.
		<br />&nbsp;<br />
		For custom fields only, the <strong>",raw" option</strong> bypasses the code to sanitize the returned value. Use this option to allow HTML tags to be returned from a custom field.
		<br />&nbsp;<br />
		One special custom "pseudo-value" is available; <strong>ALL_CUSTOM</strong> (<code>[+custom:ALL_CUSTOM+]</code>). This returns a string representation of all custom field values. You can use this pseudo-values to quickly examine which fields are populated for a given Media Library item and what its values are.
		<br />&nbsp;<br />
		The ALL_CUSTOM value is altered in two ways. First, values of more than 256 characters are truncated to 256 characters. This prevents large fields from dominating the display. Second, array values are shown '(ARRAY)'.</td>
	</tr>
	<tr>
		<td class="mla-doc-table-label">terms,<br />page_terms,<br />parent_terms</td>
		<td>WordPress Category, tag or custom taxonomy terms. The "terms" prefix acts on the attachment itself, "page_terms" acts on the post/page in which the shortcode occurs, and "parent_terms" acts on the attachment's parent, if any. Note that "page_terms" is useful only for shortcodes; it has no values in mapping rules.
		<br />&nbsp;<br />
		For these prefixes, you code the name of the taxonomy as the field name. The term(s) associated with the attachment will be displayed in the <code>[mla_gallery]</code>. Note that you must use the name/slug string for taxonomy, not the "title" string. For example, use "attachment_category" or "attachment_tag", not "Att. Category" or "Attachment Category".
		<br />&nbsp;<br />
		You can change the term field by adding the field name in parentheses after the taxonomy name. For example, <code>[+terms:attachment_category(slug)+]</code> or <code>[+terms:attachment_category(term_id)+]</code>.
		<br />&nbsp;<br />
		You can access fields from a specific term, independent of terms assigned to an item, with a compound name. Append the term slug to the taxonomy slug separated by a period ("."), e.g. <code>[+terms:attachment_category.my-term(term_id)+]</code>. <span style="display:none">You can also pass a term slug to the parameter from the <code>request:</code> or <code>query:</code> arguments. For example, if your shortcode is something like <code>[mla_gallery attachment_category=my-term]</code> you can access the query value as <code>[+terms:attachment_category.[\+query:attachment_category+\](name)+}(slug)+]</code> in a custom markup template. The backslash ("\") characters are required to prevent parsing confusion when a substitution parameter is embedded in another substitution parameter.
		<br />&nbsp;<br />
		You can use this form in a shortcode parameter such as <code>mla_caption</code> by coding <code>[mla_gallery attachment_category=my-term mla_caption="{+terms:attachment_category.{\\+query:attachment_category+\\}(name)+}(slug)+}" ]</code>. The extra backslash characters are required to pass the parameter through the WordPress shortcode parameter parsing process.</span>
		</td>
	</tr>
	<tr>
		<td class="mla-doc-table-label">parent</td>
		<td>
		Values assigned to the item's parent post/page; empty for unattached items.
		These include any of the columns in the database posts table, e.g., <code>[+parent:post_title+]</code>. You can access the parent's Permalink as <code>[+parent:permalink+]</code>.<br />
		&nbsp;<br />
		You can also access custom field values assigned to the parent; simply use the custom field name. The field name, or key, can contain spaces and some punctuation characters. You cannot use the plus sign ('+') in a field name you want to use with <code>[mla_gallery]</code>. Custom field names are case-sensitive; "client" and "Client" are not the same.
		<br />&nbsp;<br />
		For custom fields only, the ",raw" option bypasses the code to sanitize the returned value. Use this option to allow HTML tags to be returned from a custom field.<br />&nbsp;
		</td>
	</tr>
	<tr>
		<td class="mla-doc-table-label">author</td>
		<td>
		Values assigned to the item's author; empty if the author cannot be determined.
		These include any of the columns in the database users and usermeta tables, e.g., <code>[+author:user_nicename+]</code> or  <code>[+author:description+]</code>.<br />
		&nbsp;<br />
		The ",raw" option bypasses the code to sanitize the returned value. Use this option, for example, to allow HTML tags to be returned.<br />&nbsp;
		</td>
	</tr>
	<tr>
		<td class="mla-doc-table-label">iptc</td>
		<td>
		The IPTC (International Press Telecommunications Council) metadata, if any, embedded in the image file. For this category, you can code any of the IPTC DataSet tag and field identifiers, e.g., "2#025" for the Keywords field. You can also use the "friendly name" MLA defines for most of the IPTC fields; see the <a href="#mla_iptc_identifiers">table of identifiers and friendly names</a> below.<br />
		&nbsp;<br />
		You can find more IPTC information in the <a href="https://www.iptc.org/std/IIM/4.2/specification/IIMV4.2.pdf" title="IPTC-NAA Information Interchange Model Version No. 4.2 specification (PDF)" target="_blank">IPTC-NAA Information Interchange Model Version No. 4.2 specification (PDF document)</a>.
		<br />&nbsp;<br />
		A special iptc "pseudo-value" is available; <strong>ALL_IPTC</strong> (<code>[+iptc:ALL_IPTC+]</code>). It returns a string representation of all IPTC data. You can use the pseudo-value to examine the metadata in an image, find field names and see what values are embedded in the image.
		<br />&nbsp;<br />
		The ALL_IPTC value is altered in two ways. First, values of more than 256 characters are truncated to 256 characters. This prevents large fields such as keyword arrays from dominating the display. Second, array values are shown once, at their expanded level.<br />&nbsp;
		</td>
	</tr>
	<tr>
		<td class="mla-doc-table-label">exif</td>
		<td>
		The EXIF (EXchangeable Image File) metadata, if any, embedded in a JPEG DCT or TIFF Rev 6.0 image file. 
		Though the specification is not currently maintained by any industry or standards organization, almost all camera manufacturers use it. It is also supported by many image editing programs such as Adobe PhotoShop.
		For this category, you can code any of the field names embedded in the image by the camera or editing software. There is no official list of standard field names, so you just have to know the names your camera and software use; field names are case-sensitive.
		<br />&nbsp;<br />
		You can find more information in the <a href="https://en.wikipedia.org/wiki/Exif" title="Exchangeable image file format Wikipedia article" target="_blank">Exchangeable image file format</a> article on Wikipedia. You can find External Links to EXIF standards and tag listings at the end of the Wikipedia article.
		<br />&nbsp;<br />
		MLA uses a standard PHP function, <a href="http://php.net/manual/en/function.exif-read-data.php" title="PHP Manual page for exif_read_data" target="_blank">exif_read_data</a>, to extract EXIF data from images. The function returns three arrays in addition to the raw EXIF data; COMPUTED, THUMBNAIL and COMMENT. You can access the array elements by prefacing the element you want with the array name. For example, the user comment text is available as "COMPUTED.UserComment" and "COMPUTED.UserCommentEncoding". You can also get "COMPUTED.Copyright" and its two parts (if present), "COMPUTED.Copyright.Photographer" and "COMPUTED.Copyright.Editor". The THUMBNAIL and COMMENT arrays work in a similar fashion.
		<br />&nbsp;<br />
		A special exif "pseudo-value" is available; <strong>ALL_EXIF</strong> (<code>[+exif:ALL_EXIF+]</code>). It returns a string representation of all EXIF data. You can use the pseudo-value to examine the metadata in an image, find field names and see what values are embedded in the image.
		<br />&nbsp;<br />
		The ALL_EXIF value is altered in two ways. First, values of more than 256 characters are truncated to 256 characters. This prevents large fields such as image thumbnails from dominating the display. Second, array values are replaced by an "(ARRAY)" placeholder, e.g., <code>'COMPUTED' => '(ARRAY)'</code>. You can explore array values individually by coding something like <code>[+exif:COMPUTED,export+]</code> to expand all levels within the array or <code>[+exif:CAMERA,unpack+]</code> to expand one level within the array. You can go deeper in the array hierarchy with compound names, e.g., <code>[+exif:CAMERA.ShutterSpeed+]</code> or <code>[+exif:CAMERA.LensSpecification,unpack+]</code>.<br />&nbsp;</td>
	</tr>
	<tr>
		<td class="mla-doc-table-label">xmp</td>
		<td>
Data defined by the <a href="https://www.adobe.com/products/xmp/" title="Adobe XMP site" target="_blank">Extensible Metadata Platform (XMP)</a> framework, if present. XMP metadata varies from image to image but is often extensive. MLA provides access to this data in three ways:
<ol>
<li>
MLA will copy appropriate values from the XMP data into the nine "<a href="#pdf_metadata">PDF Document Information Dictionary</a>" fields to populate them as often as possible. For example, the "creator" value(s) in the "dc" namespace ("dc.creator") might be copied to an empty "Author" field, or the "dc.subject" value(s) might be copied to an empty Keywords field.
</li>
<li>
Additional values in the "xmp", "xmpMM", "xmpRights", "xap", "xapMM" and "dc" namespaces are copied up to the root level for easier access. For example, the "xmp.ModifyDate" value can be accessed as "ModifyDate", without the "xmp." portion of the compound name.
</li>
<li>
Other namespaces in the document are copied to arrays at the root level. For example, some documents contain information in the "photoshop" namespace, such as "photoshop.CaptionWriter" and "photoshop.AuthorsPosition". The native values of some fields, e.g., "dc.creator", can be an array.
</li>
</ol>
MLA adds three fields of its own to the XMP metadata information:
<br />&nbsp;<br />
<table>
	<tr>
		<td class="mla-doc-table-label">xmptk</td>
		<td>the XMP software used to create the metadata</td>
	</tr>
	<tr>
		<td class="mla-doc-table-label">xmlns</td>
		<td>an array of the namespaces found in the document, such as <code>'dc' => 'http://purl.org/dc/elements/1.1/'</code></td>
	</tr>
	<tr>
		<td class="mla-doc-table-label">ALL_XMP</td>
		<td>a special "pseudo value" that returns a string representation of all the metadata. You can use this pseudo-value to examine the metadata in a document, find field names and see what values are present.</td>
	</tr>
</table>
&nbsp;<br />
		The ALL_XMP value is altered in two ways. First, values of more than 256 characters are truncated to 256 characters. This prevents large fields such as image thumbnails from dominating the display. Second, array values are replaced by an "(ARRAY)" placeholder, e.g., <code>'History' => '(ARRAY)'</code>. You can explore array values individually by coding something like <code>[+xmp:History,export+]</code> to expand all levels within the array or <code>[+xmp:mwg-rs,unpack+]</code> to expand one level within the array. You can go deeper in the array hierarchy with compound names, e.g., <code>[+xmp:mwg-rs.RegionList,unpack+]</code> or <code>[+xmp:mwg-rs.RegionList.*.Description.Name+]</code>.
		<br />&nbsp;</td>
	</tr>
	<tr>
		<td class="mla-doc-table-label">id3</td>
		<td>
		<a href="https://en.wikipedia.org/wiki/ID3" title="Wikipedia page for ID3" target="_blank">Wikipedia</a> says "ID3 is a metadata container most often used in conjunction with the MP3 audio file format. It allows information such as the title, artist, album, track number and other information about the file to be stored in the file itself."
		WordPress includes a subset of the <a href="http://www.getid3.org/" title="Official getID3() site" target="_blank">getID3() PHP Media File Parser</a> with support for audio and video file formats. A few values are available for other file types but they are not very useful.<br />
		&nbsp;<br />
		You can also use [+id3:ALL_ID3+], a special "pseudo value" that returns a string representation of all the metadata. You can use this pseudo-value to examine the metadata in a file, find field names and see what values are present. The ALL_ID3 value is altered to limit the amount of information displayed. Values of more than 256 characters are truncated to 256 characters. This prevents large fields such as image thumbnails from dominating the display. Array values are replaced by an "(ARRAY)" placeholder, e.g., <code>'audio' => '(ARRAY)'</code>. You can explore array values individually by coding something like <code>[+id3:audio,export+]</code> to expand all levels within the array or <code>[+id3:audio,unpack+]</code> to expand one level within the array. You can go deeper in the array hierarchy with compound names, e.g., <code>[+id3:quicktime.moov.subatoms,unpack+]</code> or <code>[+id3:quicktime.moov.subatoms.*.name+]</code>.
		<br />&nbsp;</td>
	</tr>
	<tr>
		<td class="mla-doc-table-label">pdf</td>
		<td>
		The Document Information Dictionary (D.I.D.)and XMP metadata, if any, embedded in a PDF file. For this category, you can code any of the nine D.I.D. entries (Title, Author, Subject, Keywords, Creator, Producer, CreationDate, ModDate, Trapped). For many documents there is also a rich collection of additional metadata stored in XMP Metadata Streams; see the <a href="#pdf_metadata">Metadata in PDF documents</a> section below for details on accessing PDF metadata.<br />
		&nbsp;<br />
		You can find more PDF information at the <a href="http://www.adobe.com/devnet/pdf.html" title="Adobe PDF Technology Center" target="_blank">Adobe PDF Technology Center</a>.<br />&nbsp;</td>
	</tr>
	<tr>
		<td class="mla-doc-table-label">png</td>
		<td>
		For PNG files, data defined by the <a href="https://www.w3.org/TR/png/" title="W3C Draft Standard" target="_blank">Portable Network Graphics (PNG) Specification (Third Edition)</a> is extracted. The IHDR (Image header) seven elements of general interest. These are available in their raw numeric form and in an enhanced textual form. Any tEXt chunks, if present, are parsed into their keyword and text value parts and made available. The <a title="Find the Diffusion Parameters Example" href="[+example_url+]&amp;mla-example-search=Search+Plugins&amp;s=%22MLA+Diffusion+Parameters+Example%22" class="mla-doc-bold-link">MLA Diffusion Parameters Example</a> plugin parses the <code>png:parameters</code> text and creates an array of individual <code>png:diffusion.</code> elements.<br />
		&nbsp;<br />
		Although the W3C standard provides for adding EXIF and XMP metadata chunks to PNG files I have never seen an actual example of either one, so MLA does not extract this data. If you find an example, open a support topic and I will investigate further.
		<br />&nbsp;<br />
		A special png "pseudo-value" is available; <strong>ALL_PNG</strong> (<code>[+png:ALL_PNG+]</code>). It returns a string representation of all PNG metadata. You can use the pseudo-value to examine the metadata in an image, find field names and see what values are embedded in the image.
		<br />&nbsp;<br />
		The ALL_PNG value is altered in two ways. First, values of more than 256 characters are truncated to 256 characters. This prevents large fields such as keyword arrays from dominating the display. Second, array values are shown once, at their expanded level.
		<br />&nbsp;</td>
	</tr>
	<tr>
		<td class="mla-doc-table-label">mso</td>
		<td>
For Microsoft Office documents, data defined by the <a href="https://en.wikipedia.org/wiki/Office_Open_XML_file_formats#Document_properties" title="Wikipedia Article" target="_blank">Office Open XML file formats</a>, if present. The formats (e.g., docx, xlsx, pptx) were developed by Microsoft and first appeared in Microsoft Office 2007. MLA provides access to the "Document Properties" data in three ways:
<ol>
<li>
MLA will copy appropriate values from the Document Properties data into the nine "<a href="#pdf_metadata">PDF Document Information Dictionary</a>" fields to populate them as often as possible. For example, the "creator" value(s) in the "dc" namespace ("dc.creator") might be copied to an empty "Author" field, or the "cp.keywords" and "cp.category" value(s) might be copied to an empty Keywords field.
</li>
<li>
Additional values in the "cp", "dc", "dcterms" and "app" namespaces are copied up to the root level for easier access. For example, the "cp.description" value can be accessed as "description", without the "cp." portion of the compound name.
</li>
<li>
The "Extended Properties" are copied to the "app." array at the root level. For example, Word documents contain information such as "app.Pages", "app.Words" and "app.Characters". The native values of some fields, e.g., "app.HeadingPairs", can be an array.
</li>
</ol>
MLA adds two fields of its own to the MS Office metadata information:
<br />&nbsp;<br />
<table>
	<tr>
		<td class="mla-doc-table-label">xmlns</td>
		<td>an array of the namespaces found in the document, such as <code>'dc' => 'http://purl.org/dc/elements/1.1/'</code></td>
	</tr>
	<tr>
		<td class="mla-doc-table-label">ALL_MSO</td>
		<td>a special "pseudo value" that returns a string representation of all the metadata. You can use this pseudo-value to examine the metadata in a document, find field names and see what values are present.</td>
	</tr>
</table>
&nbsp;<br />
		The ALL_MSO value is altered in two ways. First, values of more than 256 characters are truncated to 256 characters. This prevents large fields from dominating the display. Second, array values are replaced by an "(ARRAY)" placeholder, e.g., <code>'Keywords' => '(ARRAY)'</code>. You can explore array values individually by coding something like <code>[+mso:TitlesOfParts,export+]</code> to expand all levels within the array or <code>[+mso:Keywords,unpack+]</code> to expand one level within the array. You can go deeper in the array hierarchy with compound names, e.g., <code>[+mso:HeadingPairs.vector,unpack+]</code>.
		<br />&nbsp;</td>
	</tr>
	<tr>
		<td class="mla-doc-table-label">matches</td>
		<td>The matches prefix is part of MLA&rsquo;s <a href="#mla_regular_expressions">Regular Expression Features</a>. It allows you to access data sources created by applying the <code>,match(p)</code> and <code>,extract(p)</code> format/option values.</td>
	</tr>
</table>
<p>
You can view an item's metadata values (pdf, iptc, exif, xmp, png, msp, and id3) in the "Attachment File Metadata" meta box on the Media/Edit Media screen for the item.
</p>
<p>
<a name="field_level_formats"></a>
&nbsp;<br />
</p>
<h4>Field-level option/format values</h4>
<p>
You can use a field-level option or format value to specify the treatment of fields with multiple values or to change the format of a field for display/mapping purposes. If no option/format value is present, fields with multiple values are formatted as a comma-delimited text list. The option/format value, if present, immediately follows the field name using a comma (,) separator and ends with the closing delimiter ('+]' or '+}'). There can be no spaces in this part of the parameter.
</p>
<p>
Three "option" values change the treatment of fields with multiple values:
</p>
<table>
	<tr>
		<td class="mla-doc-table-label">,single</td>
		<td>If this option is present, only the first value of the field will be returned. Use this option to limit the data returned for a custom field, taxonomy or metadata field that can have many values. For example, if you code <code>[+meta:sizes.thumbnail,single+]</code> the result will be something like "20120313-ASK_5605-150x150.jpg".
		</td>
	</tr>
	<tr>
		<td class="mla-doc-table-label">,export</td>
		<td>If this option is present, the PHP <code>var_export</code> function is used to return a string representation of all the elements in an array field. For example, if you code <code>[+meta:sizes.thumbnail,export+]</code> the result will be "array ('file' => '20120313-ASK_5605-150x150.jpg', 'width' => 150, 'height' => 150, 'mime-type' => 'image/jpeg', )".
		</td>
	</tr>
	<tr>
		<td class="mla-doc-table-label">,unpack</td>
		<td>If this option is present, the top-level elements in an array field will be expanded; lower-level arrays will be denoted by a placeholder. For example, if you code <code>[+meta:sizes,unpack+]</code> the result will be "array ( 'thumbnail' => '(ARRAY)', 'medium' => '(ARRAY)', 'large' => '(ARRAY)', 'post-thumbnail' => '(ARRAY)', )".
		</td>
	</tr>
</table>
<p>
Eight "format" values help you reformat fields or encode them for use in HTML attributes and tags:
</p>
<table>
<tr>
<td class="mla-doc-table-label">,raw</td>
<td>If you want to avoid filtering a value through the WordPress <code>sanitize_text_field()</code> function you can add the ",raw" option. This is helpful when, for example, you are using a field that contains HTML markup such as a hyperlink.</td>
</tr>
<tr>
<td class="mla-doc-table-label">,commas</td>
<td>For numeric data source parameters such as "file_size" you can add the ",commas" option to format the value for display purposes.</td>
</tr>
<tr>
<td class="mla-doc-table-label">,attr</td>
<td>If you use a substitution parameter in an HTML attribute such as the <code>title</code> attribute of a hyperlink (<code>a</code>) or <code>img</code> tag you can add the ",attr" option to encode the &lt;, >, &amp;, " and ' (less than, greater than, ampersand, double quote and single quote) characters.</td>
</tr>
<tr>
<td class="mla-doc-table-label">,url</td>
<td>If you use a substitution parameter in an HTML <code>href</code> attribute such as a hyperlink (<code>a</code>) or <code>img</code> tag you can add the ",url" option to convert special characters such as quotes, spaces and ampersands to their URL-encoded equivalents.</td>
</tr>
<tr>
<td class="mla-doc-table-label" style="white-space:nowrap">,substr(s,l)</td>
<td>If you need to limit the length of a value or extract a portion of it the ",substr" option will return part of the value. This option accepts one or two parameters, "start" (s) and "length" (l). The first character in the value is at position zero (0) so, for example, ",substr(2,3)" would return "cde" from a value of "abcdef". You can find complete information on "start" and "length", including the effect of negative values, at: <a href="http://php.net/manual/en/function.substr.php" title="PHP substr parameters" target="_blank">http://php.net/manual/en/function.substr.php</a>.</td>
</tr>
<tr>
<td class="mla-doc-table-label" style="white-space:nowrap">,str_replace(s,r)</td>
<td>Replace all occurrences of the "search" string (s) with the "replacement" string (r). If search and replacement are arrays, then str_replace() takes a value from each array and uses them to search and replace on subject. If replace has fewer values than search, then an empty string is used for the rest of replacement values. If search is an array and replace is a string, then this replacement string is used for every value of search. You can find complete information on "search" and "replacement", including examples, at: <a href="http://php.net/manual/en/function.str-replace.php" title="PHP str_replace parameters" target="_blank">http://php.net/manual/en/function.str-replace.php</a>.<br />&nbsp;<br />To specify an array argument enclose the argument in braces ( "{" and "}" ) and separate elements with <strong>spaces</strong>. For example, <code>,str_replace( {',' '-'}, {' ' '_'} )</code> will change commas to spaces and dashes to underscores, while <code>,str_replace( {',' '-'}, ' ' )</code> will change both commas <strong>and</strong> dashes to spaces.</td>
</tr>
<tr>
<td class="mla-doc-table-label" style="white-space:nowrap">,kbmb(t,k,m,p)</td>
<td>Some data values, e.g., file size, are better expressed in kilobytes and megabytes. The "kbmb" format provides this conversion. There are four optional arguments; "t" (threshold), "k" (kilobyte suffix), "m" (megabyte suffix) and "p" (precision). The threshold argument (default 10240; ten kilobytes) sets the dividing amount between bytes and kilobytes. For example, a value of 1536 bytes would display as "1,536", not "1.50 KB" and 15360 bytes would display as "15.5 KB". The "k" and "m" arguments replace the default " KB" and/or " MB" suffix displayed following the numeric value. The "p" argument is the number of decimal places in the result, e.g., a value of 287,709 with a threshold of 1024 displays as "281", "281.0", "280.97", "280.966", or "280.9658" for precisions 0, 1, 2, 3 and 4.<br />&nbsp;<br />If the "k" argument is empty and the "m" argument is present all numbers above the threshold will be displayed in megabytes. For example, the value ",kbmb(10240,,Mb)" or ",kbmb(10240,'',Mb)" would display 15360 bytes "0.015Mb".</td>
</tr>
<tr>
<td class="mla-doc-table-label" style="white-space:nowrap">,fraction(f,s)</td>
<td>Many of the EXIF metadata fields are expressed as "rational" quantities, i.e., separate numerator and denominator values separated by a slash. For example, <code>[+exif:ExposureTime+]</code> can be expressed as "1/200" seconds. The "fraction" format converts these to a more useful format.<br />&nbsp;<br />There two optional arguments; "f" (format_string)and "s" (show_fractions). The "format_string" (default "2") can either be the number of decimal places desired or a sprintf()-style format specification. For example, <code>[+exif:ExposureTime,fraction(4)+]</code> will display 7/6 as "+1.1667". A format specification such as '%1$.2f' will display 7/6 as "1.17". Numbers between -1 and +1, i.e. true fractions, will display in their original form, e.g., "1/6". If the optional "show_fractions" (default true) argument is "false" fractional values will convert to a decimal equivalent. For example, fraction(4,false) will display 1/6 as "+0.1667", and <code>[+exif:ExposureTime,fraction( '%1$.2f', false )+]</code> will display 1/6 as "0.17".</td>
</tr>
<tr>
<td class="mla-doc-table-label" style="white-space:nowrap">,timestamp(f,m)</td>
<td>Many date and time values such as <code>[+meta:image_meta.created_timestamp+]</code> are stored as a UNIX timestamp. The ",timestamp" format converts a timestamp into a variety of date and/or time string formats, using the PHP <code>date()</code> function. Details on the "f" (format string) argument can be found at: <a href="https://www.php.net/manual/en/datetime.format.php" title="PHP Date format parameter valuess" target="_blank">http://php.net/manual/en/datetime.format.php</a>.<br />&nbsp;<br />The default format string is "d/m/Y H:i:s", e.g., "31/12/2014 23:59:00" (just before midnight on new year's eve). You could code <code>[+meta:image_meta.created_timestamp,timestamp('j F, Y')+]</code> to display "31 December, 2014".<br />&nbsp;<br />The "m" (modifier) argument is optional. If present and set to "i18n" the displayed value will be localized using the site's locale value.<br />&nbsp;<br />If the "m" (modifier) argument is set to "age" it will return a human-readable difference between the source value and the current date/time. In this case you must also code "%s" in the format string, e.g., <code>[+meta:image_meta.created_timestamp,timestamp('%s ago')+]</code> to display something like "2 months ago".</td>
</tr>
<tr>
<td class="mla-doc-table-label" style="white-space:nowrap">,date(f,m)</td>
<td>Many EXIF date and time values such as DateTimeOriginal and DateTimeDigitized are stored as strings with a format of "YYYY:MM:DD HH:MM:SS". You can parse this format and just about any English textual datetime description into a Unix timestamp, then format the result by using the ",date" format. This format first uses the PHP <code>strtotime()</code> function, then the <code>date()</code> function. Details on the "f" (format string) argument can be found at: <a href="https://www.php.net/manual/en/datetime.format.php" title="PHP Date format parameter values" target="_blank">http://php.net/manual/en/datetime.format.php</a>.<br />&nbsp;<br />The default "f" (format string) argument is "d/m/Y H:i:s", e.g., "31/12/2014 23:59:00" (just before midnight on new year's eve). You could code <code>[+exif:DateTimeOriginal,date('j F, Y')+]</code> to display "31 December, 2014".<br />&nbsp;<br />The "m" (modifier) argument is optional. If present and set to "i18n" the displayed value will be localized using the site's locale value.<br />&nbsp;<br />If the "m" (modifier) argument is set to "age" it will return a human-readable difference between the source value and the current date/time. In this case you must also code "%s" in the format string, e.g., <code>[+exif:DateTimeOriginal,date('%s ago')+]</code> to display something like "2 months ago".</td>
</tr>
</table>
<p>
Three values let you use powerful regular expressions to apply patterns to any data source, extracting or replacing pieces of it. These three values are explained in detail, with examples, in the <a href="#mla_regular_expressions">Regular Expression Features</a> section below. They are:
</p>
<table>
	<tr>
		<td class="mla-doc-table-label" style="white-space:nowrap"><a href="#mla_regular_expressions_match">,match(p)</a></td>
		<td>This format/option value looks for a match of its pattern (and optional subpatterns) in the data source. If a match is found, that portion of the data source is returned. If the pattern is not matched an empty value is returned. Any pattern or subpattern matches found are stored for later access using the "matches:" prefix.
		</td>
	</tr>
	<tr>
		<td class="mla-doc-table-label" style="white-space:nowrap"><a href="#mla_regular_expressions_extract">,extract(p,v)</a></td>
		<td>This format/option value looks for a match of its pattern (and optional subpatterns) (the p paremeter) in the data source. Any pattern or subpattern matches found are stored for later access using the "matches:" prefix. An empty value is returned by default but this can be changed with the optional second (v) parameter.
		</td>
	</tr>
	<tr>
		<td class="mla-doc-table-label" style="white-space:nowrap"><a href="#mla_regular_expressions_replace">,replace(p,r,v)</a></td>
		<td>This format/option value looks for a match of its pattern (p) (and optional subpatterns) in the data source. By default, if a match is found, the replacement (r) pattern is used to return a modified version of the data source. If the pattern is not matched the original data source value is returned. The default can be changed with the optional third (v) parameter.
		</td>
	</tr>
</table>
<a name="field_level_data_sources"></a>&nbsp;
<p>
<a href="#backtotop">Go to Top</a>
</p>
<h4>Field-level data sources</h4>
Each Media Library attachment item has a row in the "posts" database table that records information such as the Title, Author and Parent post/page. It also has an "attached file" with attributes like the file name and file size. All of this information and more is available as "field-level data sources" that can be used for <code>[mla_gallery]</code> or mapping purposes. The data sources are:
<table>
<tr>
<td class="mla-doc-table-label">post_id, ID</td>
<td>the value stored in the attachment's "posts" database row.</td>
</tr>
<tr>
<td class="mla-doc-table-label">post_author</td>
<td>the value stored in the attachment's "posts" database row.</td>
</tr>
<tr>
<td class="mla-doc-table-label">post_date</td>
<td>the value stored in the attachment's "posts" database row.</td>
</tr>
<tr>
<td class="mla-doc-table-label">post_date_gmt</td>
<td>the value stored in the attachment's "posts" database row.</td>
</tr>
<tr>
<td class="mla-doc-table-label">post_content</td>
<td>the value stored in the attachment's "posts" database row.</td>
</tr>
<tr>
<td class="mla-doc-table-label">post_title</td>
<td>the value stored in the attachment's "posts" database row.</td>
</tr>
<tr>
<td class="mla-doc-table-label">post_excerpt</td>
<td>the value stored in the attachment's "posts" database row.</td>
</tr>
<tr>
<td class="mla-doc-table-label">post_status</td>
<td>the value stored in the attachment's "posts" database row.</td>
</tr>
<tr>
<td class="mla-doc-table-label">comment_status</td>
<td>the value stored in the attachment's "posts" database row.</td>
</tr>
<tr>
<td class="mla-doc-table-label">ping_status</td>
<td>the value stored in the attachment's "posts" database row.</td>
</tr>
<tr>
<td class="mla-doc-table-label">post_name</td>
<td>the value stored in the attachment's "posts" database row.</td>
</tr>
<tr>
<td class="mla-doc-table-label">post_modified</td>
<td>the value stored in the attachment's "posts" database row.</td>
</tr>
<tr>
<td class="mla-doc-table-label">post_modified_gmt</td>
<td>the value stored in the attachment's "posts" database row.</td>
</tr>
<tr>
<td class="mla-doc-table-label">post_content_filtered</td>
<td>the value stored in the attachment's "posts" database row.</td>
</tr>
<tr>
<td class="mla-doc-table-label">parent,<br />post_parent</td>
<td style="vertical-align: top">the value stored in the attachment's "posts" database row.</td>
</tr>
<tr>
<td class="mla-doc-table-label">guid</td>
<td>the value stored in the attachment's "posts" database row.</td>
</tr>
<tr>
<td class="mla-doc-table-label">menu_order</td>
<td>the value stored in the attachment's "posts" database row.</td>
</tr>
<tr>
<td class="mla-doc-table-label">mime_type,<br />post_mime_type</td>
<td style="vertical-align: top">the value stored in the attachment's "posts" database row.</td>
</tr>
<tr>
<td class="mla-doc-table-label">comment_count</td>
<td>the value stored in the attachment's "posts" database row.</td>
</tr>
<tr>
<td class="mla-doc-table-label">alt_text</td>
<td style="padding-bottom: 2em;">ALT text, for image types. If there are multiple values (unlikely) they will be returned as a comma-separated list. You can use the ",single" or ",export" option values to change that.</td>
</tr>
<tr>
<td class="mla-doc-table-label">site_url</td>
<td style="vertical-align: top">absolute URL to the site directory, without trailing slash.</td>
</tr>
<tr>
<td class="mla-doc-table-label">base_url</td>
<td>absolute URL to the upload directory, without trailing slash.</td>
</tr>
<tr>
<td class="mla-doc-table-label">base_dir</td>
<td style="padding-bottom: 2em;">absolute (full) path to the upload directory, without trailing slash.</td>
</tr>
<tr>
<td class="mla-doc-table-label">current_timestamp</td>
<td style="vertical-align: top">an integer Unix timestamp of the current local time. In other words, the value of the PHP <code>time()</code> function, adjusted to the time zone of the site. You can use the <code>,timestamp(f,m)</code> format value described above to re-format the value in a variety of ways. You can get the GMT value by adding a <code>(gmt)</code> qualifier to the name, i.e., <code>current_timestamp(gmt)</code>.</td>
</tr>
<tr>
<td class="mla-doc-table-label">current_datetime</td>
<td>a string representation of the current local (adjusted to the time zone of the site) date and time with a format of "YYYY:MM:DD HH:MM:SS". You can use the <code>,date(f,m)</code> format value described above to re-format the value in a variety of ways. You can get the GMT value by adding a <code>(gmt)</code> qualifier to the name, i.e., <code>current_datetime(gmt)</code>.</td>
</tr>
<tr>
<td class="mla-doc-table-label">current_getdate</td>
<td style="padding-bottom: 2em;">an associative array containing the date and time elements of the current local (adjusted to the time zone of the site) time. You can use name qualifiers to access individual elements within the array, e.g., `current_getdate(month)` or `current_getdate(wday)`. You can get the GMT value by adding a <code>(gmt)</code> qualifier to the name, i.e., <code>current_getdate(gmt)</code>.<br />&nbsp;<br />Individual array elements are in the site&rsquo;s local time. You can get the GMT value by prepending "gmt" to the name as shown in the list below. The array elements are:<br />&nbsp;<br />
<table>
	<tr>
		<td class="mla-doc-table-label">seconds,<br />gmtseconds</td>
		<td style="vertical-align: top">Numeric representation of seconds, 0 to 59.</td>
	</tr>
	<tr>
		<td class="mla-doc-table-label">minutes,<br />gmtminutes</td>
		<td style="vertical-align: top">Numeric representation of minutes, 0 to 59</td>
	</tr>
	<tr>
		<td class="mla-doc-table-label">hours,<br />gmthours</td>
		<td style="vertical-align: top">Numeric representation of hours, 0 to 23</td>
	</tr>
	<tr>
		<td class="mla-doc-table-label">mday,<br />gmtmday</td>
		<td style="vertical-align: top">Numeric representation of the day of the month, 1 to 31</td>
	</tr>
	<tr>
		<td class="mla-doc-table-label">wday,<br />gmtwday</td>
		<td style="vertical-align: top">Numeric representation of the day of the week, 0 (for Sunday) through 6 (for Saturday)</td>
	</tr>
	<tr>
		<td class="mla-doc-table-label">mon,<br />gmtmon</td>
		<td style="vertical-align: top">Numeric representation of a month, 1 through 12</td>
	</tr>
	<tr>
		<td class="mla-doc-table-label">year,<br />gmtyear</td>
		<td style="vertical-align: top">A full numeric representation of a year, 4 digits.  Examples: 1999 or 2003</td>
	</tr>
	<tr>
		<td class="mla-doc-table-label">yday,<br />gmtgmtyday</td>
		<td style="vertical-align: top">Numeric representation of the day of the year, 0 through 365</td>
	</tr>
	<tr>
		<td class="mla-doc-table-label">weekday,<br />gmtweekday</td>
		<td style="vertical-align: top">A full textual representation of the day of the week, Sunday through Saturday</td>
	</tr>
	<tr>
		<td class="mla-doc-table-label">month,<br />gmtmonth</td>
		<td style="vertical-align: top">A full textual representation of a month, January through December</td>
	</tr>
	<tr>
		<td class="mla-doc-table-label">0,<br />gmt0</td>
		<td style="vertical-align: top">Seconds since the Unix Epoch (timestamp), similar to the values returned by time() and used by date().</td>
	</tr>
</table>
</td>
</tr>
<tr>
<td class="mla-doc-table-label">absolute_path</td>
<td>complete path portion of the attachment file, e.g., C:/site/wordpress/wp-content/uploads/2012/11/</td>
</tr>
<tr>
<td class="mla-doc-table-label">absolute_file_name</td>
<td>complete path and file name of the attachment file, e.g., C:/site/wordpress/wp-content/uploads/2012/11/filename.ext</td>
</tr>
<tr>
<td class="mla-doc-table-label">base_file</td>
<td>relative path (within uploads directory) and file name of the attachment file, e.g., 2012/11/image.jpg</td>
</tr>
<tr>
<td class="mla-doc-table-label">path</td>
<td>path portion of the base_file value, e.g., 2012/11/</td>
</tr>
<tr>
<td class="mla-doc-table-label">file_name</td>
<td>file name and extension portion of the base_file value, e.g., image.jpg</td>
</tr>
<tr>
<td class="mla-doc-table-label">name_only</td>
<td>file name portion of the base_file value, e.g., image</td>
</tr>
<tr>
<td class="mla-doc-table-label">extension</td>
<td>extension portion of the base_file value, e.g., jpg</td>
</tr>
<tr>
<td class="mla-doc-table-label">file_size</td>
<td>file size in bytes</td>
</tr>
<tr>
<td class="mla-doc-table-label">upload_date</td>
<td style="padding-bottom: 2em;">date and time attachment was added to the Media Library</td>
</tr>
<tr>
<td class="mla-doc-table-label">dimensions</td>
<td>for image types, width x height, e.g., 1024x768</td>
</tr>
<tr>
<td class="mla-doc-table-label">pixels</td>
<td>for image types, size in pixels, e.g., 307200 for a 640x480 image</td>
</tr>
<tr>
<td class="mla-doc-table-label">width</td>
<td>for image types, width in pixels</td>
</tr>
<tr>
<td class="mla-doc-table-label">height</td>
<td>for image types, height in pixels</td>
</tr>
<tr>
<td class="mla-doc-table-label">orientation</td>
<td>"portrait" (height > width) or "landscape", for image types; empty for non-image types</td>
</tr>
<tr>
<td class="mla-doc-table-label">hwstring_small</td>
<td>HTML dimensions of a "small" image, i.e., 128 or less width, 96 or less height. Not computed for images uploaded in WordPress 3.5 and later.</td>
</tr>
<tr>
<td class="mla-doc-table-label">size_keys</td>
<td>image size names for thumbnail versions of the image, e.g., "thumbnail, medium, large"</td>
</tr>
<tr>
<td class="mla-doc-table-label">size_names</td>
<td>image file names for thumbnail versions of the image, e.g., "image-150x150.jpg, image-300x225.jpg, image-600x288.jpg"</td>
</tr>
<tr>
<td class="mla-doc-table-label">size_bytes</td>
<td>file size in bytes for thumbnail versions of the image, e.g., "5127, 11829, 33968"</td>
</tr>
<tr>
<td class="mla-doc-table-label">size_pixels</td>
<td>image size in pixels for thumbnail versions of the image, e.g., "22500, 67500, 172800"</td>
</tr>
<tr>
<td class="mla-doc-table-label">size_dimensions</td>
<td>image dimensions for thumbnail versions of the image, e.g., "150x150, 300x225, 600x288"</td>
</tr>
<tr>
<td class="mla-doc-table-label">size_name[size]</td>
<td>image file name for a specific thumbnail version, e.g., size_name[medium] = "image-300x225.jpg"; set to empty string if the specified size does not exist. There will be a [size] choice for every thumbnail version registered with WordPress for the site.</td>
</tr>
<tr>
<td class="mla-doc-table-label">size_bytes[size]</td>
<td>file size in bytes for a specific thumbnail version, e.g., size_bytes[medium] = "11829"</td>
</tr>
<tr>
<td class="mla-doc-table-label">size_pixels[size]</td>
<td>image size in pixels for a specific thumbnail version, e.g., size_pixels[medium] = "67500"</td>
</tr>
<tr>
<td class="mla-doc-table-label" style="width: 12em">size_dimensions[size]</td>
<td style="padding-bottom: 2em;">image dimensions for a specific thumbnail version, e.g., size_dimensions[medium] = "300x225"; set to empty string if the specified size does not exist. There will be a [size] choice for every thumbnail version registered with WordPress for the site.</td>
</tr>
<tr>
<td class="mla-doc-table-label" style="padding-bottom: 2em;">original_absolute_file_name,<br />original_base_file,<br />original_file_name,<br />original_name_only,<br />original_file_size,<br />original_dimensions,<br />original_pixels,<br />original_width,<br />original_height</td>
<td valign="top">values for the original image associated with large, scaled images. For unscaled images these values are the same as the corresponding data source without the "original_" prefix, so they will work for all images.</td>
</tr>
<tr>
<td class="mla-doc-table-label">parent_date</td>
<td>for "attached" (post_parent not zero) objects, "published on" date of the parent object</td>
</tr>
<tr>
<td class="mla-doc-table-label">parent_type</td>
<td>for "attached" (post_parent not zero) objects, post type of the parent object</td>
</tr>
<tr>
<td class="mla-doc-table-label">parent_title</td>
<td>for "attached" (post_parent not zero) objects, post title of the parent object</td>
</tr>
<tr>
<td class="mla-doc-table-label">parent_issues</td>
<td>summary of parent status (only) "issues", e.g., bad parent, invalid parent, unattached</td>
</tr>
<tr>
<td class="mla-doc-table-label">reference_issues</td>
<td>summary of all reference and parent status "issues", e.g., orphan, bad parent, invalid parent, unattached</td>
</tr>
<tr>
<td class="mla-doc-table-label">featured_in</td>
<td>the title, post/page type and id number of each post/page for which this item is the "Featured Image"</td>
</tr>
<tr>
<td class="mla-doc-table-label">featured_in_title</td>
<td>the title of each post/page for which this item is the "Featured Image"</td>
</tr>
<tr>
<td class="mla-doc-table-label">inserted_in</td>
<td>the title, post/page type and id number of each post/page where this item is inserted in the post/page content</td>
</tr>
<tr>
<td class="mla-doc-table-label">inserted_in_title</td>
<td>the title of each post/page where this item is inserted in the post/page content</td>
</tr>
<tr>
<td class="mla-doc-table-label">gallery_in</td>
<td>the title, post/page type and id number of each post/page where this item appears in a <code>[gallery]</code> shortcode</td>
</tr>
<tr>
<td class="mla-doc-table-label">gallery_in_title</td>
<td>the title of each post/page where this item appears in a <code>[gallery]</code> shortcode</td>
</tr>
<tr>
<td class="mla-doc-table-label">mla_gallery_in</td>
<td>the title, post/page type and id number of each post/page where this item appears in an <code>[mla_gallery]</code> shortcode</td>
</tr>
<tr>
<td class="mla-doc-table-label">mla_gallery_in_title</td>
<td style="padding-bottom: 2em;">the title of each post/page where this item appears in an <code>[mla_gallery]</code> shortcode</td>
</tr>
<tr>
<td class="mla-doc-table-label">aperture</td>
<td>for image types, the value stored in WordPress "image_meta" array</td>
</tr>
<tr>
<td class="mla-doc-table-label">credit</td>
<td>for image types, the value stored in WordPress "image_meta" array</td>
</tr>
<tr>
<td class="mla-doc-table-label">camera</td>
<td>for image types, the value stored in WordPress "image_meta" array</td>
</tr>
<tr>
<td class="mla-doc-table-label">caption</td>
<td>for image types, the value stored in WordPress "image_meta" array</td>
</tr>
<tr>
<td class="mla-doc-table-label">created_timestamp</td>
<td>for image types, the value stored in WordPress "image_meta" array</td>
</tr>
<tr>
<td class="mla-doc-table-label">copyright</td>
<td>for image types, the value stored in WordPress "image_meta" array</td>
</tr>
<tr>
<td class="mla-doc-table-label">focal_length</td>
<td>for image types, the value stored in WordPress "image_meta" array</td>
</tr>
<tr>
<td class="mla-doc-table-label">iso</td>
<td>for image types, the value stored in WordPress "image_meta" array</td>
</tr>
<tr>
<td class="mla-doc-table-label">shutter_speed</td>
<td>for image types, the value stored in WordPress "image_meta" array</td>
</tr>
<tr>
<td class="mla-doc-table-label">title</td>
<td>for image types, the value stored in WordPress "image_meta" array</td>
</tr>
</table>
<a name="mla_iptc_identifiers"></a>
&nbsp;
<p>
<a href="#backtotop">Go to Top</a>
</p>
<h4>Field-level IPTC Identifiers and Friendly Names</h4>
<p>
IPTC Photo Metadata provides data about photographs and the values can be processed by software. Each individual metadata entity is called a property and they are grouped into Administrative, Descriptive and Rights-related properties. IPTC Photo Metadata properties have photo specific definitions that are widely supported by imaging software. You can find complete documentation of IPTC properites at the <a href="https://www.iptc.org/std/photometadata/specification/IPTC-PhotoMetadata" title="IPTC Photo Metadata Standard 2023.2" target="_blank">IPTC Photo Metadata Standard 2023.2 web site.</a>
</p>
<p>
The IPTC specification defines all of the allowed fields and organizes them into "Records" and "DataSets" (fields). When you use the "iptc:" prefix to source a field-level substitution parameter you can specify the field you want in either of two ways. First you can use the Record number and DataSet tag, such as "2#005" for Record 2, DataSet 005; this is the "Object Name" DataSet. Second, you can use the Friendly Name, such as "object-name". The MLA Friendly Name values differ in some cases from the names in the IPTC specification but the table below should be easy to follow.
</p>
<table>
<tr><td colspan="3" style="font-weight:bold">Envelope Record</td></tr>
<tr><td class="mla-doc-table-label">model-version</td><td class="mla-doc-table-sublabel">1#000</td><td class="mla-doc-table-sublabel">2 octet binary IIM version number</td></tr>
<tr><td class="mla-doc-table-label">destination</td><td class="mla-doc-table-sublabel">1#005</td><td class="mla-doc-table-sublabel">Max 1024 characters of Destination (ISO routing information); repeatable</td></tr>
<tr><td class="mla-doc-table-label">file-format</td><td class="mla-doc-table-sublabel">1#020</td><td class="mla-doc-table-sublabel">2 octet binary file format number, see IPTC-NAA V4 Appendix A</td></tr>
<tr><td class="mla-doc-table-label">file-format-version</td><td class="mla-doc-table-sublabel">1#022</td><td class="mla-doc-table-sublabel">2 octet binary file format version number</td></tr>
<tr><td class="mla-doc-table-label">service-identifier</td><td class="mla-doc-table-sublabel">1#030</td><td class="mla-doc-table-sublabel">Max 10 characters of Service Identifier and product</td></tr>
<tr><td class="mla-doc-table-label">envelope-number</td><td class="mla-doc-table-sublabel">1#040</td><td class="mla-doc-table-sublabel">8 Character Envelope Number</td></tr>
<tr><td class="mla-doc-table-label">product-id</td><td class="mla-doc-table-sublabel">1#050</td><td class="mla-doc-table-sublabel">Max 32 characters subset of provider's overall service; repeatable</td></tr>
<tr><td class="mla-doc-table-label">envelope-priority</td><td class="mla-doc-table-sublabel">1#060</td><td class="mla-doc-table-sublabel">1 numeric character of envelope handling priority (not urgency)</td></tr>
<tr><td class="mla-doc-table-label">date-sent</td><td class="mla-doc-table-sublabel">1#070</td><td class="mla-doc-table-sublabel">8 numeric characters of Date Sent by service - CCYYMMDD</td></tr>
<tr><td class="mla-doc-table-label">time-sent</td><td class="mla-doc-table-sublabel">1#080</td><td class="mla-doc-table-sublabel">11 characters of Time Sent by service - HHMMSS±HHMM</td></tr>
<tr><td class="mla-doc-table-label">coded-character-set</td><td class="mla-doc-table-sublabel">1#090</td><td class="mla-doc-table-sublabel">Max 32 characters of control functions, etc.</td></tr>
<tr><td class="mla-doc-table-label">uno</td><td class="mla-doc-table-sublabel">1#100</td><td class="mla-doc-table-sublabel">14 to 80 characters of eternal, globally unique identification for objects</td></tr>
<tr><td class="mla-doc-table-label">arm-identifier</td><td class="mla-doc-table-sublabel">1#120</td><td class="mla-doc-table-sublabel">2 octet binary Abstract Relationship Model Identifier</td></tr>
<tr><td class="mla-doc-table-label">arm-version</td><td class="mla-doc-table-sublabel">1#122</td><td class="mla-doc-table-sublabel">2 octet binary Abstract Relationship Model Version</td></tr>
<tr><td colspan="3" style="font-weight:bold">&nbsp;<br />Application Record</td></tr>
<tr><td class="mla-doc-table-label">record-version</td><td class="mla-doc-table-sublabel">2#000</td><td class="mla-doc-table-sublabel">2 octet binary Information Interchange Model, Part II version number</td></tr>
<tr><td class="mla-doc-table-label">object-type-reference</td><td class="mla-doc-table-sublabel">2#003</td><td class="mla-doc-table-sublabel">3 to 67 Characters of Object Type Reference number and optional text</td></tr>
<tr><td class="mla-doc-table-label">object-attribute-reference</td><td class="mla-doc-table-sublabel">2#004</td><td class="mla-doc-table-sublabel">3 to 67 Characters of Object Attribute Reference number and optional text; repeatable</td></tr>
<tr><td class="mla-doc-table-label">object-name</td><td class="mla-doc-table-sublabel">2#005</td><td class="mla-doc-table-sublabel">Max 64 characters of the object name or shorthand reference</td></tr>
<tr><td class="mla-doc-table-label">edit-status</td><td class="mla-doc-table-sublabel">2#007</td><td class="mla-doc-table-sublabel">Max 64 characters of the status of the objectdata</td></tr>
<tr><td class="mla-doc-table-label">editorial-update</td><td class="mla-doc-table-sublabel">2#008</td><td class="mla-doc-table-sublabel">2 numeric characters of the type of update this object provides</td></tr>
<tr><td class="mla-doc-table-label">urgency</td><td class="mla-doc-table-sublabel">2#010</td><td class="mla-doc-table-sublabel">1 numeric character of the editorial urgency of content</td></tr>
<tr><td class="mla-doc-table-label">subject-reference</td><td class="mla-doc-table-sublabel">2#012</td><td class="mla-doc-table-sublabel">13 to 236 characters of a structured definition of the subject matter; repeatable</td></tr>
<tr><td class="mla-doc-table-label">category</td><td class="mla-doc-table-sublabel">2#015</td><td class="mla-doc-table-sublabel">Max 3 characters of the subject of the objectdata, DEPRECATED</td></tr>
<tr><td class="mla-doc-table-label">supplemental-category</td><td class="mla-doc-table-sublabel">2#020</td><td class="mla-doc-table-sublabel">Max 32 characters (each) of further refinement of subject, DEPRECATED; repeatable</td></tr>
<tr><td class="mla-doc-table-label">fixture-identifier</td><td class="mla-doc-table-sublabel">2#022</td><td class="mla-doc-table-sublabel">Max 32 characters identifying recurring, predictable content</td></tr>
<tr><td class="mla-doc-table-label">keywords</td><td class="mla-doc-table-sublabel">2#025</td><td class="mla-doc-table-sublabel">Max 64 characters (each) of tags; repeatable</td></tr>
<tr><td class="mla-doc-table-label">content-location-code</td><td class="mla-doc-table-sublabel">2#026</td><td class="mla-doc-table-sublabel">3 characters of ISO3166 country code or IPTC-assigned code; repeatable</td></tr>
<tr><td class="mla-doc-table-label">content-location-name</td><td class="mla-doc-table-sublabel">2#027</td><td class="mla-doc-table-sublabel">Max 64 characters of publishable country/geographical location name; repeatable</td></tr>

<tr><td class="mla-doc-table-label">release-date</td><td class="mla-doc-table-sublabel">2#030</td><td class="mla-doc-table-sublabel">8 numeric characters of Release Date (earliest use) - CCYYMMDD</td></tr>
<tr><td class="mla-doc-table-label">release-time</td><td class="mla-doc-table-sublabel">2#035</td><td class="mla-doc-table-sublabel">11 characters of Release Time (earliest use) - HHMMSS±HHMM</td></tr>
<tr><td class="mla-doc-table-label">expiration-date</td><td class="mla-doc-table-sublabel">2#037</td><td class="mla-doc-table-sublabel">8 numeric characters of Expiration Date (latest use) -  CCYYMDD</td></tr>
<tr><td class="mla-doc-table-label">expiration-time</td><td class="mla-doc-table-sublabel">2#038</td><td class="mla-doc-table-sublabel">11 characters of Expiration Time (latest use) - HHMMSS±HHMM</td></tr>
<tr><td class="mla-doc-table-label">special-instructions</td><td class="mla-doc-table-sublabel">2#040</td><td class="mla-doc-table-sublabel">Max 256 Characters of editorial instructions, e.g., embargoes and warnings</td></tr>
<tr><td class="mla-doc-table-label">action-advised</td><td class="mla-doc-table-sublabel">2#042</td><td class="mla-doc-table-sublabel">2 numeric characters of type of action this object provides to a previous object</td></tr>
<tr><td class="mla-doc-table-label">reference-service</td><td class="mla-doc-table-sublabel">2#045</td><td class="mla-doc-table-sublabel">Max 10 characters of the Service ID (1#030) of a prior envelope; repeatable</td></tr>
<tr><td class="mla-doc-table-label">reference-date</td><td class="mla-doc-table-sublabel">2#047</td><td class="mla-doc-table-sublabel">8 numeric characters of prior envelope Reference Date (1#070) - CCYYMMDD; repeatable</td></tr>
<tr><td class="mla-doc-table-label">reference-number</td><td class="mla-doc-table-sublabel">2#050</td><td class="mla-doc-table-sublabel">8 characters of prior envelope Reference Number (1#040); repeatable</td></tr>
<tr><td class="mla-doc-table-label">date-created</td><td class="mla-doc-table-sublabel">2#055</td><td class="mla-doc-table-sublabel">8 numeric characters of intellectual content Date Created - CCYYMMDD</td></tr>
<tr><td class="mla-doc-table-label">time-created</td><td class="mla-doc-table-sublabel">2#060</td><td class="mla-doc-table-sublabel">11 characters of intellectual content Time Created - HHMMSS±HHMM</td></tr>
<tr><td class="mla-doc-table-label">digital-creation-date</td><td class="mla-doc-table-sublabel">2#062</td><td class="mla-doc-table-sublabel">8 numeric characters of digital representation creation date - CCYYMMDD</td></tr>
<tr><td class="mla-doc-table-label">digital-creation-time</td><td class="mla-doc-table-sublabel">2#063</td><td class="mla-doc-table-sublabel">11 characters of digital representation creation time - HHMMSS±HHMM</td></tr>
<tr><td class="mla-doc-table-label">originating-program</td><td class="mla-doc-table-sublabel">2#065</td><td class="mla-doc-table-sublabel">Max 32 characters of the program used to create the objectdata</td></tr>
<tr><td class="mla-doc-table-label">program-version</td><td class="mla-doc-table-sublabel">2#070</td><td class="mla-doc-table-sublabel">Program Version - Max 10 characters of the version of the program used to create the objectdata</td></tr>
<tr><td class="mla-doc-table-label">object-cycle</td><td class="mla-doc-table-sublabel">2#075</td><td class="mla-doc-table-sublabel">1 character where a=morning, p=evening, b=both</td></tr>
<tr><td class="mla-doc-table-label">by-line</td><td class="mla-doc-table-sublabel">2#080</td><td class="mla-doc-table-sublabel">Max 32 Characters of the name of the objectdata creator, e.g., the writer, photographer; repeatable</td></tr>
<tr><td class="mla-doc-table-label">by-line-title</td><td class="mla-doc-table-sublabel">2#085</td><td class="mla-doc-table-sublabel">Max 32 characters of the title of the objectdata creator; repeatable</td></tr>
<tr><td class="mla-doc-table-label">city</td><td class="mla-doc-table-sublabel">2#090</td><td class="mla-doc-table-sublabel">Max 32 Characters of the city of objectdata origin</td></tr>
<tr><td class="mla-doc-table-label">sub-location</td><td class="mla-doc-table-sublabel">2#092</td><td class="mla-doc-table-sublabel">Max 32 Characters of the location within the city of objectdata origin</td></tr>
<tr><td class="mla-doc-table-label">province-or-state</td><td class="mla-doc-table-sublabel">2#095</td><td class="mla-doc-table-sublabel">Max 32 Characters of the objectdata origin Province or State</td></tr>
<tr><td class="mla-doc-table-label">country-or-primary-location-code</td><td class="mla-doc-table-sublabel">2#100</td><td class="mla-doc-table-sublabel">3 characters of ISO3166 or IPTC-assigned code for Country of objectdata origin</td></tr>
<tr><td class="mla-doc-table-label">country-or-primary-location-name</td><td class="mla-doc-table-sublabel">2#101</td><td class="mla-doc-table-sublabel">Max 64 characters of publishable country/geographical location name; repeatable</td></tr>
<tr><td class="mla-doc-table-label">original-transmission-reference</td><td class="mla-doc-table-sublabel">2#103</td><td class="mla-doc-table-sublabel">Max 32 characters of a code representing the location of original transmission</td></tr>
<tr><td class="mla-doc-table-label">headline</td><td class="mla-doc-table-sublabel">2#105</td><td class="mla-doc-table-sublabel">Max 256 Characters of a publishable entry providing a synopsis of the contents of the objectdata</td></tr>
<tr><td class="mla-doc-table-label">credit</td><td class="mla-doc-table-sublabel">2#110</td><td class="mla-doc-table-sublabel">Max 32 Characters that identifies the provider of the objectdata (Vs. the owner/creator)</td></tr>
<tr><td class="mla-doc-table-label">source</td><td class="mla-doc-table-sublabel">2#115</td><td class="mla-doc-table-sublabel">Max 32 Characters that identifies the original owner of the intellectual content</td></tr>
<tr><td class="mla-doc-table-label">copyright-notice</td><td class="mla-doc-table-sublabel">2#116</td><td class="mla-doc-table-sublabel">Max 128 Characters that contains any necessary copyright notice</td></tr>
<tr><td class="mla-doc-table-label">contact</td><td class="mla-doc-table-sublabel">2#118</td><td class="mla-doc-table-sublabel">Max 128 characters that identifies the person or organization which can provide further background information; repeatable</td></tr>
<tr><td class="mla-doc-table-label">caption-or-abstract</td><td class="mla-doc-table-sublabel">2#120</td><td class="mla-doc-table-sublabel">Max 2000 Characters of a textual description of the objectdata</td></tr>
<tr><td class="mla-doc-table-label">caption-writer-or-editor</td><td class="mla-doc-table-sublabel">2#122</td><td class="mla-doc-table-sublabel">Max 32 Characters that the identifies the person involved in the writing, editing or correcting the objectdata or caption/abstract; repeatable</td></tr>
<tr><td class="mla-doc-table-label">rasterized-caption</td><td class="mla-doc-table-sublabel">2#125</td><td class="mla-doc-table-sublabel">7360 binary octets of the rasterized caption - 1 bit per pixel, 460x128-pixel image</td></tr>
<tr><td class="mla-doc-table-label">image-type</td><td class="mla-doc-table-sublabel">2#130</td><td class="mla-doc-table-sublabel">2 characters of color composition type and information</td></tr>
<tr><td class="mla-doc-table-label">image-orientation</td><td class="mla-doc-table-sublabel">2#131</td><td class="mla-doc-table-sublabel">1 alphabetic character indicating the image area layout - P=portrait, L=landscape, S=square</td></tr>
<tr><td class="mla-doc-table-label">language-identifier</td><td class="mla-doc-table-sublabel">2#135</td><td class="mla-doc-table-sublabel">2 or 3 alphabetic characters containing the major national language of the object, according to the ISO 639:1988 codes</td></tr>
<tr><td class="mla-doc-table-label">audio-type</td><td class="mla-doc-table-sublabel">2#150</td><td class="mla-doc-table-sublabel">2 characters identifying monaural/stereo and exact type of audio content</td></tr>
<tr><td class="mla-doc-table-label">audio-sampling-rate</td><td class="mla-doc-table-sublabel">2#151</td><td class="mla-doc-table-sublabel">6 numeric characters representing the audio sampling rate in hertz (Hz)</td></tr>
<tr><td class="mla-doc-table-label">audio-sampling-resolution</td><td class="mla-doc-table-sublabel">2#152</td><td class="mla-doc-table-sublabel">2 numeric characters representing the number of bits in each audio sample</td></tr>
<tr><td class="mla-doc-table-label">audio-duration</td><td class="mla-doc-table-sublabel">2#153</td><td class="mla-doc-table-sublabel">6 numeric characters of the Audio Duration - HHMMSS</td></tr>
<tr><td class="mla-doc-table-label">audio-outcue</td><td class="mla-doc-table-sublabel">2#154</td><td class="mla-doc-table-sublabel">Max 64 characters of the content of the end of an audio objectdata</td></tr>
<tr><td class="mla-doc-table-label">objectdata-preview-file-format</td><td class="mla-doc-table-sublabel">2#200</td><td class="mla-doc-table-sublabel">2 octet binary file format of the ObjectData Preview</td></tr>
<tr><td class="mla-doc-table-label">objectdata-preview-file-format-version</td><td class="mla-doc-table-sublabel">2#201</td><td class="mla-doc-table-sublabel">2 octet binary particular version of the ObjectData Preview File Format</td></tr>
<tr><td class="mla-doc-table-label">objectdata-preview-data</td><td class="mla-doc-table-sublabel">2#202</td><td class="mla-doc-table-sublabel">Max 256000 binary octets containing the ObjectData Preview data</td></tr>
<tr><td colspan="3" style="font-weight:bold">&nbsp;<br />Pre ObjectData Descriptor Record</td></tr>
<tr><td class="mla-doc-table-label">size-mode</td><td class="mla-doc-table-sublabel">7#010</td><td class="mla-doc-table-sublabel">1 numeric character - 0=objectdata size not known, 1=objectdata size known at beginning of transfer</td></tr>
<tr><td class="mla-doc-table-label">max-subfile-size</td><td class="mla-doc-table-sublabel">7#020</td><td class="mla-doc-table-sublabel">4 octet binary maximum subfile dataset(s) size</td></tr>
<tr><td class="mla-doc-table-label">objectdata-size-announced</td><td class="mla-doc-table-sublabel">7#090</td><td class="mla-doc-table-sublabel">4 octet binary objectdata size if known at beginning of transfer</td></tr>
<tr><td class="mla-doc-table-label">maximum-objectdata-size</td><td class="mla-doc-table-sublabel">7#095</td><td class="mla-doc-table-sublabel">4 octet binary largest possible objectdata size</td></tr>
<tr><td colspan="3" style="font-weight:bold">&nbsp;<br />ObjectData</td></tr>
<tr><td class="mla-doc-table-label">subfile</td><td class="mla-doc-table-sublabel">8#010</td><td class="mla-doc-table-sublabel">Subfile DataSet containing the objectdata itself; repeatable</td></tr>
<tr><td colspan="3" style="font-weight:bold">&nbsp;<br />Post ObjectData Descriptor Record</td></tr>
<tr><td class="mla-doc-table-label">confirmed-objectdata-size</td><td class="mla-doc-table-sublabel">9#010</td><td class="mla-doc-table-sublabel">4 octet binary total objectdata size</td></tr>
</table>
<a name="mla_camera_values"></a>&nbsp;
<p>
<a href="#backtotop">Go to Top</a>
</p>
<h4>Field-level enhanced EXIF CAMERA values</h4>
<p>
The EXIF specification defines many "Tags Relating to Picture-taking Conditions". Some of these are processed by WordPress and added to the "image_meta" array (as aperture, camera, focal_length, iso, shutter_speed). The field-level values in this section supplement those values and provide convenient access to additional values as well.
</p>
<p>
The native format of this data is somewhat complicated, so MLA converts the most common elements into more convenient formats. For example, "rational" values are expressed as decimal equivalents or converted to forms more often seen in photographic applications. You can use the enhanced values as-is or use them in a Content Template to compose the format(s) you need. You can access the native values with the names defined in the EXIF specification, e.g., "ExposureTime". The enhanced values are provided in the "CAMERA" array and accessed with compound names, e.g., "CAMERA.ExposureTime". The MLA enhanced values are:</p>
<table>
<tr style="font-weight: bold"><td>Field</td><td>Example</td><td>Content</td></tr>
<tr>
<td class="mla-doc-table-label">ExposureTime</td>
<td class="mla-doc-table-sublabel">1.04, 1/250</td>
<td class="mla-doc-table-sublabel">Exposure time, given in seconds.</td>
</tr>
<tr>
<td class="mla-doc-table-label">ExposureBiasValue</td>
<td class="mla-doc-table-sublabel">-1, +1/3</td>
<td class="mla-doc-table-sublabel">The exposure bias. The unit is the APEX value, usually in the range of -99.99 to 99.99.</td>
</tr>
<tr>
<td class="mla-doc-table-label">ExposureMode</td>
<td class="mla-doc-table-sublabel">Auto, Manual, Bracket</td>
<td class="mla-doc-table-sublabel">The exposure mode.</td>
</tr>
<tr>
<td class="mla-doc-table-label">ShutterSpeed<br />(from&nbsp;ExposureTime)</td>
<td class="mla-doc-table-sublabel">1.04, 1/250</td>
<td class="mla-doc-table-sublabel">Derived from ExposureTime and more often converted to the more useful "one over something" format.</td>
</tr>
<tr>
<td class="mla-doc-table-label">FNumber</td>
<td class="mla-doc-table-sublabel">7.1, 8</td>
<td class="mla-doc-table-sublabel">The F Number.</td>
</tr>
<tr>
<td class="mla-doc-table-label">Flash</td>
<td class="mla-doc-table-sublabel">No, Yes</td>
<td class="mla-doc-table-sublabel">The "flash fired" portion of the flash status.</td>
</tr>
<tr>
<td class="mla-doc-table-label">FocalLength</td>
<td class="mla-doc-table-sublabel">420, 500</td>
<td class="mla-doc-table-sublabel">The actual focal length of the lens, in mm. It is not converted to the focal length of a 35mm film camera.</td>
</tr>
</table>
<p>
The EXIF specification defines several "Other Tags" with more information about each image; these tags are not recognized by the PHP <code>exif_read_data()</code> function. 
The MLA enhanced values for "Other Tags" are:</p>
<table>
<tr style="font-weight: bold"><td>Field</td><td>Example</td><td>Content</td></tr>
<tr>
<td class="mla-doc-table-label">ImageUniqueID</td>
<td class="mla-doc-table-sublabel"></td>
<td class="mla-doc-table-sublabel">an identifier assigned uniquely to each image. It is recorded as an ASCII string equivalent to hexadecimal notation and 128-bit fixed length.</td>
</tr>
<tr>
<td class="mla-doc-table-label">CameraOwnerName</td>
<td class="mla-doc-table-sublabel"></td>
<td class="mla-doc-table-sublabel">records the owner of a camera used in photography as an ASCII string.</td>
</tr>
<tr>
<td class="mla-doc-table-label">BodySerialNumber</td>
<td class="mla-doc-table-sublabel">6033674</td>
<td class="mla-doc-table-sublabel">the serial number of the camera body as an ASCII string.</td>
</tr>
<tr>
<td class="mla-doc-table-label">LensSpecification</td>
<td class="mla-doc-table-sublabel">"80/1, 400/1, 45/10, 56/10"</td>
<td class="mla-doc-table-sublabel">a four-element array containing minimum focal length, maximum focal length, minimum F number in the minimum focal length and minimum F number in the maximum focal length.</td>
</tr>
<tr>
<td class="mla-doc-table-label">LensMinFocalLength</td>
<td class="mla-doc-table-sublabel">80</td>
<td class="mla-doc-table-sublabel">minimum focal length element of the LensSpecification array.</td>
</tr>
<tr>
<td class="mla-doc-table-label">LensMaxFocalLength</td>
<td class="mla-doc-table-sublabel">400</td>
<td class="mla-doc-table-sublabel">maximum focal length element of the LensSpecification array.</td>
</tr>
<tr>
<td class="mla-doc-table-label">LensMinFocalLengthFN</td>
<td class="mla-doc-table-sublabel">4.5</td>
<td class="mla-doc-table-sublabel">minimum F number in the minimum focal length element of the LensSpecification array.</td>
</tr>
<tr>
<td class="mla-doc-table-label">LensMaxFocalLengthFN</td>
<td class="mla-doc-table-sublabel">5.6</td>
<td class="mla-doc-table-sublabel">minimum F number in the maximum focal length element of the LensSpecification array.</td>
</tr>
<tr>
<td class="mla-doc-table-label">LensMake</td>
<td class="mla-doc-table-sublabel">Canon</td>
<td class="mla-doc-table-sublabel">the lens manufacturer as an ASCII string.</td>
</tr>
<tr>
<td class="mla-doc-table-label">LensModel</td>
<td class="mla-doc-table-sublabel">80.0-400.0 mm f/4.5-5.6</td>
<td class="mla-doc-table-sublabel">the lens's model name and model number as an ASCII string.</td>
</tr>
<tr>
<td class="mla-doc-table-label">LensSerialNumber</td>
<td class="mla-doc-table-sublabel"></td>
<td class="mla-doc-table-sublabel">the serial number of the interchangeable lens as an ASCII string.</td>
</tr>
</table>
<a name="mla_gps_values"></a>&nbsp;
<p>
<a href="#backtotop">Go to Top</a>
</p>
<h4>Field-level enhanced EXIF GPS values</h4>
<p>
There are three basic forms of writing geographic coordinates; they are explained in a Wikipedia article, <a href="http://en.wikipedia.org/wiki/Geographic_coordinate_conversion" title="Wikipedia on Geographic coordinate conversion" target="_blank">Geographic coordinate conversion</a>. The <a href="http://www.cipa.jp/std/documents/e/DC-008-2012_E.pdf" title="EXIF Version 2.3 specification" target="_blank">Exif Standard version 2.3</a> (PDF) and <a href="http://www.cipa.jp/std/documents/e/DC-008-Translation-2016-E.pdf" title="EXIF Version 2.31 specification" target="_blank">Exif Standard version 2.3</a> (PDF) documents explain the structure and defines the rules for 32 GPS elements.
</p>
<p>
The native format of this data is somewhat complicated, so MLA converts the most common elements into a variety of convenient formats. You can use the enhanced values as-is or use them in a Content Template to compose the format(s) you need. You can access the native values with the names defined in the EXIF specification, e.g., "GPSLatitude". The enhanced values are provided in th "GPS" array and accessed with compound names, e.g., "GPS.Latitude". The MLA enhanced values are:</p>
<table>
<tr style="font-weight: bold"><td>Field</td><td>Example</td><td>Content</td></tr>
<tr>
<td class="mla-doc-table-label">Version</td>
<td class="mla-doc-table-sublabel">2.2.0.0</td>
<td class="mla-doc-table-sublabel">The version of the GPS Information specification</td>
</tr>
<tr>
<td class="mla-doc-table-label">LatitudeRef</td>
<td class="mla-doc-table-sublabel">N or S</td>
<td class="mla-doc-table-sublabel">Indicates whether the latitude is north or south latitude</td>
</tr>
<tr>
<td class="mla-doc-table-label">LatitudeRefS</td>
<td class="mla-doc-table-sublabel">empty or "-"</td>
<td class="mla-doc-table-sublabel">Blank for north, "-" for south</td>
</tr>
<tr>
<td class="mla-doc-table-label">Latitude</td>
<td class="mla-doc-table-sublabel">44d 7' 34.0167" N</td>
<td class="mla-doc-table-sublabel">Latitude expressed as degrees, minutes and seconds</td>
</tr>
<tr>
<td class="mla-doc-table-label">LatitudeD</td>
<td class="mla-doc-table-sublabel">44</td>
<td class="mla-doc-table-sublabel">Degree portion of Latitude</td>
</tr>
<tr>
<td class="mla-doc-table-label">LatitudeM</td>
<td class="mla-doc-table-sublabel">7</td>
<td class="mla-doc-table-sublabel">Minute portion of Latitude</td>
</tr>
<tr>
<td class="mla-doc-table-label">LatitudeS</td>
<td class="mla-doc-table-sublabel">34.0167</td>
<td class="mla-doc-table-sublabel">Second portion of Latitude</td>
</tr>
<tr>
<td class="mla-doc-table-label">LatitudeSDM</td>
<td class="mla-doc-table-sublabel">44 7.5669</td>
<td class="mla-doc-table-sublabel">Latitude expressed as degrees and decimal minutes (MinDec),<br />with a leading "-" for Southern values</td>
</tr>
<tr>
<td class="mla-doc-table-label">LatitudeSDD</td>
<td class="mla-doc-table-sublabel">44.126116</td>
<td class="mla-doc-table-sublabel">Latitude expressed as decimal degrees,<br />with a leading "-" for Southern values</td>
</tr>
<tr>
<td class="mla-doc-table-label">LatitudeDM</td>
<td class="mla-doc-table-sublabel">44 7.5669N</td>
<td class="mla-doc-table-sublabel">Latitude expressed as degrees and decimal minutes (MinDec)</td>
</tr>
<tr>
<td class="mla-doc-table-label">LatitudeDD</td>
<td class="mla-doc-table-sublabel">44.126116N</td>
<td class="mla-doc-table-sublabel">Latitude expressed as decimal degrees</td>
</tr>
<tr>
<td class="mla-doc-table-label">LatitudeMinDec</td>
<td class="mla-doc-table-sublabel">7.5669</td>
<td class="mla-doc-table-sublabel">Decimal Minutes portion of Latitude</td>
</tr>
<tr>
<td class="mla-doc-table-label">LatitudeDegDec</td>
<td class="mla-doc-table-sublabel">.126116</td>
<td class="mla-doc-table-sublabel">Decimal Degrees portion of Latitude</td>
</tr>
<tr>
<td class="mla-doc-table-label">LongitudeRef</td>
<td class="mla-doc-table-sublabel">E or W</td>
<td class="mla-doc-table-sublabel">Indicates whether the Longitude is east or west longitude</td>
</tr>
<tr>
<td class="mla-doc-table-label">LongitudeRefS</td>
<td class="mla-doc-table-sublabel">empty or "-"</td>
<td class="mla-doc-table-sublabel">Blank for east, "-" for west</td>
</tr>
<tr>
<td class="mla-doc-table-label">Longitude</td>
<td class="mla-doc-table-sublabel">145d 5' 9.2055" E</td>
<td class="mla-doc-table-sublabel">Longitude expressed as degrees, minutes and seconds</td>
</tr>
<tr>
<td class="mla-doc-table-label">LongitudeD</td>
<td class="mla-doc-table-sublabel">145</td>
<td class="mla-doc-table-sublabel">Degree portion of Longitude</td>
</tr>
<tr>
<td class="mla-doc-table-label">LongitudeM</td>
<td class="mla-doc-table-sublabel">5</td>
<td class="mla-doc-table-sublabel">Minute portion of Longitude</td>
</tr>
<tr>
<td class="mla-doc-table-label">LongitudeS</td>
<td class="mla-doc-table-sublabel">9.2055</td>
<td class="mla-doc-table-sublabel">Second portion of Longitude</td>
</tr>
<tr>
<td class="mla-doc-table-label">LongitudeSDM</td>
<td class="mla-doc-table-sublabel">145 5.1534</td>
<td class="mla-doc-table-sublabel">Longitude expressed as degrees and decimal minutes (MinDec),<br />with a leading "-" for Western values</td>
</tr>
<tr>
<td class="mla-doc-table-label">LongitudeSDD</td>
<td class="mla-doc-table-sublabel">145.085890</td>
<td class="mla-doc-table-sublabel">Longitude expressed as decimal degrees,<br />with a leading "-" for Western values</td>
</tr>
<tr>
<td class="mla-doc-table-label">LongitudeDM</td>
<td class="mla-doc-table-sublabel">145 5.1534E</td>
<td class="mla-doc-table-sublabel">Longitude expressed as degrees and decimal minutes (MinDec)</td>
</tr>
<tr>
<td class="mla-doc-table-label">LongitudeDD</td>
<td class="mla-doc-table-sublabel">145.085890E</td>
<td class="mla-doc-table-sublabel">Longitude expressed as decimal degrees</td>
</tr>
<tr>
<td class="mla-doc-table-label">LongitudeMinDec</td>
<td class="mla-doc-table-sublabel">5.1534</td>
<td class="mla-doc-table-sublabel">Decimal Minutes portion of Longitude</td>
</tr>
<tr>
<td class="mla-doc-table-label">LongitudeDegDec</td>
<td class="mla-doc-table-sublabel">.085890</td>
<td class="mla-doc-table-sublabel">Decimal Degrees portion of Longitude</td>
</tr>
<tr>
<td class="mla-doc-table-label">AltitudeRef</td>
<td class="mla-doc-table-sublabel">0 or 1</td>
<td class="mla-doc-table-sublabel">0 = above sea level, 1 = below sea level</td>
</tr>
<tr>
<td class="mla-doc-table-label">AltitudeRefS</td>
<td class="mla-doc-table-sublabel">blank or "-"</td>
<td class="mla-doc-table-sublabel">Blank above sea level, "-" below sea level</td>
</tr>
<tr>
<td class="mla-doc-table-label">Altitude</td>
<td class="mla-doc-table-sublabel">247.0825</td>
<td class="mla-doc-table-sublabel">Altitude in meters</td>
</tr>
<tr>
<td class="mla-doc-table-label">AltitudeFeet</td>
<td class="mla-doc-table-sublabel">810.64</td>
<td class="mla-doc-table-sublabel">Altitude in feet</td>
</tr>
<tr>
<td class="mla-doc-table-label">TimeStamp</td>
<td class="mla-doc-table-sublabel">01:00:34</td>
<td class="mla-doc-table-sublabel">The time as UTC (Coordinated Universal Time)</td>
</tr>
<tr>
<td class="mla-doc-table-label">TimeStampH</td>
<td class="mla-doc-table-sublabel">01</td>
<td class="mla-doc-table-sublabel">The hours portion of TimeStamp</td>
</tr>
<tr>
<td class="mla-doc-table-label">TimeStampM</td>
<td class="mla-doc-table-sublabel">00</td>
<td class="mla-doc-table-sublabel">The minutes portion of TimeStamp</td>
</tr>
<tr>
<td class="mla-doc-table-label">TimeStampS</td>
<td class="mla-doc-table-sublabel">34</td>
<td class="mla-doc-table-sublabel">The seconds portion of TimeStamp</td>
</tr>
<tr>
<td class="mla-doc-table-label">DateStamp</td>
<td class="mla-doc-table-sublabel">2013:08:09</td>
<td class="mla-doc-table-sublabel">The date as UTC (Coordinated Universal Time)</td>
</tr>
<tr>
<td class="mla-doc-table-label">DateStampY</td>
<td class="mla-doc-table-sublabel">2013</td>
<td class="mla-doc-table-sublabel">The year portion of DateStamp</td>
</tr>
<tr>
<td class="mla-doc-table-label">DateStampM</td>
<td class="mla-doc-table-sublabel">08</td>
<td class="mla-doc-table-sublabel">The month portion of DateStamp</td>
</tr>
<tr>
<td class="mla-doc-table-label">DateStampD</td>
<td class="mla-doc-table-sublabel">09</td>
<td class="mla-doc-table-sublabel">The day portion of DateStamp</td>
</tr>
<tr>
<td class="mla-doc-table-label">MapDatum</td>
<td class="mla-doc-table-sublabel">WGS-84</td>
<td class="mla-doc-table-sublabel">The geodetic survey data used by the GPS receiver</td>
</tr>
</table>
<a name="pdf_metadata"></a>&nbsp;
<p>
<a href="#backtotop">Go to Top</a>
</p>
<h4>Field-level metadata in PDF documents</h4>
<p>
Metadata in PDF documents comes from two sources. Early versions of the PDF specification defined a Document Information Dictionary (D.I.D.) containing up to nine (optional) fields:
</p>
<table>
	<tr>
		<td class="mla-doc-table-label">Title</td>
		<td>The document's title</td>
	</tr>
	<tr>
		<td class="mla-doc-table-label">Author</td>
		<td>The name of the person who created the document</td>
	</tr>
	<tr>
		<td class="mla-doc-table-label">Subject</td>
		<td>The subject of the document</td>
	</tr>
	<tr>
		<td class="mla-doc-table-label">Keywords</td>
		<td>Keywords associated with the document</td>
	</tr>
	<tr>
		<td class="mla-doc-table-label">Creator</td>
		<td>If the document was converted to PDF from another format, the name of the application (for example, Adobe FrameMaker&reg;) that created the original document from which it was converted</td>
	</tr>
	<tr>
		<td class="mla-doc-table-label">Producer</td>
		<td>If the document was converted to PDF from another format, the name of the application (for example, Acrobat Distiller) that converted it to PDF</td>
	</tr>
	<tr>
		<td class="mla-doc-table-label">CreationDate</td>
		<td>The date and time the document was created, in human-readable form</td>
	</tr>
	<tr>
		<td class="mla-doc-table-label">ModDate</td>
		<td>The date and time the document was most recently modified, in human-readable form</td>
	</tr>
	<tr>
		<td class="mla-doc-table-label">Trapped</td>
		<td>A keyword (True, False, Unknown) indicating whether the document has been modified to include trapping information</td>
	</tr>
</table>
<p>
More recent versions of the specification add a second source of metadata, Metadata Streams, holding data defined by the <a href="https://www.adobe.com/products/xmp/" title="Adobe XMP site" target="_blank">Extensible Metadata Platform (XMP)</a> framework. XMP metadata varies from document to document but is often extensive. MLA provides access to this data in four ways:
</p>
<ol>
<li>
If a D.I.D. field is not stored in the document, MLA will copy appropriate values from the XMP data into the empty field to populate it as often as possible. For example, the "creator" value(s) in the "dc" namespace ("dc.creator") might be copied to an empty "Author" field, or the "dc.subject" value(s) might be copied to an empty Keywords field.
</li>
<li>
Additional values in the "xmp", "xmpMM", "xmpRights", "xap", "xapMM", "dc", "pdf" and "pdfx" namespaces are copied up to the root level for easier access. For example, the "pdfx.SourceModified" value can be accessed as "SourceModified", without the "pdfx." portion of the compound name.
</li>
<li>
Other namespaces in the document are copied to arrays at the root level. For example, some documents contain information in the "photoshop" namespace, such as "photoshop.CaptionWriter" and "photoshop.AuthorsPosition". The native values of some fields, e.g., "dc.creator", can be an array.
</li>
<li>
For consistency with other file types, all XMP data found in a PDF document is also available with the "xmp:" prefix.
</li>
</ol>
<p>
MLA adds five fields of its own to the metadata information:
</p>
<table>
	<tr>
		<td class="mla-doc-table-label">PDF_Version</td>
		<td>the version of the PDF specification to which the file conforms. For a file conforming to PDF 1.7, this would be PDF−1.7</td>
	</tr>
	<tr>
		<td class="mla-doc-table-label">PDF_VersionNumber</td>
		<td>the numeric portion of the PDF_Version. For a file conforming to PDF 1.7, this would be 1.7</td>
	</tr>
	<tr>
		<td class="mla-doc-table-label">xmptk</td>
		<td>the XMP software used to create the metadata</td>
	</tr>
	<tr>
		<td class="mla-doc-table-label">xmlns</td>
		<td>an array of the namespaces found in the document, such as <code>'dc' => 'http://purl.org/dc/elements/1.1/'</code></td>
	</tr>
	<tr>
		<td class="mla-doc-table-label">ALL_PDF</td>
		<td>a special "pseudo value" that returns a string representation of all the metadata. You can use this pseudo-value to examine the metadata in a document, find field names and see what values are present.</td>
	</tr>
</table>
<a name="substitution_parameter_filters"></a>&nbsp;
<p>
<a href="#backtotop">Go to Top</a>
</p>
<h4>Field-level substitution parameter filters (Hooks)</h4>
<p>
Field-level substitution parameters can be extended to include any data values your application requires. They are supported by a set of filters that enables PHP code in your theme or in another plugin to create data values and make them available to MLA. An example of using the hooks from a simple, stand-alone plugin can be found in the Documentation/Example Plugins submenu. You can find the example plugin here: <a title="Find the Substitution Parameter Hooks Example" href="[+example_url+]&amp;mla-example-search=Search+Plugins&amp;s=%22MLA+Substitution+Parameter+Hooks+Example%22" class="mla-doc-bold-link">MLA Substitution Parameter Hooks Example</a>. To run the example:
</p>
<ol>
<li>Click on the link above or go to top of the Documentation tab and click on the "Example Plugins" button.</li>
<li>Hover over "MLA Substitution Parameter Hooks Example" in the Name column, then click the "Install" rollover action.</li>
<li>Go to the Plugins/Installed Plugins screen and activate the "MLA Substitution Parameter Hooks Example" plugin.</li>
<li>Create a new `[mla_gallery]` shortcode, markup template or mapping rule that uses terms from an item's parent post/page.</li>
<li>Run the shortcode or mapping rule to see the plugin's data put to use.</li>
</ol>
<p>
The following hooks are defined in <code>/wp-admin/includes/class-mla-data.php</code>:
</p>
<table>
<tr>
<td class="mla-doc-table-label">mla_expand_custom_data_source</td>
<td class="mla-doc-hook-definition"><strong>for shortcode and Content Template processing</strong>, called when a parameter has no prefix value and the data-source name is not recognized by MLA, giving you an opportunity to generate your custom data value. Use a distinctive data-source name to minimize the risk that your name will conflict with other plugins or future MLA versions.</td>
</tr>
<tr>
<td class="mla-doc-table-label">mla_expand_custom_prefix</td>
<td class="mla-doc-hook-definition">called when a parameter's prefix value is not recognized by MLA, giving you an opportunity to generate your custom data value. Using a custom prefix lowers the risk that your data-source name will conflict with other plugins or future MLA versions.</td>
</tr>
<tr>
<td class="mla-doc-table-label">mla_apply_custom_format</td>
<td class="mla-doc-hook-definition">called when a parameter's option/format value is not recognized by MLA, giving you an opportunity to apply your custom option/format to the data value. This filter is called after either of the two "expand_custom" filters above. It will also be called if you use a custom option/format with any other field-level substitution parameter.</td>
</tr>
<tr>
<td class="mla-doc-table-label">mla_fetch_attachment_image_metadata_raw</td>
<td class="mla-doc-hook-definition"><strong>for Attachment File Metadata processing</strong>, called after MLA has extracted the metadata but before MLA enhances the EXIF metadata with CAMERA and GPS values, giving you an opportunity to add or modify the "raw" metadata values.</td>
</tr>
<tr>
<td class="mla-doc-table-label">mla_fetch_attachment_image_metadata_final</td>
<td class="mla-doc-hook-definition"><strong>for Attachment File Metadata processing</strong>, called after MLA enhances the EXIF metadata with CAMERA and GPS values, giving you an opportunity to add or modify the "final" metadata values.</td>
</tr>
</table>
<p>
The following hook is defined in <code>/wp-admin/includes/class-mla-data-source.php</code>:
</p>
<table>
<tr>
<td class="mla-doc-table-label">mla_evaluate_custom_data_source</td>
<td class="mla-doc-hook-definition"><strong>for metadata mapping rules</strong>, called when a parameter has no prefix value and the data-source name is not recognized by MLA, giving you an opportunity to generate your custom data value. Use a distinctive data-source name to minimize the risk that your name will conflict with other plugins or future MLA versions.</td>
</tr>
</table>
<p>
Note the distinction between <code>mla_expand_custom_data_source</code> and <code>mla_evaluate_custom_data_source</code>; they are called in different contexts with slightly different parameters.
<a name="mla_template_parameters"></a>
</p>
<p>
<a href="#backtotop">Go to Top</a>
</p>
<h3>Content Templates</h3>
<p>
Content Templates (templates) are one of the Field-level Markup Substitution Parameters, indicated by a prefix value ( <code>[+template: ... +]</code> ). Within a template you can have any combination of four elements:
</p>
<table>
	<tr>
		<td class="mla-doc-table-label">String</td>
		<td>text and/or field-level substitution parameters, e.g., <code>[+template: Base File - [+base_file+] +]</code></td>
	</tr>
	<tr>
		<td class="mla-doc-table-label">Conditional</td>
		<td>text and/or field-level substitution parameters that will be tested for missing values. Any field-level substitution parameter that is not valid, is empty or contains only whitespace will cause the entire conditional to be eliminated. Conditional elements are enclosed in parentheses. For example, <code>[+template: (IPTC Title: [+iptc:object-name+] ) +]</code>. If the IPTC field is missing or blank both it and the preceding "IPTC Title: " literal are eliminated.</td>
	</tr>
	<tr>
		<td class="mla-doc-table-label">Choice</td>
		<td>two or more alternatives from which the first valid, non-empty value will be taken. Choice elements are separated by vertical bars ("|"), e.g., <code>[+template: Summary: ([+caption+]|[+description+]|[+title+]) +]</code></td>
	</tr>
	<tr>
		<td class="mla-doc-table-label">Template</td>
		<td>another template. There is no particular advantage to nesting templates, but it works.</td>
	</tr>
</table>
<p>
The conditional and choice elements are the key to templates' power, particularly with custom fields and metadata such as IPTC and EXIF. With the conditional element you can combine literal text with a substitution value and eliminate the text if the value is missing. With the choice element you can specify multiple sources for a value and decide the order in which they are tested. In the choice example above the text "Description: " will always be used, followed by the attachment's caption (if present) or the description value or the literal "none" if both of the other values are missing. In other words, each alternative of the choice element is evaluated as a conditional element; no need for more parentheses.
</p>
<p>
Conditional, choice and template elements can be nested as needed. For example, a conditional element can have a choice element within it or a choice alternative could include a conditional. Here's an example:
</p>
<p>
<code>[+template: Terms: (([+terms:category+], [+terms:post_tag+])|[+ terms: category +]|[+terms:post_tag +]|none)+]</code>
</p>
<p>
This template has a String, "Terms: " and a Conditional, "(([+terms: ... none)". This Conditional separates the "Terms: " literal from the first alternative in the Choice. Within the Conditional is a Choice having four alternatives. The first alternative is a Conditional, which will be empty unless both categories and tags are present.  The second and third alternatives handle the cases where one of the two taxonomies has terms, and the final alternative is used when neither categories nor tags are present.
</p>
<p>
In the Media/Assistant submenu table Bulk Edit area and the IPTC/EXIF/WP Standard Field mapping fields you can use the special <code>template:[+empty+]</code> value to support deleting the content of the Title, Caption, Description and ALT Text fields. For a Custom Field mapping rule, set the Data Source to "-- Template (see below) --", and enter <code>[+empty+]</code> in the Meta/Template text box. Set Existing Text to "Replace" and check the Delete NULL Values box.
</p>
<h4>Special characters inside templates</h4>
<p>
The conditional and choice elements require delimiters, "(", ")" and "|". If you want to put any of these three characters in your template, preface them with a backslash character, e.g., "\(". If you need a backslash in your template, code it as two backslash characters, i.e., "\\".
</p>
<p>
<strong>In a shortcode parameter:</strong> If your template is coded in a shortcode parameter, preface the template delimiters with two backslash characters, e.g., "\\(". If you need a backslash in your template, code it as four backslash characters, i.e., "\\\\". The doubling of backslash characters is required because of the way WordPress processes shortcode parameters.
<a name="mla_regular_expressions"></a>
</p>
<p>
<a href="#backtotop">Go to Top</a>
</p>
<h3>Regular Expression Features</h3>
<p>
Regular Expressions is a formal name for a powerful pattern-matching tool you can use to extract parts of, for example, a file name and use the parts to compose or update a caption, title or other item element. Although they can get complicated pretty quickly regular expressions are well defined and even simple examples can be quite powerful. They are definitely a power tool! You can find a wealth of information on the web, such as these resources:
</p>
<ul class="mla_settings">
<li><a href="https://en.wikipedia.org/wiki/Regular_expression" title="Wikipedia Article" target="_blank">Regular expression - Wikipedia</a></li>
<li><a href="http://www.regular-expressions.info/" title="The Premier website about Regular Expressions" target="_blank">Regular-Expressions.info</a></li>
<li><a href="http://php.net/manual/en/book.pcre.php" title="Official PHP Documentation for regular expressions" target="_blank">Regular Expressions (Perl-Compatible) in PHP</a></li>
</ul>
<p>
The MLA regular expression features are simply a way to access a few of PHP's PCRE functions, so the last link above is particularly useful. The <a href="http://php.net/manual/en/pcre.examples.php" title="PCRE Examples" target="_blank">Examples</a> and <a href="http://php.net/manual/en/reference.pcre.pattern.syntax.php" title="Pattern Syntax" target="_blank">PCRE regex syntax</a> sections give you the details you need to build your expressions. The rest of this section describes how the PCRE functions are made available within MLA shortcodes, custom markup templates, mapping rules and the Bulk Edit area. Of course, they can be used within Content Templates in any of these areas as well.
<a name="mla_regular_expressions_patterns"></a>
</p>
<h4>Patterns and subpatterns</h4>
<p>
Each regular expression defines a "pattern" that is applied to the subject, or data source. If the pattern is matched, that part of the data source is returned from the option/format value. Subpatterns allow you to take a portion of the overall pattern and return it separately. For example, you might construct a pattern that matches a date and include within the pattern subpatterns that return the year, month and day portions of the date. The pattern and subpattern matches are stored by MLA and become data sources you can access with the <code>matches:</code> field-level prefix. By default, the pattern match and any subpattern match(es) are assigned index numbers. The pattern is number zero and the subpatterns are numbered from one to the total number of subpatterns.
</p>
<p>
When coding a pattern as a parameter for any of these option/format values remember to start and end with a delimiter, e.g., a slash, and to enclose the parameter in single quotes. For example, for a pattern that matches an "x", code the parameter as <code>'/x/'</code>.
</p>
<p>
For example, consider the <code>post_date</code> data source, the "Uploaded on" date and time for a Media Library item. This date is stored as a string with a specific format: "YYYY-MM-DD HH:MM:SS", e.g., "2013-10-03 02:47:13". You can match this value in many ways:
</p>
<ul class="mla_settings">
<li><strong>/\d{4}-\d{2}-\d{2} \d{2}:\d{2}:\d{2}/</strong> - matches the entire date and time, e.g., "2013-10-03 02:47:13"</li>
<li><strong>/(\d{4}-\d{2}-\d{2}) (\d{2}:\d{2}:\d{2})/</strong> - matches the entire date and time (index 0) and matches two subpatterns, for the date portion (index 1) and the time portion (index 2)</li>
<li><strong>/\d{4}-\d{2}-\d{2}/</strong> - matches the date portion, e.g., "2013-10-03"</li>
<li><strong>/\d{2}:\d{2}:\d{2}/</strong> - matches the time portion, e.g., "02:47:13"</li>
<li><strong>/(\d{4})-(\d{2})-(\d{2})/</strong> - matches the date portion (index 0) and matches three subpatterns for the year (index 1), month (index 2) and day (index 3) portions.</li>
<li><strong>/(?&lt;year&gt;\d{4})-(?&lt;month&gt;\d{2})-(?&lt;day&gt;\d{2})/</strong> - matches the date portion (index 0) and matches three subpatterns for the year (index 1, name "year"), month (index 2, name "month") and day (index 3, name "day") portions.</li>
</ul>
<p>
The last example is particularly useful, because named subpatterns let you give unique names to each piece of your data for later use with the <code>matches:</code> prefix. With only one pattern the index values are fine, but if you have more than one pattern the index numbers are reused so later patterns overwrite matches from earlier patterns.
</p>
<p>
The patterns above contain backslash ('\') characters. When entering backslashes in an argument of the three option/format values below <strong>you must code two backslashes</strong> because the backslash is used in function arguments to escape special characters such as quotes (" ' "). The examples below show how this is done.
<a name="mla_regular_expressions_match"></a>
</p>
<h4>The <code>,match(p)</code> option/format value</h4>
<p>
The <code>,match(p)</code> option/format value can be applied to any data source, including those specified by any of the field-level prefix values. The "p" argument is a regular expression pattern that is applied to the data source. If a match is found the portion of the data source that matches the pattern is returned. If no match is found and empty value is returned. Any pattern and subpattern matches are stored and made available as data sources accessed with the <code>matches:</code> field-level prefix.
<a name="mla_regular_expressions_extract"></a>
</p>
<h4>The <code>,extract(p,v)</code> option/format value</h4>
<p>
The <code>,extract(p)</code> option/format value can be applied to any data source, including those specified by any of the field-level prefix values. The "p" argument is a regular expression pattern that is applied to the data source. By default, the <code>,extract(p)</code> option/format value <strong>returns an empty value</strong>; it's purpose is to collect pattern/subpattern matches for later use as data sources accessed with the <code>matches:</code> field-level prefix. You can change the returned value by adding the optional second "v" argument to specify any of the matched pattern or subpattern keys. For example, add zero ("0") to return the entire pattern, the index number of a subpattern or the name of a named subpattern.
<a name="mla_regular_expressions_replace"></a>
</p>
<h4>The <code>,replace(p,r,v)</code> option/format value</h4>
<p>
The <code>,replace(p,r)</code> option/format value matches a pattern (like <code>,match(p)</code>) but returns a modified version of the original data source value. The "p" argument is a regular expression pattern that is applied to the data source. The "r" argument is a replacement pattern. If a match is found the data source modified by the replacement pattern is returned. If the match is not found, the original data source value is returned unaltered. For example, if a <code>post_date</code> data source contains "2013-10-03 02:47:13", then <code>[+post_date,replace( '/(\\d{4})-(\\d{2})-(\\d{2})/', 'year: $1, month: $2, day: $3' )+]</code> would return "year: 2013, month: 10, day: 03 02:47:13". Note the double backslashes in the pattern argument! To specify an array argument enclose the argument in braces ( "{" and "}" ) and separate elements with <strong>spaces</strong>. For a simple example, <code>,replace( {'/,/' '/-/'}, {' ' '_'} )</code> will change commas to spaces and dashes to underscores, while <code>,replace( {'/,/' '/-/'}, ' ' )</code> will change both commas <strong>and</strong> dashes to spaces.
</p>
<p>
If you enter an array of mutiple patterns, note that they are processed sequentially. In other words, the first pattern replacement is performed, creating a new value. Then, the second pattern replacement is performed on the new value that includes the results of the first pattern replacement, and so on.
</p>
<p>
You can alter the value returned by adding the optional third "v" parameter set to "true". If you add this parameter the returned value will be just the matched portion of the original with the replacement modifications applied. For example, if a <code>post_date</code> data source contains "2013-10-03 02:47:13", then <code>[+post_date,replace( '/(\\d{4})-(\\d{2})-(\\d{2})/', 'year: $1, month: $2, day: $3', true )+]</code> would return "year: 2013, month: 10, day: 03". Note the double backslashes in the pattern argument!
</p>
<p>
Note that, unlike match and extract, the replace format/option value does not store its pattern or subpattern(s) for later use with the matches: prefix.
<a name="mla_regular_expressions_matches"></a>
</p>
<h4>The <code>matches:</code> field-level prefix</h4>
<p>
The <code>matches:</code> field-level prefix lets you access the patterns and subpatterns matched by all of the match and extract format/option values that precede it in a shortcode, template or rule. For example, if you code <code>[+post_date,extract( '/(?&lt;year&gt;\\d{4})-(?&lt;month&gt;\\d{2})-(?&lt;day&gt;\\d{2})/' )+]</code> you can then code <code>[+matches:year+]</code> or <code>[+matches:1+]</code> (index 1) to access the year subpattern from the extract format/option.
<a name="mla_regular_expressions_examples"></a>
</p>
<h4>Application Examples</h4>
<p>
Imagine that you have a photo archive where all the files are named with the date on which the image was taken, for example "2010.06.14 Death Valley Landscape.jpg". You would like to extract the date from the file name and use it to update the post_date (Uploaded on) date in the database. You'd also like to preserve the time portion of the current post_date so the items will sort in the order they were uploaded. You can define an IPTC/EXIF/WP mapping rule to do this or use the Media/Assistant Bulk Edit area. In either place you can compose a Content Template to do the job:
</p>
<p>
<code>template:[+name_only,extract( '/(?&lt;year&gt;\\d{4}).(?&lt;month&gt;\\d{2}).(?&lt;day&gt;\\d{2})/' )+]([+matches:year+]-[+matches:month+]-[+matches:day+] [+post_date,date( 'H:i:s' )+])</code>
</p>
<p>
That looks complicated, so let&rsquo;s consider each part. The first part, <code>[+name_only,extract( ...</code>, extracts the three subparts of the date from the file name and stores them for later use. This part of the template returns an empty value, so it does not contribute to the new post_date value. The second part uses three <code>[+matches: ...</code> data sources to build a valid date separated by dashes. The third part returns just the time portion of the original post_date. The second and third part are surrounded by parentheses, so an empty value is returned when the date values are not found in the file name. That will leave the original post_date value intact for any items whose file names lack a date portion.
</p>
<p>
Here is a somewhat shorter alternative:
</p>
<p>
<code>template:[+name_only,extract( '/(?&lt;filedate&gt;\\d{4}.\\d{2}.\\d{2})/' )+]([+matches:filedate,str_replace( '.', '-' )+] [+post_date,date( 'H:i:s' )+])</code>
</p>
<p>
In this alternative the first part extracts the complete date with its period separators. The second part reformats the date, replacing the periods with dashes. The third part is the same as in the first alternative.
</p>
<p>
One subtle point. The period characters (".") separating the year, month and day portions of the pattern are actually one of the regular expression metacharacters; they will match any character in the subject. For example, they will match "2010/06/14" or "2010X06X14". Either of those values will cause the <code>str_replace()</code> function to fail. If you want to explicitly match a period, preface it with a backslash, e.g.:
</p>
<p>
<code>template:[+name_only,extract( '/(?&lt;filedate&gt;\\d{4}\.\\d{2}\.\\d{2})/' )+]([+matches:filedate,str_replace( '.', '-' )+] [+post_date,date( 'H:i:s' )+])</code>
</p>
<p>
Finally, here&rsquo;s a version that uses the <code>replace</code> value in a different way:
</p>
<p>
<code>template:([+name_only,replace( '/(\\d{4})\.(\\d{2})\.(\\d{2})/','$1-$2-$3',true)+] [+post_date,date( 'H:i:s' )+])</code>
</p>
<p>
In this version the first part matches the date at the beginning of the file name and replaces its period separators with dashes. It uses the thrid `true` argument to return just the matches/modified portion of the file name. The second part is the same as in the first alternative.
</p>
<p>
As you can see, regular expressions require close attention to detail and they reward careful study of the documentation and examples in the PHP documentation and elsewhere. They are a power tool with sharp edges.
<a name="mla_text_widget"></a>
</p>
<p>
<a href="#backtotop">Go to Top</a>
</p>
<h3>The MLA Text Widget</h3>
<p>
The MLA Text Widget lets you add content such as <code>[mla_gallery]</code> and <code>[mla_tag_cloud]</code> displays to your site's sidebars. It is an easy way to add slide shows and navigation features to all your pages. The MLA Text Widget is based on the WordPress Text widget, but adds the ability to include <strong>any</strong> shortcode to widget content. To use the MLA Text Widget:
</p>
<ol>
<li>Go to the Appearance/Widgets Administration screen</li>
<li>Open the sidebar, footer, or Theme section to which you wish to add the Text Widget</li>
<li>Find the Text Widget in the list of Widgets</li>
<li>Click and drag the Widget to the spot you wish it to appear</li>
</ol>
<p>
To open and edit the MLA Text Widget: 
</p>
<ol>
<li>Click the down arrow to the right of the MLA Text Widget title</li>
<li>Set the MLA Text Widget Title (optional)</li>
<li>Add the text or HTML code to the box or edit what is currently there</li>
<li>If desired, choose the option to Automatically add paragraphs to wrap each block of text in an HTML paragraph tag</li>
<li>Click Save to save the Widget</li>
<li>Click Close to close the Widget</li>
<li>Switch tabs in your browser and review the results; make changes if necessary</li>
</ol>
<p>
To add an <code>[mla_gallery]</code> or <code>[mla_tag_cloud]</code> shortcode to your widget, simply enter the shortcode name and parameters just as you would in the body of a post or page. Aside from the usually more limited area devoted to displaying the widget content, there are no differences in the way shortcodes are processed in the MLA Widget. Also, there is nothing special about the two MLA shortcodes; <strong>any</strong> shortcode can be added to the MLA Widget.
<a name="where_used_reporting"></a>
</p>
<p>
<a href="#backtotop">Go to Top</a>
</p>
<h3>Where-used Reporting</h3>
<p>The Media/Assistant "where-used" columns (Featured in, Inserted in, Gallery in, MLA Gallery in) are a powerful tool for managing your attachments. They help you identify Media Library items that are obsolete or, well, unused. These features were the original motivation for beginning work on this plugin years ago.</p>
<h4>Unused Vs Unattached</h4>
<p>WordPress notions of "attachments" and <a href="https://wordpress.org/documentation/article/use-image-and-file-attachments/#attachment-to-a-post" target="_blank">Attachment to a Post</a> are very, very old, going back to WP 2.0. In some ways attachments are the original custom post type. Because of the way WordPress has evolved in recent years "unattached" is unreliable in many sites and applications. It has a very precise definition; there is a "post_parent" field in the database and if this field contains zero the item is unattached. However, even WordPress itself has flaws in maintaining this field, to say nothing of plugins and themes. Also for cases like "Featured Image" where the same item can be used in multiple posts/pages, what's the proper "parent"? The original purpose of attaching an item to a post or page was tied to the <a href="https://wordpress.org/documentation/article/the-wordpress-gallery-classic-editor/#gallery-shortcode" target="_blank">WordPress <code>[gallery]</code> shortcode</a> (also very old). When WordPress 3.5 changed the way image galleries were composed the notion of "parent" fell into disuse.</p>
<p>The only time WordPress "un-attaches" an item is when the parent post/page is deleted. Deleting an item block or other insertion in the post/page content will not affect the attached status. Attached items do not have to explicitly appear in the post/page content. Part of the original WordPress implementation was the [gallery] shortcode, which displays the attached images. I would guess that's why WordPress never added any automatic detaching features.</p>
<p>MLA provides "Set Parent" elements for attaching and detaching Media Library items and some attaching tools in the "Attach Media Library items" section of the <a title="Find the Insert Fixit Example" href="[+example_url+]&amp;mla-example-search=Search+Plugins&amp;s=%22MLA+Insert+Fixit%22" class="mla-doc-bold-link" target="_blank">MLA Insert Fixit example plugin</a>. It does not have any logic to detect and detach items as they are removed from a post/page. The bottom line is that detaching items is a manual admin task in the current WordPress and MLA versions.</p>
<h4>Activating the Categories</h4>
<p>There are four where-used reporting categories and you can turn them on or off with options in the "Where-used database access tuning" section on the Settings/Media Library Assistant General tab. Here's a summary:</p>
<table><tr>
<td>Featured in</td>
<td>Search database posts and pages for Featured Image attachments.</td>
</tr><tr>
<td>Inserted in</td>
<td>Search database posts and pages for attachments embedded in content.<br />
Enabled = report each intermediate and full size insertion separately.<br />
Base = ignore intermediate size suffixes; use path, base name and extension only.</td>
</tr><tr>
<td>Gallery in</td>
<td>Search database posts and pages for <code>[gallery]</code> shortcode results.<br />
Dynamic = once every page load, Cached = once every login, Disabled = never.<br />
Refresh = update references, then set to Cached.</td>
</tr><tr>
<td>MLA Gallery in</td>
<td>Search database posts and pages for <code>[mla_gallery]</code> shortcode results.<br />
Dynamic = once every page load, Cached = once every login, Disabled = never.<br />
Refresh = update references, then set to Cached.</td>
</tr></table>
<p>Because the analysis requires significant processor, memory and database resources all four categories are Disabled by default. Use them when you need them and disable them when you don't. Once you have activated the categories you want, navigate to the Media/Assistant admin submenu, pull down the "Screen Options" in the upper-right corner of the screen and check the box next to the where-used columns you want to add to the submenu table.</p>
<p>MLA's where-used reporting was actually the first feature I implemented and they were the original inspiration for the plugin. When you need them they are very useful but it takes a lot of database work to perform their analysis. The "Inserted in" feature must go through every post and page on the site and search the content for any IMG tags containing a Media Library item. The "Gallery in" and "MLA Gallery in" features must find every shortcode in every post/page and then execute the shortcodes to see which items they return.
All of this processing can severely slow down the site, especially for sites with thousands of Media Library items. That's why there are switches to turn the features off and that's why the default settings are "Disabled".</p>
<p>Because an item can be used in several places, the Media/Assistant table columns are not sortable. If you want to sort and filter the table based on where-used information you can create a custom field. This technique is explained in the "Sorting and Filtering on Where-used Status" subsection below.</p>
<h4>Intrepreting The Results</h4>
<p>The "(INVALID PARENT)" notation means that the item is attached (i.e., the post_parent database field is not zero), but either the parent ID is for a post or page which has been deleted or the parent ID exists but the attachment is not used as the Featured Image, not inserted in the body of the post/page and is not used in a <code>[gallery]</code> or <code>[mla_gallery]</code> shortcode on that post/page. There are some problems with the post_parent field; for example, if you change the "Featured Image" for a post the post_parent doesn't always get updated. There are some ways to use an item that MLA is not yet searching for. For example, some other plugin that uses the item in a shortcode other than <code>[gallery]</code> or <code>[mla_gallery]</code>.</p>
<p>The "(UNUSED)" notation means that the MLA search found a valid parent for the item but the parent does not use the item as a Featured Image, it is not inserted in the body of the parent and it is not used in a [gallery] or [mla_gallery] shortcode in the parent.</p>
<p>The "(ORPHAN)" notation means that the MLA search did not find any post or page which uses the item as a Featured Image, it is not inserted in the body of any post/page and is not used in any [gallery] or [mla_gallery] shortcode.</p>
<p>If one or more of the categories is turned off, you will see "(UNUSED?)" or "(ORPHAN?)" in the where-used results. The question mark means that the item may be used in a way you are not testing for. If all of the categories are turned off you will see "(NO REFERENCE TESTS)" as a reminder.</p>
<h4>Limitations and Warnings</h4>
<p><strong>Before you rely on the "(UNUSED)" notation and start deleting items from the Media Library</strong> it is vital to understand the limitations of MLA's approach. The "Inserted in" category relies on finding image tags in post/page content by matching specific patterns within the HTML markup. Some plugins, blocks and page builders format their tags differently and may not be detected. You can always look for one or more items you know are used and see if they're flagged as "(UNUSED)".</p>
<p>The "Gallery in" category reports only the results of executing any <code>[gallery]</code> shortcode found in post/page content. MLA actually runs every shortcode it finds and parses the results in much the same way as the "Inserted in" category. Many gallery and lightbox plugins work by taking over the <code>[gallery]</code> shortcode and they may or may not format their results in a way MLA looks for.</p>
<p>The "MLA Gallery in" category reports the results of executing any <code>[mla_gallery]</code> shortcode found in post/page content. This works well if the items selected by the shortcode do not change based on selections made by the user when the post/page is processed. For example, selecting taxonomy terms from a <code>[mla_tag_cloud]</code> or <code>[mla_term_list]</code> shortcode or doing a keyword or term name search by entering text values cannot be analyzed in the admin mode.</p>
<h4>The WordPress Media Trash Feature</h4>
<p>You can make deleting items somewhat safer by enabling the WordPress "Trash" feature for Media Library items. To do that, add these two elements to your wp-config.php file:</p>
<code>
/**<br />
&nbsp;* Days before trash items permanently deleted.<br />
&nbsp;*<br />
&nbsp;* Set this to 0 to disable trash and permanently delete items<br />
&nbsp;* Set this > 0 to hold items in Trash state for 1 or more days <br />
&nbsp;*/<br />
define ('EMPTY_TRASH_DAYS', 360);<br />
<br />
/**<br />
&nbsp;* Enable the Trash feature for attachments.<br />
&nbsp;*<br />
&nbsp;* Set this to true to enable the Trash<br />
&nbsp;* Set this to false (the default) to disable the Trash <br />
&nbsp;*/<br />
define ('MEDIA_TRASH', true);
</code>
<p>With those additions you the "Permanently delete" operations become "Move to trash" and a new "Trash" view is available above the Media/Assistant submenu table. Selecting the Trash view gives you a list of the trashed items; you can restore them or permanently delete them as needed.</p>
<h4>Where-used Substitution Parameter/Data Source Values</h4>
<p>All four categories are available as <a href="#field_level_data_sources" target="_blank">Field-level data sources</a>. In that Documentation subsection scroll down to "parent_issues" and read through the list down to "mla_gallery_in_title". These values are available only when the corresponding category is active.</p>
<p>You can, of course, use them directly, e.g., in an <code>[mla_gallery]</code> shortcode or custom markup template. If you do, be aware of the performance issues because the values will be computed each time the data source is used and the categories must remain enabled. A more common alternative is to use the values in an IPTC/EXIF/WP or Custom Field mapping rule, storing the information as text in a custom field and then using the custom field value for display purposes. If you take that approach you can disable the categories once the custom field is populated, restoring performance. The next subsection is a detailed example of the mapping rule &amp; custom field approach.</p>
<h4>Sorting and Filtering on Where-used Status</h4>
<p>As noted above the four Media/Assistant where-used columns are not sortable, and they cannot be used to filter the table display. There is no explicit way to filter the Media/Assistant submenu table to display only where-used issues such as "orphans". There is, however, an approximate solution that may be useful. To get the best results you need to activate all four reporting categories in the Where-used Reporting section of the Settings/Media Library Assistant General tab. Try these settings:</p>
<ul class="mla_settings">
<li>Featured in - Enabled</li>
<li>Inserted in - Base</li>
<li>Gallery in - Cached</li>
<li>MLA Gallery in - Cached</li>
</ul>
<p>Once that's done you can proceed. Briefly, the solution has two parts: 1) create a custom field to record the where-used issues for your items, and 2) filter the Media/Assistant submenu table on the custom field values. For part 1), follow these steps:</p>
<ol>
<li>Navigate to the Settings/Media Library Assistant "Custom Fields" tab.</li>
<li>Scroll down to the "Add New Custom Field Rule" area below the "Enable" checkboxes.</li>
<li>Under the "Name" dropdown control, click "Enter new field" to create a new custom field.</li>
<li>In the "Name" text box, give your field a name, e.g., "Ref Issues".</li>
<li>From the Data Source dropdown list, select "reference_issues".</li>
<li>Click the "MLA Column" check box to make the field available in the Media/Assistant submenu table. Leave the "Quick Edit" and "Bulk Edit" check boxes unchecked for this solution.</li>
<li>In the "Existing Text" dropdown list, select "Replace".</li>
<li>In the "Format" dropdown list, select "Native".</li>
<li>In the "Option:" dropdown list, select "Text".</li>
<li>Click the "Delete NULL Values" checkbox.</li>
<li>Leave the "Status" set to "Active".</li>
<li>Click the "Add Rule" button to save your work.</li>
</ol>
<p>Once the rule is created you must execute it to create the "Ref Issues" value for the items in your Media Library:</p>
<ol>
<li>Find the "Ref Issues" (or your chosen field name) in the table of rules on the right-hand side of the screen. If you don't see your new rule, type the name you gave it in the search box above the table and click "Search Rules".</li>
<li>Hover your mouse in the "Name" column and click the "Execute" rollover action.</li>
<li>Wait for the mapping process to complete.</li>
</ol>
<p>At this point you can, if you like, go back and disable the Where-used Reporting options to increase the performance of your system – you don't need to re-analyze the items once the custom field is populated. You can also set your new rule to "inactive" so it won't run when new items are added to the Media Library.</p>
<p>To check your progress, navigate to the Media/Assistant admin screen and look for your new column. If you don't see the "Ref Issues" column in the Media/Assistant submenu table pull down the "Screen Options" area and make sure that "Ref Issues" is listed and the box next to it is checked.
You can sort on this column to bring the items that have one or more issues to the front of the table. You can click on a value in the column to filter the table by that value. To make the filtering more convenient, there are two alternatives for part 2) of the solution. If you want to replace the "Att. Categories" Taxonomy List Filter dropdown, follow these steps:</p>
<ol>
<li>Navigate to the Settings/Media Library Assistant General tab.</li>
<li>Scroll down to the "Taxonomy Support" section.</li>
<li>At the bottom of the taxonomy table you will see a dropdown control. Select your "Ref Issues" custom field.</li>
<li>Click the radio button in the "List Filter" column to filter the Media/Assistant submenu table by the custom field values.</li>
<li>Scroll to the bottom of the page and click "Save Changes" to record your new settings.</li>
</ol>
<p>When you return to the Media/Assistant screen you should see something like "All Ref Issues" in the dropdown control above the table. Click on that to select one of the "issues" values, then click "Filter" to filter the table by that value.</p>
<p>The alternative is to create a custom table view, leaving the Taxonomy List Filter dropdown intact. To create a custom view:</p>
<ol>
<li>Navigate to the Settings/Media Library Assistant "Views" tab.</li>
<li>Scroll down to the Add New View area on the left side of the page.</li>
<li>Enter something like "ref-issues" in the Slug field.</li>
<li>Enter something like "Reference Issues" in the Singular and Plural Label fields.</li>
<li>Enter <code>custom:Ref Issues=*</code> in the Specification field.</li>
<li>Leave the Post MIME Type box unchecked, since this is not a MIME type.</li>
<li>Check the Table View box, to add this as a Media/Assistant view.</li>
<li>Leave the Menu Order blank, unless you want to position the column in a specific place. (unusual)</li>
<li>Enter any notes you like in the Description box, or leave it blank.</li>
<li>Click "Add View" to add your view to the custom views list.</li>
</ol>
<p>Return to the Media/Assistant admin page and you will see the new view above the submenu table. Click on it to eliminate items with no reference issues from the table.</p>
<p>If this is a one-time or infrequent task you can 1) go back to the General tab and reset the taxonomy filter to Att. Categories or another taxonomy, or 2) go back to the Views tab and set the "Table View" option to "No" to hide the view. You can then go to the Custom Fields tab, use the "Purge Values" rollover action for your rule to delete the custom field values and set the rule to "Inactive" status for future use or delete it entirely.
</p>
<h4>Finding Duplicate Items Based on File Name</h4>
<p>It is deceptively easy to upload the same image or document to the Media Library multiple times. Finding and removing duplicated items has two parts: 1) which items represent the same media file, and 2) where are these items used? Part 2 is addressed by the solutions already outlined in this section. MLA includes an Example Plugin to help with part 1.</p>
<p>There is no specific MLA feature for analyzing the file names associated with Media Library items. You can approximate a solution by creating a Custom Field mapping rule to create a custom field populated from either the file_name or name_only data sources. Add this field to the Media/Assistant admin submenu table and then sort on that column to bring the duplicates close together for visual inspection. You can also display the Base File column to determine the year/month values for each file (if you divide your uploads that way).</p>
</p>
<p>This can be tedious for a site with thousands of files. The example plugin queries the database to get a list of all attached files, isolating the name_only portion to resolve the year/month issue and removing the suffix WordPress assigns (an imperfect process) if a duplicate file is uploaded to the same directory. Then, the list is sorted and processed to find the items that share a root file name. The results are summarized as a <code>filename_issues</code> custom data source. For unique names the value is empty; shared names display the root name and number of items that have it. You can map the values to a custom field as in the "Reference Issues" solution outlined above. Because <code>filename_issues</code> is a custom data source the settings to access it are somewhat different. Here are the steps to follow:</p>
<ol>
<li>Navigate to the Settings/Media Library Assistant "Custom Fields" tab.</li>
<li>Scroll down to the "Add New Custom Field Rule" area below the "Enable" checkboxes.</li>
<li>Under the "Name" dropdown control, click "Enter new field" to create a new custom field.</li>
<strong><li>In the "Name" text box, give your field a name, e.g., "Filename Issues".</li>
<li>From the Data Source dropdown list, select "-- Template (see below) --".</li>
<li>In the Meta/Template text box, enter <code>[+filename_issues+]</code>.</li></strong>
<li>Click the "MLA Column" check box to make the field available in the Media/Assistant submenu table. Leave the "Quick Edit" and "Bulk Edit" check boxes unchecked for this solution.</li>
<li>In the "Existing Text" dropdown list, select "Replace".</li>
<li>In the "Format" dropdown list, select "Native".</li>
<li>In the "Option:" dropdown list, select "Text".</li>
<li>Click the "Delete NULL Values" checkbox.</li>
<li>Leave the "Status" set to "Active".</li>
<li>Click the "Add Rule" button to save your work.</li>
</ol>
<p>Once the rule is created you must execute it to create the "Filename Issues" value for the items in your Media Library:</p>
<ol>
<li>Find the "Filename Issues" (or your chosen field name) in the table of rules on the right-hand side of the screen. If you don't see your new rule, type the name you gave it in the search box above the table and click "Search Rules".</li>
<li>Hover your mouse in the "Name" column and click the "Execute" rollover action.</li>
<li>Wait for the mapping process to complete.</li>
</ol>
<p>When you go back to the Media/Assistant screen you will see the new column. You can sort on it to bring the items with issues to the top of the list. You can click on a column value to limit the display to just the files sharing that name. Creating a custom view is similar to the earlier example. When you're done with the column you can disable or delete the example plugin, purge the custom field values and disable or delete the rule as in the earlier example.</p>
<p>
<a name="terms_search"></a>
</p>
<p>
<a href="#backtotop">Go to Top</a>
</p>
<h3>Terms Search - filtering on taxonomy term names</h3>
<p>
The "Terms Search" features let you filter the Media/Assistant submenu table and the Media Manager Modal Window by matching one or more phrases in the Name field of taxonomy terms. There are two ways to access this feature:
</p>
<ol>
<li>Check the "Terms" box under the "Search Media" button on the Media/Assistant submenu table or the Media Manager toolbar. The phrase(s) you enter in the search box will match taxonomy term names as well as any other search fields you have checked.</li>
<li>Click the "Terms Search" button beside the terms filter dropdown. This will bring up the "Search Terms" popup window with several additional controls to refine your search. They are described below.</li>
</ol>
<h4>Entering words and phrases</h4>
<p>
You can enter one or more words/phrases in the Search Media or Search Terms text box, separated by spaces. A multi-word phrase is created by surrounding two or more words with double quotes ( " ). For example:
</p>
<ul class="mla_settings">
<li>' man bites dog ' is three separate one-word phrases</li>
<li>' man "bites dog" ' is a one-word phrase (man) and a two-word phrase (bites dog)</li>
<li>' "man bites dog" ' is one three-word phrase</li>
</ul>
<p>
The first example would match each word separately. The second would match "man" and "bites dog" separately, with exactly one space between "bites" and "dog". 
</p>
<p>
Quote marks have another effect on the search; they restrict the match to a word boundary. For example, if you enter 'man' without enclosing quotes it will match "man" or "woman", because "<strong>man</strong>" appears as a part of "wo<strong>man</strong>". If you add quotes, i.e., ' "man" ', it will match "man" or "big man" but it will not match the "man" portion of "woman".
</p>
<p>
In the unlikely event you need to match single or double quotes inside a phrase you can enter them as an escape sequence. Use <code>\47</code> for a single quote<code>\42</code> for a double quote. 
</p>
<h4>Connecting multiple phrases</h4>
<p>
The search is further defined by the connector used between multiple phrases:
</p>
<ul class="mla_settings">
<li>'and'/'All phrases' - all of the phrases must appear in the search field/term name.</li>
<li>'or'/'Any phrase' - any one (or more) of the phrases must appear in the search field/term name.</li>
</ul>
<p>
For example, if you choose the default 'and'/'All phrases' connector and enter 'man "bites dog"' in the text box:
</p>
<ul class="mla_settings">
<li>'man that bites dog' will match, but 'man that dog bites' will not match.</li>
<li>'dog bites man' will not match.</li>
<li>'man bites man with dog' will not match.</li>
</ul>
<p>
If, however you remove the quotes and enter 'man bites dog' all of the above examples will match, because all three of the phrases appear somewhere in the text. On the other hand 'man bites man' would not match because "dog" does not appear in the text.
</p>
<p>
If you choose the 'or'/'Any phrase' connector and enter 'man "bites dog"' in the text box:
</p>
<ul class="mla_settings">
<li>'man that bites dog' will match.</li>
<li>'man that dog bites' will match because "man" is present.</li>
<li>'dog bites man' will match because "man" is present.</li>
<li>'dog bites another dog' will not match.</li>
</ul>
<h4>Exact phrase matching</h4>
<p>
The Search Terms popup window has an additional capability, "Exact match" and a checkbox to activate it. When you check the "Exact" box, each phrase must match the entire text of a term name. For example, if you check "Exact", the phrase "man" will match a term of the same name but not a term named "big man". If you check "Exact" and enter "big man" you will match terms named "big" or "man" <strong>but not</strong> "big man". If you want an exact match on a multi-word term such as "big man", put quotes around the name, i.e., ' "big man" '.
</p>
<h4>Whole word matching</h4>
<p>
The Search Terms popup window has an additional capability, "Whole word match" and a checkbox to activate it. When you check the "Whole Word" box, each word in the phrase must match a whole word of a term name. For example, if you check "Whole Word", the phrase "man" will match a term that contains "man" but not the word "woman". If you check "Whole Word" and enter "big man" it is as if you put quotes around each of the words, i.e., ` "big" "man" `. If you want an exact match on a multi-word term such as "big man", put quotes around the name, i.e., ' "big man" '.
</p>
<h4>Excluding phrases</h4>
<p>
If you want to exclude terms that match a phrase, enclose the phrase in slash ("/") delimiters. For example, enter "/dog/" to exclude terms containing the word dog. To exclude a multi word phrase, enter something like "/bites dog/" to exclude both words or ' /"bites dog"/ ' to exclude the exact phrase. You can combine include and exclude phrases, e.g., something like "man /that/ dog" to select terms containing "man" and "dog" but not containing "that". 
</p>
<p>
You can also exclude terms by prepending a word or quoted phrase with a hyphen, e.g., 'pillow -sofa' will select terms containing 'pillow' but not 'sofa'. 
</p>
<p>
When you add exclude phrases to your search, the phrases you enter are divided into two sub-values, "positive" and "negative", with everything enclosed by the exclude delmiters going to the negative sub-value and everything else to the positive. Two queries are performed. First, the negative sub-value is used and a list of the item IDs that pass the query is compiled. Second, the positive sub-value is used and items with the "negative" IDs are excluded.
</p>
<h4>Entering multiple terms</h4>
<p>
The Search Terms popup window has an additional capability and another control to refine it. The additional capability lets you search for multiple terms and the control sets the connector between terms. For example, consider two taxonomies, each with several terms:
</p>
<ul class="mla_settings">
<li>Att. Categories, containing "big animal", "small animal" and "other being"</li>
<li>Att. Tags, containing "male", "female", "cat" and "dog"</li>
</ul>
<p>
If you choose 'All phrases' and 'Any term' (the defaults) and enter 'big dog' there are no matches because none of the terms contain both 'big' and 'dog'. If you choose 'Any phrase' and 'Any term' you will get items assigned to the 'big animal' Att. Category or the 'dog' Att. Tag. If you choose 'Any phrase' and 'All terms' you will get only the items assigned to both the 'big animal' Att. Category <strong>and</strong> the 'dog' Att. Tag.
</p>
<p>
If you enter 'big,dog', separating the two phrases with a comma, the search results will change. Terms will be matched against "big" and "dog" separately. The 'All phrases'/Any phrase' choice will not matter because both of the phrases contain just one word. Choose 'All terms' and you will get any items assigned to 'big animal' <strong>and</strong> to 'dog'. Choose 'Any term' and you will get all of the 'big animal' matches and all of the 'dog' matches; that includes small dogs and big cats.
</p>
<h4>Selecting taxonomies</h4>
<p>
By default, the Att. Categories and Att. Tags taxonomies are included in the terms search. In the Taxonomy Support section of the Settings/Media Library Assistant General tab you can use the checkboxes in the Terms Search column to add or remove any of the supported taxonomies from the search process.
</p>
<p>
In the Search Terms popup window you will find a list of all supported taxonomies, with checkboxes reflecting their participation in the search process. You can add or remove taxonomies from the process on a search-by-search basis.
</p>
<h4>Debugging output</h4>
<p>
If you are having problems with search results or are simply curious you can activate some debug logging by adding a special value to the beginning of the phrases text box. Adding <code>}|{</code> activates the display of information about the query parameters and SQL statements used to retrieve items. You will see a lot of information added to the post or page containing the gallery or to the Media/Assistant admin screen. Of course, this value should ONLY be used in a development/debugging environment; it's quite ugly.
</p>
<p>
If you add <code>{|}</code> all of the information will be written to the error log, a more practical choice. You can use the MLA Debug Tab to view and download the information in the error log.
<a name="select_parent"></a>
</p>
<p>
<a href="#backtotop">Go to Top</a>
</p>
<h3>Select Parent Popup Window</h3>
<p>
The "Select Parent" popup window lets you find the parent post/page/custom post type for one or more attachments. You can access the popup window in four ways:
</p>
<ol>
<li>Click the "Set Parent" link in the "Attached to" column of the Media/Assistant submenu table.</li>
<li>Click the "Select" button in the Media/Assistant submenu table Quick Edit area.</li>
<li>Click the "Select" button in the Media/Assistant submenu table Bulk Edit area.</li>
<li>Click the "Select" button in the Media/Edit Media submenu "Parent Info" meta box.</li>
</ol>
<p>
In all cases the Select Parent popup window will appear and will be filled with up to 50 parent candidates. If the current parent is in the list its radio button will be selected. You can select a new parent, including "(unattached)", by clicking anywhere in the row of the candidate you want.
</p>
<p>
If you don't see the candidate you want you have three ways of updating the list:
</p>
<ol>
<li>Enter one or more keywords in the text box at the top of the window and click "Search". The word(s) you enter will filter the list by searching the Title and Content fields for matches.</li>
<li>Select a post type from the dropdown list at the top of the window. The list will be filtered to show candidates from the post type you choose.</li>
<li>Click the "next page" (" &raquo; ") button in the Media/Assistant submenu table Bulk Edit area. The list will move to the next page of up to 50 additional candidates. You can click the "previous page" (" &laquo; ") button to move back towards the top of the list.</li>
</ol>
<p>
Once you have chosen a new parent, click the "Update" button at the lower right of the window to save your choice. You will be returned to your starting point with the new value filled in. Changes made in the "Attached to" column are immediate; changes to the Quick Edit, Bulk Edit and Parent Info meta box are made later, when you click the "Update" button in those areas to save all your changes.
</p>
<p>
If you change your mind you can close the window without making a change by clicking the "X" in the upper-right corner of the window or the "Cancel" button in the lower-left corner of the window.
<a name="admin_columns"></a>&nbsp;
</p>
<p>
<a href="#backtotop">Go to Top</a>
</p>
<h3>Support for the &#8220;Admin Columns&#8221; Plugin</h3>
<p>
The <a href="https://wordpress.org/plugins/codepress-admin-columns/" title="Admin Columns plugin directory page" target="_blank">Admin Columns</a> plugin allows you to customize columns on several admin-mode screens, including the MLA Media/Assistant submenu screen. All you have to do is install the plugin; MLA will detect its presence and automatically register the Media/Assistant submenu screen for support. With Admin Columns, you can:
</p>
<ul class="mla_settings">
<li>Reorder columns with a simple drag &amp; drop interface.</li>
<li>Re-size columns to give more or less space to a column.</li>
<li>Remove (not just hide) columns from the submenu table.</li>
<li>Add new columns for custom fields and additional information.</li>
<li>The Admin Columns "Pro" version adds support for inline editing, ACF fields and other capabilities.</li>
<li>The Admin Columns "Pro" version adds support for exporting Media/Assistant table values to CSV-format files.</li>
</ul>
<p>
When Admin Columns is present you will see a new "Edit Columns" button just above the Media/Assistant submenu table. Click the button to go to the Settings/Admin Columns configuration screen. There you will see "Media Library Assistant" added to the "Others:" list. Click on it to see the configuration of the Media/Assistant submenu screen.
</p>
<p>
You can find detailed configuration instructions at the <a href="http://admincolumns.com/documentation/" title="Admin Columns Documentation" target="_blank">Admin Columns web site Documentation page</a>.
</p>
<p>
When you have completed your configuration changes, click "Update Media Library Assistant" in the Store Settings metabox at the top-right of the screen. You can also click "Restore Media Library Assistant columns" to remove your changes and go back to the MLA default settings. Click the "View" button at the right of the Media Library Assistant heading to return to the Media/Assistant submenu screen and see your changes.
<a name="mla_taxonomy_hooks"></a>
</p>
<p>
<a href="#backtotop">Go to Top</a>
</p>
<h3>Custom Taxonomy Actions and Filters (Hooks)</h3>
<p>
The Custom Taxonomy filters and actions give you control over the registration of the Att. Categories and Att. Tags taxonomies from PHP code in your theme or in another plugin. An example of using the hooks from a simple, stand-alone plugin can be found in the Documentation/Example Plugins submenu. You can find the example plugin here: <a title="Find the Taxonomy Hooks Example" href="[+example_url+]&amp;mla-example-search=Search+Plugins&amp;s=%22MLA+Taxonomy+Hooks+Example%22" class="mla-doc-bold-link">MLA Taxonomy Hooks Example</a>. To run the example:
</p>
<ol>
<li>Click on the link above or go to top of the Documentation tab and click on the "Example Plugins" button.</li>
<li>Hover over "MLA Taxonomy Hooks Example" in the Name column, then click the "Install" rollover action.</li>
<li>Go to the Plugins/Installed Plugins screen and activate the "MLA Taxonomy Hooks Example" plugin.</li>
<li>Go to, for example, the Media/Assistant submenu to exercise the filters and write filter/action information to the site's Error Log.</li>
<li>Examine the Error Log to see the filter/action information.</li>
</ol>
<p>
You can find more information about the types, labels and arguments in the <a href="https://codex.wordpress.org/Function_Reference/register_taxonomy" title="register_taxonomy() Documentation" target="_blank">Function Reference/register taxonomy</a> repository page. 
</p>
<p>
The example code documents each hook with comments in the filter/action function that intercepts each hook.
</p>
<p>
The following hooks are defined in <code>/wp-admin/includes/class-mla-objects.php</code>:
</p>
<table>
<tr>
<td class="mla-doc-hook-label">mla_attachment_category_types,<br />mla_attachment_tag_types</td>
<td class="mla-doc-hook-definition">Modify the array of post types for which the taxonomy is registered. The default is "attachment".</td>
</tr>
<tr>
<td class="mla-doc-hook-label">mla_attachment_category_labels,<br />mla_attachment_tag_labels</td>
<td class="mla-doc-hook-definition">Modify the array of labels used in the User Interface for submenu and metabox names, etc.</td>
</tr>
<tr>
<td class="mla-doc-hook-label">mla_attachment_category_arguments,<br />mla_attachment_tag_arguments</td>
<td class="mla-doc-hook-definition">Modify the array of arguments with which the taxonomy is registered. For example, you can change the URL rewrite slug from the default <code>attachment_category/attachment_tag</code> values for SEO purposes. <strong>Note</strong>: You may need to flush the rewrite rules after changing the slug. You can do it manually by going to the Permalink Settings page and re-saving the rules -- you don't need to change them.</td>
</tr>
</table>
<a name="mla_list_table_hooks"></a>&nbsp;
<p>
<a href="#backtotop">Go to Top</a>
</p>
<h3>Media/Assistant Submenu Actions and Filters (Hooks)</h3>
<p>
The Media/Assistant submenu supports a comprehensive set of filters and actions that give you control over table columns, inline actions and bulk actions from PHP code in your theme or in another plugin. An example of using the hooks from a simple, stand-alone plugin can be found in the Documentation/Example Plugins submenu. You can find the example plugin here: <a title="Find the List Table Hooks Example" href="[+example_url+]&amp;mla-example-search=Search+Plugins&amp;s=%22MLA+List+Table+Hooks+Example%22" class="mla-doc-bold-link">MLA List Table Hooks Example</a>. To run the example:
</p>
<ol>
<li>Click on the link above or go to top of the Documentation tab and click on the "Example Plugins" button.</li>
<li>Hover over "MLA List Table Hooks Example" in the Name column, then click the "Install" rollover action.</li>
<li>Go to the Plugins/Installed Plugins screen and activate the "MLA List Table Hooks Example" plugin.</li>
<li>Go to the Media/Assistant submenu to exercise the filters and write filter/action information to the site's Error Log.</li>
<li>Examine the Error Log to see the filter/action information.</li>
</ol>
<p>
The example code documents each hook with comments in the filter/action function that intercepts each hook. There are hooks that let you add, modify or delete table columns. 
</p>
<p>
In addition, there are hooks that run when the Media Library items are selected from the database and hooks for adding and processing custom quick actions and bulk actions.
</p>
<p>
The following hooks are defined in <code>/wp-admin/includes/class-wp-list-table.php</code>:
</p>
<table>
<tr>
<td class="mla-doc-hook-label">views_media_page_mla_menu</td>
<td class="mla-doc-hook-definition">Filter the list of available list table views.</td>
</tr>
<tr>
<td class="mla-doc-hook-label">bulk_actions-media_page_mla-menu</td>
<td class="mla-doc-hook-definition">Filter the list table Bulk Actions drop-down. This WordPress filter can currently only be used to remove bulk actions.</td>
</tr>
<tr>
<td class="mla-doc-hook-label">months_dropdown_results</td>
<td class="mla-doc-hook-definition">Filter the 'Months' drop-down results.</td>
</tr>
<tr>
<td class="mla-doc-hook-label">mla_entries_per_page</td>
<td class="mla-doc-hook-definition">Filter the number of items to be displayed on each page of the list table.</td>
</tr>
<tr>
<td class="mla-doc-hook-label">manage_media_page_mla-menu_sortable_columns</td>
<td class="mla-doc-hook-definition">Filter the list table sortable columns for a specific screen.</td>
</tr>
</table>
<p>
The following hooks are defined in <code>/media-library-assistant/includes/class-mla-objects.php</code>:
</p>
<table>
<tr>
<td class="mla-doc-hook-label">mla_taxonomy_get_columns</td>
<td class="mla-doc-hook-definition">Gives you an opportunity to change the columns defined for the Edit Taxonomy submenu table(s).</td>
</tr>
<tr>
<td class="mla-doc-hook-label">mla_taxonomy_column</td>
<td class="mla-doc-hook-definition">Gives you an opportunity to replace column content in the Edit Taxonomy submenu table(s) before MLA computes the count.</td>
</tr>
<tr>
<td class="mla-doc-hook-label">mla_taxonomy_column_final</td>
<td class="mla-doc-hook-definition">Gives you an opportunity to replace column content in the Edit Taxonomy submenu table(s) after MLA computes the count.</td>
</tr>
</table>
<p>
The following hooks are defined in <code>/media-library-assistant/includes/class-mla-data.php</code>:
</p>
<table>
<tr>
<td class="mla-doc-hook-label">mla_list_table_query_final_terms</td>
<td class="mla-doc-hook-definition">Gives you an opportunity to change the terms of the prepare_items query after they are processed by the "Prepare List Table Query" handler.</td>
</tr>
<tr>
<td class="mla-doc-hook-label">mla_list_table_query_custom_items</td>
<td class="mla-doc-hook-definition">Gives you an opportunity to substitute the results of the prepare_items query with alternative results of your own.</td>
</tr>
<tr>
<td class="mla-doc-hook-label">mla_list_table_search_filter_fields</td>
<td class="mla-doc-hook-definition">Gives you an opportunity to add or remove any of the MLA standard fields for Search Media.</td>
</tr>
<tr>
<td class="mla-doc-hook-label">mla_list_table_search_filter_inner_clause</td>
<td class="mla-doc-hook-definition">Gives you an opportunity to modify or add to the inner WHERE clause for Search Media.</td>
</tr>
<tr>
<td class="mla-doc-hook-label">mla_fetch_attachment_references</td>
<td class="mla-doc-hook-definition">Gives you an opportunity to modify or add to the "where-used" reference reporting information.</td>
</tr>
<tr>
<td class="mla-doc-hook-label">mla_update_single_item</td>
<td class="mla-doc-hook-definition">Gives you an opportunity to modify, delete or add to updates before they are applied.</td>
</tr>
<tr>
<td class="mla-doc-hook-label">mla_updated_single_item</td>
<td class="mla-doc-hook-definition">Gives you an opportunity to work with the item after updates have been applied.</td>
</tr>
</table>
<p>
The following hooks are defined in <code>/media-library-assistant/includes/class-mla-main.php</code>:
</p>
<table>
<tr>
<td class="mla-doc-hook-label">mla_list_table_help_template</td>
<td class="mla-doc-hook-definition">Gives you an opportunity to modify the pull-down Help menu on the Media/Assistant screen.</td>
</tr>
<tr>
<td class="mla-doc-hook-label">mla_list_table_admin_action</td>
<td class="mla-doc-hook-definition">Gives you an opportunity to pre-process an MLA_List_Table item-level action, standard or custom, before the MLA handler. This filter is called before anything is output for the Media/Assistant submenu, so you can redirect to another admin screen if desired.</td>
</tr>
<tr>
<td class="mla-doc-hook-label">mla_list_table_custom_admin_action</td>
<td class="mla-doc-hook-definition">Gives you an opportunity to process an MLA_List_Table item-level action that MLA does not recognize. This filter is called before anything is output for the Media/Assistant submenu, so you can redirect to another admin screen if desired.</td>
</tr>
<tr>
<td class="mla-doc-hook-label">mla_list_table_inline_fields</td>
<td class="mla-doc-hook-definition">Gives you an opportunity to name the fields passed to the JavaScript functions for Quick editing.</td>
</tr>
<tr>
<td class="mla-doc-hook-label">mla_list_table_inline_action</td>
<td class="mla-doc-hook-definition">Gives you an opportunity to pre-process an MLA_List_Table "Quick Edit" action before the MLA handler.</td>
</tr>
<tr>
<td class="mla-doc-hook-label">mla_list_table_bulk_action_initial_request</td>
<td class="mla-doc-hook-definition">Gives you an opportunity to pre-process the request parameters for a bulk action before the action begins. DO NOT assume parameters come from the $_REQUEST super array!</td>
</tr>
<tr>
<td class="mla-doc-hook-label">mla_list_table_begin_bulk_action</td>
<td class="mla-doc-hook-definition">Gives you an opportunity to pre-process an MLA_List_Table bulk action, standard or custom, before the MLA handler. The filter is called once before any of the items in $_REQUEST['cb_attachment'] are processed.</td>
</tr>
<tr>
<td class="mla-doc-hook-label">mla_list_table_bulk_action_item_request</td>
<td class="mla-doc-hook-definition">Gives you an opportunity to pre-process the request parameters for each item during a bulk action. DO NOT assume parameters come from the $_REQUEST super array!</td>
</tr>
<tr>
<td class="mla-doc-hook-label">mla_list_table_bulk_action</td>
<td class="mla-doc-hook-definition">Gives you an opportunity to pre-process an MLA_List_Table bulk action, standard or custom, before the MLA handler. The filter is called once for each of the items in $_REQUEST['cb_attachment'].</td>
</tr>
<tr>
<td class="mla-doc-hook-label">mla_list_table_custom_bulk_action</td>
<td class="mla-doc-hook-definition">Gives you an opportunity to process an MLA_List_Table bulk action that MLA does not recognize. The filter is called once for each of the items in $_REQUEST['cb_attachment'].</td>
</tr>
<tr>
<td class="mla-doc-hook-label">mla_list_table_end_bulk_action</td>
<td class="mla-doc-hook-definition">Gives you an opportunity to post-process an MLA_List_Table bulk action, standard or custom. The filter is called once after all of the items in $_REQUEST['cb_attachment'] are processed.</td>
</tr>
<tr>
<td class="mla-doc-hook-label">mla_list_table_single_action</td>
<td class="mla-doc-hook-definition">Gives you an opportunity to pre-process an MLA_List_Table item-level action, standard or custom, before the MLA handler. This filter is called after the Media/Assistant submenu screen header is output but before the messages and submenu table are displayed.</td>
</tr>
<tr>
<td class="mla-doc-hook-label">mla_list_table_custom_single_action</td>
<td class="mla-doc-hook-definition">Gives you an opportunity to process an MLA_List_Table page-level or single-item action that MLA does not recognize. This filter is called after the Media/Assistant submenu screen header is output but before the messages and submenu table are displayed.</td>
</tr>
<tr>
<td class="mla-doc-hook-label">mla_list_table_clear_filter_by</td>
<td class="mla-doc-hook-definition">Gives you an opportunity to clear any custom submenu "Filter-by" parameters.</td>
</tr>
<tr>
<td class="mla-doc-hook-label">mla_list_table_new_instance</td>
<td class="mla-doc-hook-definition">Gives you an opportunity to extend the MLA_List_Table class.</td>
</tr>
<tr>
<td class="mla-doc-hook-label">mla_list_table_inline_values</td>
<td class="mla-doc-hook-definition">Gives you a chance to modify and extend the substitution values for the Quick and Bulk Edit forms. See the additional filters for the Bulk Edit form below.</td>
</tr>
<tr>
<td class="mla-doc-hook-label">mla_list_table_inline_template</td>
<td class="mla-doc-hook-definition">Gives you a chance to modify and extend the template used for the Quick and Bulk Edit forms. See the additional filters for the Bulk Edit form below.</td>
</tr>
<tr>
<td class="mla-doc-hook-label">mla_list_table_inline_parse</td>
<td class="mla-doc-hook-definition">Gives you a final chance to modify and extend the HTML markup used for the Quick and Bulk Edit forms.</td>
</tr>
</table>
<p>
The Media/Assistant Bulk Edit area has three copies of field-level values. The "initial" values are displayed when the Area opens. The "blank" values are used when the "Reset" button is clicked. The "preset" values are used when the "Import" button is clicked. There are filters that give you a chance to modify the values and templates used to populate each of these three copies separately. The following hooks are defined in <code>/media-library-assistant/includes/class-mla-edit-media.php</code>, function <code>mla_generate_bulk_edit_form_fieldsets()</code>, which is called from <code>/media-library-assistant/includes/class-mla-main.php</code>:
</p>
<table>
<tr>
<td class="mla-doc-hook-label">mla_get_bulk_edit_form_presets</td>
<td class="mla-doc-hook-definition">Gives you a chance to modify or extend the presets used to populate the Media/Assistant Bulk Edit and Bulk Edit on Upload forms.</td>
</tr>
<tr>
<td class="mla-doc-hook-label">mla_list_table_inline_blank_fieldset_values,<br />
mla_list_table_inline_initial_fieldset_values,<br />
mla_list_table_inline_preset_fieldset_values
</td>
<td class="mla-doc-hook-definition">Give you a chance to modify the data values that populate the Bulk Edit form.</td>
</tr>
<tr>
<td class="mla-doc-hook-label">mla_list_table_inline_blank_values,<br />
mla_list_table_inline_initial_values,<br />
mla_list_table_inline_preset_values
</td>
<td class="mla-doc-hook-definition">Give you a chance to modify and extend the substitution values for the Bulk Edit forms.</td>
</tr>
<tr>
<td class="mla-doc-hook-label">mla_list_table_inline_blank_template,<br />
mla_list_table_inline_initial_template,<br />
mla_list_table_inline_preset_template
</td>
<td class="mla-doc-hook-definition">Give you a chance to modify and extend the template for the Bulk Edit forms.</td>
</tr>
</table>
<p>
The following hooks are defined in <code>/media-library-assistant/includes/class-mla-list-table.php</code>:
</p>
<table>
<tr>
<td class="mla-doc-hook-label">mla_list_table_get_columns</td>
<td class="mla-doc-hook-definition">Gives you an opportunity to filter the list table columns.</td>
</tr>
<tr>
<td class="mla-doc-hook-label">mla_list_table_get_hidden_columns</td>
<td class="mla-doc-hook-definition">Gives you an opportunity to filter the hidden list table columns.</td>
</tr>
<tr>
<td class="mla-doc-hook-label">mla_list_table_get_sortable_columns</td>
<td class="mla-doc-hook-definition">Gives you an opportunity to filter the sortable list table columns; a good alternative to the 'manage_media_page_mla_menu_sortable_columns' filter.</td>
</tr>
<tr>
<td class="mla-doc-hook-label">mla_list_table_get_bulk_actions</td>
<td class="mla-doc-hook-definition">Gives you an opportunity to filter the list of bulk actions; a good alternative to the 'bulk_actions-media_page_mla-menu' filter.</td>
</tr>
<tr>
<td class="mla-doc-hook-label">mla_list_table_extranav_actions</td>
<td class="mla-doc-hook-definition">Gives you an opportunity to add, remove and/or re-order the controls added to the top &amp; bottom table navigation areas.</td>
</tr>
<tr>
<td class="mla-doc-hook-label">mla_list_table_extranav_custom_action</td>
<td class="mla-doc-hook-definition">Called when the MLA_List_Table can't find a value for an extranav action.</td>
</tr>
<tr>
<td class="mla-doc-hook-label">mla_list_table_column_default</td>
<td class="mla-doc-hook-definition">Called when the MLA_List_Table can't find a value for a given column.</td>
</tr>
<tr>
<td class="mla-doc-hook-label">mla_list_table_submenu_arguments,<br />
mla_setting_table_submenu_arguments
</td>
<td class="mla-doc-hook-definition">Gives you an opportunity to filter the URL parameters that will be retained when the submenu page refreshes. The "mla_list_table..." filter is used in the Media/Assistant submenu. The "mla_setting_table..." filter is used in several Settings/Media Library Assistant submenu tabs. An additional parameter for this filter specifies which tab the filter applies to.</td>
</tr>
<tr>
<td class="mla-doc-hook-label">mla_list_table_prepare_items_pagination</td>
<td class="mla-doc-hook-definition">Gives you an opportunity to filter the per_page and current_page parameters used for the prepare_items database query.</td>
</tr>
<tr>
<td class="mla-doc-hook-label">mla_list_table_prepare_items_total_items</td>
<td class="mla-doc-hook-definition">Gives you an opportunity to substitute your own $total_items parameter used for the prepare_items database query.</td>
</tr>
<tr>
<td class="mla-doc-hook-label">mla_list_table_prepare_items_the_items</td>
<td class="mla-doc-hook-definition">Gives you an opportunity to substitute your own items array in place of the default prepare_items database query.</td>
</tr>
<tr>
<td class="mla-doc-hook-label">mla_list_table_prepare_items</td>
<td class="mla-doc-hook-definition">Gives you an opportunity to record or modify the results of the prepare_items database query.</td>
</tr>
<tr>
<td class="mla-doc-hook-label">mla_list_table_build_rollover_actions</td>
<td class="mla-doc-hook-definition">Gives you an opportunity to filter the list of "Rollover" actions giving item-level links such as "Quick Edit", "Move to Trash".</td>
</tr>
<tr>
<td class="mla-doc-hook-label">mla_list_table_build_inline_data</td>
<td class="mla-doc-hook-definition">Gives you an opportunity to filter the data passed to the JavaScript functions for Quick and Bulk editing.</td>
</tr>
<tr>
<td class="mla-doc-hook-label">mla_list_table_primary_column_link</td>
<td class="mla-doc-hook-definition">Gives you an opportunity to filter the primary column thumbnail hyperlink permission.</td>
</tr>
<tr>
<td class="mla-doc-hook-label">mla_list_table_primary_column_content</td>
<td class="mla-doc-hook-definition">Gives you an opportunity to modify or replace the content of the primary column.</td>
</tr>
<tr>
<td class="mla-doc-hook-label">views_upload</td>
<td class="mla-doc-hook-definition">Views for the "upload" page when WPML is active. This filter is hooked by WPML Media in wpml-media.class.php, and is only applied when WPML is active.</td>
</tr>
</table>
<p>
The following hooks are defined in <code>/media-library-assistant/includes/class-mla-edit-media.php</code>:
</p>
<table>
<tr>
<td class="mla-doc-hook-label">mla_upload_bulk_edit_form_values</td>
<td class="mla-doc-hook-definition">Gives you a chance to modify and extend the substitution values for the Bulk Edit on Upload form. See the additional filters for the Bulk Edit form below.</td>
</tr>
<tr>
<td class="mla-doc-hook-label">mla_upload_bulk_edit_form_template</td>
<td class="mla-doc-hook-definition">Gives you a chance to modify and extend the template used for the Bulk Edit on Upload form. See the additional filters for the Bulk Edit form below.</td>
</tr>
<tr>
<td class="mla-doc-hook-label">mla_upload_bulk_edit_form_parse</td>
<td class="mla-doc-hook-definition">Gives you a final chance to modify and extend the HTML markup used for the Bulk Edit on Upload form.</td>
</tr>
</table>
<p>
The Media/Add New (Upload New Media) Bulk Edit area has three copies of field-level values. The "initial" values are displayed when the Area opens. The "blank" values are used when the "Reset" button is clicked. The "preset" values are used when the "Import" button is clicked. There are filters that give you a chance to modify the values and templates used to populate each of these three copies separately. The following hooks are defined in <code>/media-library-assistant/includes/class-mla-edit-media.php</code>, function <code>mla_generate_bulk_edit_form_fieldsets()</code>:
</p>
<table>
<tr>
<td class="mla-doc-hook-label">mla_get_bulk_edit_form_presets</td>
<td class="mla-doc-hook-definition">Gives you a chance to modify or extend the presets used to populate the Media/Assistant Bulk Edit and Bulk Edit on Upload forms.</td>
</tr>
<tr>
<td class="mla-doc-hook-label">mla_upload_bulk_edit_form_blank_fieldset_values,<br />
mla_upload_bulk_edit_form_initial_fieldset_values,<br />
mla_upload_bulk_edit_form_preset_fieldset_values
</td>
<td class="mla-doc-hook-definition">Give you a chance to modify the data values that populate the Bulk Edit form.</td>
</tr>
<tr>
<td class="mla-doc-hook-label">mla_upload_bulk_edit_form_blank_values,<br />
mla_upload_bulk_edit_form_initial_values,<br />
mla_upload_bulk_edit_form_preset_values
</td>
<td class="mla-doc-hook-definition">Give you a chance to modify and extend the substitution values for the Bulk Edit form.</td>
</tr>
<tr>
<td class="mla-doc-hook-label">mla_list_table_inline_blank_template,<br />
mla_upload_bulk_edit_form_initial_template,<br />
mla_upload_bulk_edit_form_preset_template
</td>
<td class="mla-doc-hook-definition">Give you a chance to modify and extend the template for the Bulk Edit form.</td>
</tr>
</table>
<a name="mla_media_modal_filters"></a>&nbsp;
<p>
<a href="#backtotop">Go to Top</a>
</p>
<h3>Media Manager Enhancement filters (Hooks)</h3>
<p>
Media Library Assistant adds several controls to the toolbar in the Media Manager Modal Window; more MIME type filters, year/month filter, taxonomy term filter and an enhanced Search media box. These features are supported by a comprehensive set of filters and actions that give you control over MMMW content from PHP code in your theme or in another plugin. An example of using the hooks from a simple, stand-alone plugin can be found in the Documentation/Example Plugins submenu. You can find the example plugin here: <a title="Find the Media Modal Hooks Example" href="[+example_url+]&amp;mla-example-search=Search+Plugins&amp;s=%22MLA+Media+Modal+Hooks+Example%22" class="mla-doc-bold-link">MLA Media Modal Hooks Example</a>. To run the example:
</p>
<ol>
<li>Click on the link above or go to top of the Documentation tab and click on the "Example Plugins" button.</li>
<li>Hover over "MLA Media Modal Hooks Example" in the Name column, then click the "Install" rollover action.</li>
<li>Go to the Plugins/Installed Plugins screen and activate the "MLA Media Modal Hooks Example" plugin.</li>
<li>Make any changes or additions you want to in the example plugin source code. For example, you can uncomment the <code>$initial_values</code> assignments and setting a new initial value for one or more controls.</li>
<li>Click the "Add Media" button for a post or page to see the effect of your changes.</li>
</ol>
<p>
The following hooks are defined in <code>/wp-admin/includes/class-mla-media-modal-ajax.php</code>:
</p>
<table>
<tr>
<td class="mla-doc-table-label">mla_media_modal_form_fields</td>
<td class="mla-doc-hook-definition">Change the content of the Media Manager Modal Window ATTACHMENT DETAILS fields</td>
</tr>
<tr>
<td class="mla-doc-table-label">mla_media_modal_begin_fill_compat_fields</td>
<td class="mla-doc-hook-definition">Replace the content of the Media Manager Modal Window ATTACHMENT DETAILS taxonomy meta boxes before the MLA results have been added</td>
</tr>
<tr>
<td class="mla-doc-table-label">mla_media_modal_end_fill_compat_fields</td>
<td class="mla-doc-hook-definition">Change the content of the Media Manager Modal Window ATTACHMENT DETAILS taxonomy meta boxes after MLA results have been added.</td>
</tr>
<tr>
<td class="mla-doc-table-label">mla_media_modal_begin_update_compat_fields</td>
<td class="mla-doc-hook-definition">Pre-process the $_REQUEST elements for the Media Manager Modal Window ATTACHMENT DETAILS taxonomy meta boxes updates</td>
</tr>
<tr>
<td class="mla-doc-table-label">mla_media_modal_update_compat_fields_terms</td>
<td class="mla-doc-hook-definition">Change the terms assigned to one Media Manager Modal Window ATTACHMENT DETAILS taxonomy</td>
</tr>
<tr>
<td class="mla-doc-table-label">mla_media_modal_end_update_compat_fields</td>
<td class="mla-doc-hook-definition">Change the content of one (or more) Media Manager Modal Window ATTACHMENT DETAILS taxonomy meta boxes with updated checkbox or tag/term lists</td>
</tr>
<tr>
<td class="mla-doc-table-label">mla_media_modal_query_initial_terms</td>
<td class="mla-doc-hook-definition">Change the terms of the Media Manager Modal Window "Query Attachments" query before they are pre-processed by the MLA handler</td>
</tr>
<tr>
<td class="mla-doc-table-label">mla_media_modal_query_filtered_terms</td>
<td class="mla-doc-hook-definition">Change the terms of the Media Manager Modal Window "Query Attachments" query after they are pre-processed by the AJAX handler</td>
</tr>
</table>
<p>
The following hooks are defined in <code>/wp-admin/includes/class-mla-media-modal.php</code>:
</p>
<table>
<tr>
<td class="mla-doc-table-label">mla_media_modal_months_dropdown</td>
<td class="mla-doc-hook-definition">Change the content of the Media Manager Modal Window Month &amp; Year Dropdown control</td>
</tr>
<tr>
<td class="mla-doc-table-label">mla_media_modal_terms_options</td>
<td class="mla-doc-hook-definition">Change the content of the Media Manager Modal Window Terms Dropdown control</td>
</tr>
<tr>
<td class="mla-doc-table-label">mla_media_modal_initial_filters</td>
<td class="mla-doc-hook-definition">Change  the initial values of the Media Manager Modal Window toolbar controls</td>
</tr>
<tr>
<td class="mla-doc-table-label">mla_media_modal_settings</td>
<td class="mla-doc-hook-definition">Change the content of the Media Manager Modal Window toolbar controls</td>
</tr>
<tr>
<td class="mla-doc-table-label">mla_media_modal_strings</td>
<td class="mla-doc-hook-definition">Change the content of the string values passed Media Manager Modal Window toolbar controls</td>
</tr>
<tr>
<td class="mla-doc-table-label">mla_media_modal_template_path</td>
<td class="mla-doc-hook-definition">Change the path to the JavaScript template file or substitute your own template(s)</td>
</tr>
<tr>
<td class="mla-doc-table-label">mla_media_modal_query_items</td>
<td class="mla-doc-hook-definition">Record or modify the results of the "mla_query_media_modal_items" query</td>
</tr>
</table>
<p>
The following hooks are defined in <code>/wp-admin/includes/class-mla-data-query.php</code>:
</p>
<table>
<tr>
<td class="mla-doc-table-label">mla_media_modal_query_final_terms</td>
<td class="mla-doc-hook-definition">Change the terms of the Media Manager Modal Window "Query Attachments" query after they are processed by the "Prepare List Table Query" handler</td>
</tr>
<tr>
<td class="mla-doc-table-label">mla_media_modal_query_custom_items</td>
<td class="mla-doc-hook-definition">Substitute the results of the Media Manager Modal Window "Query Attachments" query with alternative results of your own</td>
</tr>
</table>
<a name="mla_edit_meta_boxes"></a>&nbsp;
<p>
<a href="#backtotop">Go to Top</a>
</p>
<h3>Edit Media additional meta boxes (and Hooks)</h3>
<p>
Media Library Assistant adds support for the "Custom Fields" meta box to the Media/Edit Media screen. MLA also adds several meta boxes to this screen with more information about the item and where it is  used on your site. You can enable/disable the additional meta boxes with an option on the Settings/Media Library Assistant General tab.
</p>
<p>
You can also make individual changes in which meta boxes are displayed and in their content by using one or more of the filters MLA provides. An example of using the hooks from a simple, stand-alone plugin can be found in the Documentation/Example Plugins submenu. You can find the example plugin here: <a title="Find the Meta Box Hooks Example" href="[+example_url+]&amp;mla-example-search=Search+Plugins&amp;s=%22MLA+Meta+Box+Hooks+Example%22" class="mla-doc-bold-link">MLA Meta Box Hooks Example</a>. To run the example:
</p>
<ol>
<li>Click on the link above or go to top of the Documentation tab and click on the "Example Plugins" button.</li>
<li>Hover over "MLA Meta Box Hooks Example" in the Name column, then click the "Install" rollover action.</li>
<li>Go to the Plugins/Installed Plugins screen and activate the "MLA Meta Box Hooks Example" plugin.</li>
<li>Make any changes or additions you want to in the example plugin source code. For example, you can modify the <code>mla_inserted_in_metabox</code> example to display a simplified version of the "Inserted in" information.</li>
<li>View the Media/Edit Media screen for an item to see the effect of your changes.</li>
</ol>
<p>
The example code documents each hook with comments in the filter function that intercepts the hook. Generally, each meta box filter lets you change the size of the text box (if appropriate) and the content that appears in the box. There is also a second filter for each meta box that lets you replace <strong>all</strong> of the HTML content for most boxes; use these with caution. The current hooks are:
</p>
<table>
<tr>
<td class="mla-doc-hook-label">mla_edit_media_support</td>
<td class="mla-doc-hook-definition">suppress the addition of Custom Fields to the Edit Media screen. To suppress Custom Fields, return an empty array, i.e., <code>return array();</code></td>
</tr>
<tr>
<td class="mla-doc-hook-label">mla_edit_media_meta_boxes</td>
<td class="mla-doc-hook-definition">record the original list of meta box slugs. You can also remove elements from the array to suppress one or more meta boxes. To suppress a box, remove it from the array, e.g., <code>unset( $active_boxes['mla-menu-order'] );</code></td>
</tr>
<tr>
<td class="mla-doc-hook-label">mla_parent_info_meta_box</td>
<td class="mla-doc-hook-definition">modify the text portion of the "Parent Info" meta box.</td>
</tr>
<tr>
<td class="mla-doc-hook-label">mla_menu_order_meta_box</td>
<td class="mla-doc-hook-definition">modify the "Menu Order" meta box.</td>
</tr>
<tr>
<td class="mla-doc-hook-label">mla_image_metadata_meta_box<br />mla_image_metadata_meta_box_html</td>
<td class="mla-doc-hook-definition">modify the rows, columns and content of the "Attachment Metadata" meta box.</td>
</tr>
<tr>
<td class="mla-doc-hook-label">mla_file_metadata_meta_box<br />mla_file_metadata_meta_box_html</td>
<td class="mla-doc-hook-definition">modify the rows, columns and content of the "Attachment File Metadata" meta box.</td>
</tr>
<tr>
<td class="mla-doc-hook-label">mla_featured_in_meta_box<br />mla_featured_in_meta_box_html</td>
<td class="mla-doc-hook-definition">modify the rows, columns and content of the "Featured in" meta box.</td>
</tr>
<tr>
<td class="mla-doc-hook-label">mla_inserted_in_meta_box<br />mla_inserted_in_meta_box_html</td>
<td class="mla-doc-hook-definition">modify the rows, columns and content of the "Inserted in" meta box.</td>
</tr>
<tr>
<td class="mla-doc-hook-label">mla_gallery_in_meta_box<br />mla_gallery_in_meta_box_html</td>
<td class="mla-doc-hook-definition">modify the rows, columns and content of the "Gallery in" meta box.</td>
</tr>
<tr>
<td class="mla-doc-hook-label">mla_mla_gallery_in_meta_box<br />mla_mla_gallery_in_meta_box_html</td>
<td class="mla-doc-hook-definition">modify the rows, columns and content of the "MLA Gallery in" meta box.</td>
</tr>
</table>
<a name="mla_views"></a>&nbsp;
<p>
<a href="#backtotop">Go to Top</a>
</p>
<h3>Library Views/Post MIME Type Processing</h3>
<p>
WordPress uses <em><strong>Post MIME Types</strong></em> (a terrible name; they have nothing to do with Posts or Pages), to define the views for the Media/Library screen and the Media Manager/Add Media "media items" drop down list. MLA's Media/Assistant screen uses an enhanced version of the list, <em><strong>Table Views</strong></em>, to support views with multiple MIME Types (e.g., "audio,video") and wildcard specifications (e.g. "*/*ms*").
</p>
<p>
The first time it is invoked, MLA will retrieve the current list of Post MIME Types and use it to initialize the list. MLA will add any custom items it finds added to the list by other plugins and code. Once the list is initialized, MLA's list will be used and other plugins and code will have no effect. You can disable MLA handling of the list by clearing the <em><strong>Enable View and Post MIME Type Support</strong></em> checkbox at the bottom of the screen and clicking "Save Changes".
</p>
<h4>Post MIME Type</h4>
<p>
The Post MIME Type list uses the Slug, Singular Label and Plural Label values. The Slug is most important; it uniquely identifies the list entry. The Slug value must be all lowercase and contain only letters, numbers, periods (.), slashes (/) and hyphens (-). For &ldquo;Post MIME Type&rdquo; items, the slug is also the MIME type specification and must be a single, valid MIME specification, e.g., &ldquo;image&rdquo; or &ldquo;image/jpeg&rdquo;. The labels are displayed in various admin screens.
</p>
<h4>Use Within WordPress</h4>
<p>
Within WordPress, the Post MIME Types list is returned from <code>/wp-includes/post.php, function get_post_mime_types()</code>. That function is called from:
</p>
<ul class="mla_settings">
<li><code>/wp-admin/includes/media.php function get_media_item()</code>, to validate the type of an attachment when it is edited,</li>
<li><code>/wp-admin/includes/post.php, function wp_edit_attachments_query()</code> to count the number of attachments of each type, and</li>
<li><code>/wp-includes/media.php function wp_enqueue_media()</code>, to populate the the Media Manager/Add Media "media items" drop down list.</li>
</ul>
<h4>Table View</h4>
<p>
The Table View list adds several enhancements to the Post MIME Type list. In the Specification field you can select several MIME types with a comma-separated list, e.g., "audio,video". Wildcard specifications are also supported. For example, "*/mpeg" to select audio and video mpeg formats or "application/*ms*" to select all Microsoft application formats (Word, Excel, etc.). In the Menu Order field you can enter numeric values to re-arrange the order in which the list entries are displayed in, for example, the Media/Assistant screen.
</p>
<p>
The Table View list also supports custom field queries. A custom field query has four parts:
</p>
<ol>
<li>A prefix, "custom:"</li>
<li>A comma-separated list of one or more custom field names</li>
<li>An equals sign ("="), to divide the field names from the values</li>
<li>A comma-separated list of one or more values</li>
</ol>
<p>
To return all items that match one or more values, enter the prefix "custom:" followed by the custom field name(s) and then "=" followed by a list of values. For example, <code>custom:Color=red</code> or <code>custom:Color=red,green,blue</code>. To search multiple fields, enter something like <code>custom:Artist,Patron=smith,jones</code>. To search <strong>all</strong> custom fields, enter an asterisk ("*"), e.g., <code>custom:*=smith,jones</code>. Wildcard specifications are also supported; for example, "*post" to match anything ending in "post" or "th*da*" to match values like "the date" and "this day". As explained below, a value of "*" will match any non-NULL value for a custom field.
</p>
<p>
There are two special forms of the custom field specification used to test for the presence (non-NULL) or absence (NULL) of <strong>any</strong> values:
</p>
<ul class="mla_settings">
<li>To return all items that have a non-NULL value in the field, enter the custom field name and then "=*", e.g., <code>custom:My Featured Items=*</code>. You can also enter the prefix "custom:" followed by just the custom field name(s). For example, <code>custom:My Featured Items</code>.</li>
<li>To return all items that have a NULL value in the field, enter the prefix "custom:" followed by the custom field name(s) and then "=", e.g., <code>custom:My Featured Items,My Inserted Items=</code>. You can also enter a single custom field name and then ",null". For example, <code>custom:My Featured Items,null</code>.</li>
</ul>
<p>
You can add one or more MIME filters to a custom field query. For example, to limit the view to image items you can code something like <code>image,custom:Color=red</code>. Because the comma is used as a delimiter for multiple MIME types as well as within some forms of the custom field query, <strong>the custom field query must be the last (or only) element of the specification</strong>. For example, <code>audio,video,custom:Artist,Patron=smith,jones</code>.
</p>
<p>
If you have enabled the <em><strong>Media Manager Enhanced MIME Type filter</strong></em>, the Table View list will also be available in the Media Manager/Add Media "media items" drop down list.
<a name="mla_uploads"></a>
</p>
<p>
<a href="#backtotop">Go to Top</a>
</p>
<h3>File Extension and MIME Type Processing</h3>
<p>
The file extension/MIME Type associations are used by WordPress to decide what kind of files can be uploaded to the Media Library and to fill in the <code>post_mime_type</code> value for files added to the Media Library. To upload a file, the file extension must be in this list and be active. 
</p>
<p>
The first time it is invoked, MLA will retrieve the current list of extensions and  MIME Types and use it to initialize the list. MLA will add any custom items it finds added to the list by other plugins and code. Once the list is initialized, MLA's list will be used and other plugins and code will have no effect. You can disable MLA handling of the list by clearing the <em><strong>Enable Upload MIME Type Support</strong></em> checkbox at the bottom of the screen and clicking "Save Changes".
</p>
<p>WordPress examines the content of a file during upload to more carefully validate the file's MIME type. Sometimes this extra validation prevents valid files from being added to the Media Library. For example, a CSV or plain text file that contains some HTML tags will be classified as "text/html" instead of text/csv or text/plain. This causes the upload to fail for "security reasons".</p>
<p>You can check the <em><strong>Always Use MLA MIME Type</strong></em> option to bypass this extra security and use the MIME Type defined here in all uploads. Consider using this option carefully, only when you are having trouble uploading a file or files you know to be valid.</p><h4>Extension and MIME Type</h4>
<p>
The Extension is the file extension for this type, and unique key for the item. It must be all lowercase and contain only letters, numbers and hyphens (-). The MIME Type value must be all lowercase and contain only letters, numbers, periods (.), slashes (/) and hyphens (-). The MIME type specification must be a single, valid MIME specification, e.g., "image" or "image/jpeg". These two values are used to compose the list of valid extension/type associations for use within WordPress.
</p>
<p>
When a file is uploaded to your Media Library the MIME type associated with that file extension is saved in the WordPress database record for the item. Later, you can use the <code>post_mime_type</code> to, for example, include or exclude the item from an <code>[mla_gallery]</code> display. You can think of the MIME Type as another way to categorize items in the Media Library. Once assigned, the MIME Type is not changed if you later alter the association between file extension and MIME Type. Think twice, therefore, when adding a new association to the list or changing the MIME type associated with an existing extension on the list.
</p>
<h4>Icons and Icon Types</h4>
<p>WordPress maintains a list of "file types" which associate file extensions with type names used to select an icon image. For example, an "audio" file type is associated with an image of musical notes. There are nine of these types: archive, audio, code, default, document, interactive, spreadsheet, text and video. MLA has a much longer list; 112 icon types/images in all. If the "Enable MLA File Type Icons Support" checkbox at the bottom of the Settings screen, Uploads tab  is checked, the enhanced icon images will be used in place of the WordPress images.</p>
<p>The MLA icon images are slightly larger than the default images and square; 64x64 pixels. The images are drawn (with permission) from the <a href="http://www.softicons.com/free-icons/system-icons/crystal-project-icons-by-everaldo-coelho" target="_blank">Crystal Project Icons</a>, created by <a href="http://www.everaldo.com" target="_blank">Everaldo Coelho</a>, founder of <a href="http://www.yellowicon.com/" target="_blank">Yellowicon</a>. You can find the images in the <code>/plugins/media-library-assistant/images/crystal</code> directory.</p>
<p>You can add icon images of your own to the MLA set. Place your icon image file(s) (<code>.png</code> format only, 64x64 pixels) in a directory anywhere within the <code>.../wp-content/</code> directory tree, e.g., <code>.../wp-content/my-icons/</code>. Then, enter the direstory name (relative to <code>.../wp-content/</code>) in the "Custom Icons" text box on the Uploads tab, e.g., <code>my-icons</code>. MLA will copy your files to the <code>crystal</code> directory whenever you click "Save Changes". MLA will also copy the files again each time the MLA version number changes, because the plugin update process deletes the existing plugin directories before installing the new version.</p>
<p>You can change the icon image associated with any file extension by selecting a new value from the dropdown list on the Edit Upload MIME Type screen or in the Quick Edit area. You can change the icon image for several extensions at once using the Bulk Edit action.</p>
<p>If you have some other plugin or mechanism for handling the Upload MIME Type items, you can disable MLA support entirely. Clear the checkbox at the bottom-left corner of the screen and click "Save Changes".</p>
<h4>Source and Status</h4>
<p>
The "Source" of an Upload MIME Type reveals where the extension/MIME Type association comes from:
</p>
<ul class="mla_settings">
<li><strong>core</strong>: WordPress defines a core set of extensions and associated MIME types, and this list changes with new WordPress releases. These are the "official" items. You can't delete them, but you can inactivate them so they are not used to validate file uploads.</li>
<li><strong>mla</strong>: Media Library Assistant adds several more extension/type items, drawing from the most popular items found in other plugins and web sites. They are initialized as "inactive" items, so you must explicitly decide to activate them for use in file upload validation.</li>
<li><strong>custom</strong>: Defined by some other plugin or code, or by manual action. When MLA first builds its list it will automatically add anything it finds in your current list as a new, active custom item. After that, you can use MLA to manage them.</li>
</ul>
<p>
The "Status" of an item determines whether it is used by WordPress to validate file uploads and assign MIME types to attachments in your Media Library. Only "active" items are used in this way; making an item "inactive" will prevent further uploads with that extension but will NOT affect any attachments already in your Media Library.
</p>
<h4>Use Within WordPress</h4>
<p>
Within WordPress, the Uploads list is returned from two different functions. In the current MLA release, the same list is returned from both functions. It appears that <code>wp_get_mime_types()</code> is designed to be more liberal than <code>get_allowed_mime_types()</code>. If you have a reason to return different results from one or the other function, let me know and I will consider enhancing the plugin.
</p>
<p>
The first function is <code>/wp-includes/functions.php, function wp_get_mime_types()</code>. That function is called from:
</p>
<ul class="mla_settings">
<li><code>/wp-includes/class-wp-image-editor.php function get_mime_type()</code>, to validate the type of an attachment when it is edited,</li>
<li><code>/wp-includes/class-wp-image-editor.php function get_extension()</code>, to validate the type of an attachment when it is edited,</li>
<li><code>/wp-includes/functions.php, function do_enclose()</code> to "check content for video and audio links to add as enclosures", and</li>
<li><code>/wp-includes/functions.php, function get_allowed_mime_types()</code>, to populate the the Media Manager/Add Media "media items" drop down list.</li>
</ul>
<p>
The second function is <code>/wp-includes/functions.php, function get_allowed_mime_types()</code>. That function is called from:
</p>
<ul class="mla_settings">
<li><code>/wp-includes/formatting.php function sanitize_file_name()</code>, to validate the name of a file, and</li>
<li><code>/wp-includes/functions.php, function wp_check_filetype()</code>, to validate the type of a file before it is uploaded</li>
</ul>
<p>
The list is also used in <code>/wp-includes/ms-functions.php, function check_upload_mimes()</code>, which "is used to filter that list against the filetype whitelist provided by Multisite Super Admins at <code>/wp-admin/network/settings.php</code>." Multisite installs must respect this restriction, so any list we produce will be passed thru that function if it exists.
</p>
<p>
The Icon Type information is used primarily in a function that matches a file extension to an icon image:
</p>
<ul class="mla_settings">
<li><code>/wp-includes/post.php, function wp_mime_type_icon()</code></li>
</ul>
<p>
The icon images can be returned in a <code>[gallery]</code> or an <code>[mla_gallery]</code> shortcode when <code>size=icon</code> is specified. The icons also appear on the Media/Library and Media/Assistant submenu tables.
<a name="mla_optional_uploads"></a>
</p>
<p>
<a href="#backtotop">Go to Top</a>
</p>
<h3>Searching for Upload MIME Types</h3>
<p>
The association between file extensions and MIME Types is an inexact science, as you might imagine. Over the years many companies, standards bodies and other organizations have laid claim to file extensions for different purposes and defined MIME Types to suit their needs. As this is written there are hundreds of web sites with lists of extensions and corresponding MIME Types; most of them give no explanation or justification for their choices. 
</p>
<p>
If you come across a new file extension, or if the existing extension/MIME type association does not suit you, you can search the MLA list of over 1,500 alternatives. The list was compiled from several Internet sources and a vigorous attempt was made to get a Description for each choice. If you find a mistake or an entry missing from the list, let me know!
</p>
<p>
The <em><strong>Known File Extension/MIME Type Associations</strong></em> list will often list several MIME Types for a given file extension. Think carefully before choosing one that differs from the WordPress and MLA Types, if they exist. Once you choose an association and upload files of that type, think <strong>very carefully</strong> before changing it, because changes will <strong>not</strong> be applied to existing Media Library items.
</p>
<p>
For your own research, I suggest starting with these resources:
</p>
<ul class="mla_settings">
<li><a href="http://www.iana.org/assignments/media-types" target="_blank">Internet Assigned Number Authority MIME Media Types</a></li>
<li><a href="http://en.wikipedia.org/wiki/Internet_media_type" target="_blank">Wikipedia: Internet Media Type</a></li>
<li><a href="http://en.wikipedia.org/wiki/Mailcap" target="_blank">Wikipedia: Mailcap</a></li>
<li><a href="http://filext.com/" target="_blank">FILExt: A free online resource by Uniblue</a></li>
</ul>
<p>
Put on your boots and have a paddle handy - it's a swamp! Good luck.
<a name="mla_custom_field_mapping"></a>
</p>
<p>
<a href="#backtotop">Go to Top</a>
</p>
<h3>Custom Field and Attachment Metadata Processing Options</h3>
<p>
In the Custom Fields tab of the Settings screen you can define the rules for mapping several types of file and image metadata to WordPress custom fields. You can also use this screen to define rules for adding or updating elements within the WordPress-supplied "Attachment Metadata", stored in the "_wp_attachment_metadata" custom field. See the <a href="#attachment_metadata_mapping">Adding or changing Attachment Metadata</a> section below for details.
</p>
<p>
You can view and/or download this PDF document with more information: <a href="http://davidlingren.com/assets/MLA-Metadata-Mapping.pdf" target="_blank">Mapping File Metadata to WordPress Fields with Media Library Assistant</a>
</p>
<p>
In this tab there are three ways to execute one or more custom field mapping rules for <strong>ALL</strong> of your Media Library items:
</p>
<ul class="mla_settings">
<li><strong>Execute All Rules button</strong> - just below the "Enable" checkbox controls in the upper-left portion of the tab. Click this button to immediately run <strong>ALL</strong> of the active rules. Rules marked as inactive will not be executed.</li>
<li><strong>Bulk Actions "Execute"</strong> - Runs the rules you select by checking the box to the left of one or more rule names. Pull down the "Bulk Actions" control and select "Execute", then click the "Apply" button. <strong>Inactive rules will be executed</strong>; do not select them unless you want to execute them!</li>
<li><strong>"Execute" rollover action</strong> - Runs the single rule you select by clicking the rule's "Execute" rollover action. <strong>Inactive rules will be executed</strong>.</li>
</ul>
<p>
These commands process your items in "chunks" to prevent timeout errors. You can pause/resume or cancel the operation between chunks. Note that rules with a Data Source of "none" are ignored because they can't change the custom field value.
</p>
<p>
There are two other ways you can perform custom field mapping for one or more existing attachments:
</p>
<ul class="mla_settings">
<li><strong>Edit Media screen</strong> - You can click the "Map Custom Field metadata" link in the "Image Metadata" postbox to apply the existing mapping rules to a single attachment.</li>
<li><strong>Bulk Action edit area</strong> - To perform mapping for a group of attachments you can use the Bulk Action facility on the Media/Assistant screen. Check the attachments you want to map, select "Edit" from the Bulk Actions dropdown list and click "Apply". The bulk edit area will open with a list of the checked attachments in the left-hand column. You can click the "Map Custom Field metadata" button in the lower left corner of the area to apply the existing mapping rules to the attachments in the list.</li>
</ul>
<p>
Custom field mapping is a powerful tool, but it comes at the price of additional database storage space and processing time to maintain and retrieve the data. <strong><em>Think carefully about your needs before you use this tool.</em></strong> You can disable or delete any rules you create, so you might want to set up some rules for a special project or analysis of your library and then discard them when you're done. That said, the advantages of mapping metadata to custom fields are:
</p>
<ul class="mla_settings">
<li>You can add the data to an <code>[mla_gallery]</code> with a field-level markup substitution parameter. For example, add the image dimensions or a list of all the intermediate sizes available for the image.</li>
<li>You can add the data as a sortable, searchable column to the Media/Assistant submenu table. For example, you can find all the "orphans" in your library by adding "reference_issues" and then sorting by that column. You can also click on any value in the column to filter the display on a single custom field value.</li>
</ul>
<p>
If you just want to add a custom field to the Media/Assistant submenu, the quick edit area and/or the bulk edit area you can bypass the mapping logic by leaving the Data Source value as "-- None (select a value) --".
</p>
<p>
Three checkbox options control the custom field mapping when new items are added to the Media Library:
</p>
<ul class="mla_settings">
<li><strong>Enable custom field mapping</strong> - Check this option to enable the mapping rules and display the "Map" buttons on the Media/Edit Media and Media/Assistant Bulk Edit screens.</li>
<li><strong>Perform custom field mapping when adding new media</strong> - Check this option to perform mapping when uploading new items (attachments) to the Media Library.</li>
<li><strong>Perform custom field mapping when updating media metadata</strong> - Check this option to perform mapping when WordPress regenerates the item (attachment) metadata array,
 e.g., when the Media/Edit Media "Edit Image" functions are used.</li>
</ul>
<p>
The "when adding" and "when updating" options do <strong>NOT</strong> affect the operation of the "Map" buttons on the bulk edit or single edit screens, nor do they affect any of the "Execute" mapping functions On this Settings screen.
</p>
<p>
Check one or more options to enable these features, then click the "Save Changes" button to record your new setting(s).
</p>
<p>
Some plugins support file uploads from the WordPress "front end", usually by using the WordPress "AJAX" support. To enable mapping when these plugins are used you must add an entry to your <code>wp-config.php</code> file so MLA will load the mapping code:
</p>
<ul class="mla_settings">
<li><code>define( 'MLA_AJAX_EXCEPTIONS', 'wfu_ajax_action,upload_ugc' );</code></li>
</ul>
<p>
The above example adds the "action" values for two popular file upload plugins, <a href="https://wordpress.org/plugins/wp-file-upload/" title="WordPress File Upload plugin page" target="_blank">WordPress File Upload</a> and <a href="https://wordpress.org/plugins/frontend-uploader/" title="Frontend Uploader plugin page" target="_blank">Frontend Uploader</a> respectively. Once the entry is added MLA will run the mapping rules when it detects file upload operations from the other plugin(s).
</p>
<p>
If you cannot identify the proper "action" value or if your uploader uses another method to do its work you can try adding <code>define( 'MLA_AJAX_EXCEPTIONS', 'always' );</code> to your <code>wp-config.php</code> file. This value will unconditionally load full MLA support for AJAX operations and may give you better results. You can also use the <a href="#mla_debug_tab">Debug tab</a> and <code>define( 'MLA_DEBUG_LEVEL', 3 );</code> to log more information about file upload requests; that may help identify the appropriate "action" value. 
<a name="custom_field_mapping_example"></a>
</p>
<p>
<a href="#backtotop">Go to Top</a>
</p>
<h4>Custom field mapping example</h4>
<p>
Here is a simple example of mapping the items' file size to a custom field, so you can display it in the Media/Assistant submenu table and use it in and <code>[mla_gallery]</code> shortcode. You can go to the Settings/Media Library Assistant Custom Fields tab and define a rule that maps file size to a WordPress custom field. The steps required are:
</p>
<ol>
<li>Navigate to the Settings/Media Library Assistant "Custom Fields" tab.</li>
<li>Make sure the "Perform custom field mapping when adding new media" box is checked. If not, check the box, scroll down and click "Save Changes".</li>
<li>Scroll down to the "Add New Rule" area on the left part of the screen.</li>
<li>Click the "Enter new field" link to change the drop down list of existing fields to a text box.</li>
<li>In the text box, give your field a name, e.g., "File Size".</li>
<li>From the Data Source dropdown list, select "file_size".</li>
<li>Leave the "Meta/Template" text box empty; it's not needed for this example.</li>
<li>Click the "MLA Column" check box to make the field available in the Media/Assistant submenu table. You can also click the "Quick Edit" and "Bulk Edit" check boxes to make the field available in the Media/Assistant submenu table Quick Edit and Bulk Edit areas if that's useful for you.</li>
<li>In the "Existing Text" dropdown list, select "Replace".</li>
<li>In the "Format" dropdown list, select "Commas". This will format the values in a more attractive way.</li>
<li>In the "Option:" dropdown list, select "Text".</li>
<li>Click the "Delete NULL Values" checkbox.</li>
<li>Click the "Add Rule" button to save your work and create the rule.</li>
</ol>
<p>To create the "File Size" value for the items already in your Media Library, find your new rule in the table on the right part of the screen. Hover below the "File Size" rule name and click the "Execute" rollover action.</p> 
<p>On the Media/Assistant screen you can now display a File Size column. If you don't see the column, pull down the Screen Options (upper-right corner) and check the box next to File Size. Each of the terms in the column is a link; click on a value to get a list filtered by that value. You can also sort the table on File Size by clicking on the column header.</p>
<p>You can use the meta_key, orderby and order parameters to sort an <code>[mla_gallery]</code> by your custom field. For example:<br />
&nbsp;<br />
<code>[mla_gallery post_parent=all meta_key="File Size" orderby=meta_value order=DESC]</code><br />
&nbsp;<br />
The three parameters in the above example will select all of the images in your media library and sort your gallery so the largest files appear first. You can replace <code>post_parent=all</code> with any other data selection parameters to get the items you want. For example, you can use a "meta_query" to select only those items (of any MIME Type) whose File Size is less than 82,168 bytes (and display the size in the gallery item caption):<br />
&nbsp;<br />
<code>[mla_gallery post_mime_type=all meta_query="array( array( 'key' => 'File Size', 'value' => array( '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;', '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;82,168' ), 'compare' => 'BETWEEN' ) )" meta_key="File Size" orderby="meta_value" order="DESC" mla_caption="{+caption+}<br />{+custom:File Size+}"]</code>
</p>
<p>
Note the format of the <code>value</code> and <code>compare</code> parameters within the <code>meta_query</code>. Because the File Size custom field uses the "Commas" format, the values are stored as 15-character strings with leading spaces; this makes the values display and sort sensibly. You must use <code>'compare' => 'BETWEEN'</code> and give the lowest and highest values as an array in the <code>'value' => array( '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;', '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;82,168' )</code> parameter, padding each value out to exactly 15 characters wide.
<a name="custom_field_rule_elements"></a>&nbsp;
</p>
<p>
<a href="#backtotop">Go to Top</a>
</p>
<h4>The custom field rule elements</h4>
<dl>
<dt>Rule Name</dt>
<dd>
Contains the name of the custom field or metadata element to which the rule applies. Attachment metadata elements are displayed as a "meta:" prefix followed by the element name; see the <a href="#attachment_metadata_mapping">Adding or changing Attachment Metadata</a> section for more details.
</dd>
<dt>Data Source dropdown</dt>
<dd>
Contains a list of data elements you can map to the custom field. You can also select "Metadata" or "Template" and use the text box below the dropdown to specify attachment metadata or a content template for the source.
<table>
<tr>
<td class="mla-doc-table-label">-- None (select a value) --</td>
<td>nothing, i.e., no change to existing value (if any). Use this source if you just want to add a custom field to the Media/Assistant submenu and/or the inline edit areas.</td>
</tr>
<tr>
<td class="mla-doc-table-label">--&nbsp;Metadata&nbsp;(see&nbsp;below)&nbsp;--</td>
<td>WordPress attachment metadata, from the <em>_wp_attachment_metadata</em> array. Enter the field you want in the text box below the dropdown list. More coding guidelines are given in the "<a href="#attachment_metadata_mapping">Adding or changing Attachment Metadata</a>" section below.</td>
</tr>
<tr>
<td class="mla-doc-table-label">--&nbsp;Template&nbsp;(see&nbsp;below)&nbsp;--</td>
<td style="padding-bottom: 2em;">A Content Template; enter the template text (without the "template:" prefix) in the text box below the dropdown list. More coding guidelines are given in the "<a href="#custom_field_mapping_with_templates">Custom field mapping with Content Templates</a>" section above.</td>
</tr>
<tr>
<td class="mla-doc-table-label">(other data source)</td>
<td> See the <a href="#field_level_data_sources">Data sources for custom field mapping</a> section for definitions of the other data elements you can select from.
</td>
</tr>
</table>
If you just want to add a custom field to the Media/Assistant submenu, the quick edit area and/or the bulk edit area you can bypass the mapping logic by leaving the Data Source value as "-- None (select a value) --".
<br />&nbsp;<br />
Most of the data elements are static, i.e., they do not change after the attachment is added to the Media Library.
The parent/reference information (parent_type, parent_title, parent_issues, reference_issues) and the "where-used" information (featured in, inserted in, gallery in and MLA gallery in) is dynamic; it will change as you define galleries, insert images in posts, define Featured Images, etc. Because of the database processing required to update this information, <strong><em>parent, where-used and reference data are NOT automatically refreshed</em></strong>. If you use these elements, you must manually refresh them with the "map data" buttons on the Settings screen, the bulk edit area or the Edit Media screen.
<br />&nbsp;<br />
Several of the data elements are sourced from the WordPress "image_meta" array. The credit, caption, copyright and title elements are taken from the IPTC/EXIF/WP metadata (if any), but they go through a number of filtering rules that are not easy to replicate with the MLA IPTC/EXIF/WP processing rules. You may find these "image_meta" elements more useful than the raw IPTC/EXIF/WP metadata.
</dd>
<dt>Meta/Template text</dt>
<dd>
If you select "<strong>-- Metadata (see below) --</strong>" as the data source you must specify the name of the field you want in the text box below the data source dropdown box. Any of the fields in the <em>_wp_attachment_metadata</em> array may be named, including the new audio/video fields available with WordPress 3.6 and later. For example, "length_formatted" will return the length of a video attachment. You can specify elements within an array with a compound name, e.g., "audio.sample_rate" to get the sampling rate field from the "audio" array of a video attachment. If you simply specify "audio", you will get the values of every array element, e.g., "mp4,ISO/IEC 14496 AAC,48000,2,16,false,stereo".
<br />&nbsp;<br />
If you select "<strong>-- Template (see below) --</strong>" as the data source you must enter your template in the text box below the data source dropdown box. See the <a href="#custom_field_mapping_with_templates">Custom field mapping with Content Templates</a> section for more details.
</dd>
<dt>MLA Column checkbox</dt>
<dd>
Check this box if you want a custom field to appear as a sortable column in the Media/Assistant submenu table. Attachment metadata elements cannot be used as a table column; this box is ignored if the Field Title contains the "meta:" prefix.
</dd>
<dt>Quick Edit checkbox</dt>
<dd>
Check this box if you want the field to appear in the Media/Assistant submenu Quick Edit area.
</dd>
<dt>Bulk Edit checkbox</dt>
<dd>
Check this box if you want the field to appear in the Media/Assistant submenu Bulk Edit area.
</dd>
<dt>Existing Text dropdown</dt>
<dd>
If the custom field already has values for one or more items, you can use "Keep" to retain them. For options other than "Multi", "Keep" means that an item with a non-blank value in the field will be unchanged, and new values will be stored only in those items that do not have an existing value. For the "Multi" option, the existing value(s) will be retained and any new values will be added as separate instances. 
<br />&nbsp;<br />
You can combine "Keep" and "Multi" in useful ways. For example, you might enter some values manually or source them from another plugin or application. Then, map the same field using an MLA data source with the "Keep" and "Multi" parameters. That will add the MLA values to the values you already entered, giving you a single column with both results.
<br />&nbsp;<br />
If you want to delete the existing values you can use "Replace" to replace the existing values when the new value is not empty, or "Replace All" to unconditionally replace the existing value even if the new value is empty (effectively deleting the existing value). 
</dd>
<dt>Format dropdown</dt>
<dd>
Sorting by custom fields in the Media/Assistant submenu is by string values. For numeric data this can cause odd-looking results, e.g., dimensions of "1200x768" will sort before "640x480". Numeric data sources are converted to strings and padded on the left with spaces if you use the "<strong>commas</strong>" format. This padding makes them sort more sensibly. The following example shows the results for the &quot;size_bytes[large]&quot; data source, sorted in ascending order:
<table class="mla-doc-dropdown-padding" style="margin-bottom: 10px;">
<thead>
<tr>
<td class="textleft" style="width: 80px">
Native
</td>
<td class="textright" style="width: 80px">
Commas
</td>
<td class="textleft mla-doc-dropdown-padding" style="width: 80px">
Raw
</td>
</tr>
</thead>
<tbody>
<tr>
<td class="textleft">&nbsp;</td>
<td class="textright">&nbsp;</td>
<td class="textleft mla-doc-dropdown-padding">0</td>
</tr>
<tr>
<td class="textleft">374871</td>
<td class="textright">4,096</td>
<td class="textleft mla-doc-dropdown-padding">374871</td>
</tr>
<tr>
<td class="textleft">4096</td>
<td class="textright">8,192</td>
<td class="textleft mla-doc-dropdown-padding">4096</td>
</tr>
<tr>
<td class="textleft">440242</td>
<td class="textright">374,871</td>
<td class="textleft mla-doc-dropdown-padding">440242</td>
</tr>
<tr>
<td class="textleft">8192</td>
<td class="textright">440,242</td>
<td class="textleft mla-doc-dropdown-padding">8192</td>
</tr>
</tbody>
</table>
Four data sources, "file_size", "pixels", "width" and "height", are padded on the left with spaces even if you use the "<strong>native</strong>" format.<br />
&nbsp;<br />
You can also use the "<strong>raw</strong>" format to avoid the conversion of empty values, such as a numeric zero, to a single space. The first row in the above table shows this "<strong>raw</strong>" treatment; it can be useful for fields like "parent".
</dd>
<dt>Option Dropdown</dt>
<dd>
Several data sources can return more than one value. For example, the "Inserted in" source can return a list of posts/pages that contain references to Media Library items. The format option dropdown can further refine your specification where multiple values exist. There are five options:
<table class="mla-doc-dropdown-padding" style="margin-bottom: 10px">
<tr>
<td class="mla-doc-table-label">Text</td>
<td>(the default) stores a list of the data source values, separated by commas</td>
</tr>
<tr>
<td class="mla-doc-table-label">Single</td>
<td>stores the first value and discards any additional values, e.g., "mp4" for the "audio" example below</td>
</tr>
<tr>
<td class="mla-doc-table-label">Export</td>
<td>for single values, same as Text. For multiple values, stores all the field names and values (including nested arrays). For example, the below audio data would be returned in Export format as "array ('dataformat' => 'mp4', 'codec' => 'ISO/IEC 14496-3 AAC', 'sample_rate' => 48000, 'channels' => 2, 'bits_per_sample' => 16, 'lossless' => false, 'channelmode' => 'stereo')".</td>
</tr>
<tr>
<td class="mla-doc-table-label">Array</td>
<td>stores an array of values in a single instance (database row) of the custom field.</td>
</tr>
<tr>
<td class="mla-doc-table-label">Multi</td>
<td>stores each unique value in a separate instance (database row) of the custom field. This is the most flexible format, as explained below.</td>
</tr>
</table>
The "Multi" option takes advantage of WordPress' ability to store multiple values for a given custom field name (key) as distinct instances (database rows). For example, consider an image that has been inserted in two different posts, "First Post" and "Second Post". The "Text" option would store both titles in a single custom field instance; "First Post,Second Post". The "Multi" option would store two instances, "First Post" and "Second Post". If the custom field is added to the Media/Assistant submenu table as a column, you could click on either of the two values to filter the table listing by value. That would show you all the items inserted in First Post or all the items inserted in Second Post.
</dd>
<dt>Delete NULL values checkbox</dt>
<dd>
The "Delete NULL values" checkbox lets you control what happens if the data source you've selected does not have a value for every attachment. If the checkbox is cleared (not checked), a single space character will be stored for each attachment if the data source value is empty. If the checkbox is set (checked), there will be no entry/row at all in the metadata table for empty data source values and the custom field will not appear in the Edit Media screen for those attachments. This saves space but might confuse other applications that expect a value to be present for all attachments.
<br />&nbsp;<br />
If you use the "Multi" option you will almost certainly want to use the "Delete NULL values" option as well.
</dd>
<dt>Status dropdown</dt>
<dd>
The "Status" dropdown lets you turn rules on or off for most mapping purposes. If you select "Active" the rule will always be applied during a mapping operation. If you select "Inactive" the rule will NOT be applied except when explicitly included in a Bulk Action "Execute" or "Execute" rollover action.
</dd>
</dl>
<a name="attachment_metadata_mapping"></a>&nbsp;
<p>
<a href="#backtotop">Go to Top</a>
</p>
<h4>Adding or changing Attachment Metadata</h4>
<p>
WordPress stores an array of information for image, audio and video items in the "_wp_attachment_metadata" custom field. Plugins such as "Fullscreen Galleria" also use this field to store information like GPS coordinates. Many of the array elements, such as the "sizes" array for images, are in turn arrays of more detailed values. <strong>Compound names</strong> are used to access elements within arrays, e.g., &quot;<strong>sizes.thumbnail.file</strong>&quot; is used to specify the file name for the thumbnail version of an image.
</p>
<p>
As explained elsewhere, you can access all of this data with the "meta:" <a href="#mla_variable_parameters">Field-level markup substitution parameter</a>. By coding the "meta:" prefix in the Field Title column of a field mapping rule you can add to or update this data as well, from any of the data sources listed below. You can use a <a href="#mla_template_parameters">Content Template</a> to compose a value from multiple substitution parameters and test for empty values, choosing among two or more alternatives or suppressing the mapping altogether for a given item.
</p>
<p>
You can also use a special template <code>[+empty+]</code> value to delete the content of an element. Create a rule naming the metadata element, set the Data Source to "-- Template (see below) --", and enter <code>[+empty+]</code> in the Meta/Template text box. Set Existing Text to "Replace" and check the Delete NULL Values box.
</p>
<p>
Let's say, for example, that you want to add GPS coordinates to the "image_meta" element of the Attachment Metadata.
</p>
<ol>
<li>
Open the Settings/Media Library Assistant submenu and select the Custom Fields tab. Scroll down to the "Add a new Field and Mapping Rule" section.
</li>
<li>
In the Field Title text box, enter "meta:image_meta.latitude". The rule will store its results in the "latitude" element of the "image_meta" array within the Attachment Metadata field.
</li>
<li>
In the Data Source dropdown, select "-- Template (see below) --". In the text box below the dropdown, enter "([+exif:GPS.LatitudeSDD+])". This is a Content Template that extracts the "GPS.LatitudeSDD" value from the EXIF data embedded in an image file. The parentheses test the result to eliminate empty values; only non-empty values will be mapped into the image_meta array.
</li>
<li>
Set the other parts of the rule as needed. You can select "Keep" if some of your items already have this information or "Replace" to update all items. "Native" and "Text" are appropriate for this example. You can check "Delete NULL values" to remove any existing, empty values for this element. The "MLA Column", "Quick Edit" and "Bulk Edit" checkboxes have no meaning for Attachment Metadata elements and can be left blank; they will be ignored if checked.
</li>
</ol>
<p>
If you are creating an IPTC/EXIF/WP mapping rule the details are a bit different.
</p>
<ol>
<li>
Open the Settings/Media Library Assistant submenu and select the IPTC/EXIF/WP tab. Scroll down to the "Add a new Field and Mapping Rule" section.
</li>
<li>
In the Field Title text box, enter "meta:image_meta.latitude". The rule will store its results in the "latitude" element of the "image_meta" array within the Attachment Metadata field.
</li>
<li>
In the "EXIF/Template" text box, enter "template:([+exif:GPS.LatitudeSDD+])". This is a Content Template that extracts the "GPS.LatitudeSDD" value from the EXIF data embedded in an image file. The parentheses test the result to eliminate empty values; only non-empty values will be mapped into the image_meta array.
</li>
<li>
Set the other parts of the rule as needed. You can select "EXIF" unless you also select an IPTC value and want it to have priority. You can select "Keep" if some of your items already have this information or "Replace" to update all items.
</li>
</ol>
<a name="custom_field_mapping_with_templates"></a>&nbsp;
<p>
<a href="#backtotop">Go to Top</a>
</p>
<h4>Custom field mapping with Content Templates</h4>
<p>
If you select "<strong>-- Template (see below) --</strong>" as the data source you must enter your template in the text box below the data source dropdown box. Do not code the "template:" prefix, just enter the template text.
</p>
<p>
Within a template, all of the data sources listed above are available. For example, you can code <code>[+pixels+]</code> or <code>[+size_keys,single+]</code>.
</p>
<p>
You can use a template to compose a custom field from multiple data sources, e.g., "<code>Taken with [+meta:camera+] at [+dimensions+] using ISO [+exif:ISOSpeedRatings,single+] and [+exif:ExposureTime+] exposure time</code>".
</p>
<p>
You can use a template to compose a custom field from alternative data sources, depending on which fields are populated for a given attachment. For example, "<code>[+pdf:Keywords+]|[+iptc:2#025+]|none</code>" will use the PDF Keywords field, if populated, then the IPTC keywords field, if populated, or the literal "none" if neither field contains a value. With this template you can get keywords from both PDF documents and images in a single field.
</p>
<p>
Using a template with the Option Dropdown "Text" or "Single" values will yield a text result. For example, multiple IPTC keywords would be converted into a comma-delimited list as a string. If you combine a template with the "Export", "Array" or "Multi" values the template will deliver an array result if the fields inside the template have multiple values. For example, with "Multi" you can code "<code>([+iptc:2#020<strong>,array</strong>+])([+iptc:2#025<strong>,array</strong>+])</code>" to store each of the IPTC supplemental-category <em><strong>and</strong></em> keywords values (there is no "|" in the template) in a separate custom field value. Note the use of the <strong>,array</strong> formatting option in each field; this is required to get an array result for the field. Also, note that each of the fields is enclosed in parentheses, so the field is suppressed if it contains no values.
</p>
<p>
<strong>CAUTION:</strong> If you use the <code>[+custom:ALL_CUSTOM+]</code> pseudo value in a mapping rule, and you apply the rule more than once, you will see copies of the field you are mapping to in the result. To "clear out" a field you are mapping ALL_CUSTOM into, clear out the text box containing the template, select "Replace" and check the "Delete NULL values" box. Then, click "Map All Attachments"; that will delete the old values and give you a clean start. You'll also see that the template you deleted will be restored after the mapping is complete.
<a name="mla_iptc_exif_mapping"></a>
</p>
<p>
<a href="#backtotop">Go to Top</a>
</p>
<h3>IPTC &amp; EXIF Processing Options</h3>
<p>
Some image file formats such as JPEG DCT or TIFF Rev 6.0 support the addition of data about the image, or <em>metadata</em>, in the image file. In addition, many JPEG, TIFF and PDF files use the <a href="https://www.adobe.com/products/xmp/" title="Adobe XMP site" target="_blank">Extensible Metadata Platform (XMP)</a> framework. XMP metadata varies from file to file but is often extensive. Many popular image processing programs such as Adobe PhotoShop allow you to populate metadata fields with information such as a copyright notice, caption, the image author and keywords that categorize the image in a larger collection. WordPress uses some of this information to populate the Title, Slug and Description fields when you add an image to the Media Library.
</p>
<p>
The Media Library Assistant has powerful tools for copying metadata to:
</p>
<ul class="mla_settings">
<li>the WordPress standard fields, e.g., the Caption</li>
<li>taxonomy terms, e.g., in categories, tags or custom taxonomies like Att. Categories and Att. Tags</li>
<li>WordPress Custom Fields</li>
</ul>
<p>
You can define the rules for mapping metadata on the "IPTC/EXIF/WP" tab of the Settings page. You can choose to automatically apply the rules when new media are added to the Library (or not). You can click the "Map IPTC/EXIF/WP metadata" button on the Edit Media/Edit Single Item screen or in the bulk edit area to selectively apply the rules to one or more items. You can use the "Execute" functions in the tab to apply the rules to one, some or <strong><em>ALL</em></strong> of the items in your library at one time.
</p>
<p>If you use any of the "Execute" functions, the selected rule(s) will be immediately applied to <strong>all</strong> of the attachments in your Media Library. THERE<strong> IS NO UNDO FOR THESE ACTIONS!</strong></p>
<p>
If you just want to add a custom field to the Media/Assistant submenu, the quick edit area and/or the bulk edit area go to the "Custom Fields" tab and follow the instructions there.
</p>
<p>
You can view and/or download this PDF document with more information: <a href="http://davidlingren.com/assets/MLA-Metadata-Mapping.pdf" target="_blank">Mapping File Metadata to WordPress Fields with Media Library Assistant</a>
</p>
<p>In this tab there are three ways to execute one or more IPTC/EXIF/WP mapping rules for <strong>ALL</strong> of your Media Library items:
</p>
<ul class="mla_settings">
<li><strong>Execute All Rules button</strong> - just below the "Enable" checkbox controls in the upper-left portion of the tab. Click this button to immediately run <strong>ALL</strong> of the active rules. Rules marked as inactive will not be executed.</li>
<li><strong>Bulk Actions "Execute"</strong> - Runs the rules you select by checking the box to the left of one or more rule names. Pull down the "Bulk Actions" control and select "Execute", then click the "Apply" button. <strong>Inactive rules will be executed</strong>; do not select them unless you want to execute them!</li>
<li><strong>"Execute" rollover action</strong> - Runs the single rule you select by clicking the rule's "Execute" rollover action. <strong>Inactive rules will be executed</strong>.</li>
</ul>
<p>
These commands process your items in "chunks" to prevent timeout errors. You can pause/resume or cancel the operation between chunks.</p>
<p>There are two other ways you can perform IPTC/EXIF/WP mapping for one or more existing attachments: 
</p>
<ul class="mla_settings">
<li><strong>Edit Media screen</strong> - You can click the "Map IPTC/EXIF/WP metadata" link in the "Image Metadata" postbox to apply the existing mapping rules to a single attachment.</li>
<li><strong>Bulk Action edit area</strong> - To perform mapping for a group of attachments you can use the Bulk Action facility on the Media/Assistant screen. Check the attachments you want to map, select "Edit" from the Bulk Actions dropdown list and click "Apply". The bulk edit area will open with a list of the checked attachments in the left-hand column. You can click the "Map IPTC/EXIF/WP metadata" button in the lower left corner of the area to apply the standing mapping rules to the attachments in the list.</li>
</ul>
<p>Three checkbox options control the IPTC/EXIF/WP mapping when new items are added to the Media Library:
</p>
<ul class="mla_settings">
<li><strong>Enable IPTC/EXIF/WP Mapping</strong> - Check this option to enable the mapping rules and display the "Map" buttons on the Media/Edit Media and Media/Assistant Bulk Edit screens.</li>
<li><strong>Perform IPTC/EXIF/WP Mapping when adding new media</strong> - Check this option to perform mapping when uploading new items (attachments) to the Media Library.</li>
<li><strong>Perform IPTC/EXIF/WP Mapping when updating media metadata</strong> - Check this option to perform mapping when WordPress regenerates the item (attachment) metadata array,
 e.g., when the Media/Edit Media "Edit Image" functions are used.</li>
</ul>
<p>
The "when adding" and "when updating" options do <strong>NOT</strong> affect the operation of the "Map" buttons on the bulk edit or single edit screens, nor do they affect any of the "Execute" mapping functions On this Settings screen.</p>
<p>Check one or more options to enable these features, then click the "Save Changes" button to record your new setting(s).</p>
<p>
Some plugins support file uploads from the WordPress "front end", usually by using the WordPress "AJAX" support. To enable mapping when these plugins are used you must add an entry to your <code>wp-config.php</code> file so MLA will load the mapping code:
</p>
<ul class="mla_settings">
<li><code>define( 'MLA_AJAX_EXCEPTIONS', 'wfu_ajax_action,upload_ugc' );</code></li>
</ul>
<p>
The above example adds the "action" values for two popular file upload plugins, <a href="https://wordpress.org/plugins/wp-file-upload/" title="WordPress File Upload plugin page" target="_blank">WordPress File Upload</a> and <a href="https://wordpress.org/plugins/frontend-uploader/" title="Frontend Uploader plugin page" target="_blank">Frontend Uploader</a> respectively. Once the entry is added MLA will run the mapping rules when it detects file upload operations from the other plugin(s).
</p>
<p>
If you cannot identify the proper "action" value or if your uploader uses another method to do its work you can try adding <code>define( 'MLA_AJAX_EXCEPTIONS', 'always' );</code> to your <code>wp-config.php</code> file. This value will unconditionally load full MLA support for AJAX operations and may give you better results. You can also use the <a href="#mla_debug_tab">Debug tab</a> and <code>define( 'MLA_DEBUG_LEVEL', 3 );</code> to log more information about file upload requests; that may help identify the appropriate "action" value. 
<a name="iptc_exif_mapping_example"></a>
</p>
<p>
<a href="#backtotop">Go to Top</a>
</p>
<h4>IPTC/EXIF/WP mapping examples</h4>
<p>
Here is a simple example that uses a content template to populate the WordPress ALT Text standard field, when empty, from the Title field.
</p>
<ol>
<li>Navigate to the Settings/Media Library Assistant IPTC/EXIF/WP tab.</li>
<li>Find the "ALT Text" standard field rule in the submenu table.</li>
<li>Leave the "IPTC Value" dropdown list set to the default "None (select a value)" setting.</li>
<li>Enter "template:([+post_title+]}" in the EXIF/Template Value field.</li>
<li>Set the Priority dropdown to "EXIF".</li>
<li>Set the Existing Text dropdown to "Keep".</li>
<li>Set the Status dropdown to "Active".</li>
<li>Click "Add Rule" to save your rule.</li>
</ol>
<p>
Here is another example; mapping an image's creation date to a custom field, so you can use it to display a gallery of images sorted by the date on which they were taken. There are three common EXIF fields that are populated in most images. For example:
</p>
<blockquote>
DateTimeDigitized 2012:11:28 15:53:23<br />
DateTimeOriginal 2012:11:28 15:53:23<br />
DateTime 2012:12:01 17:37:05<br />
</blockquote>
<p>
You can go to the Settings/Media Library Assistant IPTC/EXIF/WP tab and define a rule that maps any of these fields to a WordPress custom field. The steps required are:
</p>
<ol>
<li>Navigate to the Settings/Media Library Assistant IPTC/EXIF/WP tab.</li>
<li>Make sure the "Enable IPTC/EXIF/WP Mapping when adding new media" box is checked.  If not, check the box, scroll down and click "Save Changes".</li>
<li>Scroll down to the "Add New Custom Field Rule" section.</li>
<li>If you have already defined "Date Time Created" as a custom field, select the field name in the first dropdown. If the field does not yet exist, click the "Enter new field" link to change the drop down list of existing fields to a text box and enter, for example, "Date Time Created" in the text box.</li>
<li>Leave the "IPTC Value" dropdown list set to the default "None (select a value)" setting.</li>
<li>Enter "DateTimeOriginal" in the EXIF/Template Value field.</li>
<li>Set the Priority dropdown to "EXIF".</li>
<li>Set the Existing Text dropdown to "Keep", unless you want to wipe out any values you've assigned earlier.</li>
<li>In the "Format" dropdown list, select "Native".</li>
<li>In the "Option:" dropdown list, select "Text".</li>
<li>Click the "Delete NULL Values" checkbox. This prevents storing an empty value in the database for items that do not have a "DateTimeOriginal" value.</li>
<li>Click "Add Rule" to save your rule.</li>
</ol>
<p>
If you want to test your work, you can go to the Media/Assistant submenu table and click the "Edit" rollover action for an image you know has a "DateTimeOriginal" value. Click the "Map IPTC/EXIF/WP Metadata" link in the upper right "Save" area of the screen, then look down at the Custom Fields meta box and see if your "Date Time Created" value is present and correct. Once you've got your rule working you can update individual images, use the Bulk Edit area to update groups of images or use the "Execute" rollover action for your rule to process all of your images.
</p>
<p>
You can use the meta_key, orderby and order parameters to sort an <code>[mla_gallery]</code> by your custom field. For example:<br />
&nbsp;<br />
<code>[mla_gallery post_parent=all meta_key="Date Time Created" orderby=meta_value order=DESC]</code><br />
&nbsp;<br />
The three parameters in the above example will select all of the images in your media library and sort your gallery so the newest/most recent images appear first. You can replace <code>post_parent=all</code> with any other data selection parameters to get the images you want. For example, you can use a "meta_query" to select only those images created after 2012-01-01 (and display the date in the gallery item caption):<br />
&nbsp;<br />
<code>[mla_gallery meta_query="array( array( 'key' => 'Date Time Created', 'value' => '2012-01-01', 'compare' => '&lt;' ) )" meta_key="Date Time Created" orderby="meta_value DESC" mla_caption="{+custom:Date Time Created+}" ]</code>
<a name="iptc_exif_mapping_tables"></a>
</p>
<p>
<a href="#backtotop">Go to Top</a>
</p>
<h4>The IPTC/EXIF/WP rule elements</h4>
<p>
All types of IPTC/EXIF/WP mapping rules have the following common elements:
</p>
<dl>
<dt>Field Title</dt>
<dd>The standard field title, taxonomy name or Custom Field name. In the Add New Custom Field Rule area you can define a new field by clicking the "Enter new field" link and entering its name in the text box; the value will be saved when you click "Add Rule" at the bottom of the area.
<br />&nbsp;<br />
You can also use the Add New Custom Field Rule area to define rules for adding or updating elements within the WordPress-supplied "Attachment Metadata", stored in the "_wp_attachment_metadata" custom field. Code the "meta:" prefix in the Field Title textbox to make the destination of the rule an element of the Attachment Metadata; see the <a href="#attachment_metadata_mapping">Adding or changing Attachment Metadata</a> section for more details.
</dd>
<dt>IPTC Value</dt>
<dd>The IPTC (International Press Telecommunications Council) metadata, if any, embedded in the image file. For this category, you can select any of the IPTC DataSet tag and field identifiers, e.g., "2#025" for the Keywords field. The dropdown list has the identifier and the "friendly name" MLA defines for most of the IPTC fields; see the table of identifiers and friendly names in the table below. You can find more information in the <a href="https://www.iptc.org/std/IIM/4.2/specification/IIMV4.2.pdf" title="IPTC-NAA Information Interchange Model Version No. 4.2 specification (PDF)" target="_blank">IPTC-NAA Information Interchange Model Version No. 4.2 specification (PDF document)</a>.
</dd>
<dt>EXIF/Template Value</dt>
<dd>The EXIF (EXchangeable Image File) metadata, if any, embedded in a JPEG DCT or TIFF Rev 6.0 image file. 
 Though the specification is not currently maintained by any industry or standards organization, almost all camera manufacturers use it. For this category, you can code any of the field names embedded in the image by the camera or editing software. There is no official list of standard field names, so you just have to know the names your camera and software use; field names are case-sensitive. You can find more information in the <a href="http://en.wikipedia.org/wiki/Exchangeable_image_file_format" title="Exchangeable image file format Wikipedia article" target="_blank">Exchangeable image file format</a> article on Wikipedia. You can find External Links to EXIF standards and tag listings at the end of the Wikipedia article.
<br />&nbsp;<br />
MLA uses a standard PHP function, <a href="http://php.net/manual/en/function.exif-read-data.php" title="PHP Manual page for exif_read_data" target="_blank">exif_read_data</a>, to extract EXIF data from images. The function returns three arrays in addition to the raw EXIF data; COMPUTED, THUMBNAIL and COMMENT. You can access the array elements by prefacing the element you want with the array name. For example, the user comment text is available as "COMPUTED.UserComment" and "COMPUTED.UserCommentEncoding". You can also get "COMPUTED.Copyright" and its two parts (if present), "COMPUTED.Copyright.Photographer" and "COMPUTED.Copyright.Editor". The THUMBNAIL and COMMENT arrays work in a similar fashion.
<br />&nbsp;<br />
MLA provides enhanced access to GPS values within the EXIF metadata; more details are given in the <a href="#mla_gps_values">Enhanced GPS values</a> section below.
<br />&nbsp;<br />
You can also enter a <strong>Content Template</strong> here by coding the "template:" prefix at the beginning of the value. Do <strong>not</strong> add the "[+" and "+]" delimiters; the prefix is all you need. You can use a Content Template to access XMP metadata as an alternative to EXIF metadata. More information about using templates here is given below.
<br />&nbsp;<br />
Two special exif "pseudo-values" are available; <strong>ALL_IPTC</strong> and <strong>ALL_EXIF</strong>. These return a string representation (in &quot;export&quot; format) of all IPTC or EXIF data respectively. You can use these pseudo-values to examine the metadata in an image, find field names and see what values are embedded in the image.
</dd>
<dt>Priority</dt>
<dd>If both the IPTC Value and the EXIF Value are non-blank for a particular image, you can select which of the values will be used for the mapping.
</dd>
<dt>Existing Text</dt>
<dd>Images already in the Media Library will have non-blank values in many fields and may have existing terms assigned in a taxonomy. You can select "Keep" to retain these values and term assignments.
<br />&nbsp;<br />
If you want to delete the existing values you can use "Replace" to replace the existing values when the new value is not empty, or "Replace All" to unconditionally replace the existing value even if the new value is empty (effectively deleting the existing value). For a taxonomy, "Replace" will delete existing term assignments if the new value contains one or more terms, while "Replace All" will delete existing term assignments even if the new value is empty, i.e., contains no term assignments.
</dd>
<dt>Status</dt>
<dd>The "Status" dropdown lets you turn rules on or off for most mapping purposes. If you select "Active" the rule will always be applied during a mapping operation. If you select "Inactive" the rule will NOT be applied except when explicitly included in a Bulk Action "Execute" or "Execute" rollover action. 
</dd>
</dl>
<p>
The Taxonomy mapping rules have three additional elements:
</p>
<dl>
<dt>Option</dt>
<dd>
For most rules the default "Array" value will be the best option. For certain Content Templates the "Text" option will give better results. For example, if you want to combine two EXIF fields into one compound term name use the "Text" option and enter something like this in the EXIF/Template element: <code>template:([+exif:Image.Make+] [+exif:Image.Model+])</code>. For this template the default "Array" option would create two terms, one for each EXIF field.</dd>
<dt>Delimiter(s)</dt>
<dd>
In some cases multiple terms will be contained in a single IPTC or EXIF value. For example, Microsoft Windows stores its "Tags" in a single EXIF value (called Keywords) as a semicolon-separated list, e.g., "tag1; tag2". Other tools use a comma-separated list. For example, the IPTC standard allows either commas or semicolons in the "2#025 keywords" field. You can separate terms encoded in this way by entering one or more delimiter characters in this column.
</dd>
<dt>Parent</dt>
<dd>For hierarchical taxonomies such as Categories you can select one of the existing terms in the taxonomy as the parent term for any terms you are mapping from metadata values. For example, you could define "IPTC Keywords" as a parent and then assign all of the 2#025 values under that parent term.
</dd>
</dl>
<p>
The Custom Field mapping rules have three additional elements (see <a href="#custom_field_rule_elements">The custom field rule elements</a> for more information on these elements):
</p>
<dl>
<dt>Format</dt>
<dd>
The Format element has a "commas" value that can improve the results of sorting on numeric values and a "raw" value that changes the handling of "empty" values such as zero.
</dd>
<dt>Option</dt>
<dd>Some metadata fields can contain more than one value. For example, the "Keywords" field can contain a list of terms that describe the item. The format option dropdown can further refine your specification where multiple values exist.
</dd>
<dt>Delete NULL Values</dt>
<dd>The "Delete NULL values" checkbox lets you control what happens if the data source you've selected does not have a value for every attachment.
</dd>
</dl>
<a name="iptc_exif_mapping_with_templates"></a>&nbsp;
<p>
<a href="#backtotop">Go to Top</a>
</p>
<h4>EXIF/Template mapping with Content Templates</h4>
<p>
If you code the "template:" prefix at the beginning of the EXIF/Template value you have all the power of Content Templates at your disposal. Do <strong>not</strong> add the "[+" and "+]" delimiters; the prefix is all you need.
</p>
<p>
A template can be used to access any IPTC, EXIF or XMP metadata your items contain, as well as any of the <a href="#field_level_data_sources">field-level data sources</a>. For example:<br />
&nbsp;<br />
<code>template:([+xmp:Title+])</code><br />
<code>template:([+xmp:Regions.RegionList.*.*.Name,array+])</code><br />
&nbsp;<br />
Note the use of parentheses around the XMP parameters, which replace missing values with an empty value to enable proper rule processing.
</p>
<p>
Within a template, all of the <a href="#field_level_data_sources">Data sources for custom field mapping</a> are available. For example, you can code <code>[+pixels+]</code> or <code>[+size_keys,single+]</code>.
</p>
<p>
You can use a template to compose a value from multiple data sources, e.g., "<code>Taken with [+meta:camera+] at [+dimensions+] using ISO [+exif:ISOSpeedRatings,single+] and [+exif:ExposureTime+] exposure time</code>".
</p>
<p>
You can use a template to compose a value from alternative data sources, depending on which fields are populated for a given attachment. For example, "<code>[+iptc:2#020+]|[+iptc:2#025+]|none</code>" will use the IPTC supplemental-category field, if populated, then the IPTC keywords field, if populated, or the literal "none" if neither IPTC field contains a value.
</p>
<p>
Using a template in the "Standard field mapping" or "Custom field mapping" tables will yield a text result. For example, multiple IPTC keywords would be converted into a comma-delimited list as a string. In the "Taxonomy term mapping" table the template will deliver an array result if the fields inside the template have multiple values. For example, you can code "<code>template:([+iptc:2#020+])([+iptc:2#025+])</code>" to store each of the IPTC supplemental-category <em><strong>and</strong></em> keywords values (there is no "|" in the template) as a separate taxonomy term. Note that each of the fields is enclosed in parentheses, so the field is suppressed if it contains no values.
</p>
<p>
In the "Standard field mapping" table a special <code>template:[+empty+]</code> value supports deleting the content of the Title, Caption, Description and ALT Text fields. This value is also available in the Media/Assistant submenu table Bulk Edit area.
</p>
<p>
Note that the <strong>,array</strong> formatting option is <strong>not</strong> required to get an array result for the field in a Taxonomy term mapping template; it is assumed. If you want a <strong>text</strong>, <strong>single</strong> or <strong>export</strong> result you can add one of those formatting options to your field specification.
<a name="date_iptc_exif_mapping"></a>
</p>
<p>
<a href="#backtotop">Go to Top</a>
</p>
<h4>IPTC/EXIF/WP Mapping and Bulk Editing for the "Uploaded on" Standard Field</h4>
<p>
The "Uploaded on" Standard Field is set by WordPress to the date and time the item is uploaded to the Media Library. You can use a mapping rule to replace this with a different value, such as the date and time the item was created. Many EXIF date and time values such as DateTimeOriginal and DateTimeDigitized are stored as strings with a format of "YYYY:MM:DD HH:MM:SS". You can parse this format and just about any English textual datetime description into a Unix timestamp, then convert the result to the appropriate format ('Y-m-d H:i:s', e.g., "2014-12-31 23:59:00", or just before midnight on new year's eve). The mapping rule first uses the PHP strtotime() function, then the date() function, to compose a valid date and time. The "Supported Date and Time Formats" that can be passed in to the rule are described at: <a href="http://php.net/manual/en/datetime.formats.php" title="PHP Supported Date and Time Formats" target="_blank">http://php.net/manual/en/datetime.formats.php</a>.<br />&nbsp;<br />You can use a Content Template to compose the starting value in many ways. For example:
</p>
<p><code>
template:([+exif:DateTimeOriginal+]|[+meta:image_meta.created_timestamp,timestamp('Y-m-d H:i:s')+])
</code></p>
<p>
This example first uses the EXIF <code>DateTimeOriginal</code> value, if present. If that value is missing the alternative is the <code>created_timestamp</code> that WordPress calculates and adds to the <code>image_meta</code> array in the attachment metadata. Since the <code>created_timestamp</code> is a Unix timestamp it is first converted to a text format that can be processed by strtotime(). If neither value is available the original WordPress-supplied default will be retained.
</p>
<p>
You can also replace the Uploaded on values for one or more items in the <strong>Bulk Edit Area</strong> of the Media/Assistant submenu table. Again, the Content Template feature adds power to this feature. For example, you can replace the date portion of the value while retaining the time portion to preserve the sort order of your items:
</p>
<p><code>
template: 20180102 [+post_date,date( 'H:i:s' )+]<br />
template: today [+post_date,date( 'H:i:s' )+]
</code></p>
<p>
The first example above sets the date to a fixed value. The second example uses "today", one of the <a href="http://php.net/manual/en/datetime.formats.relative.php" title="PHP Supported Relative Date/Time Formats" target="_blank">Relative Formats</a> PHP supports to replace the date portion with the current date. Both examples access the original <code>post_date</code> data value and then use the "date" format/option function to extract just the time portion.
<a name="pdf_iptc_exif_mapping"></a>
</p>
<p>
<a href="#backtotop">Go to Top</a>
</p>
<h4>IPTC/EXIF/WP Mapping for PDF Documents</h4>
<p>
PDF documents contain a Document Information Dictionary (D.I.D.) and many also contain XMP metadata. For the <code>pdf:</code> prefix, you can code any of the nine D.I.D. entries:
</p>
<ul class="mla_settings">
<li><strong>Title</strong> - The document's title</li>
<li><strong>Author</strong> - The name of the person who created the document</li>
<li><strong>Subject</strong> - The subject of the document</li>
<li><strong>Keywords</strong> - Keywords associated with the document</li>
<li><strong>Creator</strong> - the name of the conforming product that created the original document</li>
<li><strong>Producer</strong> - the name of the conforming product that converted it to PDF</li>
<li><strong>CreationDate</strong> - The date and time the document was created</li>
<li><strong>ModDate</strong> - The date and time the document was most recently modified</li>
<li><strong>Trapped</strong> - indicates whether the document has been modified to include trapping information</li>
</ul>
<p>
MLA contains logic that attempts to fill in the entries from the dictionary or from any XMP metadata the document contains. This gives you a simple way to access the information regardless of where in the metadata it appears.
</p>
<p>
You can use Content Templates in the EXIF/Template Value text box to extract metadata from your PDF documents and add it to the Standard Fields and Taxonomy Terms of your Media Library items. The templates can be coded to select the appropriate source whether the item is a PDF document or an image. Here are three rules for metadata contained in PDF documents:
</p>
<table>
<tr style="font-weight: bold">
<td class="mla-doc-table-reverse">Field</td>
<td>EXIF/Template Value</td>
<td>Priority</td>
<td>Existing Text</td>
<td>Delimiter(s)</td>
</tr>
<tr>
<td class="mla-doc-table-reverse" style="font-weight:bold">Title:</td>
<td class="mla-doc-table-sublabel">template:([+pdf:Title+])</td>
<td>EXIF</td>
<td>Replace</td>
<td>&nbsp;</td>
</tr>
<tr>
<td class="mla-doc-table-reverse" style="font-weight:bold">Caption:</td>
<td class="mla-doc-table-sublabel">template:([+pdf:Subject+])</td>
<td>EXIF</td>
<td>Replace</td>
<td>&nbsp;</td>
</tr>
<tr>
<td class="mla-doc-table-reverse" style="font-weight:bold">Att. Categories:</td>
<td class="mla-doc-table-sublabel">template:([+pdf:Keywords,array+])</td>
<td>EXIF</td>
<td>Replace</td>
<td>;,</td>
</tr>
</table>
<p>
The three rules have a similar structure:
</p>
<ul class="mla_settings">
<li>"template:" (goes in the text box below "EXIF/Template Value") is used to access the pdf: values instead of the EXIF values.</li>
<li>The values are surrounded by parentheses "(" and ")" so they will return an empty string for documents without meta data in the field and for other items such as images.
</li>
<li>I have selected "Replace" to overwrite the existing text, because a default Title was assigned to the items when they were uploaded. You can change this to "Keep" if you already have values in one or more of the fields that you want to retain.
</li>
</ul>
<p>
The taxonomy rule also has the ",array" option to return multiple keywords as individual array elements that can be converted to taxonomy terms. For this rule, the "Delimiter(s)" text box contains a comma and a semicolon, which should cover most of the documents you will encounter.
</p>
<p>
If your Media Library contains a mix of images and PDF documents you will want a more flexible rule to map metadata from different sources in each MIME type. You can extend the rules as follows:
</p>
<table>
<tr style="font-weight: bold">
<td class="mla-doc-table-reverse">Field</td>
<td>EXIF/Template Value</td>
<td>Priority</td>
<td>Existing Text</td>
<td>Delimiter(s)</td>
</tr>
<tr>
<td class="mla-doc-table-reverse" style="font-weight:bold">Title:</td>
<td class="mla-doc-table-sublabel">template:([+pdf:Title+]|[+exif:Title+])</td>
<td>EXIF</td>
<td>Replace</td>
<td>&nbsp;</td>
</tr>
<tr>
<td class="mla-doc-table-reverse" style="font-weight:bold">Caption:</td>
<td class="mla-doc-table-sublabel">template:([+pdf:Subject+]|[+exif:ImageDescription+])</td>
<td>EXIF</td>
<td>Replace</td>
<td>&nbsp;</td>
</tr>
<tr>
<td class="mla-doc-table-reverse" style="font-weight:bold">Att. Categories:</td>
<td class="mla-doc-table-sublabel">template:([+pdf:Keywords,array+]|[+iptc:2#025+])</td>
<td>EXIF</td>
<td>Replace</td>
<td>;,</td>
</tr>
</table>
<p>
The three rules have similar changes:
</p>
<ul class="mla_settings">
<li>A vertical bar ("|") separates the two data source specifications. This is the Content Template "Choice" operator, which takes the first non-blank alternative from among the choices.</li>
<li>A second data source for images. The PDF documents will not have "exif:"/"iptc:" data sources, and images will not have "pdf:" data sources, so only one (at most) of the two alternatives will be non-blank.
</li>
</ul>
<p>
In fact, WordPress contains its own rules for composing a Title from IPTC/Exif metadata (see <a href="#wordpress_default_mapping">WordPress default title, slug and description mapping</a>), so you may not need or want to extend the Title rule. WordPress also fills the Description field, but does not fill the Caption. You may want to copy the Description into the Caption; if you do, replace <code>[+exif:ImageDescription+]</code> with <code>[+post_content+]</code> in the Caption rule.
<a name="wordpress_default_mapping"></a>
</p>
<p>
<a href="#backtotop">Go to Top</a>
</p>
<h4>WordPress default title, slug and description mapping</h4>
<p>
When WordPress uploads a new image file the default title is derived from the file name. If the file contains IPTC and/or EXIF metadata WordPress automatically maps metadata values to the title (post_title), name/slug (post_name) and description (post_content) fields. This happens before the MLA mapping rules are applied, so if you want to override the default mapping you must select "Replace" or "Replace All"in the "Existing Text" column.
</p>
<p>
The WordPress rules are somewhat complex; consult the source code if you need exact details. Here are some functions to example:
</p>
<ol>
<li>/wpadmin/includes/image.php, function wp_read_image_metadata()</li>
<li>/wpadmin/includes/media.php, function media_handle_upload()</li>
<li>/wpadmin/includes/media.php, function media_handle_sideload()</li>
</ol>
<p>
Roughly speaking, the priority order for mapping the post_title and post_name values from non-blank IPTC/EXIF/WP metadata is:
</p>
<ol>
<li>EXIF "Title"</li>
<li>EXIF "ImageDescription" (if less than 80 characters)</li>
<li>IPTC 2#105 "headline"</li>
<li>IPTC 2#005 "object-name"</li>
<li>IPTC 2#120 "caption-or-abstract" (if less than 80 characters)</li>
</ol>
The priority order for mapping the post_content value from non-blank IPTC/EXIF/WP metadata is:
<ol>
<li>EXIF "ImageDescription" (if different from post_title)</li>
<li>IPTC 2#120 "caption-or-abstract" (if different from post_title)</li>
</ol>
<a name="mla_mapping_hooks"></a>&nbsp;
<p>
<a href="#backtotop">Go to Top</a>
</p>
<h3>MLA Custom Field and IPTC/EXIF/WP Mapping Actions and Filters (Hooks)</h3>
<p>
The Custom Field and IPTC/EXIF/WP Mapping tools support a comprehensive set of filters and actions that give you complete control over rule execution and value creation from PHP code in your theme or in another plugin. An example of using the hooks from a simple, stand-alone plugin can be found in the Documentation/Example Plugins submenu. You can find the example plugin here: <a title="Find the Mapping Hooks Example" href="[+example_url+]&amp;mla-example-search=Search+Plugins&amp;s=%22MLA+Mapping+Hooks+Example%22" class="mla-doc-bold-link">MLA Mapping Hooks Example</a>. To run the example:
</p>
<ol>
<li>Click on the link above or go to top of the Documentation tab and click on the "Example Plugins" button.</li>
<li>Hover over "MLA Mapping Hooks Example" in the Name column, then click the "Install" rollover action.</li>
<li>Go to the Plugins/Installed Plugins screen and activate the "MLA Mapping Hooks Example" plugin.</li>
<li>Upload a new attachment and/or run the mapping rules to exercise the filters and write mapping information to the site's Error Log.</li>
<li>Examine the Error Log to see the mapping information.</li>
</ol>
<p>
The example code documents each hook with comments in the filter/action function that intercepts each hook. There are hooks that run at the beginning and end of the overall mapping operation as well as hooks for each mapping rule. 
</p>
<p>
In addition, there are hooks that run when attachments are uploaded to the Media Library and when the "attachment metadata" is altered, e.g., when the Media/Edit Media "Edit Image" function is used. Plugins and other image editing code can destroy the attachment metadata or the IPTC/EXIF/WP metadata embedded in an image file. These hooks may give you an opportunity to preserve and repair the metadata you need in spite of such damage.
</p>
<p>
The current mapping hooks are:
</p>
<table>
<tr>
<td class="mla-doc-table-label">mla_begin_mapping</td>
<td class="mla-doc-hook-definition">called once, before mapping rules for any/all attachment(s) are executed.</td>
</tr>
<tr>
<td class="mla-doc-table-label">mla_mapping_settings</td>
<td class="mla-doc-hook-definition">called once for each attachment, before any mapping rules are executed. You can add, change or delete rules from the settings/rules array.</td>
</tr>
<tr>
<td class="mla-doc-table-label">mla_mapping_rule</td>
<td class="mla-doc-hook-definition">called once for each mapping rule, before the rule is evaluated. You can change the rule parameters, or prevent rule evaluation.</td>
</tr>
<tr>
<td class="mla-doc-table-label">mla_mapping_custom_value</td>
<td class="mla-doc-hook-definition">called once for each custom field mapping rule, after the rule is evaluated. You can change the new value produced by the rule.</td>
</tr>
<tr>
<td class="mla-doc-table-label">mla_mapping_old_custom_value</td>
<td class="mla-doc-hook-definition">called once for each Custom Field mapping rule, after the "old text" portion of the rule is evaluated. You can change the old value produced by the rule.</td>
</tr>
<tr>
<td class="mla-doc-table-label">mla_mapping_iptc_value</td>
<td class="mla-doc-hook-definition">called once for each IPTC/EXIF/WP mapping rule, after the IPTC portion of the rule is evaluated. You can change the new value produced by the rule.</td>
</tr>
<tr>
<td class="mla-doc-table-label">mla_mapping_exif_value</td>
<td class="mla-doc-hook-definition">called once for each IPTC/EXIF/WP mapping rule, after the EXIF portion of the rule is evaluated. You can change the new value produced by the rule.</td>
</tr>
<tr>
<td class="mla-doc-table-label">mla_mapping_new_text</td>
<td class="mla-doc-hook-definition">called once for each IPTC/EXIF/WP mapping rule, after the selection between the IPTC and EXIF values has been made. You can change the new value produced by the rule.</td>
</tr>
<tr>
<td class="mla-doc-table-label">mla_mapping_updates</td>
<td class="mla-doc-hook-definition">called AFTER all mapping rules are applied. You can add, change or remove updates for the attachment's standard fields, taxonomies and/or custom fields.</td>
</tr>
<tr>
<td class="mla-doc-table-label">mla_end_mapping</td>
<td class="mla-doc-hook-definition">called once, after mapping rules for any/all attachment(s) are executed. This is a good place to close files, perform cleanup, etc.</td>
</tr>
<tr>
<td class="mla-doc-table-label">mla_purge_custom_field_values</td>
<td class="mla-doc-hook-definition">called once for each custom field mapping rule, when the "Purge Values" rollover or Bulk action is executed. This is a good place to apply your own purge logic or prevent the purge from taking place.</td>
</tr>
</table>
<p>
A second example plugin, <a title="Find the Metadata Mapping Hooks Example" href="[+example_url+]&amp;mla-example-search=Search+Plugins&amp;s=%22MLA+Metadata+Mapping+Hooks+Example%22" class="mla-doc-bold-link">MLA Metadata Mapping Hooks Example</a>, illustrates the metadata hooks. The current insert attachment/update attachment metadata hooks are:
</p>
<table>
<tr>
<td class="mla-doc-table-label">mla_upload_prefilter</td>
<td class="mla-doc-hook-definition">gives you an opportunity to record the original IPTC, EXIF and
WordPress image_metadata <strong>before</strong> the file is stored in the Media Library.
You can also modify the file name that will be used in the Media Library.
<br />&nbsp;<br />
Many plugins and image editing functions alter or destroy this information,
so this may be your last change to preserve it.</td>
</tr>
<tr>
<td class="mla-doc-table-label">mla_upload_filter</td>
<td class="mla-doc-hook-definition">gives you an opportunity to record some additional metadata
for audio and video media <strong>after</strong> the file is stored in the Media Library.
</td>
</tr>
<tr>
<td class="mla-doc-table-label">mla_add_attachment</td>
<td class="mla-doc-hook-definition">called at the end of the wp_insert_attachment() function,
after the file is in place and the post object has been created in the database.
<br />&nbsp;<br />
By this time, other plugins have probably run their own 'add_attachment' filters
and done their work/damage to metadata, etc.
</td>
</tr>
<tr>
<td class="mla-doc-table-label">mla_update_attachment<br />_metadata_options</td>
<td class="mla-doc-hook-definition">lets you inspect or change the processing options that will
control the MLA mapping rules in the update_attachment_metadata filter.
</td>
</tr>
<tr>
<td class="mla-doc-table-label">mla_update_attachment<br />_metadata_prefilter</td>
<td class="mla-doc-hook-definition">called at the end of the wp_update_attachment_metadata() function,
<strong>before</strong> any MLA mapping rules are applied. The prefilter gives you an
opportunity to record or update the metadata before the mapping.
<br />&nbsp;<br />
The wp_update_attachment_metadata() function is called at the end of the file upload process and at several later points, such as when an image attachment is edited or by
plugins that alter the attachment file.
</td>
</tr>
<tr>
<td class="mla-doc-table-label">mla_update_attachment<br />_metadata_postfilter</td>
<td class="mla-doc-hook-definition">This filter is called <strong>after</strong> MLA mapping rules are applied during
wp_update_attachment_metadata() processing. The postfilter gives you
an opportunity to record or update the metadata after the mapping.
</td>
</tr>
</table>
<p>
The current Settings/Media Library Assistant tab list hook is:
</p>
<table>
<tr>
<td class="mla-doc-table-label">mla_get_options_tablist</td>
<td>gives you an opportunity to remove one or more tabs from the list that appears on the Settings/Media Library Assistant screen.</td>
</tr>
</table>
<a name="mla_debug_tab"></a>&nbsp;
<p>
<a href="#backtotop">Go to Top</a>
</p>
<h3>MLA Debug Tab</h3>
<p>
If you are having trouble with some part of Media Library Assistant it may be helpful to look at the PHP error log. MLA writes messages to the log for a variety of reasons, and the information they contain can be very helpful in finding the cause of a problem and resolving it.
</p>
<p>
The existence and location of the error log can vary depending on your server configuration. WordPress includes some <code>wp-config.php</code> entries that can help. If you activate the Debug tab but can't access the error log you can try adding or updating these statements in your <code>wp-config.php</code> file:
</p>
<ul class="mla_settings">
<li><code>define( 'WP_DEBUG', 1 );</code>
When WP_DEBUG is true, all PHP notices are reported. WordPress will also display notices, including one when a deprecated WordPress function, function argument, or file is used. Deprecated code may be removed from a later version.
</li>
<li><code>define( 'WP_DEBUG_LOG', 1 );</code>
When WP_DEBUG_LOG is true, errors will be logged to wp-content/debug.log. WP_DEBUG_LOG defaults to false.
</li>
<li><code>define( 'WP_DEBUG_DISPLAY', 1 );</code>
When WP_DEBUG_DISPLAY is true, WordPress will force errors to be displayed. WP_DEBUG_DISPLAY defaults to true. Defining it as null prevents WordPress from changing the global configuration setting. Defining WP_DEBUG_DISPLAY as false will force errors to be hidden.
</li>
</ul>
<p>
The full path and file name of the error log is displayed just above the text area that contains the log content. If the content doesn't display and/or you can't download the log file, you can try finding the log file at the location shown. If you can't access the PHP error log for any reason, you can write the MLA-specific messages to a separate file in your <code>/wp-content/</code> directory using the "Debug File" option explained below.
</p>
<p>
The MLA Debug Tab appears at the right of the tab list in the Settings/Media Library Assistant submenu. If you want to restrict access to the logging options and error log file you can suppress the tab by adding an entry to your <code>wp-config.php</code> file:
</p>
<ul class="mla_settings">
<li><code>define( 'MLA_DEBUG_LEVEL', 0 );</code></li>
</ul>
<p>
The MLA_DEBUG_LEVEL is also used to turn categories of debug messages on and off. Each bit of the value has a separate meaning; the current definitions are:
</p>
<table>
<tr>
<td class="mla-doc-table-label">1, or 0x0001</td>
<td>activates the Debug tab. PHP messages and some MLA error messages (such as the <code>[mla_gallery mla_debug=log]</code> messages) will be written to the file.</td>
</tr>
<tr>
<td class="mla-doc-table-label">2, or 0x0002</td>
<td>writes MLA-specific messages to the log for some of the "AJAX" functions such as bulk edit updates and mapping rule execution.</td>
</tr>
<tr>
<td class="mla-doc-table-label">4, or 0x0004</td>
<td>writes MLA-specific messages to the log for calls to the WPML/Polylang support functions.</td>
</tr>
<tr>
<td class="mla-doc-table-label">8, or 0x0008</td>
<td>writes MLA-specific messages to the log for thumbnail generation functions supporting the <code>[mla_gallery mla_viewer=...]</code> parameter.</td>
</tr>
<tr>
<td class="mla-doc-table-label">16, or 0x0010</td>
<td>writes MLA-specific messages to the log for IPTC, EXIF, XMP and PDF metadata generation.</td>
</tr>
<tr>
<td class="mla-doc-table-label">32, or 0x0020</td>
<td>writes MLA-specific messages to the log for WP REST API calls identified by <code>/wp-json/</code> in the SERVER_URI.</td>
</tr>
<tr>
<td class="mla-doc-table-label">64, or 0x0040</td>
<td>writes MLA-specific messages to the log for "where-used" reference collection.</td>
</tr>
<tr>
<td class="mla-doc-table-label">128, or 0x0080</td>
<td>writes MLA-specific messages to the log for MIME Type processing.</td>
</tr>
<tr>
<td class="mla-doc-table-label">256, or 0x0100</td>
<td>writes MLA-specific messages to the log for Media Manager Modal Window actions, e.g., "query_attachments".</td>
</tr>
<tr>
<td class="mla-doc-table-label">512, or 0x0200</td>
<td>writes MLA-specific messages to the log for Intermediate Size processing.</td>
</tr>
</table>
<p>
You can pick the logging categories you want by adding the above values together. For example, to log only PHP messages you can use <code>define( 'MLA_DEBUG_LEVEL', 1 );</code> or <code>define( 'MLA_DEBUG_LEVEL', 0x0001 );</code>. To add the "AJAX" messages you can use <code>define( 'MLA_DEBUG_LEVEL', 3 );</code> or <code>define( 'MLA_DEBUG_LEVEL', 0x0003 );</code>. The hexadecimal notation ( 0x0003 ) can be easier to understand when several options are involved.
</p>
<p>
Although you can add logging categories to the <code>MLA_DEBUG_LEVEL</code> constant you will find it more convenient to add them in the "MLA Reporting" option on the Debug tab. There you can make changes without editing and uploading the `wp-config.php` file as your needs change. It is best to <code>define( 'MLA_DEBUG_LEVEL', 1 );</code> and make any other changes in the "MLA Reporting" option. You can also set the "MLA Reporting" option to zero (0) to turn all logging off but leave the Debug tab active for future use. 
</p>
<p>
The Debug Options screen begins with the "Debug Options" section, containing:
</p>
<table>
<tr>
<td class="mla-doc-table-label">Display&nbsp;Limit</td>
<td>lets you limit the amount of log information copied to the text area for display. Setting a limit to, for example, 262144 will display the last 256 Kb of the file; this can be useful if the log file gets very large.</td>
</tr>
<tr>
<td class="mla-doc-table-label">Debug&nbsp;File</td>
<td>lets you specify a text file other than the PHP error log to receive the MLA-specific messages. The absolute path to the <code>/wp-content/</code> directory will be prepended to the value you enter. If the file does not exist an attempt will be made to create it. You can enter values such as "my-log.txt" or "/mylogs/my-log.txt". In the latter case, the "/mylogs/" directory must already exist; MLA will not create it.</td>
</tr>
<tr>
<td class="mla-doc-table-label">Replace&nbsp;PHP&nbsp;error_log&nbsp;file</td>
<td>lets you change the PHP error_log destination. You can use this to add PHP Notice, Warning and Error messages to the MLA Debug File. It's best to leave this box unchecked unless you are actively monitoring the MLA Debug file so PHP messages go to the default location.</td>
</tr>
<tr>
<td class="mla-doc-table-label">PHP&nbsp;Reporting</td>
<td>Sets which PHP errors are reported, overriding the value set in the <code>php.ini</code> file and the <code>wp-config.php</code> file. Setting a limit to, for example, 0x7FFF will display all PHP Notices and "Strict" messages (E_ALL | E_STRICT). It's best to leave this box blank unless you are actively debugging MLA so the normal PHP error_level is observed.</td>
</tr>
<tr>
<td class="mla-doc-table-label">MLA&nbsp;Reporting</td>
<td>lets you change the MLA_DEBUG_LEVEL without modifying the <code>wp-config.php</code> file. You can change any of the additional reporting categories but not the lowest bit which turns the Debug tab on and off. You can set the option to zero (0) to turn all logging off but leave the Debug tab active.</td>
</tr>
</table>
<p>
Below the Debug Options section is a list of settings and values that are useful for debugging investigation. If you are posting error information in an MLA Support Forum topic, be sure to add these values to your post to get a quicker resolution to your question or problem.
</p>
<p>
Below the Debug Settings section is a text area with the current content of the PHP (or MLA-specific) error log file. Below the text box are three action buttons:
</p>
<ul class="mla_settings">
<li><strong>Download</strong> - click this button to download a copy of the error log to your system.</li>
<li><strong>Reset</strong> - click this button to erase the contents of the error log.</li>
<li><strong>Save Changes</strong> - click this button to save a new value for the Display Limit option.</li>
</ul>
<p>
If you are having an MLA problem that includes error messages in the log, copying the messages and adding them to your Support Forum topic can be most helpful; thanks!
<a name="mla_language_tab"></a>
</p>
<p>
<a href="#backtotop">Go to Top</a>
</p>
<h3>WPML &amp; Polylang Multilingual Support; the MLA Language Tab</h3>
<p>
Media Library Assistant provides integrates support for two popular "Multilanguage/ Multilingual/ Internationalization" plugins; <a href="https://wpml.org/" title="WPML - The WordPress Multilingual Plugin" target="_blank">WPML</a> and <a href="https://wordpress.org/plugins/polylang/" title="Polylang - Making WordPress multilingual" target="_blank">Polylang</a>. These plugins let you write posts and pages in multiple languages and make it easy for a visitor to select the language in which to view your site. MLA works with the plugins to make language-specific Media library items easy to create and manage.
</p>
<p>
MLA detects the presence of either plugin and automatically adds several features that work with them:
</p>
<ul class="mla_settings">
<li><strong>Language-specific filtering</strong> of the <code>[mla_gallery]</code> and <code>[mla_tag_cloud]</code> shortcodes.</li>
<li><strong>Media/Assistant submenu table enhancements</strong> for displaying and managing item translations.</li>
<li><strong>Term Assignment and Term Synchronization</strong>, to match terms to language-specific items and automatically keep all translations for an item in synch.</li>
<li><strong>Term Mapping Replication</strong>, to manage the terms created when mapping taxonomy terms from IPTC/EXIF/WP metadata.</li>
</ul>
<h4>Items, Translations and Terms</h4>
<p>
Each Media Library item can have one or more "translations". The item translations are linked and they use the same file in the Media Library. The linkage lets us know that "&iexcl;Hola Mundo!" (Spanish), "Bonjour Monde" (French) and "Hello world!" (English) are all translations of the same post/page. Post/page translation is optional; some posts/pages may not be defined for all languages. The language of the first translation entered for a post/page is noted as the "source language".
</p>
<p>
Taxonomy terms can also have one or more translations, which are also linked. The linkage lets us know that "Accesorio Categor&iacute;a" (Spanish), "Cat&eacute;gorie Attachment" (French) and "Attachment Category" (English) are all translations of the same term. Term translation is optional; some terms may not be defined for all languages. The language of the first translation entered for a term is noted as the "source language".
</p>
<p>
When an item is uploaded to the Media Library it is assigned to the current language (note: <strong>avoid uploading items when you are in "All Languages"/"Show all languages" mode</strong>; bad things happen). WPML provides an option to duplicate the new item in all active languages; Polylang does not. MLA makes it easy to add translations to additional languages with the Translations column on the Media/Assistant submenu table. For Polylang, MLA provides Quick Translate and Bulk Translate actions as well.
</p>
<p>
Assigning language-specific terms to items with multiple translations can be complex. MLA's <strong>Term Assignment</strong> logic assures that every term you assign on any of the editing screens (Media/Add New Bulk Edit, Media/Edit, Media/Assistant Quick Edit and Bulk Edit, Media Manager ATTACHMENT DETAILS pane) will be matched to the language of each item and translation. MLA's <strong>Term Synchronization</strong> logic ensures that changes made in one translation are replicated to all other translations that have an equivalent language-specific term.
</p>
<h4>Shortcode Support</h4>
<p>
The <code>[mla_gallery]</code> shortcode selects items using the WordPress <code>WP_Query</code> class. Both WPML and Polylang use the hooks provided by <code>WP_Query</code> to return items in the current language. If you use taxonomy parameters in your shortcode you must make sure that the term name, slug or other value is in the same language as the post/page in which it is embedded. This is easily done when the post/page content is translated from one language to another.
</p>
<p>
The <code>[mla_tag_cloud]</code> shortcode selects terms using the WordPress <code>wpdb</code> class. MLA adds language qualifiers to the database queries that compose the cloud so all terms displayed are appropriate for the current language. No special coding or shortcode modification is required.
</p>
<h4>Media/Assistant submenu table</h4>
<p>
Two columns are added to the table when WPML or Polylang is active:
</p>
<ul class="mla_settings">
<li><strong>Language</strong> - displays the language of the item. This column is only present when "All languages/Show all languages" is selected in the admin toolbar at the top of the screen.</li>
<li><strong>"Translations"</strong> - displays the translation status of the item in all active languages. The column header displays the flag icon for the language. The column content will have a check mark icon for the item's language, a pencil icon for an existing translation or a plus icon for a translation that does not exist. You can click any icon to go directly to the Media/Edit Media screen for that translation. If you click a plus icon, a new translation will be created and initialized with content and terms from the current item and you will go to the Media/Edit Media screen for the new translation.</li>
</ul>
<p>
When Polylang is active, several additional features are available:
</p>
<ul class="mla_settings">
<li><strong>A Language dropdown control</strong> is added to the Quick Edit and Bulk Edit areas. You can change the language of one or more items by selecting a new value in the dropdown and clicking Update. The new language must not have an existing translation; if a translation already exists the change will be ignored.</li>
<li><strong>Translation status links</strong> are added to the Quick Edit area, just below the Language dropdown control. If you click one of the pencil/plus translation status links, a new Quick Edit area will open for the translation you selected. A new translation is created if you click a plus status icon.</li>
<li><strong>A Quick Translate rollover action</strong> can be added to each item (the default option setting is "unchecked"). If you activate this option, when you click the "Quick Translate" rollover action for an item the Quick Translate area opens, showing the Language dropdown control and the translation status links. From there, click "Set Language" to change the language assigned to the item or click one of the pencil/plus translation status links. A new Quick Edit area will open for the translation you selected. A new translation is created if you click a plus status icon.</li>
<li><strong>A Translate action</strong> is added to the Bulk Actions dropdown control. If you click the box next to one or more items, select Translate in the Bulk Actions dropdown and click Apply, the Bulk Translate area will open. The center column contains a checkbox for each active language and an "All Languages" checkbox. Check the box(es) for the languages you want and then click "Bulk Translate". The Media/Assistant submenu table will be refreshed to display only the items you selected in the language(s) you selected. Existing translations will be displayed, and <strong>new translations will be created</strong> as needed so every item has a translation in every language selected.</li>
</ul>
<h4>Term Management</h4>
<p>
Taxonomy terms are language-specific, and making sure the right terms are assigned to all items and translations can be a challenge. Terms can change when an item is updated in any of five ways:
</p>
<ol>
<li><strong>Individual edit</strong> - this is the full-screen Media/Edit Media submenu provided by WordPress. Taxonomies are displayed and updated in meta boxes along the right side of the screen. When "Update" is clicked whatever terms have been selected/entered are assigned to the item; they replace any old assignments.</li>
<li><strong>Media Manager Modal Window</strong> - this is the popup window provided by WordPress' "Add Media" and "Select Featured Image" features. Taxonomies are displayed and updated in the ATTACHMENT DETAILS meta boxes along the right side of the window. Whatever terms are selected/entered here are assigned to the item; they replace any old assignments.</li>
<li><strong>Quick Edit</strong> - this is a row-level action on the Media/Assistant screen. When "Update" is clicked whatever terms have been selected/entered are assigned to the item; they replace any old assignments.</li>
<li><strong>Bulk edit</strong> - this is a bulk action on the Media/Assistant screen, and is also available on the Media/Upload New Media screen. In the Bulk Edit area, terms can be added or removed or all terms can be replaced. The bulk edit can be applied to multiple item translations in one or more languages.</li>
<li><strong>IPTC/EXIF/WP Metadata Mapping</strong> - this is done by defining rules in the "Taxonomy term mapping" section of the <a href="#mla_iptc_exif_mapping">IPTC &amp; EXIF Processing Options</a>. The mapping rules can be run when new items are added to the Media Library, from the Settings/Media Library Assistant IPTC/EXIF/WP tab, from the Media/Assistant Bulk Edit area or from the Media/Edit Media submenu screen.</li>
</ol>
<p>
When terms change in any of the above ways there are two tasks that require rules:
</p>
<ol>
<li>How should language-specific terms be assigned to items selected? This is "Term Assignment".</li>
<li>How should terms assigned to one translation of an item be used to update other translations of the same item? This is "Term Synchronization".</li>
</ol>
<p>
When new terms are added during IPTC/EXIF/WP taxonomy term mapping a third task is required; should new terms be added only to the current language or should they be made available in all languages? This is "Term Mapping Replication".
</p>
<strong>Term Assignment</strong>
<p>
When a specific language is selected only the item translations for that language are shown, and only the terms for that language are displayed (except for a Polylang bug that shows all languages in the "auto-complete" list for flat taxonomies). When "All Languages"/"Show all languages" is selected the terms for all languages are displayed even if they cannot be assigned to an item. For example, a Spanish term may appear in the list be cannot be assigned to an English item translations.
</p>
<p>
For individual edit and quick edit updates the rule is simple:
</p>
<ol>
<li>For all terms selected/entered, find the equivalent term in the language of the item translation. Assign the equivalent (language-specific) term if one exists. If no equivalent term exists, ignore the selected/entered term. Assign all equivalent terms to the item translation, replacing any previous terms.</li>
</ol>
<p>
For bulk edit updates the rule depends on which action (add, remove, replace) has been selected. Each of the item translations in the bulk edit list is updated by these rules:
</p>
<ol>
<li><strong>Add</strong>: For all terms selected/entered, find the equivalent term in the language of the item translation. Assign the equivalent (language-specific) term if one exists. If the equivalent term exists, add it to the item translation.</li>
<li><strong>Remove</strong>: For all terms selected/entered, find the equivalent term in the language of the item translation. Assign the equivalent (language-specific) term if one exists. If the equivalent term exists, remove it from the item translation.</li>
<li><strong>Replace</strong>: This is the tricky case. What should happen to terms already assigned to an item translation that have not been selected/entered for the update? In particular, what about terms that do not have translations to all languages? Should a "French-only" term be preserved?</li>
</ol>
<p>
The "<strong>Replace</strong>" answer is the same as the individual/quick edit answer. If the term is not selected/entered for the update it is discarded along with the other old assignments. After all, in "All Languages"/"Show all languages" mode the "French-only" term would have been in the list and could be selected if desired.
</p>
<strong>Term Synchronization</strong>
<p>
If you edit an item translation, for example to add or remove a term assignment, what should happen to the other translations of the same item? Term synchronization will add or remove the equivalent term in the other item translations if the equivalent term exists.
</p>
<p>
What about "untranslated" terms that do not have translations to all languages? Should an existing "French-only" (untranslated) term be preserved? It is, since there is no way to indicate that it should be removed.
</p>
<p>
Individual and quick edits are "replace" updates, and "replace" is an option for bulk edits as well. For term synchronization to preserve untranslated terms "replace" updates must be converted to separate "add" and "remove" updates that include only the changes made to the original item translation. For example, if these terms are defined:
</p>
<table border="1" cellspacing="0"><tr>
<td style="font-weight:bold; text-align:center">English</td>
<td style="font-weight:bold; text-align:center">Spanish</td>
</tr><tr>
<td style="padding: 0px 10px">Common-term-1-eng</td>
<td style="padding: 0px 10px">Common-term-1-esp</td>
</tr><tr>
<td style="padding: 0px 10px">Common-term-2-eng</td>
<td style="padding: 0px 10px">Common-term-2-esp</td>
</tr><tr>
<td style="padding: 0px 10px">English-only-term</td>
<td style="padding: 0px 10px">&nbsp;</td>
</tr><tr>
<td style="padding: 0px 10px">&nbsp;</td>
<td style="padding: 0px 10px">Spanish-only-term</td>
</tr></table>
<p>
And these term assignments exist:
</p>
<table border="1" cellpadding="5" cellspacing="0"><tr>
<td style="font-weight:bold; text-align:center">English Translation</td>
<td style="font-weight:bold; text-align:center">Spanish Translation</td>
</tr><tr>
<td style="padding: 0px 10px">Common-term-1-eng</td>
<td style="padding: 0px 10px">Common-term-1-esp</td>
</tr><tr>
<td style="padding: 0px 10px">English-only-term</td>
<td style="padding: 0px 10px">&nbsp;</td>
</tr><tr>
<td style="padding: 0px 10px">&nbsp;</td>
<td style="padding: 0px 10px">Spanish-only-term</td>
</tr></table>
<p>
Then synchronization handles common editing actions as follows:
</p>
<ol>
<li>If you edit the English Translation and add "Common-term-2-eng", synchronization will add "Common-term-2-esp" to the Spanish Translation.</li>
<li>If you edit the English Translation and remove "Common-term-1-eng", synchronization will remove "Common-term-1-esp" from the Spanish Translation.</li>
<li>If you edit the English Translation and remove "English-only-term", nothing will happen to the Spanish Translation.</li>
</ol>
<strong>Term Mapping Replication</strong>
<p>
When rules are defined in the IPTC/EXIF/WP "Taxonomy term mapping section" they extract values (e.g., "IPTC 2#025 Keywords") from image metadata and use them to assign terms to the Media Library item(s). If the metadata value matches an existing term in the item's language it is assigned to the item. If the term already exists for any other active language it is not assigned to the item. If the term does not exist in any of the active languages, i.e., it is an entirely new term, a decision is required. The "Term Mapping Replication" option controls the decision:
</p>
<ul class="mla_settings">
<li>When Replication <strong>is active</strong>, the term is created in the current language and then copied to every other active language as a translation of the term in the current language.</li>
<li>When Replication <strong>is not active</strong>, the term is created in the current language only. It is not copied to any other active language and will not be assigned to items in any language other than the current language.</li>
</ul>
<p>
If you use Replication to automatically create terms in non-current languages they will be created with the same text value as the source term in the current language. You can always go to the taxonomy edit page and change the source text to an appropriate value for the other language(s). If you do not use Replication you can always go to the taxonomy edit page and add translations with an appropriate value for the other language(s).
<a name="mla_example_plugins"></a>
</p>
<p>
<a href="#backtotop">Go to Top</a>
</p>
<h3>The Example Plugins</h3>
<p>
The MLA example plugins have been developed to illustrate practical applications that use the hooks MLA provides to enhance the admin-mode screens and front-end content produced by the MLA shortcodes. Most of the examples are drawn from topics in the <a href="https://wordpress.org/support/plugin/media-library-assistant" title="The MLA Support Forum" target="_blank">MLA Support Forum</a>.</p>
<p>The Documentation/Example Plugins submenu lets you browse the list of MLA example plugins, install or update them in the Plugins/Installed Plugins area and see which examples you have already installed. <strong>To activate, deactivate or delete</strong> the plugins you must go to the Plugins/Installed Plugins admin submenu.</p>
<p>
The Example plugins submenu lists all of the MLA example plugins and identifies those already in the Installed Plugins area. In the submenu:
</p>
<ul class="mla_settings">
<li>the "Screen Options" dropdown area lets you choose which columns to display and how many items appear on each page</li>
<li>the "Help" dropdown area gives you a brief explanation of the submenu content and functions</li>
<li>the "Search Plugins" text box lets you filter the display to items containing one or more keywords or phrases</li>
<li>bulk and rollover actions are provided to install or update example plugins</li>
<li>the table can be sorted by any of the displayed columns</li>
</ul>
<p>
You can use the "View" rollover action to display the source code for an example plugin. Many of the plugins have documentation and use notes in a comment area at the top of the source file. They also have references to the Support Forum topics that inspired them, which can be an additional source of information.
</p>
<p>
Once you have installed an example plugin you can use the WordPress Plugins/Editor submenu to view the source code and (with extreme caution) make small changes to the code. <strong>Be very careful if you choose to modify the code!</strong> Making changes to active plugins is not recommended. If your changes cause a fatal error, the plugin will be automatically deactivated. It is much safer to download the file(s) or use FTP access to your site to modify the code offline in a more robust HTML/PHP editor.
</p>
<p>
You can use the "Download" rollover action to download a plugin to your local system. Once you have made your modifications you can copy the plugin to a compressed file (ZIP archive) and then upload it to your server with the Plugins/Add New (Upload Plugin) admin submenu.
</p>
<p>
If you do make changes to the example plugin code the best practice is to save the modified file(s) under a different name, so your changes won't be lost in a future update. If you want to retain the file name, consider changing the version number, e.g. adding 100 to the MLA value, so you can more easily identify the plugins you have modified.
</p>
<p>
<a href="#backtotop">Go to Top</a>
</p>
</div>